/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatc;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzatm;
import com.google.android.gms.internal.zzatn;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzauo;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.internal.zzaus;
import com.google.android.gms.internal.zzaut;
import com.google.android.gms.internal.zzauu;
import com.google.android.gms.internal.zzauw;
import com.google.android.gms.internal.zzbyb;
import com.google.android.gms.internal.zzbyc;
import com.google.android.gms.internal.zzbyd;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzatj
extends zzauh {
    private static final Map<String, String> zzbrh = new ArrayMap(1);
    private static final Map<String, String> zzbri;
    private static final Map<String, String> zzbrj;
    private static final Map<String, String> zzbrk;
    private static final Map<String, String> zzbrl;
    private final zzc zzbrm;
    private final zzauo zzbrn = new zzauo(this.zznR());

    zzatj(zzaue zzaue2) {
        super(zzaue2);
        String string = this.zzow();
        this.zzbrm = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzmS() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzob();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzob();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzob();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzKl().zzLZ().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzmR();
        try {
            return this.zzbrm.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzMb().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zzow() {
        return this.zzKn().zzpv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzatn zzQ(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzatn zzatn2 = new zzatn(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzKl().zzLZ().zzj("Got multiple records for event aggregates, expected one. appId", zzatx.zzfE(string));
            }
            zzatn zzatn3 = zzatn2;
            return zzatn3;
        }
    }

    @WorkerThread
    public void zza(zzatn zzatn2) {
        zzac.zzw((Object)zzatn2);
        this.zzmR();
        this.zzob();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzatn2.mAppId);
        contentValues.put("name", zzatn2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzatn2.zzbrB));
        contentValues.put("current_bundle_count", Long.valueOf(zzatn2.zzbrC));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzatn2.zzbrD));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert/update event aggregates (got -1). appId", zzatx.zzfE(zzatn2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing event aggregates. appId", zzatx.zzfE(zzatn2.mAppId), (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzR(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzKl().zzMf().zzj("Deleted user attribute rows", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zzd("Error deleting user attribute. appId", zzatx.zzfE(string), string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzz(String string, int n) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by triggered_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error pruning currencies. appId", zzatx.zzfE(string), (Object)sQLiteException);
        }
    }

    @WorkerThread
    public boolean zza(zzaus zzaus2) {
        zzac.zzw((Object)zzaus2);
        this.zzmR();
        this.zzob();
        zzaus zzaus3 = this.zzS(zzaus2.mAppId, zzaus2.mName);
        if (zzaus3 == null) {
            long l;
            if (zzaut.zzfT(zzaus2.mName)) {
                l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzaus2.mAppId});
                this.zzKn().zzKX();
                if (l >= 25L) {
                    return false;
                }
            } else {
                l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzaus2.mAppId, zzaus2.mOrigin});
                this.zzKn().zzKZ();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaus2.mAppId);
        contentValues.put("origin", zzaus2.mOrigin);
        contentValues.put("name", zzaus2.mName);
        contentValues.put("triggered_timestamp", Long.valueOf(zzaus2.zzbwj));
        this.zza(contentValues, "value", zzaus2.mValue);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert/update user property (got -1). appId", zzatx.zzfE(zzaus2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing user property. appId", zzatx.zzfE(zzaus2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzaus zzS(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"triggered_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            String string3 = cursor.getString(2);
            zzaus zzaus2 = new zzaus(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzKl().zzLZ().zzj("Got multiple records for user property, expected one. appId", zzatx.zzfE(string));
            }
            zzaus zzaus3 = zzaus2;
            return zzaus3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzaus> zzft(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        ArrayList<zzaus> arrayList = new ArrayList<zzaus>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "origin", "triggered_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzKn().zzKY()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzaus> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zzb(cursor, 3);
                if (object2 == null) {
                    this.zzKl().zzLZ().zzj("Read invalid user property value, ignoring it. appId", zzatx.zzfE(string));
                    continue;
                }
                zzaus zzaus2 = new zzaus(string, string2, (String)object, l, object2);
                arrayList.add(zzaus2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzaus> zzk(String string, String string2, String string3) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        ArrayList<zzaus> arrayList = new ArrayList<zzaus>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "triggered_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            this.zzKn().zzKY();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", String.valueOf(1001));
            if (!cursor.moveToFirst()) {
                ArrayList<zzaus> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= this.zzKn().zzKY()) {
                    this.zzKl().zzLZ().zzj("Read more than the max allowed user properties, ignoring excess", this.zzKn().zzKY());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzKl().zzLZ().zzd("(2)Read invalid user property value, ignoring it", zzatx.zzfE(string), string2, string3);
                    continue;
                }
                zzaus zzaus2 = new zzaus(string, string2, (String)object, l, object2);
                arrayList.add(zzaus2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public boolean zza(zzatg zzatg2) {
        zzac.zzw((Object)((Object)zzatg2));
        this.zzmR();
        this.zzob();
        zzaus zzaus2 = this.zzS(zzatg2.packageName, zzatg2.zzbqX.name);
        if (zzaus2 == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzatg2.packageName});
            this.zzKn().zzLa();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzatg2.packageName);
        contentValues.put("origin", zzatg2.zzbqW);
        contentValues.put("name", zzatg2.zzbqX.name);
        this.zza(contentValues, "value", zzatg2.zzbqX.getValue());
        contentValues.put("active", Boolean.valueOf(zzatg2.zzbqZ));
        contentValues.put("trigger_event_name", zzatg2.zzbra);
        contentValues.put("trigger_timeout", Long.valueOf(zzatg2.zzbrc));
        contentValues.put("timed_out_event", this.zzKh().zza((Parcelable)zzatg2.zzbrb));
        contentValues.put("creation_timestamp", Long.valueOf(zzatg2.zzbqY));
        contentValues.put("triggered_event", this.zzKh().zza((Parcelable)zzatg2.zzbrd));
        contentValues.put("triggered_timestamp", Long.valueOf(zzatg2.zzbqX.zzbwf));
        contentValues.put("time_to_live", Long.valueOf(zzatg2.zzbre));
        contentValues.put("expired_event", this.zzKh().zza((Parcelable)zzatg2.zzbrf));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("conditional_properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert/update conditional user property (got -1)", zzatx.zzfE(zzatg2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing conditional user property", zzatx.zzfE(zzatg2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzatg zzT(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zzb(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzatq zzatq2 = this.zzKh().zzb(cursor.getBlob(5), zzatq.CREATOR);
            long l2 = cursor.getLong(6);
            zzatq zzatq3 = this.zzKh().zzb(cursor.getBlob(7), zzatq.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzatq zzatq4 = this.zzKh().zzb(cursor.getBlob(10), zzatq.CREATOR);
            zzauq zzauq2 = new zzauq(string2, l3, object, string3);
            zzatg zzatg2 = new zzatg(string, string3, zzauq2, l2, bl, string4, zzatq2, l, zzatq3, l4, zzatq4);
            if (cursor.moveToNext()) {
                this.zzKl().zzLZ().zze("Got multiple records for conditional property, expected one", zzatx.zzfE(string), string2);
            }
            zzatg zzatg3 = zzatg2;
            return zzatg3;
        }
    }

    @WorkerThread
    public int zzU(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
            return n;
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zzd("Error deleting conditional property", zzatx.zzfE(string), string2, (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public List<zzatg> zzh(String string, long l) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        if (l < 0L) {
            this.zzKl().zzMb().zze("Invalid time querying timed out conditional properties", zzatx.zzfE(string), l);
            return Collections.emptyList();
        }
        String string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
        String[] stringArray = new String[]{string, String.valueOf(l)};
        return this.zzc(string2, stringArray);
    }

    @WorkerThread
    public List<zzatg> zzi(String string, long l) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        if (l < 0L) {
            this.zzKl().zzMb().zze("Invalid time querying expired conditional properties", zzatx.zzfE(string), l);
            return Collections.emptyList();
        }
        String string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
        String[] stringArray = new String[]{string, String.valueOf(l)};
        return this.zzc(string2, stringArray);
    }

    @WorkerThread
    public List<zzatg> zzc(String string, String string2, long l) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        if (l < 0L) {
            this.zzKl().zzMb().zzd("Invalid time querying triggered conditional properties", zzatx.zzfE(string), string2, l);
            return Collections.emptyList();
        }
        String string3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
        String[] stringArray = new String[]{string, string2, String.valueOf(l)};
        return this.zzc(string3, stringArray);
    }

    @WorkerThread
    public List<zzatg> zzl(String string, String string2, String string3) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzatg> zzc(String string, String[] stringArray) {
        this.zzmR();
        this.zzob();
        ArrayList<zzatg> arrayList = new ArrayList<zzatg>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            this.zzKn().zzLa();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", String.valueOf(1001));
            if (!cursor.moveToFirst()) {
                ArrayList<zzatg> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= this.zzKn().zzLa()) {
                    this.zzKl().zzLZ().zzj("Read more than the max allowed conditional properties, ignoring extra", this.zzKn().zzLa());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zzb(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzatq zzatq2 = this.zzKh().zzb(cursor.getBlob(7), zzatq.CREATOR);
                long l2 = cursor.getLong(8);
                zzatq zzatq3 = this.zzKh().zzb(cursor.getBlob(9), zzatq.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzatq zzatq4 = this.zzKh().zzb(cursor.getBlob(12), zzatq.CREATOR);
                zzauq zzauq2 = new zzauq(string3, l3, object2, string2);
                zzatg zzatg2 = new zzatg((String)object, string2, zzauq2, l2, bl, string4, zzatq2, l, zzatq3, l4, zzatq4);
                arrayList.add(zzatg2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzatc zzfu(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzatc zzatc2 = new zzatc(this.zzbqb, string);
            zzatc2.zzfd(cursor.getString(0));
            zzatc2.zzfe(cursor.getString(1));
            zzatc2.zzff(cursor.getString(2));
            zzatc2.zzad(cursor.getLong(3));
            zzatc2.zzY(cursor.getLong(4));
            zzatc2.zzZ(cursor.getLong(5));
            zzatc2.setAppVersion(cursor.getString(6));
            zzatc2.zzfh(cursor.getString(7));
            zzatc2.zzab(cursor.getLong(8));
            zzatc2.zzac(cursor.getLong(9));
            zzatc2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzatc2.zzag(cursor.getLong(11));
            zzatc2.zzah(cursor.getLong(12));
            zzatc2.zzai(cursor.getLong(13));
            zzatc2.zzaj(cursor.getLong(14));
            zzatc2.zzae(cursor.getLong(15));
            zzatc2.zzaf(cursor.getLong(16));
            zzatc2.zzaa(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzatc2.zzfg(cursor.getString(18));
            zzatc2.zzal(cursor.getLong(19));
            zzatc2.zzak(cursor.getLong(20));
            zzatc2.zzfi(cursor.getString(21));
            zzatc2.zzam(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzatc2.zzKo();
            if (cursor.moveToNext()) {
                this.zzKl().zzLZ().zzj("Got multiple records for app, expected one. appId", zzatx.zzfE(string));
            }
            zzatc zzatc3 = zzatc2;
            return zzatc3;
        }
    }

    @WorkerThread
    public void zza(zzatc zzatc2) {
        zzac.zzw((Object)zzatc2);
        this.zzmR();
        this.zzob();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzatc2.zzke());
        contentValues.put("app_instance_id", zzatc2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzatc2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzatc2.zzKp());
        contentValues.put("last_bundle_index", Long.valueOf(zzatc2.zzKy()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzatc2.zzKr()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzatc2.zzKs()));
        contentValues.put("app_version", zzatc2.zzmZ());
        contentValues.put("app_store", zzatc2.zzKu());
        contentValues.put("gmp_version", Long.valueOf(zzatc2.zzKv()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzatc2.zzKw()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzatc2.zzKx()));
        contentValues.put("day", Long.valueOf(zzatc2.zzKC()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzatc2.zzKD()));
        contentValues.put("daily_events_count", Long.valueOf(zzatc2.zzKE()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzatc2.zzKF()));
        contentValues.put("config_fetched_time", Long.valueOf(zzatc2.zzKz()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzatc2.zzKA()));
        contentValues.put("app_version_int", Long.valueOf(zzatc2.zzKt()));
        contentValues.put("firebase_instance_id", zzatc2.zzKq());
        contentValues.put("daily_error_events_count", Long.valueOf(zzatc2.zzKH()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzatc2.zzKG()));
        contentValues.put("health_monitor_sample", zzatc2.zzKI());
        contentValues.put("android_id", Long.valueOf(zzatc2.zzuW()));
        try {
            long l;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzatc2.zzke()});
            if (l2 == 0L && (l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5)) == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert/update app (got -1). appId", zzatx.zzfE(zzatc2.zzke()));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing app. appId", zzatx.zzfE(zzatc2.zzke()), (Object)sQLiteException);
        }
    }

    public long zzfv(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzKn().zzfs(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error deleting over the limit events. appId", zzatx.zzfE(string), (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzKl().zzMb().zzj("Not updating daily counts, app is not known. appId", zzatx.zzfE(string));
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.zzbrp = cursor.getLong(1);
                zza2.zzbro = cursor.getLong(2);
                zza2.zzbrq = cursor.getLong(3);
                zza2.zzbrr = cursor.getLong(4);
                zza2.zzbrs = cursor.getLong(5);
            }
            if (bl) {
                ++zza2.zzbrp;
            }
            if (bl2) {
                ++zza2.zzbro;
            }
            if (bl3) {
                ++zza2.zzbrq;
            }
            if (bl4) {
                ++zza2.zzbrr;
            }
            if (bl5) {
                ++zza2.zzbrs;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbro));
            contentValues.put("daily_events_count", Long.valueOf(zza2.zzbrp));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbrq));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbrr));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.zzbrs));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzKl().zzLZ().zzj("Failed to update remote config (got 0). appId", zzatx.zzfE(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing remote config. appId", zzatx.zzfE(string), (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzfw(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzKl().zzLZ().zzj("Got multiple records for app config, expected one. appId", zzatx.zzfE(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public boolean zza(zzauw.zze zze2, boolean bl) {
        byte[] byArray;
        Object object;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zze2));
        zzac.zzdr((String)zze2.zzaS);
        zzac.zzw((Object)zze2.zzbxn);
        this.zzLG();
        long l = this.zznR().currentTimeMillis();
        if (zze2.zzbxn < l - this.zzKn().zzLk() || zze2.zzbxn > l + this.zzKn().zzLk()) {
            this.zzKl().zzMb().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzatx.zzfE(zze2.zzaS), l, zze2.zzbxn);
        }
        try {
            int n = zze2.zzafB();
            object = new byte[n];
            zzbyc zzbyc2 = zzbyc.zzah((byte[])object);
            zze2.zza(zzbyc2);
            zzbyc2.zzafo();
            byArray = this.zzKh().zzk((byte[])object);
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Data loss. Failed to serialize bundle. appId", zzatx.zzfE(zze2.zzaS), iOException);
            return false;
        }
        this.zzKl().zzMf().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzaS);
        contentValues.put("bundle_end_timestamp", zze2.zzbxn);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert bundle (got -1). appId", zzatx.zzfE(zze2.zzaS));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing bundle. appId", zzatx.zzfE(zze2.zzaS), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzLE() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public boolean zzLF() {
        long l = this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null);
        return l != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzauw.zze, Long>> zzn(String string, int n, int n2) {
        this.zzmR();
        this.zzob();
        zzac.zzaw((n > 0 ? 1 : 0) != 0);
        zzac.zzaw((n2 > 0 ? 1 : 0) != 0);
        zzac.zzdr((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzauw.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzauw.zze, Long>> arrayList = new ArrayList<Pair<zzauw.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzKh().zzx((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zze("Failed to unzip queued bundle. appId", zzatx.zzfE(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzbyb.zzag((byte[])byArray);
                zzauw.zze zze2 = new zzauw.zze();
                try {
                    zze2.zzb((zzbyb)object);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zze("Failed to merge queued bundle. appId", zzatx.zzfE(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzauw.zze, Long>)Pair.create((Object)((Object)zze2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzauw.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzan(long l) {
        this.zzmR();
        this.zzob();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        try {
            int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
            if (n != 1) {
                throw new SQLiteException("Deleted fewer rows from queue than expected");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    void zzLG() {
        this.zzmR();
        this.zzob();
        if (!this.zzLN()) {
            return;
        }
        long l = this.zzKm().zzbte.get();
        long l2 = this.zznR().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzKn().zzLl()) {
            this.zzKm().zzbte.set(l2);
            this.zzLH();
        }
    }

    @WorkerThread
    void zzLH() {
        this.zzmR();
        this.zzob();
        if (!this.zzLN()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zznR().currentTimeMillis()), String.valueOf(this.zzKn().zzLk())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzKl().zzMf().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzauu.zza[] zzaArray) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzw((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzfx(string);
            for (zzauu.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            ArrayList arrayList = new ArrayList();
            for (zzauu.zza zza3 : zzaArray) {
                arrayList.add(zza3.zzbwn);
            }
            this.zzd(string, arrayList);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzfx(String string) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    @WorkerThread
    void zzA(String string, int n) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzauu.zza zza2) {
        void var7_13;
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzw((Object)((Object)zza2));
        zzac.zzw((Object)zza2.zzbwp);
        zzac.zzw((Object)zza2.zzbwo);
        if (zza2.zzbwn == null) {
            this.zzKl().zzMb().zzj("Audience with no ID. appId", zzatx.zzfE(string));
            return;
        }
        int n = zza2.zzbwn;
        for (zzauu.zzb zzb2 : zza2.zzbwp) {
            if (zzb2.zzbwr != null) continue;
            this.zzKl().zzMb().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzatx.zzfE(string), zza2.zzbwn);
            return;
        }
        for (zzbyd zzbyd2 : zza2.zzbwo) {
            if (zzbyd2.zzbwr != null) continue;
            this.zzKl().zzMb().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzatx.zzfE(string), zza2.zzbwn);
            return;
        }
        boolean bl = true;
        zzbyd[] zzbydArray = zza2.zzbwp;
        int n2 = zzbydArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzauu.zzb zzb2 = zzbydArray[var7_13];
            if (!this.zza(string, n, zzb2)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzbydArray = zza2.zzbwo;
            n2 = zzbydArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzbyd zzbyd3 = zzbydArray[var7_15];
                if (!this.zza(string, n, (zzauu.zze)zzbyd3)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzA(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzauu.zzb zzb2) {
        zzbyc zzbyc2;
        byte[] byArray;
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzw((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.zzbws)) {
            this.zzKl().zzMb().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzatx.zzfE(string), n, String.valueOf(zzb2.zzbwr));
            return false;
        }
        try {
            int n2 = zzb2.zzafB();
            byArray = new byte[n2];
            zzbyc2 = zzbyc.zzah((byte[])byArray);
            zzb2.zza(zzbyc2);
            zzbyc2.zzafo();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Configuration loss. Failed to serialize event filter. appId", zzatx.zzfE(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzbwr);
        contentValues.put("event_name", zzb2.zzbws);
        contentValues.put("data", byArray);
        try {
            zzbyc2 = this.getWritableDatabase();
            long l = zzbyc2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert event filter (got -1). appId", zzatx.zzfE(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing event filter. appId", zzatx.zzfE(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzauu.zze zze2) {
        zzbyc zzbyc2;
        byte[] byArray;
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzw((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.zzbwH)) {
            this.zzKl().zzMb().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzatx.zzfE(string), n, String.valueOf(zze2.zzbwr));
            return false;
        }
        try {
            int n2 = zze2.zzafB();
            byArray = new byte[n2];
            zzbyc2 = zzbyc.zzah((byte[])byArray);
            zze2.zza(zzbyc2);
            zzbyc2.zzafo();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Configuration loss. Failed to serialize property filter. appId", zzatx.zzfE(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzbwr);
        contentValues.put("property_name", zze2.zzbwH);
        contentValues.put("data", byArray);
        try {
            zzbyc2 = this.getWritableDatabase();
            long l = zzbyc2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert property filter (got -1). appId", zzatx.zzfE(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing property filter. appId", zzatx.zzfE(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzauu.zzb>> zzV(String string, String string2) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzauu.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzbyb zzbyb2 = zzbyb.zzag((byte[])byArray);
                zzauu.zzb zzb2 = new zzauu.zzb();
                try {
                    zzb2.zzb(zzbyb2);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zze("Failed to merge filter. appId", zzatx.zzfE(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzauu.zzb> arrayList = (ArrayList<zzauu.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzauu.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzauu.zze>> zzW(String string, String string2) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzauu.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzbyb zzbyb2 = zzbyb.zzag((byte[])byArray);
                zzauu.zze zze2 = new zzauu.zze();
                try {
                    zze2.zzb(zzbyb2);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zze("Failed to merge filter", zzatx.zzfE(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzauu.zze> arrayList = (ArrayList<zzauu.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzauu.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    boolean zzd(String string, List<Integer> list) {
        Object object;
        long l;
        zzac.zzdr((String)string);
        this.zzob();
        this.zzmR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Database error querying filters. appId", zzatx.zzfE(string), (Object)sQLiteException);
            return false;
        }
        int n = this.zzKn().zzfo(string);
        if (l <= (long)n) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object == null || !(object instanceof Integer)) {
                    return false;
                }
                arrayList.add(Integer.toString((Integer)object));
            }
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string2 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        int n2 = sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string2).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string2).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n)});
        return n2 > 0;
    }

    void zza(String string, int n, zzauw.zzf zzf2) {
        zzbyc zzbyc2;
        byte[] byArray;
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        zzac.zzw((Object)((Object)zzf2));
        try {
            int n2 = zzf2.zzafB();
            byArray = new byte[n2];
            zzbyc2 = zzbyc.zzah((byte[])byArray);
            zzf2.zza(zzbyc2);
            zzbyc2.zzafo();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Configuration loss. Failed to serialize filter results. appId", zzatx.zzfE(string), iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzbyc2 = this.getWritableDatabase();
            long l = zzbyc2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert filter results (got -1). appId", zzatx.zzfE(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing filter results. appId", zzatx.zzfE(string), (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzauw.zzf> zzfy(String string) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzbyb zzbyb2 = zzbyb.zzag((byte[])byArray);
                zzauw.zzf zzf2 = new zzauw.zzf();
                try {
                    zzf2.zzb(zzbyb2);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zzd("Failed to merge filter results. appId, audienceId, error", zzatx.zzfE(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzfz(String string) {
        this.zzob();
        this.zzmR();
        zzac.zzdr((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzKl().zzMf().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error deleting application data. appId, error", zzatx.zzfE(string), (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        zzac.zzdr((String)string);
        zzac.zzw((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        return cursor.getType(n);
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zzatj.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzKl().zzLZ().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzKl().zzLZ().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzKl().zzLZ().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzLI() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzfA(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        this.zzob();
        return this.zzX(string, "first_open_count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected long zzX(String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzob();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            long l2;
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                l2 = sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5);
                if (l2 == -1L) {
                    this.zzKl().zzLZ().zze("Failed to insert column (got -1). appId", zzatx.zzfE(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            l2 = sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string});
            if (l2 == 0L) {
                this.zzKl().zzLZ().zze("Failed to update column (got 0). appId", zzatx.zzfE(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zzd("Error inserting column. appId", zzatx.zzfE(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public long zzLJ() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zza(zzauw.zze zze2) throws IOException {
        byte[] byArray;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zze2));
        zzac.zzdr((String)zze2.zzaS);
        try {
            int n = zze2.zzafB();
            byArray = new byte[n];
            zzbyc zzbyc2 = zzbyc.zzah((byte[])byArray);
            zze2.zza(zzbyc2);
            zzbyc2.zzafo();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Data loss. Failed to serialize event metadata. appId", zzatx.zzfE(zze2.zzaS), iOException);
            throw iOException;
        }
        long l = this.zzKh().zzz(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzaS);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing raw event metadata. appId", zzatx.zzfE(zze2.zzaS), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzLK() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public boolean zzLL() {
        long l = this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null);
        return l != 0L;
    }

    public void zzJ(List<Long> list) {
        zzac.zzw(list);
        this.zzmR();
        this.zzob();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzKl().zzLZ().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzfB(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Failed to remove unused event metadata. appId", zzatx.zzfE(string), (Object)sQLiteException);
        }
    }

    public long zzfC(String string) {
        zzac.zzdr((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzao(long l) {
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzKl().zzMf().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zzLM() {
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, long l2, zzb zzb2) {
        zzac.zzw((Object)zzb2);
        this.zzmR();
        this.zzob();
        try (Cursor cursor = null;){
            String[] stringArray;
            String string2;
            String string3;
            String string4;
            Object[] objectArray;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l)} : new String[]{String.valueOf(l)};
                string4 = l2 != -1L ? "rowid <= ? and " : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string3 = cursor.getString(1);
                cursor.close();
            } else {
                objectArray = l2 != -1L ? new String[]{string, String.valueOf(l2)} : new String[]{string};
                string4 = l2 != -1L ? " and rowid <= ?" : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string3 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string, string3}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzKl().zzLZ().zzj("Raw event metadata record is missing. appId", zzatx.zzfE(string));
                return;
            }
            objectArray = cursor.getBlob(0);
            string4 = zzbyb.zzag((byte[])objectArray);
            zzauw.zze zze2 = new zzauw.zze();
            try {
                zze2.zzb((zzbyb)string4);
            }
            catch (IOException iOException) {
                this.zzKl().zzLZ().zze("Data loss. Failed to merge raw event metadata. appId", zzatx.zzfE(string), iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzKl().zzMb().zzj("Get multiple raw event metadata records, expected one. appId", zzatx.zzfE(string));
            }
            cursor.close();
            zzb2.zzb(zze2);
            if (l2 != -1L) {
                string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                stringArray = new String[]{string, string3, String.valueOf(l2)};
            } else {
                string2 = "app_id = ? and metadata_fingerprint = ?";
                stringArray = new String[]{string, string3};
            }
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzKl().zzMb().zzj("Raw event data disappeared while in transaction. appId", zzatx.zzfE(string));
                return;
            }
            do {
                long l3 = cursor.getLong(0);
                objectArray = cursor.getBlob(3);
                string4 = zzbyb.zzag((byte[])objectArray);
                zzauw.zzb zzb3 = new zzauw.zzb();
                try {
                    zzb3.zzb((zzbyb)string4);
                }
                catch (IOException iOException) {
                    this.zzKl().zzLZ().zze("Data loss. Failed to merge raw event. appId", zzatx.zzfE(string), iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.zzbxc = cursor.getLong(2);
                if (zzb2.zza(l3, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public boolean zza(zzatm zzatm2, long l, boolean bl) {
        Object object;
        zzauw.zzc zzc2;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)zzatm2);
        zzac.zzdr((String)zzatm2.mAppId);
        zzauw.zzb zzb2 = new zzauw.zzb();
        zzb2.zzbxd = zzatm2.zzbrz;
        zzb2.zzbxb = new zzauw.zzc[zzatm2.zzbrA.size()];
        int n = 0;
        for (String string : zzatm2.zzbrA) {
            zzc2 = new zzauw.zzc();
            zzb2.zzbxb[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzatm2.zzbrA.get(string);
            this.zzKh().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.zzafB();
            object = new byte[n2];
            zzc2 = zzbyc.zzah((byte[])object);
            zzb2.zza((zzbyc)zzc2);
            zzc2.zzafo();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Data loss. Failed to serialize event params/data. appId", zzatx.zzfE(zzatm2.mAppId), iOException);
            return false;
        }
        this.zzKl().zzMf().zze("Saving event, name, data size", zzatm2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzatm2.mAppId);
        contentValues.put("name", zzatm2.mName);
        contentValues.put("timestamp", Long.valueOf(zzatm2.zzaxb));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzKl().zzLZ().zzj("Failed to insert raw event (got -1). appId", zzatx.zzfE(zzatm2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzKl().zzLZ().zze("Error storing raw event. appId", zzatx.zzfE(zzatm2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private boolean zzLN() {
        return this.getContext().getDatabasePath(this.zzow()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static boolean zza(zzatx zzatx2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzatx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzatx zzatx2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzatx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzatj.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzatx2.zzMb().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzatx zzatx2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzatx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzatj.zza(zzatx2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzatj.zza(zzatx2, sQLiteDatabase, string, string3, map);
        }
        catch (SQLiteException sQLiteException) {
            zzatx2.zzLZ().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzatx zzatx2, SQLiteDatabase sQLiteDatabase) {
        if (zzatx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzatx2.zzMb().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzatx2.zzMb().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzatx2.zzMb().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzatx2.zzMb().log("Failed to turn on database write permission for owner");
        }
    }

    static {
        zzbrh.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zzbri = new ArrayMap(18);
        zzbri.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbri.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbri.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbri.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbri.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbri.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbri.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbri.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbri.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbri.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbri.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbri.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbri.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbri.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbri.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbri.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzbri.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzbri.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzbri.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzbrj = new ArrayMap(1);
        zzbrj.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzbrk = new ArrayMap(1);
        zzbrk.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzbrl = new ArrayMap(1);
        zzbrl.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zzatj.this.zzbrn.zzA(zzatj.this.zzKn().zzLd())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzatj.this.zzbrn.start();
                zzatj.this.zzKl().zzLZ().log("Opening the database failed, dropping and recreating it");
                String string = zzatj.this.zzow();
                if (!zzatj.this.getContext().getDatabasePath(string).delete()) {
                    zzatj.this.zzKl().zzLZ().zzj("Failed to delete corrupted db file", string);
                }
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzatj.this.zzbrn.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzatj.this.zzKl().zzLZ().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "conditional_properties", "CREATE TABLE IF NOT EXISTS conditional_properties ( app_id TEXT NOT NULL, origin TEXT NOT NULL, name TEXT NOT NULL, value BLOB NOT NULL, creation_timestamp INTEGER NOT NULL, active INTEGER NOT NULL, trigger_event_name TEXT, trigger_timeout INTEGER NOT NULL, timed_out_event BLOB,triggered_event BLOB, triggered_timestamp INTEGER NOT NULL, time_to_live INTEGER NOT NULL, expired_event BLOB, PRIMARY KEY (app_id, name)) ;", "app_id,origin,name,value,active,trigger_event_name,trigger_timeout,creation_timestamp,timed_out_event,triggered_event,triggered_timestamp,time_to_live,expired_event", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, triggered_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,triggered_timestamp,value", zzbrh);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", zzbri);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", zzbrk);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", zzbrj);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase, "app2", "CREATE TABLE IF NOT EXISTS app2 ( app_id TEXT NOT NULL, first_open_count INTEGER NOT NULL, PRIMARY KEY (app_id));", "app_id,first_open_count", zzbrl);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzatj.zza(zzatj.this.zzKl(), sQLiteDatabase);
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzb(zzauw.zze var1);

        public boolean zza(long var1, zzauw.zzb var3);
    }

    public static class zza {
        long zzbro;
        long zzbrp;
        long zzbrq;
        long zzbrr;
        long zzbrs;
    }
}

