/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzaut;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzaua
extends zzauh {
    static final Pair<String, Long> zzbsZ = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzagD;
    public final zzc zzbta = new zzc("health_monitor", this.zzKn().zzpz());
    public final zzb zzbtb = new zzb("last_upload", 0L);
    public final zzb zzbtc = new zzb("last_upload_attempt", 0L);
    public final zzb zzbtd = new zzb("backoff", 0L);
    public final zzb zzbte = new zzb("last_delete_stale", 0L);
    public final zzb zzbtf;
    private String zzbtg;
    private boolean zzbth;
    private long zzbti;
    private String zzbtj;
    private long zzbtk;
    private final Object zzbtl;
    private SecureRandom zzbtm;
    public final zzb zzbtn = new zzb("time_before_start", 10000L);
    public final zzb zzbto = new zzb("session_timeout", 1800000L);
    public final zza zzbtp = new zza("start_new_session", true);
    public final zzb zzbtq = new zzb("last_pause_time", 0L);
    public final zzb zzbtr = new zzb("time_active", 0L);
    public boolean zzbts;

    @WorkerThread
    protected SecureRandom zzMh() {
        this.zzmR();
        if (this.zzbtm == null) {
            this.zzbtm = new SecureRandom();
        }
        return this.zzbtm;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzfG(String string) {
        this.zzmR();
        long l = this.zznR().elapsedRealtime();
        if (this.zzbtg != null && l < this.zzbti) {
            return new Pair((Object)this.zzbtg, (Object)this.zzbth);
        }
        this.zzbti = l + this.zzKn().zzfm(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzbtg = info.getId();
            if (this.zzbtg == null) {
                this.zzbtg = "";
            }
            this.zzbth = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzKl().zzMe().zzj("Unable to get advertising id", throwable);
            this.zzbtg = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbtg, (Object)this.zzbth);
    }

    @WorkerThread
    String zzfH(String string) {
        this.zzmR();
        String string2 = (String)this.zzfG((String)string).first;
        MessageDigest messageDigest = zzaut.zzch("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzMi() {
        byte[] byArray = new byte[16];
        this.zzMh().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzKq() {
        this.zzmR();
        try {
            return com.google.firebase.iid.zzc.zzabN().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzKl().zzMb().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzMj() {
        this.zzob();
        this.zzmR();
        long l = this.zzbtf.get();
        if (l == 0L) {
            l = 1 + this.zzMh().nextInt(86400000);
            this.zzbtf.set(l);
        }
        return l;
    }

    zzaua(zzaue zzaue2) {
        super(zzaue2);
        this.zzbtf = new zzb("midnight_offset", 0L);
        this.zzbtl = new Object();
    }

    @Override
    protected void zzmS() {
        this.zzagD = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbts = this.zzagD.getBoolean("has_been_opened", false);
        if (!this.zzbts) {
            SharedPreferences.Editor editor = this.zzagD.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzMk() {
        this.zzmR();
        this.zzob();
        return this.zzagD;
    }

    @WorkerThread
    void zzfI(String string) {
        this.zzmR();
        SharedPreferences.Editor editor = this.zzMk().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzMl() {
        this.zzmR();
        return this.zzMk().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzfJ(String string) {
        Object object = this.zzbtl;
        synchronized (object) {
            this.zzbtj = string;
            this.zzbtk = this.zznR().elapsedRealtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzMm() {
        Object object = this.zzbtl;
        synchronized (object) {
            if (Math.abs(this.zznR().elapsedRealtime() - this.zzbtk) < 1000L) {
                return this.zzbtj;
            }
            return null;
        }
    }

    @WorkerThread
    Boolean zzMn() {
        this.zzmR();
        if (!this.zzMk().contains("use_service")) {
            return null;
        }
        return this.zzMk().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzaJ(boolean bl) {
        this.zzmR();
        this.zzKl().zzMf().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzMk().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzMo() {
        this.zzmR();
        this.zzKl().zzMf().log("Clearing collection preferences.");
        boolean bl = this.zzMk().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzaK(true);
        }
        SharedPreferences.Editor editor = this.zzMk().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzmR();
        this.zzKl().zzMf().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzMk().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzaK(boolean bl) {
        this.zzmR();
        return this.zzMk().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzMp() {
        this.zzmR();
        String string = this.zzMk().getString("previous_os_version", null);
        String string2 = this.zzKc().zzLS();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzMk().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzAX;
        private final boolean zzbtt;
        private boolean zzbtu;
        private boolean zzayS;

        public zza(String string, boolean bl) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbtt = bl;
        }

        @WorkerThread
        private void zzMq() {
            if (this.zzbtu) {
                return;
            }
            this.zzbtu = true;
            this.zzayS = zzaua.this.zzagD.getBoolean(this.zzAX, this.zzbtt);
        }

        @WorkerThread
        public boolean get() {
            this.zzMq();
            return this.zzayS;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putBoolean(this.zzAX, bl);
            editor.apply();
            this.zzayS = bl;
        }
    }

    public final class zzb {
        private final String zzAX;
        private final long zzbtw;
        private boolean zzbtu;
        private long zzadd;

        public zzb(String string, long l) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbtw = l;
        }

        @WorkerThread
        private void zzMq() {
            if (this.zzbtu) {
                return;
            }
            this.zzbtu = true;
            this.zzadd = zzaua.this.zzagD.getLong(this.zzAX, this.zzbtw);
        }

        @WorkerThread
        public long get() {
            this.zzMq();
            return this.zzadd;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putLong(this.zzAX, l);
            editor.apply();
            this.zzadd = l;
        }
    }

    public final class zzc {
        final String zzbtx;
        private final String zzbty;
        private final String zzbtz;
        private final long zzagH;

        private zzc(String string, long l) {
            zzac.zzdr((String)string);
            zzac.zzaw((l > 0L ? 1 : 0) != 0);
            this.zzbtx = String.valueOf(string).concat(":start");
            this.zzbty = String.valueOf(string).concat(":count");
            this.zzbtz = String.valueOf(string).concat(":value");
            this.zzagH = l;
        }

        @WorkerThread
        private void zzqk() {
            zzaua.this.zzmR();
            long l = zzaua.this.zznR().currentTimeMillis();
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.remove(this.zzbty);
            editor.remove(this.zzbtz);
            editor.putLong(this.zzbtx, l);
            editor.apply();
        }

        @WorkerThread
        private long zzql() {
            zzaua.this.zzmR();
            long l = this.zzqn();
            if (l == 0L) {
                this.zzqk();
                return 0L;
            }
            return Math.abs(l - zzaua.this.zznR().currentTimeMillis());
        }

        @WorkerThread
        public void zzcc(String string) {
            this.zzk(string, 1L);
        }

        @WorkerThread
        public void zzk(String string, long l) {
            long l2;
            zzaua.this.zzmR();
            long l3 = this.zzqn();
            if (l3 == 0L) {
                this.zzqk();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzaua.this.zzagD.getLong(this.zzbty, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
                editor.putString(this.zzbtz, string);
                editor.putLong(this.zzbty, l);
                editor.apply();
                return;
            }
            long l4 = zzaua.this.zzMh().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            if (bl) {
                editor.putString(this.zzbtz, string);
            }
            editor.putLong(this.zzbty, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzqm() {
            zzaua.this.zzmR();
            long l = this.zzql();
            if (l < this.zzagH) {
                return null;
            }
            if (l > this.zzagH * 2L) {
                this.zzqk();
                return null;
            }
            String string = zzaua.this.zzMk().getString(this.zzbtz, null);
            long l2 = zzaua.this.zzMk().getLong(this.zzbty, 0L);
            this.zzqk();
            if (string == null || l2 <= 0L) {
                return zzbsZ;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzqn() {
            return zzaua.this.zzMk().getLong(this.zzbtx, 0L);
        }
    }
}

