/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzcgg
extends zzchj {
    private ExecutorService zzbrV;
    private zzcgk zzbrW;
    private zzcgk zzbrX;
    private final PriorityBlockingQueue<FutureTask<?>> zzbrY;
    private final BlockingQueue<FutureTask<?>> zzbrZ;
    private final Thread.UncaughtExceptionHandler zzbsa;
    private final Thread.UncaughtExceptionHandler zzbsb;
    private final Object zzbsc = new Object();
    private final Semaphore zzbsd = new Semaphore(2);
    private volatile boolean zzbse;
    private static final AtomicLong zzbsf = new AtomicLong(Long.MIN_VALUE);

    zzcgg(zzcgl zzcgl2) {
        super(zzcgl2);
        this.zzbrY = new PriorityBlockingQueue();
        this.zzbrZ = new LinkedBlockingQueue();
        this.zzbsa = new zzcgi(this, "Thread death: Uncaught exception on worker thread");
        this.zzbsb = new zzcgi(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzjD() {
    }

    @Override
    public final void zzjC() {
        if (Thread.currentThread() != this.zzbrW) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzwq() {
        if (Thread.currentThread() != this.zzbrX) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzS() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzyM() {
        return Thread.currentThread() == this.zzbrW;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu(callable);
        zzcgj zzcgj2 = new zzcgj(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbrW) {
            if (!this.zzbrY.isEmpty()) {
                super.zzwF().zzyz().log("Callable skipped the worker queue.");
            }
            zzcgj2.run();
        } else {
            this.zza(zzcgj2);
        }
        return zzcgj2;
    }

    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu(callable);
        zzcgj zzcgj2 = new zzcgj(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbrW) {
            zzcgj2.run();
        } else {
            this.zza(zzcgj2);
        }
        return zzcgj2;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu((Object)runnable);
        this.zza(new zzcgj(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzcgj<?> zzcgj2) {
        Object object = this.zzbsc;
        synchronized (object) {
            this.zzbrY.add(zzcgj2);
            if (this.zzbrW == null) {
                this.zzbrW = new zzcgk(this, "Measurement Worker", this.zzbrY);
                this.zzbrW.setUncaughtExceptionHandler(this.zzbsa);
                this.zzbrW.start();
            } else {
                this.zzbrW.zzfF();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Runnable runnable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu((Object)runnable);
        zzcgj zzcgj2 = new zzcgj(this, runnable, false, "Task exception on network thread");
        zzcgg zzcgg2 = this;
        Object object = zzcgg2.zzbsc;
        synchronized (object) {
            zzcgg2.zzbrZ.add(zzcgj2);
            if (zzcgg2.zzbrX == null) {
                zzcgg2.zzbrX = new zzcgk(zzcgg2, "Measurement Network", zzcgg2.zzbrZ);
                zzcgg2.zzbrX.setUncaughtExceptionHandler(zzcgg2.zzbsb);
                zzcgg2.zzbrX.start();
            } else {
                zzcgg2.zzbrX.zzfF();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzyN() {
        Object object = this.zzbsc;
        synchronized (object) {
            if (this.zzbrV == null) {
                this.zzbrV = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbrV;
        }
    }

    static /* synthetic */ Semaphore zza(zzcgg zzcgg2) {
        return zzcgg2.zzbsd;
    }

    static /* synthetic */ boolean zzb(zzcgg zzcgg2) {
        return zzcgg2.zzbse;
    }

    static /* synthetic */ Object zzc(zzcgg zzcgg2) {
        return zzcgg2.zzbsc;
    }

    static /* synthetic */ zzcgk zzd(zzcgg zzcgg2) {
        return zzcgg2.zzbrW;
    }

    static /* synthetic */ zzcgk zza(zzcgg zzcgg2, zzcgk zzcgk2) {
        zzcgg2.zzbrW = null;
        return null;
    }

    static /* synthetic */ zzcgk zze(zzcgg zzcgg2) {
        return zzcgg2.zzbrX;
    }

    static /* synthetic */ zzcgk zzb(zzcgg zzcgg2, zzcgk zzcgk2) {
        zzcgg2.zzbrX = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzyO() {
        return zzbsf;
    }
}

