/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcag;
import com.google.android.gms.internal.zzcah;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcaf
extends zzcdl {
    private final Map<String, Long> zzikn;
    private final Map<String, Integer> zziko = new ArrayMap();
    private long zzikp;

    public zzcaf(zzcco zzcco2) {
        super(zzcco2);
        this.zzikn = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdl)this).zzauk().zzayc().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdl)this).zzvu().elapsedRealtime();
        ((zzcdl)this).zzauj().zzg(new zzcag(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        ((zzcdl)this).zzatu();
        ((zzcdl)this).zzug();
        zzbp.zzgf((String)string);
        if (this.zziko.isEmpty()) {
            this.zzikp = l;
        }
        if ((n = this.zziko.get(string)) != null) {
            this.zziko.put(string, n + 1);
            return;
        }
        if (this.zziko.size() >= 100) {
            ((zzcdl)this).zzauk().zzaye().log("Too many ads visible");
            return;
        }
        this.zziko.put(string, 1);
        this.zzikn.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdl)this).zzauk().zzayc().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdl)this).zzvu().elapsedRealtime();
        ((zzcdl)this).zzauj().zzg(new zzcah(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        ((zzcdl)this).zzatu();
        ((zzcdl)this).zzug();
        zzbp.zzgf((String)string);
        Integer n = this.zziko.get(string);
        if (n != null) {
            zzcef zzcef2 = ((zzcdl)this).zzauc().zzazm();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zziko.remove(string);
                Long l2 = this.zzikn.get(string);
                if (l2 == null) {
                    ((zzcdl)this).zzauk().zzayc().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzikn.remove(string);
                    this.zza(string, l3, zzcef2);
                }
                if (this.zziko.isEmpty()) {
                    if (this.zzikp == 0L) {
                        ((zzcdl)this).zzauk().zzayc().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzikp, zzcef2);
                    this.zzikp = 0L;
                }
                return;
            }
            this.zziko.put(string, n2);
            return;
        }
        ((zzcdl)this).zzauk().zzayc().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdl)this).zzauk().zzayi().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdl)this).zzauk().zzayi().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzcec.zza(zzb2, bundle);
        ((zzcdl)this).zzaty().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdl)this).zzauk().zzayi().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdl)this).zzauk().zzayi().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzcec.zza(zzb2, bundle);
        ((zzcdl)this).zzaty().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzaj(long l) {
        zzcef zzcef2 = ((zzcdl)this).zzauc().zzazm();
        for (String string : this.zzikn.keySet()) {
            long l2 = this.zzikn.get(string);
            this.zza(string, l - l2, zzcef2);
        }
        if (!this.zzikn.isEmpty()) {
            this.zza(l - this.zzikp, zzcef2);
        }
        this.zzak(l);
    }

    @WorkerThread
    private final void zzak(long l) {
        for (String string : this.zzikn.keySet()) {
            this.zzikn.put(string, l);
        }
        if (!this.zzikn.isEmpty()) {
            this.zzikp = l;
        }
    }

    static /* synthetic */ void zza(zzcaf zzcaf2, String string, long l) {
        zzcaf2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcaf zzcaf2, String string, long l) {
        zzcaf2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcaf zzcaf2, long l) {
        zzcaf2.zzak(l);
    }
}

