/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.internal.zzbdn;
import com.google.android.gms.internal.zzcak;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcbj
extends zzcdm {
    private String mAppId;
    private String zzdmh;
    private int zzioz;
    private String zziky;
    private String zzdmg;
    private long zzipa;
    private long zzilc;
    private int zzipb;
    private String zzcxs;

    zzcbj(zzcco zzcco2) {
        super(zzcco2);
    }

    @Override
    protected final void zzuh() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcdl)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcdl)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcdl)this).zzauk().zzayc().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcbo.zzjf(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcdl)this).zzauk().zzayc().zzj("Error retrieving app installer package name. appId", zzcbo.zzjf(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcdl)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcdl)this).zzauk().zzayc().zze("Error retrieving package info. appId, appName", zzcbo.zzjf(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zziky = string;
        this.zzdmh = string2;
        this.zzioz = n;
        this.zzdmg = string3;
        this.zzipa = 0L;
        zzcap.zzawj();
        packageInfo = zzca.zzcc((Context)((zzcdl)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcbj zzcbj2 = this;
            if (packageInfo2 == null) {
                ((zzcdl)zzcbj2).zzauk().zzayc().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcdl)zzcbj2).zzauk().zzayc().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcdl)this).zzaum().zzit("firebase_analytics_collection_enabled");
            if (((zzcdl)this).zzaum().zzawk()) {
                ((zzcdl)this).zzauk().zzayg().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcdl)this).zzauk().zzayg().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcap.zzaie()) {
                ((zzcdl)this).zzauk().zzayg().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcdl)this).zzauk().zzayi().log("Collection enabled");
            }
        }
        this.zzcxs = "";
        this.zzilc = 0L;
        zzcap.zzawj();
        try {
            object = zzca.zzaid();
            Object object2 = this.zzcxs = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcdl)this).zzauk().zzayi().zze("App package, google app id", this.mAppId, this.zzcxs);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdl)this).zzauk().zzayc().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcbo.zzjf(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzipb = zzbdn.zzcq((Context)((zzcdl)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzipb = 0;
    }

    @WorkerThread
    final zzcak zzjb(String string) {
        ((zzcdl)this).zzug();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcbj zzcbj2 = this;
        zzcbj2.zzwh();
        String string4 = zzcbj2.zzdmh;
        long l = this.zzaya();
        zzcbj2 = this;
        zzcbj2.zzwh();
        String string5 = zzcbj2.zziky;
        long l2 = zzcap.zzauu();
        zzcbj2 = this;
        zzcbj2.zzwh();
        ((zzcdl)zzcbj2).zzug();
        if (zzcbj2.zzipa == 0L) {
            zzcbj2.zzipa = zzcbj2.zzikb.zzaug().zzai(((zzcdl)zzcbj2).getContext(), ((zzcdl)zzcbj2).getContext().getPackageName());
        }
        long l3 = zzcbj2.zzipa;
        boolean bl = this.zzikb.isEnabled();
        boolean bl2 = !((zzcdl)this).zzaul().zziqy;
        String string6 = this.zzaup();
        this.zzwh();
        long l4 = this.zzikb.zzazd();
        zzcbj2 = this;
        zzcbj2.zzwh();
        return new zzcak(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcbj2.zzipb);
    }

    @WorkerThread
    final String zzaxz() {
        byte[] byArray = new byte[16];
        ((zzcdl)this).zzaug().zzazx().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzaup() {
        ((zzcdl)this).zzug();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdl)this).zzauk().zzaye().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwh();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwh();
        return this.zzcxs;
    }

    final int zzaya() {
        this.zzwh();
        return this.zzioz;
    }
}

