/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzccl;
import com.google.android.gms.internal.zzccm;
import com.google.android.gms.internal.zzccn;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzccj
extends zzcdm {
    private ExecutorService zzirr;
    private zzccn zzirs;
    private zzccn zzirt;
    private final PriorityBlockingQueue<FutureTask<?>> zziru;
    private final BlockingQueue<FutureTask<?>> zzirv;
    private final Thread.UncaughtExceptionHandler zzirw;
    private final Thread.UncaughtExceptionHandler zzirx;
    private final Object zziry = new Object();
    private final Semaphore zzirz = new Semaphore(2);
    private volatile boolean zzisa;
    private static final AtomicLong zzisb = new AtomicLong(Long.MIN_VALUE);

    zzccj(zzcco zzcco2) {
        super(zzcco2);
        this.zziru = new PriorityBlockingQueue();
        this.zzirv = new LinkedBlockingQueue();
        this.zzirw = new zzccl(this, "Thread death: Uncaught exception on worker thread");
        this.zzirx = new zzccl(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzuh() {
    }

    @Override
    public final void zzug() {
        if (Thread.currentThread() != this.zzirs) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzatv() {
        if (Thread.currentThread() != this.zzirt) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzaq() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzayr() {
        return Thread.currentThread() == this.zzirs;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu(callable);
        zzccm zzccm2 = new zzccm(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzirs) {
            if (!this.zziru.isEmpty()) {
                ((zzcdl)this).zzauk().zzaye().log("Callable skipped the worker queue.");
            }
            zzccm2.run();
        } else {
            this.zza(zzccm2);
        }
        return zzccm2;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu(callable);
        zzccm zzccm2 = new zzccm(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzirs) {
            zzccm2.run();
        } else {
            this.zza(zzccm2);
        }
        return zzccm2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu((Object)runnable);
        this.zza(new zzccm(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzccm<?> zzccm2) {
        Object object = this.zziry;
        synchronized (object) {
            this.zziru.add(zzccm2);
            if (this.zzirs == null) {
                this.zzirs = new zzccn(this, "Measurement Worker", this.zziru);
                this.zzirs.setUncaughtExceptionHandler(this.zzirw);
                this.zzirs.start();
            } else {
                this.zzirs.zzmi();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu((Object)runnable);
        zzccm zzccm2 = new zzccm(this, runnable, false, "Task exception on network thread");
        zzccj zzccj2 = this;
        Object object = zzccj2.zziry;
        synchronized (object) {
            zzccj2.zzirv.add(zzccm2);
            if (zzccj2.zzirt == null) {
                zzccj2.zzirt = new zzccn(zzccj2, "Measurement Network", zzccj2.zzirv);
                zzccj2.zzirt.setUncaughtExceptionHandler(zzccj2.zzirx);
                zzccj2.zzirt.start();
            } else {
                zzccj2.zzirt.zzmi();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzays() {
        Object object = this.zziry;
        synchronized (object) {
            if (this.zzirr == null) {
                this.zzirr = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzirr;
        }
    }

    static /* synthetic */ Semaphore zza(zzccj zzccj2) {
        return zzccj2.zzirz;
    }

    static /* synthetic */ boolean zzb(zzccj zzccj2) {
        return zzccj2.zzisa;
    }

    static /* synthetic */ Object zzc(zzccj zzccj2) {
        return zzccj2.zziry;
    }

    static /* synthetic */ zzccn zzd(zzccj zzccj2) {
        return zzccj2.zzirs;
    }

    static /* synthetic */ zzccn zza(zzccj zzccj2, zzccn zzccn2) {
        zzccj2.zzirs = null;
        return null;
    }

    static /* synthetic */ zzccn zze(zzccj zzccj2) {
        return zzccj2.zzirt;
    }

    static /* synthetic */ zzccn zzb(zzccj zzccj2, zzccn zzccn2) {
        zzccj2.zzirt = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzayt() {
        return zzisb;
    }
}

