/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzcaf;
import com.google.android.gms.internal.zzcaj;
import com.google.android.gms.internal.zzcak;
import com.google.android.gms.internal.zzcam;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcar;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcaw;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcay;
import com.google.android.gms.internal.zzcaz;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbe;
import com.google.android.gms.internal.zzcbj;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcbq;
import com.google.android.gms.internal.zzcbs;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcbx;
import com.google.android.gms.internal.zzcbz;
import com.google.android.gms.internal.zzccf;
import com.google.android.gms.internal.zzcci;
import com.google.android.gms.internal.zzccj;
import com.google.android.gms.internal.zzccp;
import com.google.android.gms.internal.zzccq;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccs;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzcdn;
import com.google.android.gms.internal.zzcdo;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfj;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcga;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegg;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzcco {
    private static volatile zzcco zzisi;
    private final Context mContext;
    private final zzcap zzisj;
    private final zzcbz zzisk;
    private final zzcbo zzisl;
    private final zzccj zzism;
    private final zzcfd zzisn;
    private final zzcci zziso;
    private final AppMeasurement zzisp;
    private final FirebaseAnalytics zzisq;
    private final zzcfo zzisr;
    private final zzcbm zziss;
    private final zzcaq zzist;
    private final zzcbk zzisu;
    private final zzcbs zzisv;
    private final zzd zzasl;
    private final zzcec zzisw;
    private final zzceg zzisx;
    private final zzcaw zzisy;
    private final zzcdo zzisz;
    private final zzcbj zzita;
    private final zzcbx zzitb;
    private final zzcfj zzitc;
    private final zzcam zzitd;
    private final zzcaf zzite;
    private final boolean zzdoj;
    private boolean zzitf;
    private Boolean zzitg;
    private long zzith;
    private FileLock zziti;
    private FileChannel zzitj;
    private List<Long> zzitk;
    private List<Runnable> zzitl;
    private int zzitm;
    private int zzitn;
    private long zzito;
    private long zzitp;
    private boolean zzitq;
    private boolean zzitr;
    private boolean zzits;
    private final long zzitt;

    private zzcco(zzcdn zzcdn2) {
        zzcaf zzcaf2;
        String string;
        zzcbq zzcbq2;
        zzbp.zzu((Object)zzcdn2);
        this.mContext = zzcdn2.mContext;
        this.zzito = -1L;
        this.zzasl = zzh.zzalc();
        this.zzitt = this.zzasl.currentTimeMillis();
        Object object = this;
        this.zzisj = new zzcap((zzcco)object);
        object = this;
        zzcbz zzcbz2 = new zzcbz((zzcco)object);
        zzcbz2.initialize();
        this.zzisk = zzcbz2;
        object = this;
        zzcbo zzcbo2 = new zzcbo((zzcco)object);
        zzcbo2.initialize();
        this.zzisl = zzcbo2;
        this.zzauk().zzayg().zzj("App measurement is starting up, version", zzcap.zzauu());
        zzcap.zzawj();
        this.zzauk().zzayg().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcfo zzcfo2 = new zzcfo((zzcco)object);
        zzcfo2.initialize();
        this.zzisr = zzcfo2;
        object = this;
        zzcbm zzcbm2 = new zzcbm((zzcco)object);
        zzcbm2.initialize();
        this.zziss = zzcbm2;
        object = this;
        zzcaw zzcaw2 = new zzcaw((zzcco)object);
        zzcaw2.initialize();
        this.zzisy = zzcaw2;
        object = this;
        zzcbj zzcbj2 = new zzcbj((zzcco)object);
        zzcbj2.initialize();
        this.zzita = zzcbj2;
        zzcap.zzawj();
        Object object2 = zzcbj2.getAppId();
        if (this.zzaug().zzke((String)object2)) {
            zzcbq2 = this.zzauk().zzayg();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcbq2 = this.zzauk().zzayg();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcbq2.log(string);
        this.zzauk().zzayh().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcaq((zzcco)object);
        ((zzcdm)object2).initialize();
        this.zzist = object2;
        object = this;
        zzcbk zzcbk2 = new zzcbk((zzcco)object);
        zzcbk2.initialize();
        this.zzisu = zzcbk2;
        object = this;
        zzcam zzcam2 = new zzcam((zzcco)object);
        zzcam2.initialize();
        this.zzitd = zzcam2;
        object = this;
        this.zzite = zzcaf2 = new zzcaf((zzcco)object);
        object = this;
        zzcbs zzcbs2 = new zzcbs((zzcco)object);
        zzcbs2.initialize();
        this.zzisv = zzcbs2;
        object = this;
        zzcec zzcec2 = new zzcec((zzcco)object);
        zzcec2.initialize();
        this.zzisw = zzcec2;
        object = this;
        zzceg zzceg2 = new zzceg((zzcco)object);
        zzceg2.initialize();
        this.zzisx = zzceg2;
        object = this;
        zzcdo zzcdo2 = new zzcdo((zzcco)object);
        zzcdo2.initialize();
        this.zzisz = zzcdo2;
        object = this;
        zzcfj zzcfj2 = new zzcfj((zzcco)object);
        zzcfj2.initialize();
        this.zzitc = zzcfj2;
        object = this;
        this.zzitb = new zzcbx((zzcco)object);
        object = this;
        this.zzisp = new AppMeasurement((zzcco)object);
        object = this;
        this.zzisq = new FirebaseAnalytics((zzcco)object);
        object = this;
        zzcfd zzcfd2 = new zzcfd((zzcco)object);
        zzcfd2.initialize();
        this.zzisn = zzcfd2;
        object = this;
        zzcci zzcci2 = new zzcci((zzcco)object);
        zzcci2.initialize();
        this.zziso = zzcci2;
        object = this;
        zzccj zzccj2 = new zzccj((zzcco)object);
        zzccj2.initialize();
        this.zzism = zzccj2;
        if (this.zzitm != this.zzitn) {
            this.zzauk().zzayc().zze("Not all components initialized", this.zzitm, this.zzitn);
        }
        this.zzdoj = true;
        zzcap.zzawj();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzaty();
            if (((zzcdl)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcdl)object).getContext().getApplicationContext();
                if (((zzcdo)object).zziuk == null) {
                    ((zzcdo)object).zziuk = new zzceb((zzcdo)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdo)object).zziuk);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdo)object).zziuk);
                ((zzcdl)object).zzauk().zzayi().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzauk().zzaye().log("Application context is not an Application");
        }
        this.zzism.zzg(new zzccp(this));
    }

    final void zzwh() {
        if (!this.zzdoj) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzayu() {
        this.zzwh();
        ((zzcdl)this.zzauj()).zzug();
        if (this.zzitg == null || this.zzith == 0L || this.zzitg != null && !this.zzitg.booleanValue() && Math.abs(this.zzasl.elapsedRealtime() - this.zzith) > 1000L) {
            this.zzith = this.zzasl.elapsedRealtime();
            zzcap.zzawj();
            this.zzitg = this.zzaug().zzdu("android.permission.INTERNET") && this.zzaug().zzdu("android.permission.ACCESS_NETWORK_STATE") && (zzbdp.zzcs((Context)this.mContext).zzalq() || zzccf.zzj(this.mContext, false) && zzcez.zzk(this.mContext, false));
            if (this.zzitg.booleanValue()) {
                this.zzitg = this.zzaug().zzkb(this.zzatz().getGmpAppId());
            }
        }
        return this.zzitg;
    }

    @WorkerThread
    protected final void start() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzaue().zzaxj();
        if (this.zzaul().zziqg.get() == 0L) {
            this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
        }
        if (Long.valueOf(this.zzaul().zziql.get()) == 0L) {
            this.zzauk().zzayi().zzj("Persisting first open", this.zzitt);
            this.zzaul().zziql.set(this.zzitt);
        }
        if (!this.zzayu()) {
            if (this.isEnabled()) {
                if (!this.zzaug().zzdu("android.permission.INTERNET")) {
                    this.zzauk().zzayc().log("App is missing INTERNET permission");
                }
                if (!this.zzaug().zzdu("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzauk().zzayc().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcap.zzawj();
                if (!zzbdp.zzcs((Context)this.mContext).zzalq()) {
                    if (!zzccf.zzj(this.mContext, false)) {
                        this.zzauk().zzayc().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcez.zzk(this.mContext, false)) {
                        this.zzauk().zzayc().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzauk().zzayc().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcap.zzawj();
            if (!TextUtils.isEmpty((CharSequence)this.zzatz().getGmpAppId())) {
                String string = this.zzaul().zzayl();
                if (string == null) {
                    this.zzaul().zzjj(this.zzatz().getGmpAppId());
                } else if (!string.equals(this.zzatz().getGmpAppId())) {
                    this.zzauk().zzayg().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzaul().zzayo();
                    this.zzisx.disconnect();
                    this.zzisx.zzxe();
                    this.zzaul().zzjj(this.zzatz().getGmpAppId());
                    this.zzaul().zziql.set(this.zzitt);
                    this.zzaul().zziqm.zzjl(null);
                }
            }
            this.zzaty().zzjk(this.zzaul().zziqm.zzayq());
            zzcap.zzawj();
            if (!TextUtils.isEmpty((CharSequence)this.zzatz().getGmpAppId())) {
                zzcdo zzcdo2 = this.zzaty();
                ((zzcdl)zzcdo2).zzug();
                ((zzcdl)zzcdo2).zzatu();
                zzcdo2.zzwh();
                if (zzcdo2.zzikb.zzayu()) {
                    ((zzcdl)zzcdo2).zzaub().zzazp();
                    String string = ((zzcdl)zzcdo2).zzaul().zzayp();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcdl)zzcdo2).zzaua().zzwh();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcdo2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzaub().zza(new AtomicReference<String>());
            }
        }
        this.zzazh();
    }

    public final zzcap zzaum() {
        return this.zzisj;
    }

    public final zzcbz zzaul() {
        zzcco.zza((zzcdl)this.zzisk);
        return this.zzisk;
    }

    public final zzcbo zzauk() {
        zzcco.zza(this.zzisl);
        return this.zzisl;
    }

    public final zzcbo zzayv() {
        if (this.zzisl != null && this.zzisl.isInitialized()) {
            return this.zzisl;
        }
        return null;
    }

    public final zzccj zzauj() {
        zzcco.zza(this.zzism);
        return this.zzism;
    }

    public final zzcfd zzaui() {
        zzcco.zza(this.zzisn);
        return this.zzisn;
    }

    public final zzcci zzauh() {
        zzcco.zza(this.zziso);
        return this.zziso;
    }

    final zzccj zzayw() {
        return this.zzism;
    }

    public final zzcdo zzaty() {
        zzcco.zza(this.zzisz);
        return this.zzisz;
    }

    public final AppMeasurement zzayx() {
        return this.zzisp;
    }

    public final FirebaseAnalytics zzayy() {
        return this.zzisq;
    }

    public final zzcfo zzaug() {
        zzcco.zza((zzcdl)this.zzisr);
        return this.zzisr;
    }

    public final zzcbm zzauf() {
        zzcco.zza((zzcdl)this.zziss);
        return this.zziss;
    }

    public final zzcaq zzaue() {
        zzcco.zza(this.zzist);
        return this.zzist;
    }

    public final zzcbk zzaud() {
        zzcco.zza(this.zzisu);
        return this.zzisu;
    }

    public final zzcbs zzayz() {
        zzcco.zza(this.zzisv);
        return this.zzisv;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzvu() {
        return this.zzasl;
    }

    public final zzcec zzauc() {
        zzcco.zza(this.zzisw);
        return this.zzisw;
    }

    public final zzceg zzaub() {
        zzcco.zza(this.zzisx);
        return this.zzisx;
    }

    public final zzcaw zzaua() {
        zzcco.zza(this.zzisy);
        return this.zzisy;
    }

    public final zzcbj zzatz() {
        zzcco.zza(this.zzita);
        return this.zzita;
    }

    private final zzcbx zzaza() {
        if (this.zzitb == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzitb;
    }

    private final zzcfj zzazb() {
        zzcco.zza(this.zzitc);
        return this.zzitc;
    }

    public final zzcam zzatx() {
        zzcco.zza(this.zzitd);
        return this.zzitd;
    }

    public final zzcaf zzatw() {
        zzcco.zza(this.zzite);
        return this.zzite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzcco zzdm(Context context) {
        zzbp.zzu((Object)context);
        zzbp.zzu((Object)context.getApplicationContext());
        if (zzisi != null) return zzisi;
        Class<zzcco> clazz = zzcco.class;
        synchronized (zzcco.class) {
            if (zzisi != null) return zzisi;
            zzcdn zzcdn2 = new zzcdn(context);
            zzisi = new zzcco(zzcdn2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzisi;
        }
    }

    private static void zza(zzcdm zzcdm2) {
        if (zzcdm2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcdm2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcdl zzcdl2) {
        if (zzcdl2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzazc() {
        ((zzcdl)this.zzauj()).zzug();
        String string = zzcap.zzawh();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzitj = new RandomAccessFile(file2, "rw").getChannel();
            this.zziti = this.zzitj.tryLock();
            if (this.zziti != null) {
                this.zzauk().zzayi().log("Storage concurrent access okay");
                return true;
            }
            this.zzauk().zzayc().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzauk().zzayc().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcdl)this.zzauj()).zzug();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzauk().zzayc().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzauk().zzaye().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcdl)this.zzauj()).zzug();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzauk().zzayc().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzauk().zzayc().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (this.zzisj.zzawk()) {
            return false;
        }
        Boolean bl = this.zzisj.zzit("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcap.zzaie();
        return this.zzaul().zzbn(bl2);
    }

    final void zzd(zzcak zzcak2) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzgf((String)zzcak2.packageName);
        this.zzf(zzcak2);
    }

    final long zzazd() {
        Long l = this.zzaul().zziql.get();
        if (l == 0L) {
            return this.zzitt;
        }
        return Math.min(this.zzitt, l);
    }

    private final long zzaze() {
        long l = this.zzasl.currentTimeMillis();
        zzcbz zzcbz2 = this.zzaul();
        zzcbz2.zzwh();
        zzcbz2.zzug();
        long l2 = zzcbz2.zziqk.get();
        if (l2 == 0L) {
            l2 = 1 + zzcbz2.zzaug().zzazx().nextInt(86400000);
            zzcbz2.zziqk.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcak zzjr(String string) {
        zzcaj zzcaj2 = this.zzaue().zziw(string);
        if (zzcaj2 == null || TextUtils.isEmpty((CharSequence)zzcaj2.zzul())) {
            this.zzauk().zzayh().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbdp.zzcs((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcaj2.zzul() != null && !zzcaj2.zzul().equals(string2)) {
                this.zzauk().zzaye().zzj("App version does not match; dropping. appId", zzcbo.zzjf(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcak(string, zzcaj2.getGmpAppId(), zzcaj2.zzul(), zzcaj2.zzaus(), zzcaj2.zzaut(), zzcaj2.zzauu(), zzcaj2.zzauv(), null, zzcaj2.zzauw(), false, zzcaj2.zzaup(), zzcaj2.zzavj(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcbc zzcbc2, String string) {
        Object object;
        zzcaj zzcaj2;
        block4: {
            zzcaj2 = this.zzaue().zziw(string);
            if (zzcaj2 == null || TextUtils.isEmpty((CharSequence)zzcaj2.zzul())) {
                this.zzauk().zzayh().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbdp.zzcs((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcaj2.zzul() != null && !zzcaj2.zzul().equals(object)) {
                    this.zzauk().zzaye().zzj("App version does not match; dropping event. appId", zzcbo.zzjf(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcbc2.name)) break block4;
                this.zzauk().zzaye().zzj("Could not find package. appId", zzcbo.zzjf(string));
            }
        }
        object = new zzcak(string, zzcaj2.getGmpAppId(), zzcaj2.zzul(), zzcaj2.zzaus(), zzcaj2.zzaut(), zzcaj2.zzauu(), zzcaj2.zzauv(), null, zzcaj2.zzauw(), false, zzcaj2.zzaup(), zzcaj2.zzavj(), 0L, 0);
        this.zzb(zzcbc2, (zzcak)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcbc zzcbc2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcak2));
        zzbp.zzgf((String)zzcak2.packageName);
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        String string = zzcak2.packageName;
        long l = zzcbc2.zzink;
        this.zzaug();
        if (!zzcfo.zzd(zzcbc2, zzcak2)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        this.zzaue().beginTransaction();
        try {
            com.google.android.gms.common.internal.safeparcel.zza zza2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcaq zzcaq2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzcaq2.zzug();
            zzcaq2.zzwh();
            if (l2 < 0L) {
                zzcaq2.zzauk().zzaye().zze("Invalid time querying timed out conditional properties", zzcbo.zzjf(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcaq2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzauk().zzayh().zzd("User property timed out", object22.packageName, this.zzauf().zzje(object22.zzima.name), object22.zzima.getValue());
                if (object22.zzime != null) {
                    this.zzc(new zzcbc(object22.zzime, l), zzcak2);
                }
                this.zzaue().zzal(string, object22.zzima.name);
            }
            l2 = l;
            string3 = string;
            zzcaq2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzcaq2.zzug();
            zzcaq2.zzwh();
            if (l2 < 0L) {
                zzcaq2.zzauk().zzaye().zze("Invalid time querying expired conditional properties", zzcbo.zzjf(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcaq2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcan)((Object)object4.next());
                if (object == null) continue;
                this.zzauk().zzayh().zzd("User property expired", object.packageName, this.zzauf().zzje(object.zzima.name), object.zzima.getValue());
                this.zzaue().zzai(string, object.zzima.name);
                if (object.zzimi != null) {
                    object22.add(object.zzimi);
                }
                this.zzaue().zzal(string, object.zzima.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcbc)((Object)e);
                this.zzc(new zzcbc((zzcbc)((Object)object), l), zzcak2);
            }
            long l3 = l;
            String string4 = zzcbc2.name;
            string3 = string;
            zzcaq2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzbp.zzgf((String)string4);
            zzcaq2.zzug();
            zzcaq2.zzwh();
            if (l3 < 0L) {
                zzcaq2.zzauk().zzaye().zzd("Invalid time querying triggered conditional properties", zzcbo.zzjf(string3), zzcaq2.zzauf().zzjc(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcaq2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zza2 = (zzcan)((Object)iterator.next());
                if (zza2 == null) continue;
                zzcfl zzcfl2 = zza2.zzima;
                zzcfn zzcfn2 = new zzcfn(zza2.packageName, zza2.zzilz, zzcfl2.name, l, zzcfl2.getValue());
                if (this.zzaue().zza(zzcfn2)) {
                    this.zzauk().zzayh().zzd("User property triggered", zza2.packageName, this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                } else {
                    this.zzauk().zzayc().zzd("Too many active user properties, ignoring", zzcbo.zzjf(zza2.packageName), this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                }
                if (zza2.zzimg != null) {
                    object.add(zza2.zzimg);
                }
                zza2.zzima = new zzcfl(zzcfn2);
                zza2.zzimc = true;
                this.zzaue().zza((zzcan)zza2);
            }
            this.zzc(zzcbc2, zzcak2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zza2 = (zzcbc)((Object)e);
                this.zzc(new zzcbc((zzcbc)zza2, l), zzcak2);
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcbc zzcbc2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcak2));
        zzbp.zzgf((String)zzcak2.packageName);
        long l = System.nanoTime();
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        String string = zzcak2.packageName;
        this.zzaug();
        if (!zzcfo.zzd(zzcbc2, zzcak2)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        if (this.zzauh().zzaq(string, zzcbc2.name)) {
            this.zzauk().zzaye().zze("Dropping blacklisted event. appId", zzcbo.zzjf(string), this.zzauf().zzjc(zzcbc2.name));
            boolean bl = this.zzaug().zzkg(string) || this.zzaug().zzkh(string);
            if (!bl && !"_err".equals(zzcbc2.name)) {
                this.zzaug().zza(string, 11, "_ev", zzcbc2.name, 0);
            }
            if (!bl) return;
            zzcaj zzcaj2 = this.zzaue().zziw(string);
            if (zzcaj2 == null) return;
            long l2 = Math.max(zzcaj2.zzauz(), zzcaj2.zzauy());
            if (Math.abs(this.zzasl.currentTimeMillis() - l2) <= zzcap.zzawn()) return;
            this.zzauk().zzayh().log("Fetching config for blacklisted app");
            this.zzb(zzcaj2);
            return;
        }
        if (this.zzauk().zzad(2)) {
            this.zzauk().zzayi().zzj("Logging event", this.zzauf().zzb(zzcbc2));
        }
        this.zzaue().beginTransaction();
        try {
            zzcay zzcay2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcbc2.zzinj.zzaxy();
            this.zzf(zzcak2);
            if ("_iap".equals(zzcbc2.name) || "ecommerce_purchase".equals(zzcbc2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcbc2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzauk().zzaye().zze("Data lost. Currency value is too big. appId", zzcbo.zzjf(string), d);
                            this.zzaue().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcfn zzcfn2 = this.zzaue().zzaj(string, string6);
                    if (zzcfn2 == null || !(zzcfn2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzisj.zzb(string2, zzcbe.zziow) - 1;
                        string2 = string;
                        zzcaq zzcaq2 = this.zzaue();
                        zzbp.zzgf((String)string2);
                        zzcaq2.zzug();
                        zzcaq2.zzwh();
                        try {
                            zzcaq2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcaq2.zzauk().zzayc().zze("Error pruning currencies. appId", zzcbo.zzjf(string2), (Object)sQLiteException);
                        }
                        zzcfn2 = new zzcfn(string, zzcbc2.zzilz, string6, this.zzasl.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcfn2.mValue;
                        zzcfn2 = new zzcfn(string, zzcbc2.zzilz, string6, this.zzasl.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzaue().zza(zzcfn2)) {
                        this.zzauk().zzayc().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcbo.zzjf(string), this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                        this.zzaug().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcfo.zzju(zzcbc2.name);
            boolean bl2 = "_err".equals(zzcbc2.name);
            zzcar zzcar2 = this.zzaue().zza(this.zzaze(), string, true, bl, false, bl2, false);
            long l5 = zzcar2.zzims - zzcap.zzavv();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzauk().zzayc().zze("Data loss. Too many events logged. appId, count", zzcbo.zzjf(string), zzcar2.zzims);
                }
                this.zzaue().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcar2.zzimr - zzcap.zzavw()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzauk().zzayc().zze("Data loss. Too many public events logged. appId, count", zzcbo.zzjf(string), zzcar2.zzimr);
                }
                this.zzaug().zza(string, 16, "_ev", zzcbc2.name, 0);
                this.zzaue().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzcak2.packageName;
                n = this.zzisj.zzb(string2, zzcbe.zziod);
                l5 = zzcar2.zzimu - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzauk().zzayc().zze("Too many error events logged. appId, count", zzcbo.zzjf(string), zzcar2.zzimu);
                    }
                    this.zzaue().setTransactionSuccessful();
                    return;
                }
            }
            this.zzaug().zza(bundle, "_o", (Object)zzcbc2.zzilz);
            if (this.zzaug().zzke(string)) {
                this.zzaug().zza(bundle, "_dbg", 1L);
                this.zzaug().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzaue().zzix(string)) > 0L) {
                this.zzauk().zzaye().zze("Data lost. Too many events stored on disk, deleted. appId", zzcbo.zzjf(string), l3);
            }
            zzcax zzcax2 = new zzcax(this, zzcbc2.zzilz, string, zzcbc2.name, zzcbc2.zzink, 0L, bundle);
            zzcay zzcay3 = this.zzaue().zzah(string, zzcax2.mName);
            if (zzcay3 == null) {
                long l6 = this.zzaue().zzja(string);
                zzcap.zzavu();
                if (l6 >= 500L) {
                    this.zzauk().zzayc().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcbo.zzjf(string), this.zzauf().zzjc(zzcax2.mName), zzcap.zzavu());
                    this.zzaug().zza(string, 8, null, null, 0);
                    return;
                }
                zzcay2 = new zzcay(string, zzcax2.mName, 0L, 0L, zzcax2.zzfcw);
            } else {
                zzcax2 = zzcax2.zza(this, zzcay3.zzinf);
                zzcay2 = zzcay3.zzbb(zzcax2.zzfcw);
            }
            this.zzaue().zza(zzcay2);
            this.zza(zzcax2, zzcak2);
            this.zzaue().setTransactionSuccessful();
            if (this.zzauk().zzad(2)) {
                this.zzauk().zzayi().zzj("Event recorded", this.zzauf().zza(zzcax2));
            }
        }
        finally {
            this.zzaue().endTransaction();
        }
        this.zzazh();
        this.zzauk().zzayi().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcan zzcan2) {
        zzcak zzcak2 = this.zzjr(zzcan2.packageName);
        if (zzcak2 != null) {
            this.zzb(zzcan2, zzcak2);
        }
    }

    @WorkerThread
    final void zzb(zzcan zzcan2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcan2));
        zzbp.zzgf((String)zzcan2.packageName);
        zzbp.zzu((Object)zzcan2.zzilz);
        zzbp.zzu((Object)((Object)zzcan2.zzima));
        zzbp.zzgf((String)zzcan2.zzima.name);
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        zzcan zzcan3 = new zzcan(zzcan2);
        new zzcan(zzcan2).zzimc = false;
        this.zzaue().beginTransaction();
        try {
            boolean bl = false;
            zzcan zzcan4 = this.zzaue().zzak(zzcan3.packageName, zzcan3.zzima.name);
            if (zzcan4 != null && !zzcan4.zzilz.equals(zzcan3.zzilz)) {
                this.zzauk().zzaye().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzauf().zzje(zzcan3.zzima.name), zzcan3.zzilz, zzcan4.zzilz);
            }
            if (zzcan4 != null && zzcan4.zzimc) {
                zzcan3.zzilz = zzcan4.zzilz;
                zzcan3.zzimb = zzcan4.zzimb;
                zzcan3.zzimf = zzcan4.zzimf;
                zzcan3.zzimd = zzcan4.zzimd;
                zzcan3.zzimg = zzcan4.zzimg;
                zzcan3.zzimc = zzcan4.zzimc;
                zzcan3.zzima = new zzcfl(zzcan3.zzima.name, zzcan4.zzima.zziwu, zzcan3.zzima.getValue(), zzcan4.zzima.zzilz);
            } else if (TextUtils.isEmpty((CharSequence)zzcan3.zzimd)) {
                zzcan3.zzima = new zzcfl(zzcan3.zzima.name, zzcan3.zzimb, zzcan3.zzima.getValue(), zzcan3.zzima.zzilz);
                zzcan3.zzimc = true;
                bl = true;
            }
            if (zzcan3.zzimc) {
                zzcfl zzcfl2 = zzcan3.zzima;
                zzcfn zzcfn2 = new zzcfn(zzcan3.packageName, zzcan3.zzilz, zzcfl2.name, zzcfl2.zziwu, zzcfl2.getValue());
                if (this.zzaue().zza(zzcfn2)) {
                    this.zzauk().zzayh().zzd("User property updated immediately", zzcan3.packageName, this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                } else {
                    this.zzauk().zzayc().zzd("(2)Too many active user properties, ignoring", zzcbo.zzjf(zzcan3.packageName), this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                }
                if (bl && zzcan3.zzimg != null) {
                    zzcbc zzcbc2 = new zzcbc(zzcan3.zzimg, zzcan3.zzimb);
                    this.zzc(zzcbc2, zzcak2);
                }
            }
            if (this.zzaue().zza(zzcan3)) {
                this.zzauk().zzayh().zzd("Conditional property added", zzcan3.packageName, this.zzauf().zzje(zzcan3.zzima.name), zzcan3.zzima.getValue());
            } else {
                this.zzauk().zzayc().zzd("Too many conditional properties, ignoring", zzcbo.zzjf(zzcan3.packageName), this.zzauf().zzje(zzcan3.zzima.name), zzcan3.zzima.getValue());
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcan zzcan2) {
        zzcak zzcak2 = this.zzjr(zzcan2.packageName);
        if (zzcak2 != null) {
            this.zzc(zzcan2, zzcak2);
        }
    }

    @WorkerThread
    final void zzc(zzcan zzcan2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcan2));
        zzbp.zzgf((String)zzcan2.packageName);
        zzbp.zzu((Object)((Object)zzcan2.zzima));
        zzbp.zzgf((String)zzcan2.zzima.name);
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcak2);
            zzcan zzcan3 = this.zzaue().zzak(zzcan2.packageName, zzcan2.zzima.name);
            if (zzcan3 != null) {
                this.zzauk().zzayh().zze("Removing conditional user property", zzcan2.packageName, this.zzauf().zzje(zzcan2.zzima.name));
                this.zzaue().zzal(zzcan2.packageName, zzcan2.zzima.name);
                if (zzcan3.zzimc) {
                    this.zzaue().zzai(zzcan2.packageName, zzcan2.zzima.name);
                }
                if (zzcan2.zzimi != null) {
                    Bundle bundle = null;
                    if (zzcan2.zzimi.zzinj != null) {
                        bundle = zzcan2.zzimi.zzinj.zzaxy();
                    }
                    zzcbc zzcbc2 = this.zzaug().zza(zzcan2.zzimi.name, bundle, zzcan3.zzilz, zzcan2.zzimi.zzink, true, false);
                    this.zzc(zzcbc2, zzcak2);
                }
            } else {
                this.zzauk().zzaye().zze("Conditional user property doesn't exist", zzcbo.zzjf(zzcan2.packageName), this.zzauf().zzje(zzcan2.zzima.name));
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcbc zzcbc2, @Size(min=1L) String string) {
        Object object;
        this.zzwh();
        ((zzcdl)this.zzauj()).zzug();
        zzcco.zzatt();
        zzbp.zzu((Object)((Object)zzcbc2));
        zzbp.zzgf((String)string);
        zzcgb zzcgb2 = new zzcgb();
        this.zzaue().beginTransaction();
        try {
            zzcay zzcay2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcaj zzcaj2 = this.zzaue().zziw(string);
            if (zzcaj2 == null) {
                this.zzauk().zzayh().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcaj2.zzauw()) {
                this.zzauk().zzayh().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcgc();
            zzcgb2.zziyx = new zzcgc[]{object};
            object.zziyz = 1;
            object.zzizh = "android";
            object.zzch = zzcaj2.getAppId();
            object.zzilo = zzcaj2.zzaut();
            object.zzhtl = zzcaj2.zzul();
            long l2 = zzcaj2.zzaus();
            object.zzizu = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzizl = zzcaj2.zzauu();
            object.zziln = zzcaj2.getGmpAppId();
            object.zzizq = zzcaj2.zzauv();
            if (this.isEnabled() && zzcap.zzaxg() && this.zzisj.zziu(object.zzch)) {
                this.zzatz();
                object.zzizz = null;
            }
            if ((pair = this.zzaul().zzjh(zzcaj2.getAppId())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzizn = (String)pair.first;
                object.zzizo = (Boolean)pair.second;
            }
            this.zzaua().zzwh();
            object.zzizi = Build.MODEL;
            this.zzaua().zzwh();
            object.zzcy = Build.VERSION.RELEASE;
            object.zzizk = (int)this.zzaua().zzaxv();
            object.zzizj = this.zzaua().zzaxw();
            object.zzizp = zzcaj2.getAppInstanceId();
            object.zzilv = zzcaj2.zzaup();
            List<zzcfn> list = this.zzaue().zziv(zzcaj2.getAppId());
            object.zzizb = new zzcge[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcge();
                object.zzizb[i] = object2;
                ((zzcge)((Object)object2)).name = list.get((int)i).mName;
                ((zzcge)((Object)object2)).zzjad = list.get((int)i).zziwy;
                this.zzaug().zza((zzcge)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcbc2.zzinj.zzaxy();
            if ("_iap".equals(zzcbc2.name)) {
                bundle.putLong("_c", 1L);
                this.zzauk().zzayh().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcbc2.zzilz);
            if (this.zzaug().zzke(object.zzch)) {
                this.zzaug().zza(bundle, "_dbg", 1L);
                this.zzaug().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzaue().zzah(string, zzcbc2.name)) == null) {
                l = 0L;
                zzcay2 = new zzcay(string, zzcbc2.name, 1L, 0L, zzcbc2.zzink);
                this.zzaue().zza(zzcay2);
            } else {
                l = ((zzcay)object2).zzinf;
                zzcay2 = ((zzcay)object2).zzbb(zzcbc2.zzink).zzaxx();
                this.zzaue().zza(zzcay2);
            }
            zzcax zzcax2 = new zzcax(this, zzcbc2.zzilz, string, zzcbc2.name, zzcbc2.zzink, l, bundle);
            zzcfz zzcfz2 = new zzcfz();
            object.zziza = new zzcfz[]{zzcfz2};
            zzcfz2.zziyt = zzcax2.zzfcw;
            zzcfz2.name = zzcax2.mName;
            zzcfz2.zziyu = zzcax2.zzinb;
            zzcfz2.zziys = new zzcga[zzcax2.zzinc.size()];
            int n = 0;
            for (String string2 : zzcax2.zzinc) {
                zzcga zzcga2 = new zzcga();
                zzcfz2.zziys[n++] = zzcga2;
                zzcga2.name = string2;
                Object object3 = zzcax2.zzinc.get(string2);
                this.zzaug().zza(zzcga2, object3);
            }
            object.zzizt = this.zza(zzcaj2.getAppId(), object.zzizb, object.zziza);
            object.zzizd = zzcfz2.zziyt;
            object.zzize = zzcfz2.zziyt;
            long l3 = zzcaj2.zzaur();
            object.zzizg = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcaj2.zzauq();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzizf = l4 != 0L ? Long.valueOf(l4) : null;
            zzcaj2.zzava();
            object.zzizr = (int)zzcaj2.zzaux();
            object.zzizm = zzcap.zzauu();
            object.zzizc = this.zzasl.currentTimeMillis();
            object.zzizs = Boolean.TRUE;
            zzcaj2.zzal(object.zzizd);
            zzcaj2.zzam(object.zzize);
            this.zzaue().zza(zzcaj2);
            this.zzaue().setTransactionSuccessful();
        }
        finally {
            this.zzaue().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcgb2.zzbjo()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzegg zzegg2 = zzegg.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgb2.zza(zzegg2);
            zzegg2.zzccd();
            return this.zzaug().zzo((byte[])object);
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Data loss. Failed to bundle and serialize. appId", zzcbo.zzjf(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcax var1_1, zzcak var2_2) {
        block10: {
            this.zzauj().zzug();
            this.zzwh();
            zzbp.zzu((Object)var1_1);
            zzbp.zzu((Object)var2_2);
            zzbp.zzgf((String)var1_1.mAppId);
            zzbp.zzbh((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcgc();
            new zzcgc().zziyz = 1;
            var3_3.zzizh = "android";
            var3_3.zzch = var2_2.packageName;
            var3_3.zzilo = var2_2.zzilo;
            var3_3.zzhtl = var2_2.zzhtl;
            var3_3.zzizu = var2_2.zzilu == -2147483648L ? null : Integer.valueOf((int)var2_2.zzilu);
            var3_3.zzizl = var2_2.zzilp;
            var3_3.zziln = var2_2.zziln;
            var3_3.zzizq = var2_2.zzilq == 0L ? null : Long.valueOf(var2_2.zzilq);
            var4_4 = this.zzaul().zzjh(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzizn = (String)var4_4.first;
                var3_3.zzizo = (Boolean)var4_4.second;
            }
            this.zzaua().zzwh();
            var3_3.zzizi = Build.MODEL;
            this.zzaua().zzwh();
            var3_3.zzcy = Build.VERSION.RELEASE;
            var3_3.zzizk = (int)this.zzaua().zzaxv();
            var3_3.zzizj = this.zzaua().zzaxw();
            var3_3.zzizm = null;
            var3_3.zzizc = null;
            var3_3.zzizd = null;
            var3_3.zzize = null;
            var3_3.zzizy = var2_2.zzilw;
            if (this.isEnabled() && zzcap.zzaxg()) {
                this.zzatz();
                var3_3.zzizz = null;
            }
            if ((var5_5 = this.zzaue().zziw(var2_2.packageName)) == null) {
                var5_5 = new zzcaj(this, var2_2.packageName);
                var5_5.zzim(this.zzatz().zzaxz());
                var5_5.zzip(var2_2.zzilv);
                var5_5.zzin(var2_2.zziln);
                var5_5.zzio(this.zzaul().zzji(var2_2.packageName));
                var5_5.zzaq(0L);
                var5_5.zzal(0L);
                var5_5.zzam(0L);
                var5_5.setAppVersion(var2_2.zzhtl);
                var5_5.zzan(var2_2.zzilu);
                var5_5.zziq(var2_2.zzilo);
                var5_5.zzao(var2_2.zzilp);
                var5_5.zzap(var2_2.zzilq);
                var5_5.setMeasurementEnabled(var2_2.zzils);
                var5_5.zzaz(var2_2.zzilw);
                this.zzaue().zza(var5_5);
            }
            var3_3.zzizp = var5_5.getAppInstanceId();
            var3_3.zzilv = var5_5.zzaup();
            var6_6 = this.zzaue().zziv(var2_2.packageName);
            var3_3.zzizb = new zzcge[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzizb[var7_7] = var8_9 = new zzcge();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzjad = var6_6.get((int)var7_7).zziwy;
                this.zzaug().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzaue().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzauk().zzayc().zze("Data loss. Failed to insert raw event metadata. appId", zzcbo.zzjf(var3_3.zzch), var9_10);
                return;
            }
            v0 = this.zzaue();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzinc == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzinc) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block10;
            }
            var12_14 = var10_12.zzauh().zzar(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzaue().zza(var10_12.zzaze(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzimv < (long)var10_12.zzisj.zzis(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzitp = 0L;
        }
    }

    public final String zzjs(String string) {
        Future<String> future = this.zzauj().zzd(new zzccq(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzauk().zzayc().zze("Failed to get app instance id. appId", zzcbo.zzjf(string), exception);
            return null;
        }
    }

    static void zzatt() {
        zzcap.zzawj();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcfl zzcfl2, zzcak zzcak2) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        int n = this.zzaug().zzjy(zzcfl2.name);
        if (n != 0) {
            this.zzaug();
            String string = zzcfo.zza(zzcfl2.name, zzcap.zzavn(), true);
            int n2 = zzcfl2.name != null ? zzcfl2.name.length() : 0;
            this.zzaug().zza(zzcak2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzaug().zzl(zzcfl2.name, zzcfl2.getValue());
        if (n != 0) {
            this.zzaug();
            String string = zzcfo.zza(zzcfl2.name, zzcap.zzavn(), true);
            Object object = zzcfl2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzaug().zza(zzcak2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzaug().zzm(zzcfl2.name, zzcfl2.getValue());
        if (object == null) {
            return;
        }
        zzcfn zzcfn2 = new zzcfn(zzcak2.packageName, zzcfl2.zzilz, zzcfl2.name, zzcfl2.zziwu, object);
        this.zzauk().zzayh().zze("Setting user property", this.zzauf().zzje(zzcfn2.mName), object);
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcak2);
            boolean bl = this.zzaue().zza(zzcfn2);
            this.zzaue().setTransactionSuccessful();
            if (bl) {
                this.zzauk().zzayh().zze("User property set", this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
            } else {
                this.zzauk().zzayc().zze("Too many unique user properties are set. Ignoring user property", this.zzauf().zzje(zzcfn2.mName), zzcfn2.mValue);
                this.zzaug().zza(zzcak2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcfl zzcfl2, zzcak zzcak2) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            return;
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        this.zzauk().zzayh().zzj("Removing user property", this.zzauf().zzje(zzcfl2.name));
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcak2);
            this.zzaue().zzai(zzcak2.packageName, zzcfl2.name);
            this.zzaue().setTransactionSuccessful();
            this.zzauk().zzayh().zzj("User property removed", this.zzauf().zzje(zzcfl2.name));
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazf() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        this.zzits = true;
        try {
            String string;
            zzcap.zzawj();
            Boolean bl = this.zzaul().zzayn();
            if (bl == null) {
                this.zzauk().zzaye().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzauk().zzayc().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzitp > 0L) {
                this.zzazh();
                return;
            }
            Object object = this;
            ((zzcdl)((zzcco)object).zzauj()).zzug();
            if (((zzcco)object).zzitk != null) {
                this.zzauk().zzayi().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzayz().zzyu()) {
                this.zzauk().zzayi().log("Network not connected, ignoring upload request");
                this.zzazh();
                return;
            }
            long l = this.zzasl.currentTimeMillis();
            long l2 = l - zzcap.zzawu();
            this.zzg(null, l2);
            long l3 = this.zzaul().zziqg.get();
            if (l3 != 0L) {
                this.zzauk().zzayh().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzaue().zzaxh()))) {
                if (this.zzito == -1L) {
                    this.zzito = this.zzaue().zzaxo();
                }
                Object object2 = string;
                int n = this.zzisj.zzb((String)object2, zzcbe.zziny);
                object2 = string;
                object = this.zzisj;
                int n2 = Math.max(0, ((zzcap)object).zzb((String)object2, zzcbe.zzinz));
                List<Pair<zzcgc, Long>> list = this.zzaue().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcgc zzcgc2 = (zzcgc)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcgc2.zzizn)) continue;
                        string2 = zzcgc2.zzizn;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcgc)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcgc)((Object)object3)).zzizn) || ((zzcgc)((Object)object3)).zzizn.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcgb();
                    new zzcgb().zziyx = new zzcgc[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcap.zzaxg() && this.zzisj.zziu(string);
                    for (int i = 0; i < ((zzcgb)((Object)object4)).zziyx.length; ++i) {
                        ((zzcgb)((Object)object4)).zziyx[i] = (zzcgc)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcgb)((Object)object4)).zziyx[i].zzizm = zzcap.zzauu();
                        ((zzcgb)((Object)object4)).zziyx[i].zzizc = l;
                        ((zzcgb)((Object)object4)).zziyx[i].zzizs = zzcap.zzawj();
                        if (bl2) continue;
                        ((zzcgb)((Object)object4)).zziyx[i].zzizz = null;
                    }
                    String string3 = null;
                    if (this.zzauk().zzad(2)) {
                        string3 = this.zzauf().zza((zzcgb)((Object)object4));
                    }
                    byte[] byArray = this.zzaug().zzb((zzcgb)((Object)object4));
                    String string4 = zzcap.zzawt();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbp.zzbh((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzcco)object).zzitk != null) {
                            ((zzcco)object).zzauk().zzayc().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzcco)object).zzitk = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzaul().zziqh.set(l);
                        String string5 = "?";
                        if (((zzcgb)((Object)object4)).zziyx.length > 0) {
                            string5 = ((zzcgb)((Object)object4)).zziyx[0].zzch;
                        }
                        this.zzauk().zzayi().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzitr = true;
                        zzccr zzccr2 = new zzccr(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzayz();
                        ((zzcdl)object).zzug();
                        ((zzcdm)object).zzwh();
                        zzbp.zzu((Object)uRL2);
                        zzbp.zzu((Object)byArray2);
                        zzbp.zzu((Object)zzccr2);
                        ((zzcdl)object).zzauj().zzh(new zzcbw((zzcbs)object, (String)object2, uRL2, byArray2, null, zzccr2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzauk().zzayc().zze("Failed to parse upload URL. Not uploading. appId", zzcbo.zzjf(string), string4);
                    }
                }
            } else {
                zzcaj zzcaj2;
                this.zzito = -1L;
                String string6 = this.zzaue().zzba(l - zzcap.zzawu());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcaj2 = this.zzaue().zziw(string6)) != null) {
                    this.zzb(zzcaj2);
                }
            }
            return;
        }
        finally {
            this.zzits = false;
            this.zzazl();
        }
    }

    @WorkerThread
    private final void zzb(zzcaj zzcaj2) {
        ((zzcdl)this.zzauj()).zzug();
        if (TextUtils.isEmpty((CharSequence)zzcaj2.getGmpAppId())) {
            this.zzb(zzcaj2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcaj2.getAppInstanceId();
        String string = zzcaj2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcbe.zzinw.get()).encodedAuthority(zzcbe.zzinx.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11200");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzauk().zzayi().zzj("Fetching remote configuration", zzcaj2.getAppId());
            zzcfw zzcfw2 = this.zzauh().zzjn(zzcaj2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzauh().zzjo(zzcaj2.getAppId());
            if (zzcfw2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzitq = true;
            zzccs zzccs2 = new zzccs(this);
            builder = arrayMap;
            object = uRL;
            string = zzcaj2.getAppId();
            zzcbs zzcbs2 = this.zzayz();
            ((zzcdl)zzcbs2).zzug();
            zzcbs2.zzwh();
            zzbp.zzu((Object)object);
            zzbp.zzu((Object)zzccs2);
            ((zzcdl)zzcbs2).zzauj().zzh(new zzcbw(zzcbs2, string, (URL)object, null, (Map)builder, zzccs2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzauk().zzayc().zze("Failed to parse config URL. Not fetching. appId", zzcbo.zzjf(zzcaj2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzaue().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzito;
                    long l3 = l;
                    string2 = null;
                    object = this.zzaue();
                    zzbp.zzu((Object)zza3);
                    ((zzcdl)object).zzug();
                    ((zzcdm)object).zzwh();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcaq)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcdl)object).zzauk().zzayc().zzj("Raw event metadata record is missing. appId", zzcbo.zzjf(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzegf.zzh((byte[])byArray, (int)0, (int)byArray.length);
                        zzcgc zzcgc2 = new zzcgc();
                        try {
                            zzcgc2.zza((zzegf)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcdl)object).zzauk().zzayc().zze("Data loss. Failed to merge raw event metadata. appId", zzcbo.zzjf(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcdl)object).zzauk().zzaye().zzj("Get multiple raw event metadata records, expected one. appId", zzcbo.zzjf(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcgc2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcdl)object).zzauk().zzaye().zzj("Raw event data disappeared while in transaction. appId", zzcbo.zzjf(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzegf.zzh((byte[])byArray, (int)0, (int)byArray.length);
                            zzcfz zzcfz2 = new zzcfz();
                            try {
                                zzcfz2.zza((zzegf)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcdl)object).zzauk().zzayc().zze("Data loss. Failed to merge raw event. appId", zzcbo.zzjf(string2), iOException);
                                continue;
                            }
                            zzcfz2.name = cursor.getString(1);
                            zzcfz2.zziyt = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcfz2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zzaom == null || ((zza)object).zzaom.isEmpty()) break block69;
                boolean bl = false;
                zzcgc zzcgc3 = zza2.zzitv;
                zza2.zzitv.zziza = new zzcfz[zza2.zzaom.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzaom.size(); ++n) {
                    block71: {
                        zzcga[] zzcgaArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzauh().zzaq(zza2.zzitv.zzch, zza2.zzaom.get((int)n).name)) {
                                this.zzauk().zzaye().zze("Dropping blacklisted raw event. appId", zzcbo.zzjf(zza2.zzitv.zzch), this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                                if (this.zzaug().zzkg(zza2.zzitv.zzch) || this.zzaug().zzkh(zza2.zzitv.zzch) || "_err".equals(zza2.zzaom.get((int)n).name)) continue;
                                this.zzaug().zza(zza2.zzitv.zzch, 11, "_ev", zza2.zzaom.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzauh().zzar(zza2.zzitv.zzch, zza2.zzaom.get((int)n).name);
                            if (bl2) break block70;
                            this.zzaug();
                            if (!zzcfo.zzki(zza2.zzaom.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zzaom.get((int)n).zziys == null) {
                            zza2.zzaom.get((int)n).zziys = new zzcga[0];
                        }
                        zzcga[] zzcgaArray2 = zza2.zzaom.get((int)n).zziys;
                        int n4 = zza2.zzaom.get((int)n).zziys.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcgaArray = zzcgaArray2[n3];
                            if ("_c".equals(zzcgaArray.name)) {
                                zzcgaArray.zziyw = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcgaArray.name)) continue;
                            zzcgaArray.zziyw = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzauk().zzayi().zzj("Marking event as conversion", this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                            zzcgaArray2 = Arrays.copyOf(zza2.zzaom.get((int)n).zziys, zza2.zzaom.get((int)n).zziys.length + 1);
                            zzcga zzcga2 = new zzcga();
                            new zzcga().name = "_c";
                            zzcga2.zziyw = 1L;
                            zzcgaArray2[zzcgaArray2.length - 1] = zzcga2;
                            zza2.zzaom.get((int)n).zziys = zzcgaArray2;
                        }
                        if (!bl5) {
                            this.zzauk().zzayi().zzj("Marking event as real-time", this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                            zzcgaArray2 = Arrays.copyOf(zza2.zzaom.get((int)n).zziys, zza2.zzaom.get((int)n).zziys.length + 1);
                            zzcga zzcga3 = new zzcga();
                            new zzcga().name = "_r";
                            zzcga3.zziyw = 1L;
                            zzcgaArray2[zzcgaArray2.length - 1] = zzcga3;
                            zza2.zzaom.get((int)n).zziys = zzcgaArray2;
                        }
                        bl = true;
                        if (this.zzaue().zza((long)this.zzaze(), (String)zza2.zzitv.zzch, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzimv > (long)this.zzisj.zzis(zza2.zzitv.zzch)) {
                            zzcfz zzcfz3 = zza2.zzaom.get(n);
                            for (n3 = 0; n3 < zzcfz3.zziys.length; ++n3) {
                                if (!"_r".equals(zzcfz3.zziys[n3].name)) continue;
                                zzcgaArray = new zzcga[zzcfz3.zziys.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcfz3.zziys, 0, zzcgaArray, 0, n3);
                                }
                                if (n3 < zzcgaArray.length) {
                                    System.arraycopy(zzcfz3.zziys, n3 + 1, zzcgaArray, n3, zzcgaArray.length - n3);
                                }
                                zzcfz3.zziys = zzcgaArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcfo.zzju(zza2.zzaom.get((int)n).name) && bl2 && this.zzaue().zza((long)this.zzaze(), (String)zza2.zzitv.zzch, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzimt > (long)this.zzisj.zzb(string2 = zza2.zzitv.zzch, zzcbe.zziof)) {
                            this.zzauk().zzaye().zzj("Too many conversions. Not logging as conversion. appId", zzcbo.zzjf(zza2.zzitv.zzch));
                            zzcfz zzcfz4 = zza2.zzaom.get(n);
                            boolean bl6 = false;
                            zzcga zzcga4 = null;
                            zzcga[] zzcgaArray3 = zzcfz4.zziys;
                            int n5 = zzcfz4.zziys.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcga zzcga5 = zzcgaArray3[i];
                                if ("_c".equals(zzcga5.name)) {
                                    zzcga4 = zzcga5;
                                    continue;
                                }
                                if (!"_err".equals(zzcga5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcga4 != null) {
                                zzcgaArray3 = new zzcga[zzcfz4.zziys.length - 1];
                                n5 = 0;
                                zzcga[] zzcgaArray4 = zzcfz4.zziys;
                                int n6 = zzcfz4.zziys.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcga zzcga6 = zzcgaArray4[i];
                                    if (zzcga6 == zzcga4) continue;
                                    zzcgaArray3[n5++] = zzcga6;
                                }
                                zzcfz4.zziys = zzcgaArray3;
                            } else if (zzcga4 != null) {
                                zzcga4.name = "_err";
                                zzcga4.zziyw = 10L;
                            } else {
                                this.zzauk().zzayc().zzj("Did not find conversion parameter. appId", zzcbo.zzjf(zza2.zzitv.zzch));
                            }
                        }
                    }
                    zzcgc3.zziza[n2++] = zza2.zzaom.get(n);
                }
                if (n2 < zza2.zzaom.size()) {
                    zzcgc3.zziza = Arrays.copyOf(zzcgc3.zziza, n2);
                }
                zzcgc3.zzizt = this.zza(zza2.zzitv.zzch, zza2.zzitv.zzizb, zzcgc3.zziza);
                zzcgc3.zzizd = Long.MAX_VALUE;
                zzcgc3.zzize = Long.MIN_VALUE;
                for (n = 0; n < zzcgc3.zziza.length; ++n) {
                    zzcfz zzcfz5 = zzcgc3.zziza[n];
                    if (zzcfz5.zziyt < zzcgc3.zzizd) {
                        zzcgc3.zzizd = zzcfz5.zziyt;
                    }
                    if (zzcfz5.zziyt <= zzcgc3.zzize) continue;
                    zzcgc3.zzize = zzcfz5.zziyt;
                }
                String string6 = zza2.zzitv.zzch;
                zzcaj zzcaj2 = this.zzaue().zziw(string6);
                if (zzcaj2 == null) {
                    this.zzauk().zzayc().zzj("Bundling raw events w/o app info. appId", zzcbo.zzjf(zza2.zzitv.zzch));
                } else if (zzcgc3.zziza.length > 0) {
                    long l5 = zzcaj2.zzaur();
                    zzcgc3.zzizg = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcaj2.zzauq();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcgc3.zzizf = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcaj2.zzava();
                    zzcgc3.zzizr = (int)zzcaj2.zzaux();
                    zzcaj2.zzal(zzcgc3.zzizd);
                    zzcaj2.zzam(zzcgc3.zzize);
                    zzcgc3.zzilr = zzcaj2.zzavi();
                    this.zzaue().zza(zzcaj2);
                }
                if (zzcgc3.zziza.length > 0) {
                    zzcap.zzawj();
                    zzcfw zzcfw2 = this.zzauh().zzjn(zza2.zzitv.zzch);
                    if (zzcfw2 == null || zzcfw2.zziyh == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzitv.zziln)) {
                            zzcgc3.zzizx = -1L;
                        } else {
                            this.zzauk().zzaye().zzj("Did not find measurement config or missing version info. appId", zzcbo.zzjf(zza2.zzitv.zzch));
                        }
                    } else {
                        zzcgc3.zzizx = zzcfw2.zziyh;
                    }
                    this.zzaue().zza(zzcgc3, bl);
                }
                this.zzaue().zzae(zza2.zzitw);
                string2 = string6;
                object = this.zzaue();
                SQLiteDatabase sQLiteDatabase = ((zzcaq)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcdl)object).zzauk().zzayc().zze("Failed to remove unused event metadata. appId", zzcbo.zzjf(string2), (Object)sQLiteException);
                }
                this.zzaue().setTransactionSuccessful();
                boolean bl7 = zzcgc3.zziza.length > 0;
                return bl7;
            }
            this.zzaue().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    private final zzcfy[] zza(String string, zzcge[] zzcgeArray, zzcfz[] zzcfzArray) {
        zzbp.zzgf((String)string);
        return this.zzatx().zza(string, zzcfzArray, zzcgeArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzgf((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzauk().zzayi().zzj("onConfigFetched. Response size", byArray.length);
            this.zzaue().beginTransaction();
            try {
                boolean bl;
                zzcaj zzcaj2 = this.zzaue().zziw(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcaj2 == null) {
                    this.zzauk().zzaye().zzj("App does not exist in onConfigFetched. appId", zzcbo.zzjf(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzauh().zzjn(string) == null && !this.zzauh().zzb(string, null, null) : !this.zzauh().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcaj2.zzar(this.zzasl.currentTimeMillis());
                    this.zzaue().zza(zzcaj2);
                    if (n == 404) {
                        this.zzauk().zzayf().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzauk().zzayi().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzayz().zzyu() && this.zzazg()) {
                        this.zzazf();
                    } else {
                        this.zzazh();
                    }
                } else {
                    zzcaj2.zzas(this.zzasl.currentTimeMillis());
                    this.zzaue().zza(zzcaj2);
                    this.zzauk().zzayi().zze("Fetching config failed. code, error", n, throwable);
                    this.zzauh().zzjp(string);
                    this.zzaul().zziqh.set(this.zzasl.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzaul().zziqi.set(this.zzasl.currentTimeMillis());
                    }
                    this.zzazh();
                }
                this.zzaue().setTransactionSuccessful();
            }
            finally {
                this.zzaue().endTransaction();
            }
            return;
        }
        finally {
            this.zzitq = false;
            this.zzazl();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzitk;
            this.zzitk = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
                    this.zzaul().zziqh.set(0L);
                    this.zzazh();
                    this.zzauk().zzayi().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzaue().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcaq zzcaq2 = this.zzaue();
                            zzcaq2.zzug();
                            zzcaq2.zzwh();
                            SQLiteDatabase sQLiteDatabase = zzcaq2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcaq2.zzauk().zzayc().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzaue().setTransactionSuccessful();
                    }
                    finally {
                        this.zzaue().endTransaction();
                    }
                    if (this.zzayz().zzyu() && this.zzazg()) {
                        this.zzazf();
                    } else {
                        this.zzito = -1L;
                        this.zzazh();
                    }
                    this.zzitp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzauk().zzayc().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzitp = this.zzasl.elapsedRealtime();
                    this.zzauk().zzayi().zzj("Disable upload, time", this.zzitp);
                }
            } else {
                this.zzauk().zzayi().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzaul().zziqh.set(this.zzasl.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzaul().zziqi.set(this.zzasl.currentTimeMillis());
                }
                this.zzazh();
            }
            return;
        }
        finally {
            this.zzitr = false;
            this.zzazl();
        }
    }

    private final boolean zzazg() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        return this.zzaue().zzaxm() || !TextUtils.isEmpty((CharSequence)this.zzaue().zzaxh());
    }

    @WorkerThread
    private final void zzazh() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcdl)this.zzauj()).zzug();
            this.zzwh();
            if (!this.zzazk()) {
                return;
            }
            if (this.zzitp > 0L) {
                l3 = this.zzasl.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzitp);
                if (l2 > 0L) {
                    this.zzauk().zzayi().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzaza().unregister();
                    this.zzazb().cancel();
                    return;
                }
                this.zzitp = 0L;
            }
            if (!this.zzayu() || !this.zzazg()) {
                this.zzauk().zzayi().log("Nothing to upload or uploading impossible");
                this.zzaza().unregister();
                this.zzazb().cancel();
                return;
            }
            zzcco zzcco2 = this;
            long l4 = zzcco2.zzasl.currentTimeMillis();
            long l5 = zzcap.zzaxc();
            boolean bl = zzcco2.zzaue().zzaxn() || zzcco2.zzaue().zzaxi();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzcco2.zzisj.zzaxf())) && !".none.".equals(string) ? zzcap.zzawy() : zzcap.zzawx()) : zzcap.zzaww();
            long l7 = zzcco2.zzaul().zziqg.get();
            long l8 = zzcco2.zzaul().zziqh.get();
            long l9 = zzcco2.zzaue().zzaxk();
            long l10 = zzcco2.zzaue().zzaxl();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzcco2.zzaug().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcap.zzaxe(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcap.zzaxd() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzauk().zzayi().log("Next upload time is 0");
            this.zzaza().unregister();
            this.zzazb().cancel();
            return;
        }
        if (!this.zzayz().zzyu()) {
            this.zzauk().zzayi().log("No network");
            this.zzaza().zzyr();
            this.zzazb().cancel();
            return;
        }
        l2 = this.zzaul().zziqi.get();
        long l16 = zzcap.zzawv();
        if (!this.zzaug().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzaza().unregister();
        long l17 = l3 - this.zzasl.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcap.zzawz();
            this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
        }
        this.zzauk().zzayi().zzj("Upload scheduled in approximately ms", l17);
        this.zzazb().zzs(l17);
    }

    public final void zzbo(boolean bl) {
        this.zzazh();
    }

    final void zzb(zzcdm zzcdm2) {
        ++this.zzitm;
    }

    final void zzazi() {
        ++this.zzitn;
    }

    @WorkerThread
    public final void zze(zzcak zzcak2) {
        int n;
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcak2));
        zzbp.zzgf((String)zzcak2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            return;
        }
        zzcaj zzcaj2 = this.zzaue().zziw(zzcak2.packageName);
        if (zzcaj2 != null && TextUtils.isEmpty((CharSequence)zzcaj2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcak2.zziln)) {
            zzcaj2.zzar(0L);
            this.zzaue().zza(zzcaj2);
            this.zzauh().zzjq(zzcak2.packageName);
        }
        if (!zzcak2.zzils) {
            this.zzf(zzcak2);
            return;
        }
        long l = zzcak2.zzilx;
        if (l == 0L) {
            l = this.zzasl.currentTimeMillis();
        }
        if ((n = zzcak2.zzily) != 0 && n != 1) {
            this.zzauk().zzaye().zze("Incorrect app type, assuming installed app. appId, appType", zzcbo.zzjf(zzcak2.packageName), n);
            n = 0;
        }
        this.zzaue().beginTransaction();
        try {
            zzcbc zzcbc2;
            Object object;
            long l2 = l;
            zzcak zzcak3 = zzcak2;
            zzcco zzcco2 = this;
            zzcaj zzcaj3 = zzcco2.zzaue().zziw(zzcak3.packageName);
            if (zzcaj3 != null && zzcaj3.getGmpAppId() != null && !zzcaj3.getGmpAppId().equals(zzcak3.zziln)) {
                zzcco2.zzauk().zzaye().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcbo.zzjf(zzcaj3.getAppId()));
                String string = zzcaj3.getAppId();
                zzcaq zzcaq2 = zzcco2.zzaue();
                zzcaq2.zzwh();
                zzcaq2.zzug();
                zzbp.zzgf((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcaq2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcaq2.zzauk().zzayi().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcaq2.zzauk().zzayc().zze("Error deleting application data. appId, error", zzcbo.zzjf(string), (Object)sQLiteException);
                }
                zzcaj3 = null;
            }
            if (zzcaj3 != null && zzcaj3.zzul() != null && !zzcaj3.zzul().equals(zzcak3.zzhtl)) {
                object = new Bundle();
                object.putString("_pv", zzcaj3.zzul());
                zzcbc2 = new zzcbc("_au", new zzcaz((Bundle)object), "auto", l2);
                zzcco2.zzb(zzcbc2, zzcak3);
            }
            this.zzf(zzcak2);
            zzcay zzcay2 = null;
            if (n == 0) {
                zzcay2 = this.zzaue().zzah(zzcak2.packageName, "_f");
            } else if (n == 1) {
                zzcay2 = this.zzaue().zzah(zzcak2.packageName, "_v");
            }
            if (zzcay2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    com.google.android.gms.common.internal.safeparcel.zza zza2;
                    zzcfl zzcfl2 = new zzcfl("_fot", l, l3, "auto");
                    this.zzb(zzcfl2, zzcak2);
                    l2 = l;
                    zzcak3 = zzcak2;
                    zzcco2 = this;
                    ((zzcdl)zzcco2.zzauj()).zzug();
                    zzcco2.zzwh();
                    zzcaj3 = new Bundle();
                    zzcaj3.putLong("_c", 1L);
                    zzcaj3.putLong("_r", 1L);
                    zzcaj3.putLong("_uwa", 0L);
                    zzcaj3.putLong("_pfo", 0L);
                    zzcaj3.putLong("_sys", 0L);
                    zzcaj3.putLong("_sysu", 0L);
                    if (zzcco2.mContext.getPackageManager() == null) {
                        zzcco2.zzauk().zzayc().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcbo.zzjf(zzcak3.packageName));
                    } else {
                        zzcbc2 = null;
                        try {
                            zzcbc2 = zzbdp.zzcs((Context)zzcco2.mContext).getPackageInfo(zzcak3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcco2.zzauk().zzayc().zze("Package info is null, first open report might be inaccurate. appId", zzcbo.zzjf(zzcak3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcbc2 != null && ((PackageInfo)zzcbc2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcbc2).firstInstallTime != ((PackageInfo)zzcbc2).lastUpdateTime) {
                                zzcaj3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zza2 = new zzcfl("_fi", l2, bl ? 1L : 0L, "auto");
                            zzcco2.zzb((zzcfl)zza2, zzcak3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbdp.zzcs((Context)zzcco2.mContext).getApplicationInfo(zzcak3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcco2.zzauk().zzayc().zze("Application info is null, first open report might be inaccurate. appId", zzcbo.zzjf(zzcak3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcaj3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcaj3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcak3.packageName;
                    zzcaq zzcaq3 = zzcco2.zzaue();
                    zzbp.zzgf((String)string);
                    zzcaq3.zzug();
                    zzcaq3.zzwh();
                    long l4 = zzcaq3.zzao(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcaj3.putLong("_pfo", l4);
                    }
                    zza2 = new zzcbc("_f", new zzcaz((Bundle)zzcaj3), "auto", l2);
                    zzcco2.zzb((zzcbc)zza2, zzcak3);
                } else if (n == 1) {
                    zzcfl zzcfl3 = new zzcfl("_fvt", l, l3, "auto");
                    this.zzb(zzcfl3, zzcak2);
                    l2 = l;
                    zzcak3 = zzcak2;
                    zzcco2 = this;
                    ((zzcdl)zzcco2.zzauj()).zzug();
                    zzcco2.zzwh();
                    zzcaj3 = new Bundle();
                    zzcaj3.putLong("_c", 1L);
                    zzcaj3.putLong("_r", 1L);
                    object = new zzcbc("_v", new zzcaz((Bundle)zzcaj3), "auto", l2);
                    zzcco2.zzb((zzcbc)((Object)object), zzcak3);
                }
                l2 = l;
                zzcak3 = zzcak2;
                zzcco2 = this;
                zzcaj3 = new Bundle();
                zzcaj3.putLong("_et", 1L);
                object = new zzcbc("_e", new zzcaz((Bundle)zzcaj3), "auto", l2);
                zzcco2.zzb((zzcbc)((Object)object), zzcak3);
            } else if (zzcak2.zzilt) {
                l2 = l;
                zzcak3 = zzcak2;
                zzcco2 = this;
                zzcaj3 = new Bundle();
                object = new zzcbc("_cd", new zzcaz((Bundle)zzcaj3), "auto", l2);
                zzcco2.zzb((zzcbc)((Object)object), zzcak3);
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzcak zzcak2) {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcak2));
        zzbp.zzgf((String)zzcak2.packageName);
        zzcaj zzcaj2 = this.zzaue().zziw(zzcak2.packageName);
        String string = this.zzaul().zzji(zzcak2.packageName);
        boolean bl = false;
        if (zzcaj2 == null) {
            zzcaj2 = new zzcaj(this, zzcak2.packageName);
            zzcaj2.zzim(this.zzatz().zzaxz());
            zzcaj2.zzio(string);
            bl = true;
        } else if (!string.equals(zzcaj2.zzauo())) {
            zzcaj2.zzio(string);
            zzcaj2.zzim(this.zzatz().zzaxz());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcak2.zziln) && !zzcak2.zziln.equals(zzcaj2.getGmpAppId())) {
            zzcaj2.zzin(zzcak2.zziln);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcak2.zzilv) && !zzcak2.zzilv.equals(zzcaj2.zzaup())) {
            zzcaj2.zzip(zzcak2.zzilv);
            bl = true;
        }
        if (zzcak2.zzilp != 0L && zzcak2.zzilp != zzcaj2.zzauu()) {
            zzcaj2.zzao(zzcak2.zzilp);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcak2.zzhtl) && !zzcak2.zzhtl.equals(zzcaj2.zzul())) {
            zzcaj2.setAppVersion(zzcak2.zzhtl);
            bl = true;
        }
        if (zzcak2.zzilu != zzcaj2.zzaus()) {
            zzcaj2.zzan(zzcak2.zzilu);
            bl = true;
        }
        if (zzcak2.zzilo != null && !zzcak2.zzilo.equals(zzcaj2.zzaut())) {
            zzcaj2.zziq(zzcak2.zzilo);
            bl = true;
        }
        if (zzcak2.zzilq != zzcaj2.zzauv()) {
            zzcaj2.zzap(zzcak2.zzilq);
            bl = true;
        }
        if (zzcak2.zzils != zzcaj2.zzauw()) {
            zzcaj2.setMeasurementEnabled(zzcak2.zzils);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcak2.zzilr) && !zzcak2.zzilr.equals(zzcaj2.zzavh())) {
            zzcaj2.zzir(zzcak2.zzilr);
            bl = true;
        }
        if (zzcak2.zzilw != zzcaj2.zzavj()) {
            zzcaj2.zzaz(zzcak2.zzilw);
            bl = true;
        }
        if (bl) {
            this.zzaue().zza(zzcaj2);
        }
    }

    @WorkerThread
    final void zzazj() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        if (!this.zzitf) {
            this.zzauk().zzayg().log("This instance being marked as an uploader");
            zzcco zzcco2 = this;
            ((zzcdl)zzcco2.zzauj()).zzug();
            zzcco2.zzwh();
            if (zzcco2.zzazk() && zzcco2.zzazc()) {
                int n;
                int n2 = zzcco2.zza(zzcco2.zzitj);
                int n3 = n = zzcco2.zzatz().zzaya();
                int n4 = n2;
                zzcco zzcco3 = zzcco2;
                ((zzcdl)zzcco3.zzauj()).zzug();
                if (n4 > n3) {
                    zzcco3.zzauk().zzayc().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzcco3.zza(n3, zzcco3.zzitj)) {
                        zzcco3.zzauk().zzayi().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzcco3.zzauk().zzayc().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzitf = true;
            this.zzazh();
        }
    }

    @WorkerThread
    private final boolean zzazk() {
        ((zzcdl)this.zzauj()).zzug();
        this.zzwh();
        return this.zzitf;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcdl)this.zzauj()).zzug();
        if (this.zzitl == null) {
            this.zzitl = new ArrayList<Runnable>();
        }
        this.zzitl.add(runnable);
    }

    @WorkerThread
    private final void zzazl() {
        ((zzcdl)this.zzauj()).zzug();
        if (this.zzitq || this.zzitr || this.zzits) {
            this.zzauk().zzayi().zzd("Not stopping services. fetch, network, upload", this.zzitq, this.zzitr, this.zzits);
            return;
        }
        this.zzauk().zzayi().log("Stopping uploading service(s)");
        if (this.zzitl == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzitl.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzitl.clear();
    }

    final class zza
    implements zzcas {
        zzcgc zzitv;
        List<Long> zzitw;
        List<zzcfz> zzaom;
        private long zzitx;
        private /* synthetic */ zzcco zzitu;

        private zza(zzcco zzcco2) {
            this.zzitu = zzcco2;
        }

        @Override
        public final void zzb(zzcgc zzcgc2) {
            zzbp.zzu((Object)((Object)zzcgc2));
            this.zzitv = zzcgc2;
        }

        @Override
        public final boolean zza(long l, zzcfz zzcfz2) {
            zzbp.zzu((Object)((Object)zzcfz2));
            if (this.zzaom == null) {
                this.zzaom = new ArrayList<zzcfz>();
            }
            if (this.zzitw == null) {
                this.zzitw = new ArrayList<Long>();
            }
            if (this.zzaom.size() > 0 && zza.zza(this.zzaom.get(0)) != zza.zza(zzcfz2)) {
                return false;
            }
            long l2 = this.zzitx + (long)zzcfz2.zzbjo();
            if (l2 >= (long)zzcap.zzawq()) {
                return false;
            }
            this.zzitx = l2;
            this.zzaom.add(zzcfz2);
            this.zzitw.add(l);
            return this.zzaom.size() < zzcap.zzawr();
        }

        private static long zza(zzcfz zzcfz2) {
            return zzcfz2.zziyt / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzcco zzcco2, zzccp zzccp2) {
            this(zzcco2);
        }
    }
}

