/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcak;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzccx;
import com.google.android.gms.internal.zzccy;
import com.google.android.gms.internal.zzccz;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcdb;
import com.google.android.gms.internal.zzcdc;
import com.google.android.gms.internal.zzcdd;
import com.google.android.gms.internal.zzcde;
import com.google.android.gms.internal.zzcdf;
import com.google.android.gms.internal.zzcdg;
import com.google.android.gms.internal.zzcdh;
import com.google.android.gms.internal.zzcdi;
import com.google.android.gms.internal.zzcdj;
import com.google.android.gms.internal.zzcdk;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcct
extends zzcbh {
    private final zzcco zzikb;
    private Boolean zzity;
    @Nullable
    private String zzitz;

    public zzcct(zzcco zzcco2) {
        this(zzcco2, null);
    }

    private zzcct(zzcco zzcco2, @Nullable String string) {
        zzbp.zzu((Object)zzcco2);
        this.zzikb = zzcco2;
        this.zzitz = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcak zzcak2) {
        this.zzb(zzcak2, false);
        this.zzikb.zzauj().zzg(new zzccu(this, zzcak2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbc zzcbc2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcbc2));
        this.zzb(zzcak2, false);
        this.zzikb.zzauj().zzg(new zzcdd(this, zzcbc2, zzcak2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbc zzcbc2, String string, String string2) {
        zzbp.zzu((Object)((Object)zzcbc2));
        zzbp.zzgf((String)string);
        this.zzg(string, true);
        this.zzikb.zzauj().zzg(new zzcde(this, zzcbc2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcbc zzcbc2, String string) {
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)((Object)zzcbc2));
        this.zzg(string, true);
        this.zzikb.zzauk().zzayh().zzj("Log and bundle. event", this.zzikb.zzauf().zzjc(zzcbc2.name));
        long l = this.zzikb.zzvu().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzikb.zzauj().zze(new zzcdf(this, zzcbc2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzikb.zzauk().zzayc().zzj("Log and bundle returned null. appId", zzcbo.zzjf(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzikb.zzvu().nanoTime() / 1000000L;
            this.zzikb.zzauk().zzayh().zzd("Log and bundle processed. event, size, time_ms", this.zzikb.zzauf().zzjc(zzcbc2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzd("Failed to log and bundle. appId, event, error", zzcbo.zzjf(string), this.zzikb.zzauf().zzjc(zzcbc2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcfl zzcfl2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcfl2));
        this.zzb(zzcak2, false);
        if (zzcfl2.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzcdg(this, zzcfl2, zzcak2));
            return;
        }
        this.zzikb.zzauj().zzg(new zzcdh(this, zzcfl2, zzcak2));
    }

    @Override
    @BinderThread
    public final List<zzcfl> zza(zzcak zzcak2, boolean bl) {
        this.zzb(zzcak2, false);
        Future<List<zzcfn>> future = this.zzikb.zzauj().zzd(new zzcdi(this, zzcak2));
        try {
            List<zzcfn> list = future.get();
            ArrayList<zzcfl> arrayList = new ArrayList<zzcfl>(list.size());
            for (zzcfn zzcfn2 : list) {
                if (!bl && zzcfo.zzkd(zzcfn2.mName)) continue;
                arrayList.add(new zzcfl(zzcfn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbo.zzjf(zzcak2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcak zzcak2) {
        this.zzb(zzcak2, false);
        zzcdj zzcdj2 = new zzcdj(this, zzcak2);
        if (this.zzikb.zzauj().zzayr()) {
            zzcdj2.run();
            return;
        }
        this.zzikb.zzauj().zzg(zzcdj2);
    }

    @BinderThread
    private final void zzb(zzcak zzcak2, boolean bl) {
        zzbp.zzu((Object)((Object)zzcak2));
        this.zzg(zzcak2.packageName, false);
        this.zzikb.zzaug().zzkb(zzcak2.zziln);
    }

    @BinderThread
    private final void zzg(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzikb.zzauk().zzayc().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcct zzcct2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcct2 = this;
                    if (!bl2) break block9;
                    if (zzcct2.zzity == null) {
                        zzcct2.zzity = "com.google.android.gms".equals(zzcct2.zzitz) || zzv.zzf((Context)zzcct2.zzikb.getContext(), (int)Binder.getCallingUid()) || zzp.zzca((Context)zzcct2.zzikb.getContext()).zza(zzcct2.zzikb.getContext().getPackageManager(), Binder.getCallingUid());
                    }
                    if (zzcct2.zzity.booleanValue()) break block10;
                }
                if (zzcct2.zzitz == null && zzo.zzb((Context)zzcct2.zzikb.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcct2.zzitz = string2;
                }
                if (!string2.equals(zzcct2.zzitz)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzikb.zzauk().zzayc().zzj("Measurement Service called with invalid calling package. appId", zzcbo.zzjf(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzikb.zzauj().zzg(new zzcdk(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcak zzcak2) {
        this.zzb(zzcak2, false);
        return this.zzikb.zzjs(zzcak2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcan zzcan2, zzcak zzcak2) {
        zzbp.zzu((Object)((Object)zzcan2));
        zzbp.zzu((Object)((Object)zzcan2.zzima));
        this.zzb(zzcak2, false);
        zzcan zzcan3 = new zzcan(zzcan2);
        new zzcan(zzcan2).packageName = zzcak2.packageName;
        if (zzcan2.zzima.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzccv(this, zzcan3, zzcak2));
            return;
        }
        this.zzikb.zzauj().zzg(new zzccw(this, zzcan3, zzcak2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcan zzcan2) {
        zzbp.zzu((Object)((Object)zzcan2));
        zzbp.zzu((Object)((Object)zzcan2.zzima));
        this.zzg(zzcan2.packageName, true);
        zzcan zzcan3 = new zzcan(zzcan2);
        if (zzcan2.zzima.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzccx(this, zzcan3));
            return;
        }
        this.zzikb.zzauj().zzg(new zzccy(this, zzcan3));
    }

    @Override
    @BinderThread
    public final List<zzcfl> zza(String string, String string2, boolean bl, zzcak zzcak2) {
        this.zzb(zzcak2, false);
        Future<List<zzcfn>> future = this.zzikb.zzauj().zzd(new zzccz(this, zzcak2, string, string2));
        try {
            List<zzcfn> list = future.get();
            ArrayList<zzcfl> arrayList = new ArrayList<zzcfl>(list.size());
            for (zzcfn zzcfn2 : list) {
                if (!bl && zzcfo.zzkd(zzcfn2.mName)) continue;
                arrayList.add(new zzcfl(zzcfn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbo.zzjf(zzcak2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfl> zza(String string, String string2, String string3, boolean bl) {
        this.zzg(string, true);
        Future<List<zzcfn>> future = this.zzikb.zzauj().zzd(new zzcda(this, string, string2, string3));
        try {
            List<zzcfn> list = future.get();
            ArrayList<zzcfl> arrayList = new ArrayList<zzcfl>(list.size());
            for (zzcfn zzcfn2 : list) {
                if (!bl && zzcfo.zzkd(zzcfn2.mName)) continue;
                arrayList.add(new zzcfl(zzcfn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbo.zzjf(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcan> zza(String string, String string2, zzcak zzcak2) {
        this.zzb(zzcak2, false);
        Future<List<zzcan>> future = this.zzikb.zzauj().zzd(new zzcdb(this, zzcak2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcan> zzj(String string, String string2, String string3) {
        this.zzg(string, true);
        Future<List<zzcan>> future = this.zzikb.zzauj().zzd(new zzcdc(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzcco zza(zzcct zzcct2) {
        return zzcct2.zzikb;
    }
}

