/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcau;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbg;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcer;
import com.google.android.gms.internal.zzces;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzceg
extends zzcdm {
    private final zzcet zzivp;
    private zzcbg zzivq;
    private Boolean zzivr;
    private final zzcau zzivs;
    private final zzcfi zzivt;
    private final List<Runnable> zzivu = new ArrayList<Runnable>();
    private final zzcau zzivv;

    protected zzceg(zzcco zzcco2) {
        super(zzcco2);
        this.zzivt = new zzcfi(zzcco2.zzvu());
        this.zzivp = new zzcet(this);
        this.zzivs = new zzceh(this, zzcco2);
        this.zzivv = new zzcel(this, zzcco2);
    }

    @Override
    protected final void zzuh() {
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcdl)this).zzug();
        this.zzwh();
        return this.zzivq != null;
    }

    @WorkerThread
    protected final void zzazo() {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzcem(this));
    }

    @WorkerThread
    final void zza(zzcbg zzcbg2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        ((zzcdl)this).zzug();
        ((zzcdl)this).zzatu();
        this.zzwh();
        zzcap.zzawj();
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        zzcap.zzaws();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<com.google.android.gms.common.internal.safeparcel.zza> list = ((zzcdl)this).zzaud().zzdv(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                com.google.android.gms.common.internal.safeparcel.zza zza3 = (com.google.android.gms.common.internal.safeparcel.zza)e;
                if (zza3 instanceof zzcbc) {
                    try {
                        zzcbg2.zza((zzcbc)zza3, ((zzcdl)this).zzatz().zzjb(((zzcdl)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdl)this).zzauk().zzayc().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcfl) {
                    try {
                        zzcbg2.zza((zzcfl)zza3, ((zzcdl)this).zzatz().zzjb(((zzcdl)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdl)this).zzauk().zzayc().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcan) {
                    try {
                        zzcbg2.zza((zzcan)zza3, ((zzcdl)this).zzatz().zzjb(((zzcdl)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdl)this).zzauk().zzayc().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcdl)this).zzauk().zzayc().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcbc zzcbc2, String string) {
        zzbp.zzu((Object)((Object)zzcbc2));
        ((zzcdl)this).zzug();
        this.zzwh();
        zzcap.zzawj();
        boolean bl = ((zzcdl)this).zzaud().zza(zzcbc2);
        this.zzj(new zzcen(this, true, bl, zzcbc2, string));
    }

    @WorkerThread
    protected final void zzf(zzcan zzcan2) {
        zzbp.zzu((Object)((Object)zzcan2));
        ((zzcdl)this).zzug();
        this.zzwh();
        zzcap.zzawj();
        boolean bl = ((zzcdl)this).zzaud().zzc(zzcan2);
        zzcan zzcan3 = new zzcan(zzcan2);
        this.zzj(new zzceo(this, true, bl, zzcan3, zzcan2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcan>> atomicReference, String string, String string2, String string3) {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzcep(this, atomicReference, string, string2, string3));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfl>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzceq(this, atomicReference, string, string2, string3, bl));
    }

    @WorkerThread
    protected final void zzb(zzcfl zzcfl2) {
        ((zzcdl)this).zzug();
        this.zzwh();
        zzcap.zzawj();
        boolean bl = ((zzcdl)this).zzaud().zza(zzcfl2);
        this.zzj(new zzcer(this, bl, zzcfl2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfl>> atomicReference, boolean bl) {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzces(this, atomicReference, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzcei(this, atomicReference));
    }

    @WorkerThread
    protected final void zzazp() {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzcej(this));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcdl)this).zzug();
        this.zzwh();
        this.zzj(new zzcek(this, zzb2));
    }

    @WorkerThread
    private final void zzwt() {
        ((zzcdl)this).zzug();
        this.zzivt.start();
        this.zzivs.zzs(zzcap.zzawg());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzxe() {
        zzceg zzceg2;
        block11: {
            boolean bl;
            block12: {
                ((zzcdl)this).zzug();
                this.zzwh();
                if (this.isConnected()) {
                    return;
                }
                if (this.zzivr != null) break block11;
                this.zzivr = ((zzcdl)this).zzaul().zzayn();
                if (this.zzivr != null) break block11;
                ((zzcdl)this).zzauk().zzayi().log("State of service unknown");
                zzceg2 = this;
                ((zzcdl)zzceg2).zzug();
                zzceg2.zzwh();
                zzcap.zzawj();
                ((zzcdl)zzceg2).zzauk().zzayi().log("Checking service availability");
                switch (zze.zzaew().isGooglePlayServicesAvailable(((zzcdl)zzceg2).getContext())) {
                    case 0: {
                        ((zzcdl)zzceg2).zzauk().zzayi().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        ((zzcdl)zzceg2).zzauk().zzayi().log("Service missing");
                        break;
                    }
                    case 18: {
                        ((zzcdl)zzceg2).zzauk().zzaye().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        ((zzcdl)zzceg2).zzauk().zzayh().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        ((zzcdl)zzceg2).zzauk().zzaye().log("Service disabled");
                        break;
                    }
                    case 9: {
                        ((zzcdl)zzceg2).zzauk().zzaye().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zzivr = bl;
            ((zzcdl)this).zzaul().zzbm(this.zzivr);
        }
        if (this.zzivr.booleanValue()) {
            ((zzcdl)this).zzauk().zzayi().log("Using measurement service");
            this.zzivp.zzazr();
            return;
        }
        zzceg2 = this;
        zzcap.zzawj();
        PackageManager packageManager = ((zzcdl)zzceg2).getContext().getPackageManager();
        Intent intent = new Intent().setClassName(((zzcdl)zzceg2).getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            ((zzcdl)this).zzauk().zzayi().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = ((zzcdl)this).getContext();
            zzcap.zzawj();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzivp.zzk(intent2);
            return;
        }
        ((zzcdl)this).zzauk().zzayc().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcbg zzcbg2) {
        ((zzcdl)this).zzug();
        zzbp.zzu((Object)zzcbg2);
        this.zzivq = zzcbg2;
        this.zzwt();
        this.zzazq();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcdl)this).zzug();
        this.zzwh();
        try {
            zza.zzaky();
            zzcet zzcet2 = this.zzivp;
            Context context = ((zzcdl)this).getContext();
            context.unbindService((ServiceConnection)zzcet2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzivq = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcdl)this).zzug();
        if (this.zzivq != null) {
            this.zzivq = null;
            ((zzcdl)this).zzauk().zzayi().zzj("Disconnected from device MeasurementService", componentName);
            zzceg zzceg2 = this;
            ((zzcdl)zzceg2).zzug();
            zzceg2.zzxe();
        }
    }

    @WorkerThread
    private final void zzwu() {
        ((zzcdl)this).zzug();
        if (!this.isConnected()) {
            return;
        }
        ((zzcdl)this).zzauk().zzayi().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcdl)this).zzug();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzivu.size() >= zzcap.zzawo()) {
            ((zzcdl)this).zzauk().zzayc().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzivu.add(runnable);
        this.zzivv.zzs(60000L);
        this.zzxe();
    }

    @WorkerThread
    private final void zzazq() {
        ((zzcdl)this).zzug();
        ((zzcdl)this).zzauk().zzayi().zzj("Processing queued up service tasks", this.zzivu.size());
        for (Runnable runnable : this.zzivu) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcdl)this).zzauk().zzayc().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzivu.clear();
        this.zzivv.cancel();
    }

    static /* synthetic */ zzcet zza(zzceg zzceg2) {
        return zzceg2.zzivp;
    }

    static /* synthetic */ void zza(zzceg zzceg2, ComponentName componentName) {
        zzceg2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcbg zza(zzceg zzceg2, zzcbg zzcbg2) {
        zzceg2.zzivq = null;
        return null;
    }

    static /* synthetic */ void zzb(zzceg zzceg2) {
        zzceg2.zzazq();
    }

    static /* synthetic */ void zzc(zzceg zzceg2) {
        zzceg2.zzwu();
    }

    static /* synthetic */ zzcbg zzd(zzceg zzceg2) {
        return zzceg2.zzivq;
    }

    static /* synthetic */ void zze(zzceg zzceg2) {
        zzceg2.zzwt();
    }
}

