/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcbg;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbn;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcex;
import com.google.android.gms.internal.zzcey;

public final class zzcet
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zziwd;
    private volatile zzcbn zziwe;
    final /* synthetic */ zzceg zzivw;

    protected zzcet(zzceg zzceg2) {
        this.zzivw = zzceg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        ((zzcdl)this.zzivw).zzug();
        Context context = ((zzcdl)this.zzivw).getContext();
        zza zza2 = zza.zzaky();
        zzcet zzcet2 = this;
        synchronized (zzcet2) {
            if (this.zziwd) {
                ((zzcdl)this.zzivw).zzauk().zzayi().log("Connection attempt already in progress");
                return;
            }
            this.zziwd = true;
            zza2.zza(context, intent, (ServiceConnection)zzceg.zza(this.zzivw), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onServiceConnected");
        zzcet zzcet2 = this;
        synchronized (zzcet2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zziwd = false;
                ((zzcdl)this.zzivw).zzauk().zzayc().log("Service connected with null binder");
                return;
            }
            zzcbg zzcbg2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcbg2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcbg ? (zzcbg)iInterface : new zzcbi(iBinder2));
                    ((zzcdl)this.zzivw).zzauk().zzayi().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcdl)this.zzivw).zzauk().zzayc().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcdl)this.zzivw).zzauk().zzayc().log("Service connect failed to get IMeasurementService");
            }
            if (zzcbg2 == null) {
                this.zziwd = false;
                try {
                    zza.zzaky();
                    zzcet zzcet3 = zzceg.zza(this.zzivw);
                    iInterface = ((zzcdl)this.zzivw).getContext();
                    iInterface.unbindService((ServiceConnection)zzcet3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcbg2;
                ((zzcdl)this.zzivw).zzauj().zzg(new zzceu(this, (zzcbg)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcdl)this.zzivw).zzauk().zzayh().log("Service disconnected");
        ((zzcdl)this.zzivw).zzauj().zzg(new zzcev(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzazr() {
        ((zzcdl)this.zzivw).zzug();
        Context context = ((zzcdl)this.zzivw).getContext();
        zzcet zzcet2 = this;
        synchronized (zzcet2) {
            if (this.zziwd) {
                ((zzcdl)this.zzivw).zzauk().zzayi().log("Connection attempt already in progress");
                return;
            }
            if (this.zziwe != null) {
                ((zzcdl)this.zzivw).zzauk().zzayi().log("Already awaiting connection attempt");
                return;
            }
            this.zziwe = new zzcbn(context, Looper.getMainLooper(), this, this);
            ((zzcdl)this.zzivw).zzauk().zzayi().log("Connecting to remote service");
            this.zziwd = true;
            this.zziwe.zzajf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnected");
        zzcet zzcet2 = this;
        synchronized (zzcet2) {
            try {
                zzcbg zzcbg2 = (zzcbg)this.zziwe.zzajj();
                this.zziwe = null;
                ((zzcdl)this.zzivw).zzauj().zzg(new zzcew(this, zzcbg2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zziwe = null;
                this.zziwd = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcdl)this.zzivw).zzauk().zzayh().log("Service connection suspended");
        ((zzcdl)this.zzivw).zzauj().zzg(new zzcex(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcbo zzcbo2 = this.zzivw.zzikb.zzayv();
        if (zzcbo2 != null) {
            zzcbo2.zzaye().zzj("Service connection failed", connectionResult);
        }
        zzcet zzcet2 = this;
        synchronized (zzcet2) {
            this.zziwd = false;
            this.zziwe = null;
        }
        ((zzcdl)this.zzivw).zzauj().zzg(new zzcey(this));
    }

    static /* synthetic */ boolean zza(zzcet zzcet2, boolean bl) {
        zzcet2.zziwd = false;
        return false;
    }
}

