/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfo;

public final class zzcez<T extends Context> {
    private final T zziwi;

    public zzcez(T t) {
        zzbp.zzu(t);
        this.zziwi = t;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbp.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcfo.zzw(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcfo.zzw(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcbo zzcbo2 = zzcco.zzdm(this.zziwi).zzauk();
        zzcap.zzawj();
        zzcbo2.zzayi().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcbo zzcbo2 = zzcco.zzdm(this.zziwi).zzauk();
        zzcap.zzawj();
        zzcbo2.zzayi().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcbo zzcbo2 = zzcco.zzdm(this.zziwi).zzauk();
        if (intent == null) {
            zzcbo2.zzaye().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcap.zzawj();
        zzcbo2.zzayi().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzcco zzcco2 = zzcco.zzdm(this.zziwi);
        zzcbo zzcbo2 = zzcco2.zzauk();
        zzcco2.zzauj().zzg(new zzcfa(this, zzcco2, n, zzcbo2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcct(zzcco.zzdm(this.zziwi));
        }
        this.zzauk().zzaye().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzauk().zzayi().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcbo zzcbo2 = zzcco.zzdm(this.zziwi).zzauk();
        String string = jobParameters.getExtras().getString("action");
        zzcap.zzawj();
        zzcbo2.zzayi().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzauk().zzayi().zzj("onRebind called. action", string);
    }

    private final zzcbo zzauk() {
        return zzcco.zzdm(this.zziwi).zzauk();
    }

    static /* synthetic */ Context zza(zzcez zzcez2) {
        return zzcez2.zziwi;
    }
}

