/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccs;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzccp
extends zzcds {
    private ExecutorService zzirr;
    private zzcct zzirs;
    private zzcct zzirt;
    private final PriorityBlockingQueue<FutureTask<?>> zziru;
    private final BlockingQueue<FutureTask<?>> zzirv;
    private final Thread.UncaughtExceptionHandler zzirw;
    private final Thread.UncaughtExceptionHandler zzirx;
    private final Object zziry = new Object();
    private final Semaphore zzirz = new Semaphore(2);
    private volatile boolean zzisa;
    private static final AtomicLong zzisb = new AtomicLong(Long.MIN_VALUE);

    zzccp(zzccu zzccu2) {
        super(zzccu2);
        this.zziru = new PriorityBlockingQueue();
        this.zzirv = new LinkedBlockingQueue();
        this.zzirw = new zzccr(this, "Thread death: Uncaught exception on worker thread");
        this.zzirx = new zzccr(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzuh() {
    }

    @Override
    public final void zzug() {
        if (Thread.currentThread() != this.zzirs) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzatv() {
        if (Thread.currentThread() != this.zzirt) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzaq() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzayr() {
        return Thread.currentThread() == this.zzirs;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu(callable);
        zzccs zzccs2 = new zzccs(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzirs) {
            if (!this.zziru.isEmpty()) {
                ((zzcdr)this).zzauk().zzaye().log("Callable skipped the worker queue.");
            }
            zzccs2.run();
        } else {
            this.zza(zzccs2);
        }
        return zzccs2;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu(callable);
        zzccs zzccs2 = new zzccs(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzirs) {
            zzccs2.run();
        } else {
            this.zza(zzccs2);
        }
        return zzccs2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu((Object)runnable);
        this.zza(new zzccs(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzccs<?> zzccs2) {
        Object object = this.zziry;
        synchronized (object) {
            this.zziru.add(zzccs2);
            if (this.zzirs == null) {
                this.zzirs = new zzcct(this, "Measurement Worker", this.zziru);
                this.zzirs.setUncaughtExceptionHandler(this.zzirw);
                this.zzirs.start();
            } else {
                this.zzirs.zzmi();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwh();
        zzbp.zzu((Object)runnable);
        zzccs zzccs2 = new zzccs(this, runnable, false, "Task exception on network thread");
        zzccp zzccp2 = this;
        Object object = zzccp2.zziry;
        synchronized (object) {
            zzccp2.zzirv.add(zzccs2);
            if (zzccp2.zzirt == null) {
                zzccp2.zzirt = new zzcct(zzccp2, "Measurement Network", zzccp2.zzirv);
                zzccp2.zzirt.setUncaughtExceptionHandler(zzccp2.zzirx);
                zzccp2.zzirt.start();
            } else {
                zzccp2.zzirt.zzmi();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzays() {
        Object object = this.zziry;
        synchronized (object) {
            if (this.zzirr == null) {
                this.zzirr = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzirr;
        }
    }

    static /* synthetic */ Semaphore zza(zzccp zzccp2) {
        return zzccp2.zzirz;
    }

    static /* synthetic */ boolean zzb(zzccp zzccp2) {
        return zzccp2.zzisa;
    }

    static /* synthetic */ Object zzc(zzccp zzccp2) {
        return zzccp2.zziry;
    }

    static /* synthetic */ zzcct zzd(zzccp zzccp2) {
        return zzccp2.zzirs;
    }

    static /* synthetic */ zzcct zza(zzccp zzccp2, zzcct zzcct2) {
        zzccp2.zzirs = null;
        return null;
    }

    static /* synthetic */ zzcct zze(zzccp zzccp2) {
        return zzccp2.zzirt;
    }

    static /* synthetic */ zzcct zzb(zzccp zzccp2, zzcct zzcct2) {
        zzccp2.zzirt = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzayt() {
        return zzisb;
    }
}

