/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbn;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcdb;
import com.google.android.gms.internal.zzcdc;
import com.google.android.gms.internal.zzcdd;
import com.google.android.gms.internal.zzcde;
import com.google.android.gms.internal.zzcdf;
import com.google.android.gms.internal.zzcdg;
import com.google.android.gms.internal.zzcdh;
import com.google.android.gms.internal.zzcdi;
import com.google.android.gms.internal.zzcdj;
import com.google.android.gms.internal.zzcdk;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzcdn;
import com.google.android.gms.internal.zzcdo;
import com.google.android.gms.internal.zzcdp;
import com.google.android.gms.internal.zzcdq;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzccz
extends zzcbn {
    private final zzccu zzikb;
    private Boolean zzity;
    @Nullable
    private String zzitz;

    public zzccz(zzccu zzccu2) {
        this(zzccu2, null);
    }

    private zzccz(zzccu zzccu2, @Nullable String string) {
        zzbp.zzu((Object)zzccu2);
        this.zzikb = zzccu2;
        this.zzitz = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcaq zzcaq2) {
        this.zzb(zzcaq2, false);
        this.zzikb.zzauj().zzg(new zzcda(this, zzcaq2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbi zzcbi2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcbi2));
        this.zzb(zzcaq2, false);
        this.zzikb.zzauj().zzg(new zzcdj(this, zzcbi2, zzcaq2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbi zzcbi2, String string, String string2) {
        zzbp.zzu((Object)((Object)zzcbi2));
        zzbp.zzgf((String)string);
        this.zzg(string, true);
        this.zzikb.zzauj().zzg(new zzcdk(this, zzcbi2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcbi zzcbi2, String string) {
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)((Object)zzcbi2));
        this.zzg(string, true);
        this.zzikb.zzauk().zzayh().zzj("Log and bundle. event", this.zzikb.zzauf().zzjc(zzcbi2.name));
        long l = this.zzikb.zzvu().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzikb.zzauj().zze(new zzcdl(this, zzcbi2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzikb.zzauk().zzayc().zzj("Log and bundle returned null. appId", zzcbu.zzjf(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzikb.zzvu().nanoTime() / 1000000L;
            this.zzikb.zzauk().zzayh().zzd("Log and bundle processed. event, size, time_ms", this.zzikb.zzauf().zzjc(zzcbi2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzd("Failed to log and bundle. appId, event, error", zzcbu.zzjf(string), this.zzikb.zzauf().zzjc(zzcbi2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcfr zzcfr2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcfr2));
        this.zzb(zzcaq2, false);
        if (zzcfr2.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzcdm(this, zzcfr2, zzcaq2));
            return;
        }
        this.zzikb.zzauj().zzg(new zzcdn(this, zzcfr2, zzcaq2));
    }

    @Override
    @BinderThread
    public final List<zzcfr> zza(zzcaq zzcaq2, boolean bl) {
        this.zzb(zzcaq2, false);
        Future<List<zzcft>> future = this.zzikb.zzauj().zzd(new zzcdo(this, zzcaq2));
        try {
            List<zzcft> list = future.get();
            ArrayList<zzcfr> arrayList = new ArrayList<zzcfr>(list.size());
            for (zzcft zzcft2 : list) {
                if (!bl && zzcfu.zzkd(zzcft2.mName)) continue;
                arrayList.add(new zzcfr(zzcft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbu.zzjf(zzcaq2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcaq zzcaq2) {
        this.zzb(zzcaq2, false);
        zzcdp zzcdp2 = new zzcdp(this, zzcaq2);
        if (this.zzikb.zzauj().zzayr()) {
            zzcdp2.run();
            return;
        }
        this.zzikb.zzauj().zzg(zzcdp2);
    }

    @BinderThread
    private final void zzb(zzcaq zzcaq2, boolean bl) {
        zzbp.zzu((Object)((Object)zzcaq2));
        this.zzg(zzcaq2.packageName, false);
        this.zzikb.zzaug().zzkb(zzcaq2.zziln);
    }

    @BinderThread
    private final void zzg(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzikb.zzauk().zzayc().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzccz zzccz2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzccz2 = this;
                    if (!bl2) break block9;
                    if (zzccz2.zzity == null) {
                        zzccz2.zzity = "com.google.android.gms".equals(zzccz2.zzitz) || zzv.zzf((Context)zzccz2.zzikb.getContext(), (int)Binder.getCallingUid()) || zzp.zzca((Context)zzccz2.zzikb.getContext()).zza(zzccz2.zzikb.getContext().getPackageManager(), Binder.getCallingUid());
                    }
                    if (zzccz2.zzity.booleanValue()) break block10;
                }
                if (zzccz2.zzitz == null && zzo.zzb((Context)zzccz2.zzikb.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzccz2.zzitz = string2;
                }
                if (!string2.equals(zzccz2.zzitz)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzikb.zzauk().zzayc().zzj("Measurement Service called with invalid calling package. appId", zzcbu.zzjf(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzikb.zzauj().zzg(new zzcdq(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcaq zzcaq2) {
        this.zzb(zzcaq2, false);
        return this.zzikb.zzjs(zzcaq2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcat zzcat2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcat2));
        zzbp.zzu((Object)((Object)zzcat2.zzima));
        this.zzb(zzcaq2, false);
        zzcat zzcat3 = new zzcat(zzcat2);
        new zzcat(zzcat2).packageName = zzcaq2.packageName;
        if (zzcat2.zzima.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzcdb(this, zzcat3, zzcaq2));
            return;
        }
        this.zzikb.zzauj().zzg(new zzcdc(this, zzcat3, zzcaq2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcat zzcat2) {
        zzbp.zzu((Object)((Object)zzcat2));
        zzbp.zzu((Object)((Object)zzcat2.zzima));
        this.zzg(zzcat2.packageName, true);
        zzcat zzcat3 = new zzcat(zzcat2);
        if (zzcat2.zzima.getValue() == null) {
            this.zzikb.zzauj().zzg(new zzcdd(this, zzcat3));
            return;
        }
        this.zzikb.zzauj().zzg(new zzcde(this, zzcat3));
    }

    @Override
    @BinderThread
    public final List<zzcfr> zza(String string, String string2, boolean bl, zzcaq zzcaq2) {
        this.zzb(zzcaq2, false);
        Future<List<zzcft>> future = this.zzikb.zzauj().zzd(new zzcdf(this, zzcaq2, string, string2));
        try {
            List<zzcft> list = future.get();
            ArrayList<zzcfr> arrayList = new ArrayList<zzcfr>(list.size());
            for (zzcft zzcft2 : list) {
                if (!bl && zzcfu.zzkd(zzcft2.mName)) continue;
                arrayList.add(new zzcfr(zzcft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbu.zzjf(zzcaq2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfr> zza(String string, String string2, String string3, boolean bl) {
        this.zzg(string, true);
        Future<List<zzcft>> future = this.zzikb.zzauj().zzd(new zzcdg(this, string, string2, string3));
        try {
            List<zzcft> list = future.get();
            ArrayList<zzcfr> arrayList = new ArrayList<zzcfr>(list.size());
            for (zzcft zzcft2 : list) {
                if (!bl && zzcfu.zzkd(zzcft2.mName)) continue;
                arrayList.add(new zzcfr(zzcft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zze("Failed to get user attributes. appId", zzcbu.zzjf(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcat> zza(String string, String string2, zzcaq zzcaq2) {
        this.zzb(zzcaq2, false);
        Future<List<zzcat>> future = this.zzikb.zzauj().zzd(new zzcdh(this, zzcaq2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcat> zzj(String string, String string2, String string3) {
        this.zzg(string, true);
        Future<List<zzcat>> future = this.zzikb.zzauj().zzd(new zzcdi(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikb.zzauk().zzayc().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzccu zza(zzccz zzccz2) {
        return zzccz2.zzikb;
    }
}

