/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzccp;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcdv;
import com.google.android.gms.internal.zzcdw;
import com.google.android.gms.internal.zzcdx;
import com.google.android.gms.internal.zzcdy;
import com.google.android.gms.internal.zzcdz;
import com.google.android.gms.internal.zzcea;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzced;
import com.google.android.gms.internal.zzcee;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcdu
extends zzcds {
    protected zzceh zziuk;
    private AppMeasurement.EventInterceptor zziul;
    private final Set<AppMeasurement.OnEventListener> zzium = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zziun;
    private final AtomicReference<String> zziuo = new AtomicReference();

    protected zzcdu(zzccu zzccu2) {
        super(zzccu2);
    }

    @Override
    protected final void zzuh() {
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzwh();
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzauj().zzg(new zzcdv(this, bl));
    }

    @WorkerThread
    private final void zzbp(boolean bl) {
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzatu();
        this.zzwh();
        ((zzcdr)this).zzauk().zzayh().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcdr)this).zzaul().setMeasurementEnabled(bl);
        ((zzcdr)this).zzaub().zzazo();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzauj().zzg(new zzcea(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzauj().zzg(new zzceb(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        ((zzcdr)this).zzatu();
        boolean bl2 = this.zziul == null || zzcfu.zzkd(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        ((zzcdr)this).zzatu();
        boolean bl = this.zziul == null || zzcfu.zzkd(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        ((zzcdr)this).zzatu();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcdr)this).zzvu().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcdr)this).zzauj().zzg(new zzcec(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        zzbp.zzu((Object)bundle);
        ((zzcdr)this).zzug();
        this.zzwh();
        if (!this.zzikb.isEnabled()) {
            ((zzcdr)this).zzauk().zzayh().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zziun) {
            this.zziun = true;
            zzcdu zzcdu2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcdu zzcdu3 = zzcdu2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcdr)zzcdu3).getContext());
                }
                catch (Exception exception) {
                    ((zzcdr)zzcdu3).zzauk().zzaye().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcdr)zzcdu2).zzauk().zzayg().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzcfu.zzkd(string2);
        if (bl && this.zziul != null && !bl5 && !bl4) {
            ((zzcdr)this).zzauk().zzayh().zze("Passing event to registered event handler (FE)", ((zzcdr)this).zzauf().zzjc(string2), ((zzcdr)this).zzauf().zzw(bundle));
            this.zziul.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzikb.zzayu()) {
            return;
        }
        int n = ((zzcdr)this).zzaug().zzjw(string2);
        if (n != 0) {
            ((zzcdr)this).zzaug();
            String string4 = zzcfu.zza(string2, zzcav.zzavm(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzikb.zzaug().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcdr)this).zzaug().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcdr)this).zzaug().zzazx().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcdr)this).zzaug();
            bundle2 = zzcfu.zzac(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcdr)this).zzaug().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        zzcav.zzawj();
        zzcel zzcel2 = ((zzcdr)this).zzauc().zzazm();
        if (zzcel2 != null && !bundle3.containsKey("_sc")) {
            zzcel2.zzivo = true;
        }
        object2 = zzcel2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzcei.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcdr)this).zzaug().zzx(bundle5) : bundle5;
            ((zzcdr)this).zzauk().zzayh().zze("Logging event (FE)", ((zzcdr)this).zzauf().zzjc(string2), ((zzcdr)this).zzauf().zzw(bundle2));
            zzcbi zzcbi2 = new zzcbi((String)object, new zzcbf(bundle2), string, l);
            ((zzcdr)this).zzaub().zzc(zzcbi2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzium) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        zzcav.zzawj();
        if (((zzcdr)this).zzauc().zzazm() != null && "_ae".equals(string2)) {
            ((zzcdr)this).zzaui().zzbr(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbp.zzgf((String)string);
        long l = ((zzcdr)this).zzvu().currentTimeMillis();
        int n = ((zzcdr)this).zzaug().zzjy(string2);
        if (n != 0) {
            ((zzcdr)this).zzaug();
            String string3 = zzcfu.zza(string2, zzcav.zzavn(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzikb.zzaug().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcdr)this).zzaug().zzl(string2, object);
            if (n != 0) {
                ((zzcdr)this).zzaug();
                String string4 = zzcfu.zza(string2, zzcav.zzavn(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzikb.zzaug().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcdr)this).zzaug().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcdr)this).zzauj().zzg(new zzced(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzatu();
        this.zzwh();
        if (!this.zzikb.isEnabled()) {
            ((zzcdr)this).zzauk().zzayh().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzikb.zzayu()) {
            return;
        }
        ((zzcdr)this).zzauk().zzayh().zze("Setting user property (FE)", ((zzcdr)this).zzauf().zzjc(string2), object);
        zzcfr zzcfr2 = new zzcfr(string2, l, object, string);
        ((zzcdr)this).zzaub().zzb(zzcfr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcfr> zzbq(boolean bl) {
        ((zzcdr)this).zzatu();
        this.zzwh();
        ((zzcdr)this).zzauk().zzayh().log("Fetching user attributes (FE)");
        if (((zzcdr)this).zzauj().zzayr()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdr)this).zzauj();
        if (zzccp.zzaq()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikb.zzauj().zzg(new zzcee(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdr)this).zzauk().zzaye().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdr)this).zzauk().zzaye().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcdr)this).zzaul().zzaym();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcdr)this).zzauj().zzays(), (Callable)new zzcef(this));
        }
        catch (Exception exception) {
            ((zzcdr)this).zzauk().zzaye().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzaym() {
        ((zzcdr)this).zzatu();
        return this.zziuo.get();
    }

    final void zzjk(@Nullable String string) {
        this.zziuo.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbc(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcdr)this).zzauj().zzg(new zzceg(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdr)this).zzauk().zzaye().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzatu();
        this.zzwh();
        if (eventInterceptor != null && eventInterceptor != this.zziul) {
            zzbp.zza((this.zziul == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zziul = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdr)this).zzatu();
        this.zzwh();
        zzbp.zzu((Object)onEventListener);
        if (!this.zzium.add(onEventListener)) {
            ((zzcdr)this).zzauk().zzaye().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdr)this).zzatu();
        this.zzwh();
        zzbp.zzu((Object)onEventListener);
        if (!this.zzium.remove(onEventListener)) {
            ((zzcdr)this).zzauk().zzaye().log("OnEventListener had not been registered");
        }
    }

    public static int getMaxUserProperties(String string) {
        zzbp.zzgf((String)string);
        return zzcav.zzavz();
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        ((zzcdr)this).zzatu();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcdr)this).zzauk().zzaye().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgf((String)conditionalUserProperty.mAppId);
        ((zzcdr)this).zzatt();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcdr)this).zzvu().currentTimeMillis();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgf((String)conditionalUserProperty.mName);
        zzbp.zzgf((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcdr)this).zzaug().zzjy(string) != 0) {
            ((zzcdr)this).zzauk().zzayc().zzj("Invalid conditional user property name", ((zzcdr)this).zzauf().zzje(string));
            return;
        }
        if (((zzcdr)this).zzaug().zzl(string, object) != 0) {
            ((zzcdr)this).zzauk().zzayc().zze("Invalid conditional user property value", ((zzcdr)this).zzauf().zzje(string), object);
            return;
        }
        Object object2 = ((zzcdr)this).zzaug().zzm(string, object);
        if (object2 == null) {
            ((zzcdr)this).zzauk().zzayc().zze("Unable to normalize conditional user property value", ((zzcdr)this).zzauf().zzje(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= zzcav.zzawb() && l2 >= 1L)) {
            ((zzcdr)this).zzauk().zzayc().zze("Invalid conditional user property timeout", ((zzcdr)this).zzauf().zzje(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > zzcav.zzawc() || l3 < 1L) {
            ((zzcdr)this).zzauk().zzayc().zze("Invalid conditional user property time to live", ((zzcdr)this).zzauf().zzje(string), l3);
            return;
        }
        ((zzcdr)this).zzauj().zzg(new zzcdw(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzcdr)this).zzatu();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbp.zzgf((String)string);
        ((zzcdr)this).zzatt();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcdr)this).zzvu().currentTimeMillis();
        zzbp.zzgf((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcdr)this).zzauj().zzg(new zzcdx(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbi zzcbi2;
        zzcbi zzcbi3;
        zzcbi zzcbi4;
        ((zzcdr)this).zzug();
        this.zzwh();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgf((String)conditionalUserProperty.mName);
        zzbp.zzgf((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        if (!this.zzikb.isEnabled()) {
            ((zzcdr)this).zzauk().zzayh().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcfr zzcfr2 = new zzcfr(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcbi4 = ((zzcdr)this).zzaug().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbi3 = ((zzcdr)this).zzaug().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbi2 = ((zzcdr)this).zzaug().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcat zzcat2 = new zzcat(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcfr2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcbi3, conditionalUserProperty.mTriggerTimeout, zzcbi4, conditionalUserProperty.mTimeToLive, zzcbi2);
        ((zzcdr)this).zzaub().zzf(zzcat2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbi zzcbi2;
        ((zzcdr)this).zzug();
        this.zzwh();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgf((String)conditionalUserProperty.mName);
        if (!this.zzikb.isEnabled()) {
            ((zzcdr)this).zzauk().zzayh().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcfr zzcfr2 = new zzcfr(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcbi2 = ((zzcdr)this).zzaug().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcat zzcat2 = new zzcat(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcfr2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcbi2);
        ((zzcdr)this).zzaub().zzf(zzcat2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzcdr)this).zzatu();
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbp.zzgf((String)string);
        ((zzcdr)this).zzatt();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcdr)this).zzauj().zzayr()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdr)this).zzauj();
        if (zzccp.zzaq()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikb.zzauj().zzg(new zzcdy(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdr)this).zzauk().zzaye().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdr)this).zzauk().zzaye().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcat zzcat2 = (zzcat)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcat2.zzimb;
                conditionalUserProperty.mName = zzcat2.zzima.name;
                conditionalUserProperty.mValue = zzcat2.zzima.getValue();
                conditionalUserProperty.mActive = zzcat2.zzimc;
                conditionalUserProperty.mTriggerEventName = zzcat2.zzimd;
                if (zzcat2.zzime != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcat2.zzime.name;
                    if (zzcat2.zzime.zzinj != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcat2.zzime.zzinj.zzaxy();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcat2.zzimf;
                if (zzcat2.zzimg != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcat2.zzimg.name;
                    if (zzcat2.zzimg.zzinj != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcat2.zzimg.zzinj.zzaxy();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcat2.zzima.zziwu;
                conditionalUserProperty.mTimeToLive = zzcat2.zzimh;
                if (zzcat2.zzimi != null) {
                    conditionalUserProperty.mExpiredEventName = zzcat2.zzimi.name;
                    if (zzcat2.zzimi.zzinj != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcat2.zzimi.zzinj.zzaxy();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzcdr)this).zzatu();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbp.zzgf((String)string);
        ((zzcdr)this).zzatt();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcdr)this).zzauj().zzayr()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcdr)this).zzauj();
        if (zzccp.zzaq()) {
            ((zzcdr)this).zzauk().zzayc().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikb.zzauj().zzg(new zzcdz(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdr)this).zzauk().zzaye().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdr)this).zzauk().zzaye().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcfr zzcfr2 = (zzcfr)((Object)iterator.next());
                arrayMap.put(zzcfr2.name, zzcfr2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcdu zzcdu2, boolean bl) {
        zzcdu2.zzbp(bl);
    }

    static /* synthetic */ void zza(zzcdu zzcdu2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcdu2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcdu zzcdu2, String string, String string2, Object object, long l) {
        zzcdu2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcdu zzcdu2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdu2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcdu zzcdu2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdu2.zzc(conditionalUserProperty);
    }
}

