/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcbt;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfe;

public final class zzcez
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zziwd;
    private volatile zzcbt zziwe;
    final /* synthetic */ zzcem zzivw;

    protected zzcez(zzcem zzcem2) {
        this.zzivw = zzcem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        ((zzcdr)this.zzivw).zzug();
        Context context = ((zzcdr)this.zzivw).getContext();
        zza zza2 = zza.zzaky();
        zzcez zzcez2 = this;
        synchronized (zzcez2) {
            if (this.zziwd) {
                ((zzcdr)this.zzivw).zzauk().zzayi().log("Connection attempt already in progress");
                return;
            }
            this.zziwd = true;
            zza2.zza(context, intent, (ServiceConnection)zzcem.zza(this.zzivw), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onServiceConnected");
        zzcez zzcez2 = this;
        synchronized (zzcez2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zziwd = false;
                ((zzcdr)this.zzivw).zzauk().zzayc().log("Service connected with null binder");
                return;
            }
            zzcbm zzcbm2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcbm2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcbm ? (zzcbm)iInterface : new zzcbo(iBinder2));
                    ((zzcdr)this.zzivw).zzauk().zzayi().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcdr)this.zzivw).zzauk().zzayc().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcdr)this.zzivw).zzauk().zzayc().log("Service connect failed to get IMeasurementService");
            }
            if (zzcbm2 == null) {
                this.zziwd = false;
                try {
                    zza.zzaky();
                    zzcez zzcez3 = zzcem.zza(this.zzivw);
                    iInterface = ((zzcdr)this.zzivw).getContext();
                    iInterface.unbindService((ServiceConnection)zzcez3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcbm2;
                ((zzcdr)this.zzivw).zzauj().zzg(new zzcfa(this, (zzcbm)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcdr)this.zzivw).zzauk().zzayh().log("Service disconnected");
        ((zzcdr)this.zzivw).zzauj().zzg(new zzcfb(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzazr() {
        ((zzcdr)this.zzivw).zzug();
        Context context = ((zzcdr)this.zzivw).getContext();
        zzcez zzcez2 = this;
        synchronized (zzcez2) {
            if (this.zziwd) {
                ((zzcdr)this.zzivw).zzauk().zzayi().log("Connection attempt already in progress");
                return;
            }
            if (this.zziwe != null) {
                ((zzcdr)this.zzivw).zzauk().zzayi().log("Already awaiting connection attempt");
                return;
            }
            this.zziwe = new zzcbt(context, Looper.getMainLooper(), this, this);
            ((zzcdr)this.zzivw).zzauk().zzayi().log("Connecting to remote service");
            this.zziwd = true;
            this.zziwe.zzajf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnected");
        zzcez zzcez2 = this;
        synchronized (zzcez2) {
            try {
                zzcbm zzcbm2 = (zzcbm)this.zziwe.zzajj();
                this.zziwe = null;
                ((zzcdr)this.zzivw).zzauj().zzg(new zzcfc(this, zzcbm2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zziwe = null;
                this.zziwd = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcdr)this.zzivw).zzauk().zzayh().log("Service connection suspended");
        ((zzcdr)this.zzivw).zzauj().zzg(new zzcfd(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbp.zzfx((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcbu zzcbu2 = this.zzivw.zzikb.zzayv();
        if (zzcbu2 != null) {
            zzcbu2.zzaye().zzj("Service connection failed", connectionResult);
        }
        zzcez zzcez2 = this;
        synchronized (zzcez2) {
            this.zziwd = false;
            this.zziwe = null;
        }
        ((zzcdr)this.zzivw).zzauj().zzg(new zzcfe(this));
    }

    static /* synthetic */ boolean zza(zzcez zzcez2, boolean bl) {
        zzcez2.zziwd = false;
        return false;
    }
}

