/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcao;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcan
extends zzcdt {
    private final Map<String, Long> zzikt;
    private final Map<String, Integer> zziku = new ArrayMap();
    private long zzikv;

    public zzcan(zzccw zzccw2) {
        super(zzccw2);
        this.zzikt = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdt)this).zzaum().zzaye().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdt)this).zzvx().elapsedRealtime();
        ((zzcdt)this).zzaul().zzg(new zzcao(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        ((zzcdt)this).zzatw();
        ((zzcdt)this).zzuj();
        zzbp.zzgg((String)string);
        if (this.zziku.isEmpty()) {
            this.zzikv = l;
        }
        if ((n = this.zziku.get(string)) != null) {
            this.zziku.put(string, n + 1);
            return;
        }
        if (this.zziku.size() >= 100) {
            ((zzcdt)this).zzaum().zzayg().log("Too many ads visible");
            return;
        }
        this.zziku.put(string, 1);
        this.zzikt.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdt)this).zzaum().zzaye().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdt)this).zzvx().elapsedRealtime();
        ((zzcdt)this).zzaul().zzg(new zzcap(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        ((zzcdt)this).zzatw();
        ((zzcdt)this).zzuj();
        zzbp.zzgg((String)string);
        Integer n = this.zziku.get(string);
        if (n != null) {
            zzcen zzcen2 = ((zzcdt)this).zzaue().zzazo();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zziku.remove(string);
                Long l2 = this.zzikt.get(string);
                if (l2 == null) {
                    ((zzcdt)this).zzaum().zzaye().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzikt.remove(string);
                    this.zza(string, l3, zzcen2);
                }
                if (this.zziku.isEmpty()) {
                    if (this.zzikv == 0L) {
                        ((zzcdt)this).zzaum().zzaye().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzikv, zzcen2);
                    this.zzikv = 0L;
                }
                return;
            }
            this.zziku.put(string, n2);
            return;
        }
        ((zzcdt)this).zzaum().zzaye().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdt)this).zzaum().zzayk().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdt)this).zzaum().zzayk().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzcek.zza(zzb2, bundle);
        ((zzcdt)this).zzaua().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdt)this).zzaum().zzayk().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdt)this).zzaum().zzayk().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzcek.zza(zzb2, bundle);
        ((zzcdt)this).zzaua().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzaj(long l) {
        zzcen zzcen2 = ((zzcdt)this).zzaue().zzazo();
        for (String string : this.zzikt.keySet()) {
            long l2 = this.zzikt.get(string);
            this.zza(string, l - l2, zzcen2);
        }
        if (!this.zzikt.isEmpty()) {
            this.zza(l - this.zzikv, zzcen2);
        }
        this.zzak(l);
    }

    @WorkerThread
    private final void zzak(long l) {
        for (String string : this.zzikt.keySet()) {
            this.zzikt.put(string, l);
        }
        if (!this.zzikt.isEmpty()) {
            this.zzikv = l;
        }
    }

    static /* synthetic */ void zza(zzcan zzcan2, String string, long l) {
        zzcan2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcan zzcan2, String string, long l) {
        zzcan2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcan zzcan2, long l) {
        zzcan2.zzak(l);
    }
}

