/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzccr
extends zzcdu {
    private ExecutorService zzirz;
    private zzccv zzisa;
    private zzccv zzisb;
    private final PriorityBlockingQueue<FutureTask<?>> zzisc;
    private final BlockingQueue<FutureTask<?>> zzisd;
    private final Thread.UncaughtExceptionHandler zzise;
    private final Thread.UncaughtExceptionHandler zzisf;
    private final Object zzisg = new Object();
    private final Semaphore zzish = new Semaphore(2);
    private volatile boolean zzisi;
    private static final AtomicLong zzisj = new AtomicLong(Long.MIN_VALUE);

    zzccr(zzccw zzccw2) {
        super(zzccw2);
        this.zzisc = new PriorityBlockingQueue();
        this.zzisd = new LinkedBlockingQueue();
        this.zzise = new zzcct(this, "Thread death: Uncaught exception on worker thread");
        this.zzisf = new zzcct(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzuk() {
    }

    @Override
    public final void zzuj() {
        if (Thread.currentThread() != this.zzisa) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzatx() {
        if (Thread.currentThread() != this.zzisb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzaq() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzayt() {
        return Thread.currentThread() == this.zzisa;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu(callable);
        zzccu zzccu2 = new zzccu(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzisa) {
            if (!this.zzisc.isEmpty()) {
                ((zzcdt)this).zzaum().zzayg().log("Callable skipped the worker queue.");
            }
            zzccu2.run();
        } else {
            this.zza(zzccu2);
        }
        return zzccu2;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu(callable);
        zzccu zzccu2 = new zzccu(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzisa) {
            zzccu2.run();
        } else {
            this.zza(zzccu2);
        }
        return zzccu2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu((Object)runnable);
        this.zza(new zzccu(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzccu<?> zzccu2) {
        Object object = this.zzisg;
        synchronized (object) {
            this.zzisc.add(zzccu2);
            if (this.zzisa == null) {
                this.zzisa = new zzccv(this, "Measurement Worker", this.zzisc);
                this.zzisa.setUncaughtExceptionHandler(this.zzise);
                this.zzisa.start();
            } else {
                this.zzisa.zzml();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu((Object)runnable);
        zzccu zzccu2 = new zzccu(this, runnable, false, "Task exception on network thread");
        zzccr zzccr2 = this;
        Object object = zzccr2.zzisg;
        synchronized (object) {
            zzccr2.zzisd.add(zzccu2);
            if (zzccr2.zzisb == null) {
                zzccr2.zzisb = new zzccv(zzccr2, "Measurement Network", zzccr2.zzisd);
                zzccr2.zzisb.setUncaughtExceptionHandler(zzccr2.zzisf);
                zzccr2.zzisb.start();
            } else {
                zzccr2.zzisb.zzml();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzayu() {
        Object object = this.zzisg;
        synchronized (object) {
            if (this.zzirz == null) {
                this.zzirz = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzirz;
        }
    }

    static /* synthetic */ Semaphore zza(zzccr zzccr2) {
        return zzccr2.zzish;
    }

    static /* synthetic */ boolean zzb(zzccr zzccr2) {
        return zzccr2.zzisi;
    }

    static /* synthetic */ Object zzc(zzccr zzccr2) {
        return zzccr2.zzisg;
    }

    static /* synthetic */ zzccv zzd(zzccr zzccr2) {
        return zzccr2.zzisa;
    }

    static /* synthetic */ zzccv zza(zzccr zzccr2, zzccv zzccv2) {
        zzccr2.zzisa = null;
        return null;
    }

    static /* synthetic */ zzccv zze(zzccr zzccr2) {
        return zzccr2.zzisb;
    }

    static /* synthetic */ zzccv zzb(zzccr zzccr2, zzccv zzccv2) {
        zzccr2.zzisb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzayv() {
        return zzisj;
    }
}

