/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcek
extends zzcdu {
    protected zzcen zzivi;
    private volatile AppMeasurement.zzb zzivj;
    private AppMeasurement.zzb zzivk;
    private long zzivl;
    private final Map<Activity, zzcen> zzivm = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzivn = new CopyOnWriteArrayList();
    private boolean zzivo;
    private AppMeasurement.zzb zzivp;
    private String zzivq;

    public zzcek(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    @WorkerThread
    public final zzcen zzazo() {
        this.zzwk();
        ((zzcdt)this).zzuj();
        return this.zzivi;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcdt)this).zzaum().zzayg().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcdt)this).zzaul();
        if (!zzccr.zzaq()) {
            ((zzcdt)this).zzaum().zzayg().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzivo) {
            ((zzcdt)this).zzaum().zzayg().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzivj == null) {
            ((zzcdt)this).zzaum().zzayg().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzivm.get(activity) == null) {
            ((zzcdt)this).zzaum().zzayg().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcek.zzjt(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzivj.zzikn.equals(string2);
        boolean bl2 = zzcfw.zzas(this.zzivj.zzikm, string);
        if (bl && bl2) {
            ((zzcdt)this).zzaum().zzayh().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcax.zzavr())) {
            ((zzcdt)this).zzaum().zzayg().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcax.zzavr())) {
            ((zzcdt)this).zzaum().zzayg().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcdt)this).zzaum().zzayk().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcen zzcen2 = new zzcen(string, string2, ((zzcdt)this).zzaui().zzazy());
        this.zzivm.put(activity, zzcen2);
        this.zza(activity, zzcen2, true);
    }

    public final AppMeasurement.zzb zzazp() {
        ((zzcdt)this).zzatw();
        AppMeasurement.zzb zzb2 = this.zzivj;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdt)this).zzatw();
        if (zza2 == null) {
            ((zzcdt)this).zzaum().zzayg().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzivn.remove(zza2);
        this.zzivn.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdt)this).zzatw();
        this.zzivn.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcen zzcen2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzivj != null) {
            zzb2 = this.zzivj;
        } else if (this.zzivk != null && Math.abs(((zzcdt)this).zzvx().elapsedRealtime() - this.zzivl) < 1000L) {
            zzb2 = this.zzivk;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzivo = true;
        try {
            object2 = this.zzivn.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcen2);
                }
                catch (Exception exception) {
                    ((zzcdt)this).zzaum().zzaye().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcdt)this).zzaum().zzaye().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzivo = false;
        }
        Object object3 = object2 = this.zzivj == null ? this.zzivk : this.zzivj;
        if (bl2) {
            if (zzcen2.zzikn == null) {
                zzcen2.zzikn = zzcek.zzjt(activity.getClass().getCanonicalName());
            }
            object = new zzcen(zzcen2);
            this.zzivk = this.zzivj;
            this.zzivl = ((zzcdt)this).zzvx().elapsedRealtime();
            this.zzivj = object;
            ((zzcdt)this).zzaul().zzg(new zzcel(this, bl, (AppMeasurement.zzb)object2, (zzcen)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcen zzcen2) {
        ((zzcdt)this).zzaty().zzaj(((zzcdt)this).zzvx().elapsedRealtime());
        if (((zzcdt)this).zzauk().zzbs(zzcen2.zzivw)) {
            zzcen2.zzivw = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzikm != null) {
                bundle.putString("_sn", zzb2.zzikm);
            }
            bundle.putString("_sc", zzb2.zzikn);
            bundle.putLong("_si", zzb2.zziko);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcdt)this).zzuj();
        zzcek zzcek2 = this;
        synchronized (zzcek2) {
            if (this.zzivq == null || this.zzivq.equals(string) || zzb2 != null) {
                this.zzivq = string;
                this.zzivp = zzb2;
            }
            return;
        }
    }

    private static String zzjt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcen zzq(@NonNull Activity activity) {
        zzbp.zzu((Object)activity);
        zzcen zzcen2 = this.zzivm.get(activity);
        if (zzcen2 == null) {
            String string = zzcek.zzjt(activity.getClass().getCanonicalName());
            zzcen2 = new zzcen(null, string, ((zzcdt)this).zzaui().zzazy());
            this.zzivm.put(activity, zzcen2);
        }
        return zzcen2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcen zzcen2 = this.zzq(activity);
        this.zza(activity, zzcen2, false);
        zzcan zzcan2 = ((zzcdt)this).zzaty();
        long l = ((zzcdt)zzcan2).zzvx().elapsedRealtime();
        ((zzcdt)zzcan2).zzaul().zzg(new zzcaq(zzcan2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcen zzcen2 = this.zzq(activity);
        this.zzivk = this.zzivj;
        this.zzivl = ((zzcdt)this).zzvx().elapsedRealtime();
        this.zzivj = null;
        ((zzcdt)this).zzaul().zzg(new zzcem(this, zzcen2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcen zzcen2 = this.zzivm.get(activity);
        if (zzcen2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcen2.zziko);
        bundle2.putString("name", zzcen2.zzikm);
        bundle2.putString("referrer_name", zzcen2.zzikn);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzivm.remove(activity);
    }

    static /* synthetic */ void zza(zzcek zzcek2, zzcen zzcen2) {
        zzcek2.zza(zzcen2);
    }
}

