/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcer;
import com.google.android.gms.internal.zzces;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcex;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfq;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzceo
extends zzcdu {
    private final zzcfb zzivx;
    private zzcbo zzivy;
    private Boolean zzivz;
    private final zzcbc zziwa;
    private final zzcfq zziwb;
    private final List<Runnable> zziwc = new ArrayList<Runnable>();
    private final zzcbc zziwd;

    protected zzceo(zzccw zzccw2) {
        super(zzccw2);
        this.zziwb = new zzcfq(zzccw2.zzvx());
        this.zzivx = new zzcfb(this);
        this.zziwa = new zzcep(this, zzccw2);
        this.zziwd = new zzcet(this, zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        return this.zzivy != null;
    }

    @WorkerThread
    protected final void zzazq() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzceu(this, zzcas2));
    }

    @WorkerThread
    final void zza(zzcbo zzcbo2, zzbck zzbck2, zzcas zzcas2) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatw();
        this.zzwk();
        zzcax.zzawl();
        ArrayList<zzbck> arrayList = new ArrayList<zzbck>();
        int n = 100;
        zzcax.zzawu();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<zzbck> list = ((zzcdt)this).zzauf().zzdw(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbck2 != null && n < 100) {
                arrayList.add(zzbck2);
            }
            ArrayList<zzbck> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbck zzbck3 = (zzbck)e;
                if (zzbck3 instanceof zzcbk) {
                    try {
                        zzcbo2.zza((zzcbk)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaum().zzaye().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbck3 instanceof zzcft) {
                    try {
                        zzcbo2.zza((zzcft)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaum().zzaye().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbck3 instanceof zzcav) {
                    try {
                        zzcbo2.zza((zzcav)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaum().zzaye().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcdt)this).zzaum().zzaye().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcbk zzcbk2, String string) {
        zzbp.zzu((Object)((Object)zzcbk2));
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawl();
        boolean bl = ((zzcdt)this).zzauf().zza(zzcbk2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcev(this, true, bl, zzcbk2, zzcas2, string));
    }

    @WorkerThread
    protected final void zzf(zzcav zzcav2) {
        zzbp.zzu((Object)((Object)zzcav2));
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawl();
        boolean bl = ((zzcdt)this).zzauf().zzc(zzcav2);
        zzcav zzcav3 = new zzcav(zzcav2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcew(this, true, bl, zzcav3, zzcas2, zzcav2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcav>> atomicReference, String string, String string2, String string3) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcex(this, atomicReference, string, string2, string3, zzcas2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcft>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcey(this, atomicReference, string, string2, string3, bl, zzcas2));
    }

    @WorkerThread
    protected final void zzb(zzcft zzcft2) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawl();
        boolean bl = ((zzcdt)this).zzauf().zza(zzcft2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcez(this, bl, zzcft2, zzcas2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcft>> atomicReference, boolean bl) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcfa(this, atomicReference, zzcas2, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzceq(this, atomicReference, zzcas2));
    }

    @WorkerThread
    protected final void zzazr() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcer(this, zzcas2));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        this.zzj(new zzces(this, zzb2));
    }

    @WorkerThread
    private final void zzww() {
        ((zzcdt)this).zzuj();
        this.zziwb.start();
        this.zziwa.zzs(zzcax.zzawi());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzxh() {
        zzceo zzceo2;
        block11: {
            boolean bl;
            block12: {
                ((zzcdt)this).zzuj();
                this.zzwk();
                if (this.isConnected()) {
                    return;
                }
                if (this.zzivz != null) break block11;
                this.zzivz = ((zzcdt)this).zzaun().zzayp();
                if (this.zzivz != null) break block11;
                ((zzcdt)this).zzaum().zzayk().log("State of service unknown");
                zzceo2 = this;
                ((zzcdt)zzceo2).zzuj();
                zzceo2.zzwk();
                zzcax.zzawl();
                ((zzcdt)zzceo2).zzaum().zzayk().log("Checking service availability");
                switch (zze.zzaex().isGooglePlayServicesAvailable(((zzcdt)zzceo2).getContext())) {
                    case 0: {
                        ((zzcdt)zzceo2).zzaum().zzayk().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        ((zzcdt)zzceo2).zzaum().zzayk().log("Service missing");
                        break;
                    }
                    case 18: {
                        ((zzcdt)zzceo2).zzaum().zzayg().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        ((zzcdt)zzceo2).zzaum().zzayj().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        ((zzcdt)zzceo2).zzaum().zzayg().log("Service disabled");
                        break;
                    }
                    case 9: {
                        ((zzcdt)zzceo2).zzaum().zzayg().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zzivz = bl;
            ((zzcdt)this).zzaun().zzbm(this.zzivz);
        }
        if (this.zzivz.booleanValue()) {
            ((zzcdt)this).zzaum().zzayk().log("Using measurement service");
            this.zzivx.zzazt();
            return;
        }
        zzceo2 = this;
        zzcax.zzawl();
        PackageManager packageManager = ((zzcdt)zzceo2).getContext().getPackageManager();
        Intent intent = new Intent().setClassName(((zzcdt)zzceo2).getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            ((zzcdt)this).zzaum().zzayk().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = ((zzcdt)this).getContext();
            zzcax.zzawl();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzivx.zzk(intent2);
            return;
        }
        ((zzcdt)this).zzaum().zzaye().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcbo zzcbo2) {
        ((zzcdt)this).zzuj();
        zzbp.zzu((Object)zzcbo2);
        this.zzivy = zzcbo2;
        this.zzww();
        this.zzazs();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        try {
            zza.zzakz();
            zzcfb zzcfb2 = this.zzivx;
            Context context = ((zzcdt)this).getContext();
            context.unbindService((ServiceConnection)zzcfb2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzivy = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcdt)this).zzuj();
        if (this.zzivy != null) {
            this.zzivy = null;
            ((zzcdt)this).zzaum().zzayk().zzj("Disconnected from device MeasurementService", componentName);
            zzceo zzceo2 = this;
            ((zzcdt)zzceo2).zzuj();
            zzceo2.zzxh();
        }
    }

    @WorkerThread
    private final void zzwx() {
        ((zzcdt)this).zzuj();
        if (!this.isConnected()) {
            return;
        }
        ((zzcdt)this).zzaum().zzayk().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcdt)this).zzuj();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zziwc.size() >= zzcax.zzawq()) {
            ((zzcdt)this).zzaum().zzaye().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zziwc.add(runnable);
        this.zziwd.zzs(60000L);
        this.zzxh();
    }

    @WorkerThread
    private final void zzazs() {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzaum().zzayk().zzj("Processing queued up service tasks", this.zziwc.size());
        for (Runnable runnable : this.zziwc) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcdt)this).zzaum().zzaye().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zziwc.clear();
        this.zziwd.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzcas zzbr(boolean bl) {
        zzcax.zzawl();
        return ((zzcdt)this).zzaub().zzjb(bl ? ((zzcdt)this).zzaum().zzayl() : null);
    }

    static /* synthetic */ zzcfb zza(zzceo zzceo2) {
        return zzceo2.zzivx;
    }

    static /* synthetic */ void zza(zzceo zzceo2, ComponentName componentName) {
        zzceo2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcbo zza(zzceo zzceo2, zzcbo zzcbo2) {
        zzceo2.zzivy = null;
        return null;
    }

    static /* synthetic */ void zzb(zzceo zzceo2) {
        zzceo2.zzazs();
    }

    static /* synthetic */ void zzc(zzceo zzceo2) {
        zzceo2.zzwx();
    }

    static /* synthetic */ zzcbo zzd(zzceo zzceo2) {
        return zzceo2.zzivy;
    }

    static /* synthetic */ void zze(zzceo zzceo2) {
        zzceo2.zzww();
    }
}

