/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcbq;
import com.google.android.gms.internal.zzcbv;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfg;

public final class zzcfb
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zziwl;
    private volatile zzcbv zziwm;
    final /* synthetic */ zzceo zziwe;

    protected zzcfb(zzceo zzceo2) {
        this.zziwe = zzceo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        ((zzcdt)this.zziwe).zzuj();
        Context context = ((zzcdt)this.zziwe).getContext();
        zza zza2 = zza.zzakz();
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            if (this.zziwl) {
                ((zzcdt)this.zziwe).zzaum().zzayk().log("Connection attempt already in progress");
                return;
            }
            this.zziwl = true;
            zza2.zza(context, intent, (ServiceConnection)zzceo.zza(this.zziwe), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onServiceConnected");
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zziwl = false;
                ((zzcdt)this.zziwe).zzaum().zzaye().log("Service connected with null binder");
                return;
            }
            zzcbo zzcbo2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcbo2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcbo ? (zzcbo)iInterface : new zzcbq(iBinder2));
                    ((zzcdt)this.zziwe).zzaum().zzayk().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcdt)this.zziwe).zzaum().zzaye().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcdt)this.zziwe).zzaum().zzaye().log("Service connect failed to get IMeasurementService");
            }
            if (zzcbo2 == null) {
                this.zziwl = false;
                try {
                    zza.zzakz();
                    zzcfb zzcfb3 = zzceo.zza(this.zziwe);
                    iInterface = ((zzcdt)this.zziwe).getContext();
                    iInterface.unbindService((ServiceConnection)zzcfb3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcbo2;
                ((zzcdt)this.zziwe).zzaul().zzg(new zzcfc(this, (zzcbo)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcdt)this.zziwe).zzaum().zzayj().log("Service disconnected");
        ((zzcdt)this.zziwe).zzaul().zzg(new zzcfd(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzazt() {
        ((zzcdt)this.zziwe).zzuj();
        Context context = ((zzcdt)this.zziwe).getContext();
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            if (this.zziwl) {
                ((zzcdt)this.zziwe).zzaum().zzayk().log("Connection attempt already in progress");
                return;
            }
            if (this.zziwm != null) {
                ((zzcdt)this.zziwe).zzaum().zzayk().log("Already awaiting connection attempt");
                return;
            }
            this.zziwm = new zzcbv(context, Looper.getMainLooper(), this, this);
            ((zzcdt)this.zziwe).zzaum().zzayk().log("Connecting to remote service");
            this.zziwl = true;
            this.zziwm.zzajg();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnected");
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            try {
                zzcbo zzcbo2 = (zzcbo)this.zziwm.zzajk();
                this.zziwm = null;
                ((zzcdt)this.zziwe).zzaul().zzg(new zzcfe(this, zzcbo2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zziwm = null;
                this.zziwl = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcdt)this.zziwe).zzaum().zzayj().log("Service connection suspended");
        ((zzcdt)this.zziwe).zzaul().zzg(new zzcff(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcbw zzcbw2 = this.zziwe.zzikh.zzayx();
        if (zzcbw2 != null) {
            zzcbw2.zzayg().zzj("Service connection failed", connectionResult);
        }
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            this.zziwl = false;
            this.zziwm = null;
        }
        ((zzcdt)this.zziwe).zzaul().zzg(new zzcfg(this));
    }

    static /* synthetic */ boolean zza(zzcfb zzcfb2, boolean bl) {
        zzcfb2.zziwl = false;
        return false;
    }
}

