/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdb;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfw;

public final class zzcfh<T extends Context> {
    private final T zzdtw;

    public zzcfh(T t) {
        zzbp.zzu(t);
        this.zzdtw = t;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbp.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcfw.zzv(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcfw.zzv(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcbw zzcbw2 = zzccw.zzdn(this.zzdtw).zzaum();
        zzcax.zzawl();
        zzcbw2.zzayk().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcbw zzcbw2 = zzccw.zzdn(this.zzdtw).zzaum();
        zzcax.zzawl();
        zzcbw2.zzayk().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcbw zzcbw2 = zzccw.zzdn(this.zzdtw).zzaum();
        if (intent == null) {
            zzcbw2.zzayg().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcax.zzawl();
        zzcbw2.zzayk().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzccw zzccw2 = zzccw.zzdn(this.zzdtw);
        zzcbw zzcbw2 = zzccw2.zzaum();
        zzccw2.zzaul().zzg(new zzcfi(this, zzccw2, n, zzcbw2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzaum().zzaye().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcdb(zzccw.zzdn(this.zzdtw));
        }
        this.zzaum().zzayg().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzaum().zzaye().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzaum().zzayk().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcbw zzcbw2 = zzccw.zzdn(this.zzdtw).zzaum();
        String string = jobParameters.getExtras().getString("action");
        zzcax.zzawl();
        zzcbw2.zzayk().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzaum().zzaye().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzaum().zzayk().zzj("onRebind called. action", string);
    }

    private final zzcbw zzaum() {
        return zzccw.zzdn(this.zzdtw).zzaum();
    }

    static /* synthetic */ Context zza(zzcfh zzcfh2) {
        return zzcfh2.zzdtw;
    }
}

