/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbt;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfw;
import java.util.ArrayList;
import java.util.List;

public final class zzcbs
extends zzcdu {
    private final zzcbt zzipl = new zzcbt(this, ((zzcdt)this).getContext(), zzcax.zzawj());
    private boolean zzipm;

    zzcbs(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    @WorkerThread
    private final boolean zzb(int n, byte[] byArray) {
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzuj();
        if (this.zzipm) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        zzcax.zzawt();
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzcdt)this).zzaul().zzayf().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzcdt)this).zzaul().zzayd().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzcdt)this).zzaul().zzayd().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzipm = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcdt)this).zzaul().zzayd().zzj("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzipm = true;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block20;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcdt)this).zzaul().zzayd().zzj("Error writing entry to local database", (Object)sQLiteException);
                        this.zzipm = true;
                    }
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcbk zzcbk2) {
        Parcel parcel = Parcel.obtain();
        zzcbk2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcdt)this).zzaul().zzayf().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zzb(0, byArray);
    }

    public final boolean zza(zzcft zzcft2) {
        Parcel parcel = Parcel.obtain();
        zzcft2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcdt)this).zzaul().zzayf().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(1, byArray);
    }

    public final boolean zzc(zzcav zzcav2) {
        ((zzcdt)this).zzauh();
        byte[] byArray = zzcfw.zza((Parcelable)zzcav2);
        if (byArray.length > 131072) {
            ((zzcdt)this).zzaul().zzayf().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public final List<zzbck> zzdw(int n) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatv();
        if (this.zzipm) {
            return null;
        }
        ArrayList<zzbck> arrayList = new ArrayList<zzbck>();
        if (!((zzcdt)this).getContext().getDatabasePath(zzcax.zzawj()).exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzcdt)this).zzaul().zzayf().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zzbck zzbck2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbck2 = (zzcbk)((Object)zzcbk.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbcm zzbcm2) {
                                    ((zzcdt)this).zzaul().zzayd().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zzbck2 == null) continue;
                                arrayList.add(zzbck2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zzbck2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbck2 = (zzcft)((Object)zzcft.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbcm zzbcm3) {
                                    ((zzcdt)this).zzaul().zzayd().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbck2 == null) continue;
                                arrayList.add(zzbck2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zzbck2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbck2 = (zzcav)((Object)zzcav.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbcm zzbcm4) {
                                    ((zzcdt)this).zzaul().zzayd().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbck2 == null) continue;
                                arrayList.add(zzbck2);
                                continue;
                            }
                            ((zzcdt)this).zzaul().zzayd().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzcdt)this).zzaul().zzayd().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzipm = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcdt)this).zzaul().zzayd().zzj("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzipm = true;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block41;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcdt)this).zzaul().zzayd().zzj("Error reading entries from local database", (Object)sQLiteException);
                        this.zzipm = true;
                    }
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() {
        if (this.zzipm) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzipl.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzipm = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

