/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcek
extends zzcdu {
    protected zzcen zzivj;
    private volatile AppMeasurement.zzb zzivk;
    private AppMeasurement.zzb zzivl;
    private long zzivm;
    private final Map<Activity, zzcen> zzivn = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzivo = new CopyOnWriteArrayList();
    private boolean zzivp;
    private AppMeasurement.zzb zzivq;
    private String zzivr;

    public zzcek(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    @WorkerThread
    public final zzcen zzazn() {
        this.zzwk();
        ((zzcdt)this).zzuj();
        return this.zzivj;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcdt)this).zzaul().zzayf().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcdt)this).zzauk();
        if (!zzccr.zzaq()) {
            ((zzcdt)this).zzaul().zzayf().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzivp) {
            ((zzcdt)this).zzaul().zzayf().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzivk == null) {
            ((zzcdt)this).zzaul().zzayf().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzivn.get(activity) == null) {
            ((zzcdt)this).zzaul().zzayf().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcek.zzjt(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzivk.zziko.equals(string2);
        boolean bl2 = zzcfw.zzas(this.zzivk.zzikn, string);
        if (bl && bl2) {
            ((zzcdt)this).zzaul().zzayg().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcax.zzavq())) {
            ((zzcdt)this).zzaul().zzayf().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcax.zzavq())) {
            ((zzcdt)this).zzaul().zzayf().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcdt)this).zzaul().zzayj().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcen zzcen2 = new zzcen(string, string2, ((zzcdt)this).zzauh().zzazx());
        this.zzivn.put(activity, zzcen2);
        this.zza(activity, zzcen2, true);
    }

    public final AppMeasurement.zzb zzazo() {
        ((zzcdt)this).zzatv();
        AppMeasurement.zzb zzb2 = this.zzivk;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdt)this).zzatv();
        if (zza2 == null) {
            ((zzcdt)this).zzaul().zzayf().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzivo.remove(zza2);
        this.zzivo.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdt)this).zzatv();
        this.zzivo.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcen zzcen2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzivk != null) {
            zzb2 = this.zzivk;
        } else if (this.zzivl != null && Math.abs(((zzcdt)this).zzvx().elapsedRealtime() - this.zzivm) < 1000L) {
            zzb2 = this.zzivl;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzivp = true;
        try {
            object2 = this.zzivo.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcen2);
                }
                catch (Exception exception) {
                    ((zzcdt)this).zzaul().zzayd().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcdt)this).zzaul().zzayd().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzivp = false;
        }
        Object object3 = object2 = this.zzivk == null ? this.zzivl : this.zzivk;
        if (bl2) {
            if (zzcen2.zziko == null) {
                zzcen2.zziko = zzcek.zzjt(activity.getClass().getCanonicalName());
            }
            object = new zzcen(zzcen2);
            this.zzivl = this.zzivk;
            this.zzivm = ((zzcdt)this).zzvx().elapsedRealtime();
            this.zzivk = object;
            ((zzcdt)this).zzauk().zzg(new zzcel(this, bl, (AppMeasurement.zzb)object2, (zzcen)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcen zzcen2) {
        ((zzcdt)this).zzatx().zzaj(((zzcdt)this).zzvx().elapsedRealtime());
        if (((zzcdt)this).zzauj().zzbs(zzcen2.zzivx)) {
            zzcen2.zzivx = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzikn != null) {
                bundle.putString("_sn", zzb2.zzikn);
            }
            bundle.putString("_sc", zzb2.zziko);
            bundle.putLong("_si", zzb2.zzikp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcdt)this).zzuj();
        zzcek zzcek2 = this;
        synchronized (zzcek2) {
            if (this.zzivr == null || this.zzivr.equals(string) || zzb2 != null) {
                this.zzivr = string;
                this.zzivq = zzb2;
            }
            return;
        }
    }

    private static String zzjt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcen zzq(@NonNull Activity activity) {
        zzbp.zzu((Object)activity);
        zzcen zzcen2 = this.zzivn.get(activity);
        if (zzcen2 == null) {
            String string = zzcek.zzjt(activity.getClass().getCanonicalName());
            zzcen2 = new zzcen(null, string, ((zzcdt)this).zzauh().zzazx());
            this.zzivn.put(activity, zzcen2);
        }
        return zzcen2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcen zzcen2 = this.zzq(activity);
        this.zza(activity, zzcen2, false);
        zzcan zzcan2 = ((zzcdt)this).zzatx();
        long l = ((zzcdt)zzcan2).zzvx().elapsedRealtime();
        ((zzcdt)zzcan2).zzauk().zzg(new zzcaq(zzcan2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcen zzcen2 = this.zzq(activity);
        this.zzivl = this.zzivk;
        this.zzivm = ((zzcdt)this).zzvx().elapsedRealtime();
        this.zzivk = null;
        ((zzcdt)this).zzauk().zzg(new zzcem(this, zzcen2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcen zzcen2 = this.zzivn.get(activity);
        if (zzcen2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcen2.zzikp);
        bundle2.putString("name", zzcen2.zzikn);
        bundle2.putString("referrer_name", zzcen2.zziko);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzivn.remove(activity);
    }

    static /* synthetic */ void zza(zzcek zzcek2, zzcen zzcen2) {
        zzcek2.zza(zzcen2);
    }
}

