/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfm;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzckh;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzcko;
import com.google.android.gms.internal.zzckp;
import com.google.android.gms.internal.zzcks;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;
import com.google.android.gms.internal.zzclb;
import com.google.android.gms.internal.zzclc;
import com.google.android.gms.internal.zzfhj;
import com.google.android.gms.internal.zzfhk;
import com.google.android.gms.internal.zzfhm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcfl
extends zzcii {
    private static final String[] zziwe = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zziwf = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zziwg = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;"};
    private static final String[] zziwh = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zziwi = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;"};
    private static final String[] zziwj = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzcfo zziwk;
    private final zzckh zziwl = new zzckh(this.zzwh());

    zzcfl(zzchj zzchj2) {
        super(zzchj2);
        String string = "google_app_measurement.db";
        this.zziwk = new zzcfo(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzaxo() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzwu();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzwu();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzwu();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzawn().zzays().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzut();
        try {
            return this.zziwk.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzayu().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcft zzae(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzcft zzcft2 = new zzcft(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzawn().zzays().zzj("Got multiple records for event aggregates, expected one. appId", zzcgj.zzjf(string));
            }
            zzcft zzcft3 = zzcft2;
            return zzcft3;
        }
    }

    @WorkerThread
    public final void zza(zzcft zzcft2) {
        zzbq.checkNotNull((Object)zzcft2);
        this.zzut();
        this.zzwu();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcft2.mAppId);
        contentValues.put("name", zzcft2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcft2.zziwz));
        contentValues.put("current_bundle_count", Long.valueOf(zzcft2.zzixa));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcft2.zzixb));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzcft2.zzixc));
        contentValues.put("last_sampled_complex_event_id", zzcft2.zzixd);
        contentValues.put("last_sampling_rate", zzcft2.zzixe);
        Long l = null;
        if (zzcft2.zzixf != null && zzcft2.zzixf.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert/update event aggregates (got -1). appId", zzcgj.zzjf(zzcft2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing event aggregates. appId", zzcgj.zzjf(zzcft2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzaf(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzawn().zzayy().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zzd("Error deleting user attribute. appId", zzcgj.zzjf(string), this.zzawi().zzje(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzckm zzckm2) {
        zzbq.checkNotNull((Object)zzckm2);
        this.zzut();
        this.zzwu();
        if (this.zzag(zzckm2.mAppId, zzckm2.mName) == null && (zzckn.zzju(zzckm2.mName) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzckm2.mAppId}) >= 25L : this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzckm2.mAppId, zzckm2.mOrigin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzckm2.mAppId);
        contentValues.put("origin", zzckm2.mOrigin);
        contentValues.put("name", zzckm2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzckm2.zzjhb));
        zzcfl.zza(contentValues, "value", zzckm2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert/update user property (got -1). appId", zzcgj.zzjf(zzckm2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing user property. appId", zzcgj.zzjf(zzckm2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzckm zzag(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzckm zzckm2 = new zzckm(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzawn().zzays().zzj("Got multiple records for user property, expected one. appId", zzcgj.zzjf(string));
            }
            zzckm zzckm3 = zzckm2;
            return zzckm3;
        }
    }

    @WorkerThread
    public final List<zzckm> zziv(String string) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        ArrayList<zzckm> arrayList = new ArrayList<zzckm>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzckm> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzawn().zzays().zzj("Read invalid user property value, ignoring it. appId", zzcgj.zzjf(string));
                    continue;
                }
                zzckm zzckm2 = new zzckm(string, string2, (String)object, l, object2);
                arrayList.add(zzckm2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzckm> zzg(String string, String string2, String string3) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        ArrayList<zzckm> arrayList = new ArrayList<zzckm>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzckm> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzawn().zzays().zzj("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzawn().zzays().zzd("(2)Read invalid user property value, ignoring it", zzcgj.zzjf(string), string2, string3);
                    continue;
                }
                zzckm zzckm2 = new zzckm(string, string2, (String)object, l, object2);
                arrayList.add(zzckm2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcfi zzcfi2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        this.zzut();
        this.zzwu();
        if (this.zzag(zzcfi2.packageName, zzcfi2.zzivv.name) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcfi2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcfi2.packageName);
        contentValues.put("origin", zzcfi2.zzivu);
        contentValues.put("name", zzcfi2.zzivv.name);
        zzcfl.zza(contentValues, "value", zzcfi2.zzivv.getValue());
        contentValues.put("active", Boolean.valueOf(zzcfi2.zzivx));
        contentValues.put("trigger_event_name", zzcfi2.zzivy);
        contentValues.put("trigger_timeout", Long.valueOf(zzcfi2.zziwa));
        this.zzawj();
        contentValues.put("timed_out_event", zzckn.zza((Parcelable)zzcfi2.zzivz));
        contentValues.put("creation_timestamp", Long.valueOf(zzcfi2.zzivw));
        this.zzawj();
        contentValues.put("triggered_event", zzckn.zza((Parcelable)zzcfi2.zziwb));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcfi2.zzivv.zzjgx));
        contentValues.put("time_to_live", Long.valueOf(zzcfi2.zziwc));
        this.zzawj();
        contentValues.put("expired_event", zzckn.zza((Parcelable)zzcfi2.zziwd));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert/update conditional user property (got -1)", zzcgj.zzjf(zzcfi2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing conditional user property", zzcgj.zzjf(zzcfi2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcfi zzah(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcfx zzcfx2 = this.zzawj().zzb(cursor.getBlob(5), zzcfx.CREATOR);
            long l2 = cursor.getLong(6);
            zzcfx zzcfx3 = this.zzawj().zzb(cursor.getBlob(7), zzcfx.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcfx zzcfx4 = this.zzawj().zzb(cursor.getBlob(10), zzcfx.CREATOR);
            zzckk zzckk2 = new zzckk(string2, l3, object, string3);
            zzcfi zzcfi2 = new zzcfi(string, string3, zzckk2, l2, bl, string4, zzcfx2, l, zzcfx3, l4, zzcfx4);
            if (cursor.moveToNext()) {
                this.zzawn().zzays().zze("Got multiple records for conditional property, expected one", zzcgj.zzjf(string), this.zzawi().zzje(string2));
            }
            zzcfi zzcfi3 = zzcfi2;
            return zzcfi3;
        }
    }

    @WorkerThread
    public final int zzai(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zzd("Error deleting conditional property", zzcgj.zzjf(string), this.zzawi().zzje(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcfi> zzh(String string, String string2, String string3) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcfi> zzc(String string, String[] stringArray) {
        this.zzut();
        this.zzwu();
        ArrayList<zzcfi> arrayList = new ArrayList<zzcfi>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcfi> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzawn().zzays().zzj("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcfx zzcfx2 = this.zzawj().zzb(cursor.getBlob(7), zzcfx.CREATOR);
                long l2 = cursor.getLong(8);
                zzcfx zzcfx3 = this.zzawj().zzb(cursor.getBlob(9), zzcfx.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcfx zzcfx4 = this.zzawj().zzb(cursor.getBlob(12), zzcfx.CREATOR);
                zzckk zzckk2 = new zzckk(string3, l3, object2, string2);
                zzcfi zzcfi2 = new zzcfi((String)object, string2, zzckk2, l2, bl, string4, zzcfx2, l, zzcfx3, l4, zzcfx4);
                arrayList.add(zzcfi2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcfe zziw(String string) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcfe zzcfe2 = new zzcfe(this.zzitu, string);
            zzcfe2.zzim(cursor.getString(0));
            zzcfe2.zzin(cursor.getString(1));
            zzcfe2.zzio(cursor.getString(2));
            zzcfe2.zzap(cursor.getLong(3));
            zzcfe2.zzak(cursor.getLong(4));
            zzcfe2.zzal(cursor.getLong(5));
            zzcfe2.setAppVersion(cursor.getString(6));
            zzcfe2.zziq(cursor.getString(7));
            zzcfe2.zzan(cursor.getLong(8));
            zzcfe2.zzao(cursor.getLong(9));
            zzcfe2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzcfe2.zzas(cursor.getLong(11));
            zzcfe2.zzat(cursor.getLong(12));
            zzcfe2.zzau(cursor.getLong(13));
            zzcfe2.zzav(cursor.getLong(14));
            zzcfe2.zzaq(cursor.getLong(15));
            zzcfe2.zzar(cursor.getLong(16));
            zzcfe2.zzam(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcfe2.zzip(cursor.getString(18));
            zzcfe2.zzax(cursor.getLong(19));
            zzcfe2.zzaw(cursor.getLong(20));
            zzcfe2.zzir(cursor.getString(21));
            zzcfe2.zzay(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcfe2.zzbk(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzcfe2.zzawq();
            if (cursor.moveToNext()) {
                this.zzawn().zzays().zzj("Got multiple records for app, expected one. appId", zzcgj.zzjf(string));
            }
            zzcfe zzcfe3 = zzcfe2;
            return zzcfe3;
        }
    }

    @WorkerThread
    public final void zza(zzcfe zzcfe2) {
        zzbq.checkNotNull((Object)zzcfe2);
        this.zzut();
        this.zzwu();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcfe2.getAppId());
        contentValues.put("app_instance_id", zzcfe2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcfe2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcfe2.zzawr());
        contentValues.put("last_bundle_index", Long.valueOf(zzcfe2.zzaxa()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcfe2.zzawt()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcfe2.zzawu()));
        contentValues.put("app_version", zzcfe2.zzuy());
        contentValues.put("app_store", zzcfe2.zzaww());
        contentValues.put("gmp_version", Long.valueOf(zzcfe2.zzawx()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcfe2.zzawy()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcfe2.zzawz()));
        contentValues.put("day", Long.valueOf(zzcfe2.zzaxe()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcfe2.zzaxf()));
        contentValues.put("daily_events_count", Long.valueOf(zzcfe2.zzaxg()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcfe2.zzaxh()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcfe2.zzaxb()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcfe2.zzaxc()));
        contentValues.put("app_version_int", Long.valueOf(zzcfe2.zzawv()));
        contentValues.put("firebase_instance_id", zzcfe2.zzaws());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcfe2.zzaxj()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcfe2.zzaxi()));
        contentValues.put("health_monitor_sample", zzcfe2.zzaxk());
        contentValues.put("android_id", Long.valueOf(zzcfe2.zzaxm()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzcfe2.zzaxn()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcfe2.getAppId()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert/update app (got -1). appId", zzcgj.zzjf(zzcfe2.getAppId()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing app. appId", zzcgj.zzjf(zzcfe2.getAppId()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzix(String string) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzawp().zzb(string2, zzcfz.zziyh);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error deleting over the limit events. appId", zzcgj.zzjf(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcfm zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        String[] stringArray = new String[]{string};
        zzcfm zzcfm2 = new zzcfm();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzawn().zzayu().zzj("Not updating daily counts, app is not known. appId", zzcgj.zzjf(string));
                zzcfm zzcfm3 = zzcfm2;
                return zzcfm3;
            }
            if (cursor.getLong(0) == l) {
                zzcfm2.zziwn = cursor.getLong(1);
                zzcfm2.zziwm = cursor.getLong(2);
                zzcfm2.zziwo = cursor.getLong(3);
                zzcfm2.zziwp = cursor.getLong(4);
                zzcfm2.zziwq = cursor.getLong(5);
            }
            if (bl) {
                ++zzcfm2.zziwn;
            }
            if (bl2) {
                ++zzcfm2.zziwm;
            }
            if (bl3) {
                ++zzcfm2.zziwo;
            }
            if (bl4) {
                ++zzcfm2.zziwp;
            }
            if (bl5) {
                ++zzcfm2.zziwq;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcfm2.zziwm));
            contentValues.put("daily_events_count", Long.valueOf(zzcfm2.zziwn));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcfm2.zziwo));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcfm2.zziwp));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcfm2.zziwq));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcfm zzcfm4 = zzcfm2;
            return zzcfm4;
        }
    }

    @WorkerThread
    public final byte[] zziy(String string) {
        zzbq.zzgi((String)string);
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzawn().zzays().zzj("Got multiple records for app config, expected one. appId", zzcgj.zzjf(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzclb zzclb2, boolean bl) {
        byte[] byArray;
        this.zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzclb2));
        zzbq.zzgi((String)zzclb2.zzch);
        zzbq.checkNotNull((Object)zzclb2.zzjji);
        this.zzaxw();
        long l = this.zzwh().currentTimeMillis();
        if (zzclb2.zzjji < l - zzcfk.zzaxq() || zzclb2.zzjji > l + zzcfk.zzaxq()) {
            this.zzawn().zzayu().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcgj.zzjf(zzclb2.zzch), l, zzclb2.zzjji);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzclb2.zzhl()];
            zzfhk zzfhk2 = zzfhk.zzo((byte[])byArray2, (int)0, (int)byArray3.length);
            zzclb2.zza(zzfhk2);
            zzfhk2.zzcut();
            byArray = this.zzawj().zzp(byArray2);
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Data loss. Failed to serialize bundle. appId", zzcgj.zzjf(zzclb2.zzch), iOException);
            return false;
        }
        this.zzawn().zzayy().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzclb2.zzch);
        contentValues.put("bundle_end_timestamp", zzclb2.zzjji);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert bundle (got -1). appId", zzcgj.zzjf(zzclb2.zzch));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing bundle. appId", zzcgj.zzjf(zzclb2.zzch), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzaxu() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzaxv() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzclb, Long>> zzl(String string, int n, int n2) {
        this.zzut();
        this.zzwu();
        zzbq.checkArgument((n > 0 ? 1 : 0) != 0);
        zzbq.checkArgument((n2 > 0 ? 1 : 0) != 0);
        zzbq.zzgi((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzclb, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzclb, Long>> arrayList = new ArrayList<Pair<zzclb, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzawj().zzq((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzawn().zzays().zze("Failed to unzip queued bundle. appId", zzcgj.zzjf(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray2.length);
                zzclb zzclb2 = new zzclb();
                try {
                    zzclb2.zza((zzfhj)object);
                }
                catch (IOException iOException) {
                    this.zzawn().zzays().zze("Failed to merge queued bundle. appId", zzcgj.zzjf(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzclb, Long>)Pair.create((Object)((Object)zzclb2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzclb, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzaxw() {
        this.zzut();
        this.zzwu();
        if (!this.zzayc()) {
            return;
        }
        long l = this.zzawo().zzjaj.get();
        long l2 = this.zzwh().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcfz.zziyq.get()) {
            this.zzawo().zzjaj.set(l2);
            zzcfl zzcfl2 = this;
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (zzcfl2.zzayc()) {
                SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcfl2.zzwh().currentTimeMillis()), String.valueOf(zzcfk.zzaxq())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcfl2.zzawn().zzayy().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcko[] zzckoArray) {
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)zzckoArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcfl zzcfl2 = this;
            zzcfl2.zzwu();
            zzcfl2.zzut();
            zzbq.zzgi((String)string2);
            Object object = zzcfl2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzckoArray;
            int n2 = zzckoArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzckp zzckp2;
                int n3;
                int n4;
                zzcko zzcko2 = object2[n];
                object = zzcko2;
                string2 = string;
                zzcfl2 = this;
                zzcfl2.zzwu();
                zzcfl2.zzut();
                zzbq.zzgi((String)string2);
                zzbq.checkNotNull((Object)object);
                zzbq.checkNotNull((Object)object.zzjhj);
                zzbq.checkNotNull((Object)object.zzjhi);
                if (object.zzjhh == null) {
                    zzcfl2.zzawn().zzayu().zzj("Audience with no ID. appId", zzcgj.zzjf(string2));
                    continue;
                }
                int n5 = object.zzjhh;
                zzfhm[] zzfhmArray = object.zzjhj;
                int n6 = object.zzjhj.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzfhmArray[n4].zzjhl != null) continue;
                    zzcfl2.zzawn().zzayu().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcgj.zzjf(string2), object.zzjhh);
                    continue block3;
                }
                zzfhmArray = object.zzjhi;
                n6 = object.zzjhi.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzfhmArray[n4].zzjhl != null) continue;
                    zzcfl2.zzawn().zzayu().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcgj.zzjf(string2), object.zzjhh);
                    continue block3;
                }
                boolean bl = true;
                zzfhm[] zzfhmArray2 = object.zzjhj;
                n4 = object.zzjhj.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzckp2 = zzfhmArray2[n3];
                    if (zzcfl2.zza(string2, n5, zzckp2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzfhmArray2 = object.zzjhi;
                    n4 = object.zzjhi.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzckp2 = zzfhmArray2[n3];
                        if (zzcfl2.zza(string2, n5, (zzcks)((Object)zzckp2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcfl zzcfl3 = zzcfl2;
                zzcfl3.zzwu();
                zzcfl3.zzut();
                zzbq.zzgi((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcfl3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcko[] zzckoArray2 = zzckoArray;
            n = zzckoArray.length;
            for (int i = 0; i < n; ++i) {
                zzcko zzcko3 = zzckoArray2[i];
                object2.add(zzcko3.zzjhh);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzckp zzckp2) {
        byte[] byArray;
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)((Object)zzckp2));
        if (TextUtils.isEmpty((CharSequence)zzckp2.zzjhm)) {
            this.zzawn().zzayu().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcgj.zzjf(string), n, String.valueOf(zzckp2.zzjhl));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzckp2.zzhl()];
            zzfhk zzfhk2 = zzfhk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzckp2.zza(zzfhk2);
            zzfhk2.zzcut();
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Configuration loss. Failed to serialize event filter. appId", zzcgj.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzckp2.zzjhl);
        contentValues.put("event_name", zzckp2.zzjhm);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert event filter (got -1). appId", zzcgj.zzjf(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing event filter. appId", zzcgj.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcks zzcks2) {
        byte[] byArray;
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)((Object)zzcks2));
        if (TextUtils.isEmpty((CharSequence)zzcks2.zzjib)) {
            this.zzawn().zzayu().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcgj.zzjf(string), n, String.valueOf(zzcks2.zzjhl));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcks2.zzhl()];
            zzfhk zzfhk2 = zzfhk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcks2.zza(zzfhk2);
            zzfhk2.zzcut();
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Configuration loss. Failed to serialize property filter. appId", zzcgj.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcks2.zzjhl);
        contentValues.put("property_name", zzcks2.zzjib);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert property filter (got -1). appId", zzcgj.zzjf(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing property filter. appId", zzcgj.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzckp>> zzaj(String string, String string2) {
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzckp>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzfhj zzfhj2 = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzckp zzckp2 = new zzckp();
                try {
                    zzckp2.zza(zzfhj2);
                }
                catch (IOException iOException) {
                    this.zzawn().zzays().zze("Failed to merge filter. appId", zzcgj.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzckp> arrayList = (ArrayList<zzckp>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzckp>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzckp2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcks>> zzak(String string, String string2) {
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcks>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzfhj zzfhj2 = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzcks zzcks2 = new zzcks();
                try {
                    zzcks2.zza(zzfhj2);
                }
                catch (IOException iOException) {
                    this.zzawn().zzays().zze("Failed to merge filter", zzcgj.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcks> arrayList = (ArrayList<zzcks>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcks>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcks2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbq.zzgi((String)string);
        this.zzwu();
        this.zzut();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Database error querying filters. appId", zzcgj.zzjf(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzawp().zzb(string2, zzcfz.zziyx);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzclc> zziz(String string) {
        this.zzwu();
        this.zzut();
        zzbq.zzgi((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzfhj zzfhj2 = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzclc zzclc2 = new zzclc();
                try {
                    zzclc2.zza(zzfhj2);
                }
                catch (IOException iOException) {
                    this.zzawn().zzays().zzd("Failed to merge filter results. appId, audienceId, error", zzcgj.zzjf(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzclc2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzawn().zzays().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzawn().zzays().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzawn().zzays().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzaxx() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzal(String string, String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        this.zzut();
        this.zzwu();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzawn().zzays().zze("Failed to insert column (got -1). appId", zzcgj.zzjf(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzawn().zzays().zze("Failed to update column (got 0). appId", zzcgj.zzjf(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zzd("Error inserting column. appId", zzcgj.zzjf(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzaxy() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzclb zzclb2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzclb2));
        zzbq.zzgi((String)zzclb2.zzch);
        try {
            byArray = new byte[zzclb2.zzhl()];
            object = byArray;
            zzfhk zzfhk2 = zzfhk.zzo((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzclb2.zza(zzfhk2);
            zzfhk2.zzcut();
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Data loss. Failed to serialize event metadata. appId", zzcgj.zzjf(zzclb2.zzch), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzawj();
        zzbq.checkNotNull((Object)byArray2);
        ((zzcih)object).zzut();
        MessageDigest messageDigest = zzckn.zzed("MD5");
        if (messageDigest == null) {
            ((zzcih)object).zzawn().zzays().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzckn.zzr(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzclb2.zzch);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing raw event metadata. appId", zzcgj.zzjf(zzclb2.zzch), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzaxz() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzaya() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzag(List<Long> list) {
        zzbq.checkNotNull(list);
        this.zzut();
        this.zzwu();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzawn().zzays().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzja(String string) {
        zzbq.zzgi((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzaz(long l) {
        this.zzut();
        this.zzwu();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzawn().zzayy().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzayb() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcfs zzcfs2, long l, boolean bl) {
        Object object;
        zzckz zzckz2;
        String string2;
        this.zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)zzcfs2);
        zzbq.zzgi((String)zzcfs2.mAppId);
        zzcky zzcky2 = new zzcky();
        new zzcky().zzjiy = zzcfs2.zziwx;
        zzcky2.zzjiw = new zzckz[zzcfs2.zziwy.size()];
        int n = 0;
        for (String string2 : zzcfs2.zziwy) {
            zzckz2 = new zzckz();
            zzcky2.zzjiw[n++] = zzckz2;
            zzckz2.name = string2;
            Object object2 = zzcfs2.zziwy.get(string2);
            this.zzawj().zza(zzckz2, object2);
        }
        try {
            byte[] byArray = new byte[zzcky2.zzhl()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzckz2 = zzfhk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcky2.zza((zzfhk)zzckz2);
            zzckz2.zzcut();
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Data loss. Failed to serialize event params/data. appId", zzcgj.zzjf(zzcfs2.mAppId), iOException);
            return false;
        }
        this.zzawn().zzayy().zze("Saving event, name, data size", this.zzawi().zzjc(zzcfs2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcfs2.mAppId);
        string2.put("name", zzcfs2.mName);
        string2.put("timestamp", Long.valueOf(zzcfs2.zzfgb));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzawn().zzays().zzj("Failed to insert raw event (got -1). appId", zzcgj.zzjf(zzcfs2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawn().zzays().zze("Error storing raw event. appId", zzcgj.zzjf(zzcfs2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzayc() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzcgj zzcgj2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcgj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcgj zzcgj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String[] stringArray) throws SQLiteException {
        if (zzcgj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcfl.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (set.remove(stringArray[i])) continue;
                sQLiteDatabase.execSQL(stringArray[i + 1]);
            }
        }
        if (!set.isEmpty()) {
            zzcgj2.zzayu().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcgj zzcgj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzcgj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcfl.zza(zzcgj2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcfl.zza(zzcgj2, sQLiteDatabase, string, string3, stringArray);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcgj2.zzays().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcgj zzcgj2, SQLiteDatabase sQLiteDatabase) {
        if (zzcgj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcgj2.zzayu().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcgj2.zzayu().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcgj2.zzayu().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcgj2.zzayu().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzckh zza(zzcfl zzcfl2) {
        return zzcfl2.zziwl;
    }

    static /* synthetic */ String[] zzayd() {
        return zziwe;
    }

    static /* synthetic */ String[] zzaye() {
        return zziwf;
    }

    static /* synthetic */ String[] zzayf() {
        return zziwg;
    }

    static /* synthetic */ String[] zzayg() {
        return zziwi;
    }

    static /* synthetic */ String[] zzayh() {
        return zziwh;
    }

    static /* synthetic */ String[] zzayi() {
        return zziwj;
    }
}

