/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.internal.zzbga;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcge
extends zzcii {
    private String mAppId;
    private String zzdoc;
    private int zziyz;
    private String zziur;
    private String zzdob;
    private long zziza;
    private long zziuv;
    private int zzizb;
    private String zzcvg;

    zzcge(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxo() {
        return true;
    }

    @Override
    protected final void zzayn() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcih)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcih)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcih)this).zzawn().zzays().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcgj.zzjf(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcih)this).zzawn().zzays().zzj("Error retrieving app installer package name. appId", zzcgj.zzjf(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcih)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcih)this).zzawn().zzays().zze("Error retrieving package info. appId, appName", zzcgj.zzjf(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zziur = string;
        this.zzdoc = string2;
        this.zziyz = n;
        this.zzdob = string3;
        this.zziza = 0L;
        packageInfo = zzcc.zzci((Context)((zzcih)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcge zzcge2 = this;
            if (packageInfo2 == null) {
                ((zzcih)zzcge2).zzawn().zzays().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcih)zzcge2).zzawn().zzays().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcih)this).zzawp().zzit("firebase_analytics_collection_enabled");
            if (((zzcih)this).zzawp().zzaxp()) {
                ((zzcih)this).zzawn().zzayw().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcih)this).zzawn().zzayw().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcc.zzaix()) {
                ((zzcih)this).zzawn().zzayw().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcih)this).zzawn().zzayy().log("Collection enabled");
            }
        }
        this.zzcvg = "";
        this.zziuv = 0L;
        try {
            object = zzcc.zzaiw();
            Object object2 = this.zzcvg = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcih)this).zzawn().zzayy().zze("App package, google app id", this.mAppId, this.zzcvg);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcih)this).zzawn().zzays().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcgj.zzjf(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzizb = zzbga.zzcw((Context)((zzcih)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzizb = 0;
    }

    @WorkerThread
    final zzcff zzjb(String string) {
        ((zzcih)this).zzut();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcge zzcge2 = this;
        zzcge2.zzwu();
        String string4 = zzcge2.zzdoc;
        long l = this.zzayp();
        zzcge2 = this;
        zzcge2.zzwu();
        String string5 = zzcge2.zziur;
        zzcge2 = this;
        zzcge2.zzwu();
        ((zzcih)zzcge2).zzut();
        if (zzcge2.zziza == 0L) {
            zzcge2.zziza = zzcge2.zzitu.zzawj().zzaf(((zzcih)zzcge2).getContext(), ((zzcih)zzcge2).getContext().getPackageName());
        }
        long l2 = zzcge2.zziza;
        boolean bl = this.zzitu.isEnabled();
        boolean bl2 = !((zzcih)this).zzawo().zzjay;
        String string6 = this.zzaws();
        this.zzwu();
        Boolean bl3 = ((zzcih)this).zzawp().zzit("google_analytics_adid_collection_enabled");
        return new zzcff(string2, string3, string4, l, string5, 11717L, l2, string, bl, bl2, string6, 0L, this.zzitu.zzazu(), this.zzayq(), bl3 == null || bl3 != false);
    }

    @WorkerThread
    final String zzayo() {
        byte[] byArray = new byte[16];
        ((zzcih)this).zzawj().zzbao().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzaws() {
        ((zzcih)this).zzut();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcih)this).zzawn().zzayu().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwu();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwu();
        return this.zzcvg;
    }

    final int zzayp() {
        this.zzwu();
        return this.zziyz;
    }

    final int zzayq() {
        this.zzwu();
        return this.zzizb;
    }
}

