/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcgy;
import com.google.android.gms.internal.zzcgz;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzckn;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcgu
extends zzcii {
    static final Pair<String, Long> zzjae = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdvp;
    public final zzcgy zzjaf = new zzcgy(this, "health_monitor", Math.max(0L, zzcfz.zzixu.get()), null);
    public final zzcgx zzjag = new zzcgx(this, "last_upload", 0L);
    public final zzcgx zzjah = new zzcgx(this, "last_upload_attempt", 0L);
    public final zzcgx zzjai = new zzcgx(this, "backoff", 0L);
    public final zzcgx zzjaj = new zzcgx(this, "last_delete_stale", 0L);
    public final zzcgx zzjak;
    public final zzcgx zzjal;
    public final zzcgz zzjam;
    private String zzjan;
    private boolean zzjao;
    private long zzjap;
    private String zzjaq;
    private long zzjar;
    private final Object zzjas;
    public final zzcgx zzjat = new zzcgx(this, "time_before_start", 10000L);
    public final zzcgx zzjau = new zzcgx(this, "session_timeout", 1800000L);
    public final zzcgw zzjav = new zzcgw(this, "start_new_session", true);
    public final zzcgx zzjaw = new zzcgx(this, "last_pause_time", 0L);
    public final zzcgx zzjax = new zzcgx(this, "time_active", 0L);
    public boolean zzjay;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjh(String string) {
        this.zzut();
        long l = this.zzwh().elapsedRealtime();
        if (this.zzjan != null && l < this.zzjap) {
            return new Pair((Object)this.zzjan, (Object)this.zzjao);
        }
        String string2 = string;
        this.zzjap = l + this.zzawp().zza(string2, zzcfz.zzixt);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzjan = info.getId();
                this.zzjao = info.isLimitAdTrackingEnabled();
            }
            if (this.zzjan == null) {
                this.zzjan = "";
            }
        }
        catch (Throwable throwable) {
            this.zzawn().zzayx().zzj("Unable to get advertising id", throwable);
            this.zzjan = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzjan, (Object)this.zzjao);
    }

    @WorkerThread
    final String zzji(String string) {
        this.zzut();
        String string2 = (String)this.zzjh((String)string).first;
        MessageDigest messageDigest = zzckn.zzed("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcgu(zzchj zzchj2) {
        super(zzchj2);
        this.zzjak = new zzcgx(this, "midnight_offset", 0L);
        this.zzjal = new zzcgx(this, "first_open_time", 0L);
        this.zzjam = new zzcgz(this, "app_instance_id", null);
        this.zzjas = new Object();
    }

    @Override
    protected final boolean zzaxo() {
        return true;
    }

    @Override
    protected final void zzayn() {
        this.zzdvp = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzjay = this.zzdvp.getBoolean("has_been_opened", false);
        if (!this.zzjay) {
            SharedPreferences.Editor editor = this.zzdvp.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzaza() {
        this.zzut();
        this.zzwu();
        return this.zzdvp;
    }

    @WorkerThread
    final void zzjj(String string) {
        this.zzut();
        SharedPreferences.Editor editor = this.zzaza().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzazb() {
        this.zzut();
        return this.zzaza().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjk(String string) {
        Object object = this.zzjas;
        synchronized (object) {
            this.zzjaq = string;
            this.zzjar = this.zzwh().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzazc() {
        Object object = this.zzjas;
        synchronized (object) {
            if (Math.abs(this.zzwh().elapsedRealtime() - this.zzjar) < 1000L) {
                return this.zzjaq;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzazd() {
        this.zzut();
        if (!this.zzaza().contains("use_service")) {
            return null;
        }
        return this.zzaza().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbl(boolean bl) {
        this.zzut();
        this.zzawn().zzayy().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzaza().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzaze() {
        this.zzut();
        this.zzawn().zzayy().log("Clearing collection preferences.");
        boolean bl = this.zzaza().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbm(true);
        }
        SharedPreferences.Editor editor = this.zzaza().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzut();
        this.zzawn().zzayy().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzaza().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbm(boolean bl) {
        this.zzut();
        return this.zzaza().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzazf() {
        this.zzut();
        String string = this.zzaza().getString("previous_os_version", null);
        this.zzawd().zzwu();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzaza().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcgu zzcgu2) {
        return zzcgu2.zzaza();
    }
}

