/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchp;
import com.google.android.gms.internal.zzchq;
import com.google.android.gms.internal.zzchr;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzcht;
import com.google.android.gms.internal.zzchu;
import com.google.android.gms.internal.zzchv;
import com.google.android.gms.internal.zzchw;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcib;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcig;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcho
extends zzcgc {
    private final zzchj zzitu;
    private Boolean zzjea;
    @Nullable
    private String zzjeb;

    public zzcho(zzchj zzchj2) {
        this(zzchj2, null);
    }

    private zzcho(zzchj zzchj2, @Nullable String string) {
        zzbq.checkNotNull((Object)zzchj2);
        this.zzitu = zzchj2;
        this.zzjeb = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        this.zzitu.zzawm().zzg(new zzchp(this, zzcff2));
    }

    @Override
    @BinderThread
    public final void zza(zzcfx zzcfx2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        this.zzb(zzcff2, false);
        this.zzitu.zzawm().zzg(new zzchz(this, zzcfx2, zzcff2));
    }

    @Override
    @BinderThread
    public final void zza(zzcfx zzcfx2, String string, String string2) {
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        zzbq.zzgi((String)string);
        this.zzf(string, true);
        this.zzitu.zzawm().zzg(new zzcia(this, zzcfx2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcfx zzcfx2, String string) {
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        this.zzf(string, true);
        this.zzitu.zzawn().zzayx().zzj("Log and bundle. event", this.zzitu.zzawi().zzjc(zzcfx2.name));
        long l = this.zzitu.zzwh().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzitu.zzawm().zzd(new zzcib(this, zzcfx2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzitu.zzawn().zzays().zzj("Log and bundle returned null. appId", zzcgj.zzjf(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzitu.zzwh().nanoTime() / 1000000L;
            this.zzitu.zzawn().zzayx().zzd("Log and bundle processed. event, size, time_ms", this.zzitu.zzawi().zzjc(zzcfx2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zzd("Failed to log and bundle. appId, event, error", zzcgj.zzjf(string), this.zzitu.zzawi().zzjc(zzcfx2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzckk zzckk2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzckk2));
        this.zzb(zzcff2, false);
        if (zzckk2.getValue() == null) {
            this.zzitu.zzawm().zzg(new zzcic(this, zzckk2, zzcff2));
            return;
        }
        this.zzitu.zzawm().zzg(new zzcid(this, zzckk2, zzcff2));
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(zzcff zzcff2, boolean bl) {
        this.zzb(zzcff2, false);
        Future<List<zzckm>> future = this.zzitu.zzawm().zzc(new zzcie(this, zzcff2));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkd(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zze("Failed to get user attributes. appId", zzcgj.zzjf(zzcff2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        zzcif zzcif2 = new zzcif(this, zzcff2);
        if (this.zzitu.zzawm().zzazh()) {
            zzcif2.run();
            return;
        }
        this.zzitu.zzawm().zzg(zzcif2);
    }

    @BinderThread
    private final void zzb(zzcff zzcff2, boolean bl) {
        zzbq.checkNotNull((Object)((Object)zzcff2));
        this.zzf(zzcff2.packageName, false);
        this.zzitu.zzawj().zzkb(zzcff2.zzivh);
    }

    @BinderThread
    private final void zzf(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzitu.zzawn().zzays().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcho zzcho2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcho2 = this;
                    if (!bl2) break block9;
                    if (zzcho2.zzjea == null) {
                        zzcho2.zzjea = "com.google.android.gms".equals(zzcho2.zzjeb) || zzx.zzf((Context)zzcho2.zzitu.getContext(), (int)Binder.getCallingUid()) || zzp.zzcg((Context)zzcho2.zzitu.getContext()).zzbr(Binder.getCallingUid());
                    }
                    if (zzcho2.zzjea.booleanValue()) break block10;
                }
                if (zzcho2.zzjeb == null && zzo.zzb((Context)zzcho2.zzitu.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcho2.zzjeb = string2;
                }
                if (!string2.equals(zzcho2.zzjeb)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzitu.zzawn().zzays().zzj("Measurement Service called with invalid calling package. appId", zzcgj.zzjf(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzitu.zzawm().zzg(new zzcig(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        return this.zzitu.zzjs(zzcff2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivv));
        this.zzb(zzcff2, false);
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        new zzcfi(zzcfi2).packageName = zzcff2.packageName;
        if (zzcfi2.zzivv.getValue() == null) {
            this.zzitu.zzawm().zzg(new zzchq(this, zzcfi3, zzcff2));
            return;
        }
        this.zzitu.zzawm().zzg(new zzchr(this, zzcfi3, zzcff2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcfi zzcfi2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivv));
        this.zzf(zzcfi2.packageName, true);
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        if (zzcfi2.zzivv.getValue() == null) {
            this.zzitu.zzawm().zzg(new zzchs(this, zzcfi3));
            return;
        }
        this.zzitu.zzawm().zzg(new zzcht(this, zzcfi3));
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(String string, String string2, boolean bl, zzcff zzcff2) {
        this.zzb(zzcff2, false);
        Future<List<zzckm>> future = this.zzitu.zzawm().zzc(new zzchu(this, zzcff2, string, string2));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkd(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zze("Failed to get user attributes. appId", zzcgj.zzjf(zzcff2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(String string, String string2, String string3, boolean bl) {
        this.zzf(string, true);
        Future<List<zzckm>> future = this.zzitu.zzawm().zzc(new zzchv(this, string, string2, string3));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkd(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zze("Failed to get user attributes. appId", zzcgj.zzjf(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfi> zza(String string, String string2, zzcff zzcff2) {
        this.zzb(zzcff2, false);
        Future<List<zzcfi>> future = this.zzitu.zzawm().zzc(new zzchw(this, zzcff2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfi> zzj(String string, String string2, String string3) {
        this.zzf(string, true);
        Future<List<zzcfi>> future = this.zzitu.zzawm().zzc(new zzchx(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitu.zzawn().zzays().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzcff zzcff2) {
        this.zzf(zzcff2.packageName, false);
        this.zzitu.zzawm().zzg(new zzchy(this, zzcff2));
    }

    static /* synthetic */ zzchj zza(zzcho zzcho2) {
        return zzcho2.zzitu;
    }
}

