/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzciz
extends zzcii {
    protected zzcjc zzjfc;
    private volatile AppMeasurement.zzb zzjfd;
    private AppMeasurement.zzb zzjfe;
    private long zzjff;
    private final Map<Activity, zzcjc> zzjfg = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzjfh = new CopyOnWriteArrayList();
    private boolean zzjfi;
    private AppMeasurement.zzb zzjfj;
    private String zzjfk;

    public zzciz(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxo() {
        return false;
    }

    @WorkerThread
    public final zzcjc zzbad() {
        this.zzwu();
        ((zzcih)this).zzut();
        return this.zzjfc;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcih)this).zzawn().zzayu().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcih)this).zzawm();
        if (!zzche.zzas()) {
            ((zzcih)this).zzawn().zzayu().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzjfi) {
            ((zzcih)this).zzawn().zzayu().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzjfd == null) {
            ((zzcih)this).zzawn().zzayu().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzjfg.get(activity) == null) {
            ((zzcih)this).zzawn().zzayu().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzciz.zzjt(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzjfd.zziua.equals(string2);
        boolean bl2 = zzckn.zzas(this.zzjfd.zzitz, string);
        if (bl && bl2) {
            ((zzcih)this).zzawn().zzayv().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzcih)this).zzawn().zzayu().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzcih)this).zzawn().zzayu().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcih)this).zzawn().zzayy().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcjc zzcjc2 = new zzcjc(string, string2, ((zzcih)this).zzawj().zzban());
        this.zzjfg.put(activity, zzcjc2);
        this.zza(activity, zzcjc2, true);
    }

    public final AppMeasurement.zzb zzbae() {
        AppMeasurement.zzb zzb2 = this.zzjfd;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzcih)this).zzawn().zzayu().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzjfh.remove(zza2);
        this.zzjfh.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        this.zzjfh.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcjc zzcjc2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzjfd != null) {
            zzb2 = this.zzjfd;
        } else if (this.zzjfe != null && Math.abs(((zzcih)this).zzwh().elapsedRealtime() - this.zzjff) < 1000L) {
            zzb2 = this.zzjfe;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzjfi = true;
        try {
            object2 = this.zzjfh.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcjc2);
                }
                catch (Exception exception) {
                    ((zzcih)this).zzawn().zzays().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcih)this).zzawn().zzays().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzjfi = false;
        }
        Object object3 = object2 = this.zzjfd == null ? this.zzjfe : this.zzjfd;
        if (bl2) {
            if (zzcjc2.zziua == null) {
                zzcjc2.zziua = zzciz.zzjt(activity.getClass().getCanonicalName());
            }
            object = new zzcjc(zzcjc2);
            this.zzjfe = this.zzjfd;
            this.zzjff = ((zzcih)this).zzwh().elapsedRealtime();
            this.zzjfd = object;
            ((zzcih)this).zzawm().zzg(new zzcja(this, bl, (AppMeasurement.zzb)object2, (zzcjc)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcjc zzcjc2) {
        ((zzcih)this).zzavz().zzai(((zzcih)this).zzwh().elapsedRealtime());
        if (((zzcih)this).zzawl().zzbr(zzcjc2.zzjfq)) {
            zzcjc2.zzjfq = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzitz != null) {
                bundle.putString("_sn", zzb2.zzitz);
            }
            bundle.putString("_sc", zzb2.zziua);
            bundle.putLong("_si", zzb2.zziub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcih)this).zzut();
        zzciz zzciz2 = this;
        synchronized (zzciz2) {
            if (this.zzjfk == null || this.zzjfk.equals(string) || zzb2 != null) {
                this.zzjfk = string;
                this.zzjfj = zzb2;
            }
            return;
        }
    }

    private static String zzjt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcjc zzq(@NonNull Activity activity) {
        zzbq.checkNotNull((Object)activity);
        zzcjc zzcjc2 = this.zzjfg.get(activity);
        if (zzcjc2 == null) {
            String string = zzciz.zzjt(activity.getClass().getCanonicalName());
            zzcjc2 = new zzcjc(null, string, ((zzcih)this).zzawj().zzban());
            this.zzjfg.put(activity, zzcjc2);
        }
        return zzcjc2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcjc zzcjc2 = this.zzq(activity);
        this.zza(activity, zzcjc2, false);
        zzcfa zzcfa2 = ((zzcih)this).zzavz();
        long l = ((zzcih)zzcfa2).zzwh().elapsedRealtime();
        ((zzcih)zzcfa2).zzawm().zzg(new zzcfd(zzcfa2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcjc zzcjc2 = this.zzq(activity);
        this.zzjfe = this.zzjfd;
        this.zzjff = ((zzcih)this).zzwh().elapsedRealtime();
        this.zzjfd = null;
        ((zzcih)this).zzawm().zzg(new zzcjb(this, zzcjc2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcjc zzcjc2 = this.zzjfg.get(activity);
        if (zzcjc2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcjc2.zziub);
        bundle2.putString("name", zzcjc2.zzitz);
        bundle2.putString("referrer_name", zzcjc2.zziua);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzjfg.remove(activity);
    }

    static /* synthetic */ void zza(zzciz zzciz2, zzcjc zzcjc2) {
        zzciz2.zza(zzcjc2);
    }
}

