/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcjt;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;

public final class zzcjr
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzjgf;
    private volatile zzcgi zzjgg;
    final /* synthetic */ zzcjd zzjfy;

    protected zzcjr(zzcjd zzcjd2) {
        this.zzjfy = zzcjd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzn(Intent intent) {
        ((zzcih)this.zzjfy).zzut();
        Context context = ((zzcih)this.zzjfy).getContext();
        zza zza2 = zza.zzalr();
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            if (this.zzjgf) {
                ((zzcih)this.zzjfy).zzawn().zzayy().log("Connection attempt already in progress");
                return;
            }
            ((zzcih)this.zzjfy).zzawn().zzayy().log("Using local app measurement service");
            this.zzjgf = true;
            zza2.zza(context, intent, (ServiceConnection)zzcjd.zza(this.zzjfy), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbq.zzga((String)"MeasurementServiceConnection.onServiceConnected");
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzjgf = false;
                ((zzcih)this.zzjfy).zzawn().zzays().log("Service connected with null binder");
                return;
            }
            zzcgb zzcgb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcgb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcgb ? (zzcgb)iInterface : new zzcgd(iBinder2));
                    ((zzcih)this.zzjfy).zzawn().zzayy().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcih)this.zzjfy).zzawn().zzays().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcih)this.zzjfy).zzawn().zzays().log("Service connect failed to get IMeasurementService");
            }
            if (zzcgb2 == null) {
                this.zzjgf = false;
                try {
                    zza.zzalr();
                    zzcjr zzcjr3 = zzcjd.zza(this.zzjfy);
                    iInterface = ((zzcih)this.zzjfy).getContext();
                    iInterface.unbindService((ServiceConnection)zzcjr3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcgb2;
                ((zzcih)this.zzjfy).zzawm().zzg(new zzcjs(this, (zzcgb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbq.zzga((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcih)this.zzjfy).zzawn().zzayx().log("Service disconnected");
        ((zzcih)this.zzjfy).zzawm().zzg(new zzcjt(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzbaj() {
        ((zzcih)this.zzjfy).zzut();
        Context context = ((zzcih)this.zzjfy).getContext();
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            if (this.zzjgf) {
                ((zzcih)this.zzjfy).zzawn().zzayy().log("Connection attempt already in progress");
                return;
            }
            if (this.zzjgg != null) {
                ((zzcih)this.zzjfy).zzawn().zzayy().log("Already awaiting connection attempt");
                return;
            }
            this.zzjgg = new zzcgi(context, Looper.getMainLooper(), this, this);
            ((zzcih)this.zzjfy).zzawn().zzayy().log("Connecting to remote service");
            this.zzjgf = true;
            this.zzjgg.zzajy();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbq.zzga((String)"MeasurementServiceConnection.onConnected");
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            try {
                zzcgb zzcgb2 = (zzcgb)this.zzjgg.zzakc();
                this.zzjgg = null;
                ((zzcih)this.zzjfy).zzawm().zzg(new zzcju(this, zzcgb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzjgg = null;
                this.zzjgf = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbq.zzga((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcih)this.zzjfy).zzawn().zzayx().log("Service connection suspended");
        ((zzcih)this.zzjfy).zzawm().zzg(new zzcjv(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zzga((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcgj zzcgj2 = this.zzjfy.zzitu.zzazm();
        if (zzcgj2 != null) {
            zzcgj2.zzayu().zzj("Service connection failed", connectionResult);
        }
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            this.zzjgf = false;
            this.zzjgg = null;
        }
        ((zzcih)this.zzjfy).zzawm().zzg(new zzcjw(this));
    }

    static /* synthetic */ boolean zza(zzcjr zzcjr2, boolean bl) {
        zzcjr2.zzjgf = false;
        return false;
    }
}

