/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcfp;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzckj;

public final class zzcki
extends zzcii {
    private final AlarmManager zzdsw = (AlarmManager)((zzcih)this).getContext().getSystemService("alarm");
    private final zzcfp zzjgv;
    private Integer zzdsx;

    protected zzcki(zzchj zzchj2) {
        super(zzchj2);
        this.zzjgv = new zzckj(this, zzchj2);
    }

    @Override
    protected final boolean zzaxo() {
        this.zzdsw.cancel(this.zzyu());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbam();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzbam() {
        JobScheduler jobScheduler = (JobScheduler)((zzcih)this).getContext().getSystemService("jobscheduler");
        ((zzcih)this).zzawn().zzayy().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzr(long l) {
        this.zzwu();
        if (!zzcha.zzbi(((zzcih)this).getContext())) {
            ((zzcih)this).zzawn().zzayx().log("Receiver not registered/enabled");
        }
        if (!zzcjx.zzk(((zzcih)this).getContext(), false)) {
            ((zzcih)this).zzawn().zzayx().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzcih)this).zzwh().elapsedRealtime() + l;
        if (l < Math.max(0L, zzcfz.zziyp.get()) && !this.zzjgv.zzdr()) {
            ((zzcih)this).zzawn().zzayy().log("Scheduling upload with DelayedRunnable");
            this.zzjgv.zzr(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzcih)this).zzawn().zzayy().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcki zzcki2 = this;
            ComponentName componentName = new ComponentName(((zzcih)zzcki2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzcih)zzcki2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcki2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzcih)zzcki2).zzawn().zzayy().zzj("Scheduling job. JobID", zzcki2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzcih)this).zzawn().zzayy().log("Scheduling upload with AlarmManager");
        this.zzdsw.setInexactRepeating(2, l2, Math.max(zzcfz.zziyk.get(), l), this.zzyu());
    }

    private final int getJobId() {
        if (this.zzdsx == null) {
            String string = String.valueOf(((zzcih)this).getContext().getPackageName());
            this.zzdsx = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzdsx;
    }

    public final void cancel() {
        this.zzwu();
        this.zzdsw.cancel(this.zzyu());
        this.zzjgv.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbam();
        }
    }

    private final PendingIntent zzyu() {
        Intent intent = new Intent().setClassName(((zzcih)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzcih)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

