/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcfa
extends zzcih {
    private final Map<String, Long> zzitw;
    private final Map<String, Integer> zzitx = new ArrayMap();
    private long zzity;

    public zzcfa(zzchj zzchj2) {
        super(zzchj2);
        this.zzitw = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcih)this).zzawm().zzayr().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcih)this).zzwh().elapsedRealtime();
        ((zzcih)this).zzawl().zzg(new zzcfb(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        Integer n;
        ((zzcih)this).zzut();
        zzbq.zzgh((String)string);
        if (this.zzitx.isEmpty()) {
            this.zzity = l;
        }
        if ((n = this.zzitx.get(string)) != null) {
            this.zzitx.put(string, n + 1);
            return;
        }
        if (this.zzitx.size() >= 100) {
            ((zzcih)this).zzawm().zzayt().log("Too many ads visible");
            return;
        }
        this.zzitx.put(string, 1);
        this.zzitw.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcih)this).zzawm().zzayr().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcih)this).zzwh().elapsedRealtime();
        ((zzcih)this).zzawl().zzg(new zzcfc(this, string, l));
    }

    @WorkerThread
    private final void zzf(String string, long l) {
        ((zzcih)this).zzut();
        zzbq.zzgh((String)string);
        Integer n = this.zzitx.get(string);
        if (n != null) {
            zzcjc zzcjc2 = ((zzcih)this).zzawe().zzbac();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzitx.remove(string);
                Long l2 = this.zzitw.get(string);
                if (l2 == null) {
                    ((zzcih)this).zzawm().zzayr().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzitw.remove(string);
                    this.zza(string, l3, zzcjc2);
                }
                if (this.zzitx.isEmpty()) {
                    if (this.zzity == 0L) {
                        ((zzcih)this).zzawm().zzayr().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzity, zzcjc2);
                    this.zzity = 0L;
                }
                return;
            }
            this.zzitx.put(string, n2);
            return;
        }
        ((zzcih)this).zzawm().zzayr().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcih)this).zzawm().zzayx().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcih)this).zzawm().zzayx().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzciz.zza(zzb2, bundle);
        ((zzcih)this).zzawa().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcih)this).zzawm().zzayx().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcih)this).zzawm().zzayx().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzciz.zza(zzb2, bundle);
        ((zzcih)this).zzawa().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzai(long l) {
        zzcjc zzcjc2 = ((zzcih)this).zzawe().zzbac();
        for (String string : this.zzitw.keySet()) {
            long l2 = this.zzitw.get(string);
            this.zza(string, l - l2, zzcjc2);
        }
        if (!this.zzitw.isEmpty()) {
            this.zza(l - this.zzity, zzcjc2);
        }
        this.zzaj(l);
    }

    @WorkerThread
    private final void zzaj(long l) {
        for (String string : this.zzitw.keySet()) {
            this.zzitw.put(string, l);
        }
        if (!this.zzitw.isEmpty()) {
            this.zzity = l;
        }
    }

    static /* synthetic */ void zza(zzcfa zzcfa2, String string, long l) {
        zzcfa2.zze(string, l);
    }

    static /* synthetic */ void zzb(zzcfa zzcfa2, String string, long l) {
        zzcfa2.zzf(string, l);
    }

    static /* synthetic */ void zza(zzcfa zzcfa2, long l) {
        zzcfa2.zzaj(l);
    }
}

