/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.internal.zzbga;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcge
extends zzcii {
    private String mAppId;
    private String zzdoc;
    private int zziyp;
    private String zziuh;
    private String zzdob;
    private long zziyq;
    private long zziul;
    private int zziyr;
    private String zzcvg;

    zzcge(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxn() {
        return true;
    }

    @Override
    protected final void zzaym() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcih)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcih)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcih)this).zzawm().zzayr().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcgj.zzje(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcih)this).zzawm().zzayr().zzj("Error retrieving app installer package name. appId", zzcgj.zzje(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcih)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcih)this).zzawm().zzayr().zze("Error retrieving package info. appId, appName", zzcgj.zzje(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zziuh = string;
        this.zzdoc = string2;
        this.zziyp = n;
        this.zzdob = string3;
        this.zziyq = 0L;
        packageInfo = zzcc.zzci((Context)((zzcih)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcge zzcge2 = this;
            if (packageInfo2 == null) {
                ((zzcih)zzcge2).zzawm().zzayr().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcih)zzcge2).zzawm().zzayr().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcih)this).zzawo().zzis("firebase_analytics_collection_enabled");
            if (((zzcih)this).zzawo().zzaxo()) {
                ((zzcih)this).zzawm().zzayv().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcih)this).zzawm().zzayv().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcc.zzaiw()) {
                ((zzcih)this).zzawm().zzayv().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcih)this).zzawm().zzayx().log("Collection enabled");
            }
        }
        this.zzcvg = "";
        this.zziul = 0L;
        try {
            object = zzcc.zzaiv();
            Object object2 = this.zzcvg = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcih)this).zzawm().zzayx().zze("App package, google app id", this.mAppId, this.zzcvg);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcih)this).zzawm().zzayr().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcgj.zzje(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zziyr = zzbga.zzcw((Context)((zzcih)this).getContext()) ? 1 : 0;
            return;
        }
        this.zziyr = 0;
    }

    @WorkerThread
    final zzcff zzja(String string) {
        ((zzcih)this).zzut();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcge zzcge2 = this;
        zzcge2.zzwu();
        String string4 = zzcge2.zzdoc;
        long l = this.zzayo();
        zzcge2 = this;
        zzcge2.zzwu();
        String string5 = zzcge2.zziuh;
        zzcge2 = this;
        zzcge2.zzwu();
        ((zzcih)zzcge2).zzut();
        if (zzcge2.zziyq == 0L) {
            zzcge2.zziyq = zzcge2.zzitk.zzawi().zzaf(((zzcih)zzcge2).getContext(), ((zzcih)zzcge2).getContext().getPackageName());
        }
        long l2 = zzcge2.zziyq;
        boolean bl = this.zzitk.isEnabled();
        boolean bl2 = !((zzcih)this).zzawn().zzjao;
        String string6 = this.zzawr();
        this.zzwu();
        Boolean bl3 = ((zzcih)this).zzawo().zzis("google_analytics_adid_collection_enabled");
        return new zzcff(string2, string3, string4, l, string5, 11720L, l2, string, bl, bl2, string6, 0L, this.zzitk.zzazt(), this.zzayp(), bl3 == null || bl3 != false);
    }

    @WorkerThread
    final String zzayn() {
        byte[] byArray = new byte[16];
        ((zzcih)this).zzawi().zzban().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzawr() {
        ((zzcih)this).zzut();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcih)this).zzawm().zzayt().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwu();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwu();
        return this.zzcvg;
    }

    final int zzayo() {
        this.zzwu();
        return this.zziyp;
    }

    final int zzayp() {
        this.zzwu();
        return this.zziyr;
    }
}

