/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcgy;
import com.google.android.gms.internal.zzcgz;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzckn;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcgu
extends zzcii {
    static final Pair<String, Long> zzizu = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdvp;
    public final zzcgy zzizv = new zzcgy(this, "health_monitor", Math.max(0L, zzcfz.zzixk.get()), null);
    public final zzcgx zzizw = new zzcgx(this, "last_upload", 0L);
    public final zzcgx zzizx = new zzcgx(this, "last_upload_attempt", 0L);
    public final zzcgx zzizy = new zzcgx(this, "backoff", 0L);
    public final zzcgx zzizz = new zzcgx(this, "last_delete_stale", 0L);
    public final zzcgx zzjaa;
    public final zzcgx zzjab;
    public final zzcgz zzjac;
    private String zzjad;
    private boolean zzjae;
    private long zzjaf;
    private String zzjag;
    private long zzjah;
    private final Object zzjai;
    public final zzcgx zzjaj = new zzcgx(this, "time_before_start", 10000L);
    public final zzcgx zzjak = new zzcgx(this, "session_timeout", 1800000L);
    public final zzcgw zzjal = new zzcgw(this, "start_new_session", true);
    public final zzcgx zzjam = new zzcgx(this, "last_pause_time", 0L);
    public final zzcgx zzjan = new zzcgx(this, "time_active", 0L);
    public boolean zzjao;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjg(String string) {
        this.zzut();
        long l = this.zzwh().elapsedRealtime();
        if (this.zzjad != null && l < this.zzjaf) {
            return new Pair((Object)this.zzjad, (Object)this.zzjae);
        }
        String string2 = string;
        this.zzjaf = l + this.zzawo().zza(string2, zzcfz.zzixj);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzjad = info.getId();
                this.zzjae = info.isLimitAdTrackingEnabled();
            }
            if (this.zzjad == null) {
                this.zzjad = "";
            }
        }
        catch (Throwable throwable) {
            this.zzawm().zzayw().zzj("Unable to get advertising id", throwable);
            this.zzjad = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzjad, (Object)this.zzjae);
    }

    @WorkerThread
    final String zzjh(String string) {
        this.zzut();
        String string2 = (String)this.zzjg((String)string).first;
        MessageDigest messageDigest = zzckn.zzed("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcgu(zzchj zzchj2) {
        super(zzchj2);
        this.zzjaa = new zzcgx(this, "midnight_offset", 0L);
        this.zzjab = new zzcgx(this, "first_open_time", 0L);
        this.zzjac = new zzcgz(this, "app_instance_id", null);
        this.zzjai = new Object();
    }

    @Override
    protected final boolean zzaxn() {
        return true;
    }

    @Override
    protected final void zzaym() {
        this.zzdvp = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzjao = this.zzdvp.getBoolean("has_been_opened", false);
        if (!this.zzjao) {
            SharedPreferences.Editor editor = this.zzdvp.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzayz() {
        this.zzut();
        this.zzwu();
        return this.zzdvp;
    }

    @WorkerThread
    final void zzji(String string) {
        this.zzut();
        SharedPreferences.Editor editor = this.zzayz().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzaza() {
        this.zzut();
        return this.zzayz().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjj(String string) {
        Object object = this.zzjai;
        synchronized (object) {
            this.zzjag = string;
            this.zzjah = this.zzwh().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzazb() {
        Object object = this.zzjai;
        synchronized (object) {
            if (Math.abs(this.zzwh().elapsedRealtime() - this.zzjah) < 1000L) {
                return this.zzjag;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzazc() {
        this.zzut();
        if (!this.zzayz().contains("use_service")) {
            return null;
        }
        return this.zzayz().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbl(boolean bl) {
        this.zzut();
        this.zzawm().zzayx().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzayz().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzazd() {
        this.zzut();
        this.zzawm().zzayx().log("Clearing collection preferences.");
        boolean bl = this.zzayz().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbm(true);
        }
        SharedPreferences.Editor editor = this.zzayz().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzut();
        this.zzawm().zzayx().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzayz().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbm(boolean bl) {
        this.zzut();
        return this.zzayz().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzaze() {
        this.zzut();
        String string = this.zzayz().getString("previous_os_version", null);
        this.zzawc().zzwu();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzayz().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcgu zzcgu2) {
        return zzcgu2.zzayz();
    }
}

