/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzchh;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzche
extends zzcii {
    private ExecutorService zzibs;
    private zzchi zzjbk;
    private zzchi zzjbl;
    private final PriorityBlockingQueue<zzchh<?>> zzjbm;
    private final BlockingQueue<zzchh<?>> zzjbn;
    private final Thread.UncaughtExceptionHandler zzjbo;
    private final Thread.UncaughtExceptionHandler zzjbp;
    private final Object zzjbq = new Object();
    private final Semaphore zzjbr = new Semaphore(2);
    private volatile boolean zzjbs;
    private static final AtomicLong zzjbt = new AtomicLong(Long.MIN_VALUE);

    zzche(zzchj zzchj2) {
        super(zzchj2);
        this.zzjbm = new PriorityBlockingQueue();
        this.zzjbn = new LinkedBlockingQueue();
        this.zzjbo = new zzchg(this, "Thread death: Uncaught exception on worker thread");
        this.zzjbp = new zzchg(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzaxn() {
        return false;
    }

    @Override
    public final void zzut() {
        if (Thread.currentThread() != this.zzjbk) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzavx() {
        if (Thread.currentThread() != this.zzjbl) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzas() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzazg() {
        return Thread.currentThread() == this.zzjbk;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull(callable);
        zzchh zzchh2 = new zzchh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjbk) {
            if (!this.zzjbm.isEmpty()) {
                ((zzcih)this).zzawm().zzayt().log("Callable skipped the worker queue.");
            }
            zzchh2.run();
        } else {
            this.zza(zzchh2);
        }
        return zzchh2;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull(callable);
        zzchh zzchh2 = new zzchh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjbk) {
            zzchh2.run();
        } else {
            this.zza(zzchh2);
        }
        return zzchh2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull((Object)runnable);
        this.zza(new zzchh(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzchh<?> zzchh2) {
        Object object = this.zzjbq;
        synchronized (object) {
            this.zzjbm.add(zzchh2);
            if (this.zzjbk == null) {
                this.zzjbk = new zzchi(this, "Measurement Worker", this.zzjbm);
                this.zzjbk.setUncaughtExceptionHandler(this.zzjbo);
                this.zzjbk.start();
            } else {
                this.zzjbk.zzrb();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull((Object)runnable);
        zzchh zzchh2 = new zzchh(this, runnable, false, "Task exception on network thread");
        zzche zzche2 = this;
        Object object = zzche2.zzjbq;
        synchronized (object) {
            zzche2.zzjbn.add(zzchh2);
            if (zzche2.zzjbl == null) {
                zzche2.zzjbl = new zzchi(zzche2, "Measurement Network", zzche2.zzjbn);
                zzche2.zzjbl.setUncaughtExceptionHandler(zzche2.zzjbp);
                zzche2.zzjbl.start();
            } else {
                zzche2.zzjbl.zzrb();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzazh() {
        Object object = this.zzjbq;
        synchronized (object) {
            if (this.zzibs == null) {
                this.zzibs = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzibs;
        }
    }

    static /* synthetic */ Semaphore zza(zzche zzche2) {
        return zzche2.zzjbr;
    }

    static /* synthetic */ boolean zzb(zzche zzche2) {
        return zzche2.zzjbs;
    }

    static /* synthetic */ Object zzc(zzche zzche2) {
        return zzche2.zzjbq;
    }

    static /* synthetic */ zzchi zzd(zzche zzche2) {
        return zzche2.zzjbk;
    }

    static /* synthetic */ zzchi zza(zzche zzche2, zzchi zzchi2) {
        zzche2.zzjbk = null;
        return null;
    }

    static /* synthetic */ zzchi zze(zzche zzche2) {
        return zzche2.zzjbl;
    }

    static /* synthetic */ zzchi zzb(zzche zzche2, zzchi zzchi2) {
        zzche2.zzjbl = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzazi() {
        return zzjbt;
    }
}

