/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzchn;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcij;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzckv;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;
import com.google.android.gms.internal.zzcla;
import com.google.android.gms.internal.zzclb;
import com.google.android.gms.internal.zzcld;
import com.google.android.gms.internal.zzfhb;
import com.google.android.gms.internal.zzfhc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzchj {
    private static volatile zzchj zzjca;
    private final Context mContext;
    private final zzcfk zzjcb;
    private final zzcgu zzjcc;
    private final zzcgj zzjcd;
    private final zzche zzjce;
    private final zzckc zzjcf;
    private final zzchd zzjcg;
    private final AppMeasurement zzjch;
    private final FirebaseAnalytics zzjci;
    private final zzckn zzjcj;
    private final zzcgh zzjck;
    private final zzcfl zzjcl;
    private final zzcgf zzjcm;
    private final zzcgn zzjcn;
    private final zzd zzasd;
    private final zzciz zzjco;
    private final zzcjd zzjcp;
    private final zzcfr zzjcq;
    private final zzcik zzjcr;
    private final zzcge zzjcs;
    private final zzcgs zzjct;
    private final zzcki zzjcu;
    private final zzcfh zzjcv;
    private final zzcfa zzjcw;
    private boolean zzdqd = false;
    private boolean zzjcx;
    private Boolean zzjcy;
    private long zzjcz;
    private FileLock zzjda;
    private FileChannel zzjdb;
    private List<Long> zzjdc;
    private List<Runnable> zzjdd;
    private int zzjde;
    private int zzjdf;
    private long zzjdg;
    private long zzjdh;
    private boolean zzjdi;
    private boolean zzjdj;
    private boolean zzjdk;
    private final long zzjdl;

    private zzchj(zzcij zzcij2) {
        zzcfa zzcfa2;
        zzbq.checkNotNull((Object)zzcij2);
        this.mContext = zzcij2.mContext;
        this.zzjdg = -1L;
        this.zzasd = zzh.zzalu();
        this.zzjdl = this.zzasd.currentTimeMillis();
        Object object = this;
        this.zzjcb = new zzcfk((zzchj)object);
        object = this;
        zzcgu zzcgu2 = new zzcgu((zzchj)object);
        zzcgu2.initialize();
        this.zzjcc = zzcgu2;
        object = this;
        zzcgj zzcgj2 = new zzcgj((zzchj)object);
        zzcgj2.initialize();
        this.zzjcd = zzcgj2;
        object = this;
        zzckn zzckn2 = new zzckn((zzchj)object);
        zzckn2.initialize();
        this.zzjcj = zzckn2;
        object = this;
        zzcgh zzcgh2 = new zzcgh((zzchj)object);
        zzcgh2.initialize();
        this.zzjck = zzcgh2;
        object = this;
        zzcfr zzcfr2 = new zzcfr((zzchj)object);
        zzcfr2.initialize();
        this.zzjcq = zzcfr2;
        object = this;
        zzcge zzcge2 = new zzcge((zzchj)object);
        zzcge2.initialize();
        this.zzjcs = zzcge2;
        object = this;
        zzcfl zzcfl2 = new zzcfl((zzchj)object);
        zzcfl2.initialize();
        this.zzjcl = zzcfl2;
        object = this;
        zzcgf zzcgf2 = new zzcgf((zzchj)object);
        zzcgf2.initialize();
        this.zzjcm = zzcgf2;
        object = this;
        zzcfh zzcfh2 = new zzcfh((zzchj)object);
        zzcfh2.initialize();
        this.zzjcv = zzcfh2;
        object = this;
        this.zzjcw = zzcfa2 = new zzcfa((zzchj)object);
        object = this;
        zzcgn zzcgn2 = new zzcgn((zzchj)object);
        zzcgn2.initialize();
        this.zzjcn = zzcgn2;
        object = this;
        zzciz zzciz2 = new zzciz((zzchj)object);
        zzciz2.initialize();
        this.zzjco = zzciz2;
        object = this;
        zzcjd zzcjd2 = new zzcjd((zzchj)object);
        zzcjd2.initialize();
        this.zzjcp = zzcjd2;
        object = this;
        zzcik zzcik2 = new zzcik((zzchj)object);
        zzcik2.initialize();
        this.zzjcr = zzcik2;
        object = this;
        zzcki zzcki2 = new zzcki((zzchj)object);
        zzcki2.initialize();
        this.zzjcu = zzcki2;
        object = this;
        this.zzjct = new zzcgs((zzchj)object);
        object = this;
        this.zzjch = new AppMeasurement((zzchj)object);
        object = this;
        this.zzjci = new FirebaseAnalytics((zzchj)object);
        object = this;
        zzckc zzckc2 = new zzckc((zzchj)object);
        zzckc2.initialize();
        this.zzjcf = zzckc2;
        object = this;
        zzchd zzchd2 = new zzchd((zzchj)object);
        zzchd2.initialize();
        this.zzjcg = zzchd2;
        object = this;
        zzche zzche2 = new zzche((zzchj)object);
        zzche2.initialize();
        this.zzjce = zzche2;
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzawa();
            if (((zzcih)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcih)object).getContext().getApplicationContext();
                if (((zzcik)object).zzjec == null) {
                    ((zzcik)object).zzjec = new zzciy((zzcik)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcik)object).zzjec);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcik)object).zzjec);
                ((zzcih)object).zzawm().zzayx().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzawm().zzayt().log("Application context is not an Application");
        }
        this.zzjce.zzg(new zzchk(this));
    }

    final void zzwu() {
        if (!this.zzdqd) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzazj() {
        this.zzwu();
        ((zzcih)this.zzawl()).zzut();
        if (this.zzjcy == null || this.zzjcz == 0L || this.zzjcy != null && !this.zzjcy.booleanValue() && Math.abs(this.zzasd.elapsedRealtime() - this.zzjcz) > 1000L) {
            this.zzjcz = this.zzasd.elapsedRealtime();
            this.zzjcy = this.zzawi().zzdu("android.permission.INTERNET") && this.zzawi().zzdu("android.permission.ACCESS_NETWORK_STATE") && (zzbgc.zzcy((Context)this.mContext).zzami() || zzcha.zzbi(this.mContext) && zzcjx.zzk(this.mContext, false));
            if (this.zzjcy.booleanValue()) {
                this.zzjcy = this.zzawi().zzka(this.zzawb().getGmpAppId());
            }
        }
        return this.zzjcy;
    }

    @WorkerThread
    private final void zzazk() {
        String string;
        zzcgl zzcgl2;
        ((zzcih)this.zzawl()).zzut();
        this.zzjcj.zzazk();
        this.zzjcc.zzazk();
        this.zzjcs.zzazk();
        this.zzawm().zzayv().zzj("App measurement is starting up, version", 11720L);
        this.zzawm().zzayv().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = this.zzjcs.getAppId();
        if (this.zzawi().zzkd(string2)) {
            zzcgl2 = this.zzawm().zzayv();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcgl2 = this.zzawm().zzayv();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcgl2.log(string);
        this.zzawm().zzayw().log("Debug-level message logging enabled");
        if (this.zzjde != this.zzjdf) {
            this.zzawm().zzayr().zze("Not all components initialized", this.zzjde, this.zzjdf);
        }
        this.zzdqd = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcih)this.zzawl()).zzut();
        this.zzawg().zzaxv();
        if (this.zzawn().zzizw.get() == 0L) {
            this.zzawn().zzizw.set(this.zzasd.currentTimeMillis());
        }
        if (Long.valueOf(this.zzawn().zzjab.get()) == 0L) {
            this.zzawm().zzayx().zzj("Persisting first open", this.zzjdl);
            this.zzawn().zzjab.set(this.zzjdl);
        }
        if (!this.zzazj()) {
            if (this.isEnabled()) {
                if (!this.zzawi().zzdu("android.permission.INTERNET")) {
                    this.zzawm().zzayr().log("App is missing INTERNET permission");
                }
                if (!this.zzawi().zzdu("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzawm().zzayr().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzbgc.zzcy((Context)this.mContext).zzami()) {
                    if (!zzcha.zzbi(this.mContext)) {
                        this.zzawm().zzayr().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcjx.zzk(this.mContext, false)) {
                        this.zzawm().zzayr().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzawm().zzayr().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzawb().getGmpAppId())) {
                String string = this.zzawn().zzaza();
                if (string == null) {
                    this.zzawn().zzji(this.zzawb().getGmpAppId());
                } else if (!string.equals(this.zzawb().getGmpAppId())) {
                    this.zzawm().zzayv().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzawn().zzazd();
                    this.zzjcp.disconnect();
                    this.zzjcp.zzxr();
                    this.zzawn().zzji(this.zzawb().getGmpAppId());
                    this.zzawn().zzjab.set(this.zzjdl);
                    this.zzawn().zzjac.zzjk(null);
                }
            }
            this.zzawa().zzjj(this.zzawn().zzjac.zzazf());
            if (!TextUtils.isEmpty((CharSequence)this.zzawb().getGmpAppId())) {
                zzcik zzcik2 = this.zzawa();
                ((zzcih)zzcik2).zzut();
                zzcik2.zzwu();
                if (zzcik2.zzitk.zzazj()) {
                    ((zzcih)zzcik2).zzawd().zzbaf();
                    String string = ((zzcih)zzcik2).zzawn().zzaze();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcih)zzcik2).zzawc().zzwu();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcik2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzawd().zza(new AtomicReference<String>());
            }
        }
        this.zzazx();
    }

    public final zzcfk zzawo() {
        return this.zzjcb;
    }

    public final zzcgu zzawn() {
        zzchj.zza((zzcih)this.zzjcc);
        return this.zzjcc;
    }

    public final zzcgj zzawm() {
        zzchj.zza(this.zzjcd);
        return this.zzjcd;
    }

    public final zzcgj zzazl() {
        if (this.zzjcd != null && this.zzjcd.isInitialized()) {
            return this.zzjcd;
        }
        return null;
    }

    public final zzche zzawl() {
        zzchj.zza(this.zzjce);
        return this.zzjce;
    }

    public final zzckc zzawk() {
        zzchj.zza(this.zzjcf);
        return this.zzjcf;
    }

    public final zzchd zzawj() {
        zzchj.zza(this.zzjcg);
        return this.zzjcg;
    }

    final zzche zzazm() {
        return this.zzjce;
    }

    public final zzcik zzawa() {
        zzchj.zza(this.zzjcr);
        return this.zzjcr;
    }

    public final AppMeasurement zzazn() {
        return this.zzjch;
    }

    public final FirebaseAnalytics zzazo() {
        return this.zzjci;
    }

    public final zzckn zzawi() {
        zzchj.zza((zzcih)this.zzjcj);
        return this.zzjcj;
    }

    public final zzcgh zzawh() {
        zzchj.zza((zzcih)this.zzjck);
        return this.zzjck;
    }

    public final zzcfl zzawg() {
        zzchj.zza(this.zzjcl);
        return this.zzjcl;
    }

    public final zzcgf zzawf() {
        zzchj.zza(this.zzjcm);
        return this.zzjcm;
    }

    public final zzcgn zzazp() {
        zzchj.zza(this.zzjcn);
        return this.zzjcn;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzwh() {
        return this.zzasd;
    }

    public final zzciz zzawe() {
        zzchj.zza(this.zzjco);
        return this.zzjco;
    }

    public final zzcjd zzawd() {
        zzchj.zza(this.zzjcp);
        return this.zzjcp;
    }

    public final zzcfr zzawc() {
        zzchj.zza(this.zzjcq);
        return this.zzjcq;
    }

    public final zzcge zzawb() {
        zzchj.zza(this.zzjcs);
        return this.zzjcs;
    }

    private final zzcgs zzazq() {
        if (this.zzjct == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzjct;
    }

    private final zzcki zzazr() {
        zzchj.zza(this.zzjcu);
        return this.zzjcu;
    }

    public final zzcfh zzavz() {
        zzchj.zza(this.zzjcv);
        return this.zzjcv;
    }

    public final zzcfa zzavy() {
        zzchj.zza(this.zzjcw);
        return this.zzjcw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzchj zzdu(Context context) {
        zzbq.checkNotNull((Object)context);
        zzbq.checkNotNull((Object)context.getApplicationContext());
        if (zzjca != null) return zzjca;
        Class<zzchj> clazz = zzchj.class;
        synchronized (zzchj.class) {
            if (zzjca != null) return zzjca;
            zzcij zzcij2 = new zzcij(context);
            zzjca = new zzchj(zzcij2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzjca;
        }
    }

    final void zzd(zzcff zzcff2) {
        this.zzawg().zziv(zzcff2.packageName);
        String string = zzcff2.packageName;
        zzcfl zzcfl2 = this.zzawg();
        zzbq.zzgh((String)string);
        zzcfl2.zzut();
        zzcfl2.zzwu();
        try {
            SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
            if (n > 0) {
                zzcfl2.zzawm().zzayx().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzcfl2.zzawm().zzayr().zze("Error resetting analytics data. appId, error", zzcgj.zzje(string), (Object)sQLiteException);
        }
        zzcff zzcff3 = this.zza(this.mContext, zzcff2.packageName, zzcff2.zziux, zzcff2.zzivc, zzcff2.zzivj);
        this.zzf(zzcff3);
    }

    private final zzcff zza(Context context, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzawm().zzayr().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzawm().zzayr().zzj("Error retrieving installer package name. appId", zzcgj.zzje(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = zzbgc.zzcy((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = zzbgc.zzcy((Context)context).zzgo(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzawm().zzayr().zze("Error retrieving newly installed package info. appId, appName", zzcgj.zzje(string), string5);
            return null;
        }
        return new zzcff(string, string2, string4, n, string3, 11720L, this.zzawi().zzaf(context, string), null, bl, false, "", 0L, 0L, 0, bl2);
    }

    private static void zza(zzcii zzcii2) {
        if (zzcii2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcii2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcih zzcih2) {
        if (zzcih2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzazs() {
        ((zzcih)this.zzawl()).zzut();
        String string = "google_app_measurement.db";
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzjdb = new RandomAccessFile(file2, "rw").getChannel();
            this.zzjda = this.zzjdb.tryLock();
            if (this.zzjda != null) {
                this.zzawm().zzayx().log("Storage concurrent access okay");
                return true;
            }
            this.zzawm().zzayr().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzawm().zzayr().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzawm().zzayr().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcih)this.zzawl()).zzut();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawm().zzayr().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzawm().zzayt().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzawm().zzayr().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcih)this.zzawl()).zzut();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawm().zzayr().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzawm().zzayr().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzawm().zzayr().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (this.zzjcb.zzaxo()) {
            return false;
        }
        Boolean bl = this.zzjcb.zzis("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcc.zzaiw();
        return this.zzawn().zzbm(bl2);
    }

    final void zze(zzcff zzcff2) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        zzbq.zzgh((String)zzcff2.packageName);
        this.zzg(zzcff2);
    }

    final long zzazt() {
        Long l = this.zzawn().zzjab.get();
        if (l == 0L) {
            return this.zzjdl;
        }
        return Math.min(this.zzjdl, l);
    }

    private final long zzazu() {
        long l = this.zzasd.currentTimeMillis();
        zzcgu zzcgu2 = this.zzawn();
        zzcgu2.zzwu();
        zzcgu2.zzut();
        long l2 = zzcgu2.zzjaa.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzcgu2.zzawi().zzban().nextInt(86400000);
            zzcgu2.zzjaa.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcff zzjq(String string) {
        zzcfe zzcfe2 = this.zzawg().zziv(string);
        if (zzcfe2 == null || TextUtils.isEmpty((CharSequence)zzcfe2.zzuy())) {
            this.zzawm().zzayw().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbgc.zzcy((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcfe2.zzuy() != null && !zzcfe2.zzuy().equals(string2)) {
                this.zzawm().zzayt().zzj("App version does not match; dropping. appId", zzcgj.zzje(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcff(string, zzcfe2.getGmpAppId(), zzcfe2.zzuy(), zzcfe2.zzawu(), zzcfe2.zzawv(), zzcfe2.zzaww(), zzcfe2.zzawx(), null, zzcfe2.zzawy(), false, zzcfe2.zzawr(), zzcfe2.zzaxl(), 0L, 0, zzcfe2.zzaxm());
    }

    @WorkerThread
    final void zzb(zzcfx zzcfx2, String string) {
        Object object;
        zzcfe zzcfe2;
        block4: {
            zzcfe2 = this.zzawg().zziv(string);
            if (zzcfe2 == null || TextUtils.isEmpty((CharSequence)zzcfe2.zzuy())) {
                this.zzawm().zzayw().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbgc.zzcy((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcfe2.zzuy() != null && !zzcfe2.zzuy().equals(object)) {
                    this.zzawm().zzayt().zzj("App version does not match; dropping event. appId", zzcgj.zzje(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcfx2.name)) break block4;
                this.zzawm().zzayt().zzj("Could not find package. appId", zzcgj.zzje(string));
            }
        }
        object = new zzcff(string, zzcfe2.getGmpAppId(), zzcfe2.zzuy(), zzcfe2.zzawu(), zzcfe2.zzawv(), zzcfe2.zzaww(), zzcfe2.zzawx(), null, zzcfe2.zzawy(), false, zzcfe2.zzawr(), zzcfe2.zzaxl(), 0L, 0, zzcfe2.zzaxm());
        this.zzb(zzcfx2, (zzcff)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcfx zzcfx2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgh((String)zzcff2.packageName);
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        String string = zzcff2.packageName;
        long l = zzcfx2.zziwz;
        this.zzawi();
        if (!zzckn.zzd(zzcfx2, zzcff2)) {
            return;
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawg().beginTransaction();
        try {
            zzbej zzbej2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcfl zzcfl2 = this.zzawg();
            zzbq.zzgh((String)string3);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l2 < 0L) {
                zzcfl2.zzawm().zzayt().zze("Invalid time querying timed out conditional properties", zzcgj.zzje(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcfl2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzawm().zzayw().zzd("User property timed out", object22.packageName, this.zzawh().zzjd(object22.zzivl.name), object22.zzivl.getValue());
                if (object22.zzivp != null) {
                    this.zzc(new zzcfx(object22.zzivp, l), zzcff2);
                }
                this.zzawg().zzai(string, object22.zzivl.name);
            }
            l2 = l;
            string3 = string;
            zzcfl2 = this.zzawg();
            zzbq.zzgh((String)string3);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l2 < 0L) {
                zzcfl2.zzawm().zzayt().zze("Invalid time querying expired conditional properties", zzcgj.zzje(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcfl2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcfi)((Object)object4.next());
                if (object == null) continue;
                this.zzawm().zzayw().zzd("User property expired", object.packageName, this.zzawh().zzjd(object.zzivl.name), object.zzivl.getValue());
                this.zzawg().zzaf(string, object.zzivl.name);
                if (object.zzivt != null) {
                    object22.add(object.zzivt);
                }
                this.zzawg().zzai(string, object.zzivl.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcfx)((Object)e);
                this.zzc(new zzcfx((zzcfx)((Object)object), l), zzcff2);
            }
            long l3 = l;
            String string4 = zzcfx2.name;
            string3 = string;
            zzcfl2 = this.zzawg();
            zzbq.zzgh((String)string3);
            zzbq.zzgh((String)string4);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l3 < 0L) {
                zzcfl2.zzawm().zzayt().zzd("Invalid time querying triggered conditional properties", zzcgj.zzje(string3), zzcfl2.zzawh().zzjb(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcfl2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbej2 = (zzcfi)((Object)iterator.next());
                if (zzbej2 == null) continue;
                zzckk zzckk2 = zzbej2.zzivl;
                zzckm zzckm2 = new zzckm(zzbej2.packageName, zzbej2.zzivk, zzckk2.name, l, zzckk2.getValue());
                if (this.zzawg().zza(zzckm2)) {
                    this.zzawm().zzayw().zzd("User property triggered", zzbej2.packageName, this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                } else {
                    this.zzawm().zzayr().zzd("Too many active user properties, ignoring", zzcgj.zzje(zzbej2.packageName), this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                }
                if (zzbej2.zzivr != null) {
                    object.add(zzbej2.zzivr);
                }
                zzbej2.zzivl = new zzckk(zzckm2);
                zzbej2.zzivn = true;
                this.zzawg().zza((zzcfi)zzbej2);
            }
            this.zzc(zzcfx2, zzcff2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbej2 = (zzcfx)((Object)e);
                this.zzc(new zzcfx((zzcfx)zzbej2, l), zzcff2);
            }
            this.zzawg().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzcfx var1_1, zzcff var2_2) {
        zzbq.checkNotNull((Object)var2_2);
        zzbq.zzgh((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzawl().zzut();
        this.zzwu();
        var5_4 = var2_2.packageName;
        this.zzawi();
        if (!zzckn.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzivc) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzawj().zzan(var5_4, var1_1.name)) {
            this.zzawm().zzayt().zze("Dropping blacklisted event. appId", zzcgj.zzje(var5_4), this.zzawh().zzjb(var1_1.name));
            var6_5 = this.zzawi().zzkf(var5_4) != false || this.zzawi().zzkg(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzawi().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzawg().zziv(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzaxb(), var7_7.zzaxa());
                if (Math.abs(this.zzasd.currentTimeMillis() - var8_9) > zzcfz.zziyh.get()) {
                    this.zzawm().zzayw().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzawm().zzae(2)) {
            this.zzawm().zzayx().zzj("Logging event", this.zzawh().zzb(var1_1));
        }
        this.zzawg().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzawg().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzckn.zzjt(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzawg().zza(this.zzazu(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zziwd - (long)zzcfz.zzixs.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawm().zzayr().zze("Data loss. Too many events logged. appId, count", zzcgj.zzje(var5_4), var8_10.zziwd);
                        }
                        this.zzawg().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zziwc - (long)zzcfz.zzixu.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawm().zzayr().zze("Data loss. Too many public events logged. appId, count", zzcgj.zzje(var5_4), var8_10.zziwc);
                        }
                        this.zzawi().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzawg().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzjcb.zzb((String)var19_12, zzcfz.zzixt);
                        var9_11 = var8_10.zziwf - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzawm().zzayr().zze("Too many error events logged. appId, count", zzcgj.zzje(var5_4), var8_10.zziwf);
                            }
                            this.zzawg().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zziwy.zzayl();
                    this.zzawi().zza(var11_15, "_o", (Object)var1_1.zzivk);
                    if (this.zzawi().zzkd(var5_4)) {
                        this.zzawi().zza(var11_15, "_dbg", 1L);
                        this.zzawi().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzawg().zziw(var5_4)) > 0L) {
                        this.zzawm().zzayt().zze("Data lost. Too many events stored on disk, deleted. appId", zzcgj.zzje(var5_4), var12_16);
                    }
                    var14_17 = new zzcfs(this, var1_1.zzivk, var5_4, var1_1.name, var1_1.zziwz, 0L, var11_15);
                    var15_18 = this.zzawg().zzae(var5_4, var14_17.mName);
                    if (var15_18 == null) {
                        if (this.zzawg().zziz(var5_4) >= 500L && var6_6) {
                            this.zzawm().zzayr().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcgj.zzje(var5_4), this.zzawh().zzjb(var14_17.mName), 500);
                            this.zzawi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzcft(var5_4, var14_17.mName, 0L, 0L, var14_17.zzffr, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zziwr);
                        var16_19 = var15_18.zzba(var14_17.zzffr);
                    }
                    this.zzawg().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzawl().zzut();
                    var18_20.zzwu();
                    zzbq.checkNotNull((Object)var19_12);
                    zzbq.checkNotNull((Object)var20_14);
                    zzbq.zzgh((String)var19_12.mAppId);
                    zzbq.checkArgument((boolean)var19_12.mAppId.equals(var20_14.packageName));
                    var21_21 = new zzclb();
                    new zzclb().zzjit = 1;
                    var21_21.zzjjb = "android";
                    var21_21.zzch = var20_14.packageName;
                    var21_21.zziuy = var20_14.zziuy;
                    var21_21.zzicq = var20_14.zzicq;
                    var21_21.zzjjo = var20_14.zzive == -2147483648L ? null : Integer.valueOf((int)var20_14.zzive);
                    var21_21.zzjjf = var20_14.zziuz;
                    var21_21.zziux = var20_14.zziux;
                    var21_21.zzjjk = var20_14.zziva == 0L ? null : Long.valueOf(var20_14.zziva);
                    var22_22 = var18_20.zzawn().zzjg(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzivj) {
                            var21_21.zzjjh = (String)var22_22.first;
                            var21_21.zzjji = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzawc().zzdt(var18_20.mContext)) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.mContext.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzawm().zzayt().zzj("null secure ID. appId", zzcgj.zzje(var21_21.zzch));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzawm().zzayt().zzj("empty secure ID. appId", zzcgj.zzje(var21_21.zzch));
                        }
                        var21_21.zzjjr = var23_23;
                    }
                    var18_20.zzawc().zzwu();
                    var21_21.zzjjc = Build.MODEL;
                    var18_20.zzawc().zzwu();
                    var21_21.zzcv = Build.VERSION.RELEASE;
                    var21_21.zzjje = (int)var18_20.zzawc().zzayi();
                    var21_21.zzjjd = var18_20.zzawc().zzayj();
                    var21_21.zzjjg = null;
                    var21_21.zzjiw = null;
                    var21_21.zzjix = null;
                    var21_21.zzjiy = null;
                    var21_21.zzfhr = var20_14.zzivg;
                    if (var18_20.isEnabled() && zzcfk.zzaxs()) {
                        var18_20.zzawb();
                        var21_21.zzjjt = null;
                    }
                    if ((var23_23 = var18_20.zzawg().zziv(var20_14.packageName)) == null) {
                        var23_23 = new zzcfe(var18_20, var20_14.packageName);
                        var23_23.zzil(var18_20.zzawb().zzayn());
                        var23_23.zzio(var20_14.zzivf);
                        var23_23.zzim(var20_14.zziux);
                        var23_23.zzin(var18_20.zzawn().zzjh(var20_14.packageName));
                        var23_23.zzap(0L);
                        var23_23.zzak(0L);
                        var23_23.zzal(0L);
                        var23_23.setAppVersion(var20_14.zzicq);
                        var23_23.zzam(var20_14.zzive);
                        var23_23.zzip(var20_14.zziuy);
                        var23_23.zzan(var20_14.zziuz);
                        var23_23.zzao(var20_14.zziva);
                        var23_23.setMeasurementEnabled(var20_14.zzivc);
                        var23_23.zzay(var20_14.zzivg);
                        var18_20.zzawg().zza((zzcfe)var23_23);
                    }
                    var21_21.zzjjj = var23_23.getAppInstanceId();
                    var21_21.zzivf = var23_23.zzawr();
                    var24_24 = var18_20.zzawg().zziu(var20_14.packageName);
                    var21_21.zzjiv = new zzcld[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzjiv[var25_25] = var26_27 = new zzcld();
                        var26_27.name = var24_24.get((int)var25_25).mName;
                        var26_27.zzjjx = var24_24.get((int)var25_25).zzjgr;
                        var18_20.zzawi().zza(var26_27, var24_24.get((int)var25_25).mValue);
                    }
                    try {
                        var25_26 = var18_20.zzawg().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzawm().zzayr().zze("Data loss. Failed to insert raw event metadata. appId", zzcgj.zzje(var21_21.zzch), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzawg();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zziwo == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zziwo) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzawj().zzao(var29_29.mAppId, var29_29.mName);
                    var31_33 = var28_30.zzawg().zza(var28_30.zzazu(), var29_29.mAppId, false, false, false, false, false);
                    if (var30_32 && var31_33.zziwg < (long)var28_30.zzjcb.zzir(var29_29.mAppId)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzcfs)var19_12, var25_26, v1)) {
                    var18_20.zzjdh = 0L;
                }
            }
            this.zzawg().setTransactionSuccessful();
            if (this.zzawm().zzae(2)) {
                this.zzawm().zzayx().zzj("Event recorded", this.zzawh().zza(var14_17));
            }
        }
        finally {
            this.zzawg().endTransaction();
        }
        this.zzazx();
        this.zzawm().zzayx().zzj("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzcfx zzcfx2) {
        long l;
        String string2;
        block10: {
            string2 = zzcfx2.zziwy.getString("currency");
            if ("ecommerce_purchase".equals(zzcfx2.name)) {
                double d = zzcfx2.zziwy.getDouble("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzcfx2.zziwy.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzawm().zzayt().zze("Data lost. Currency value is too big. appId", zzcgj.zzje(string), d);
                    return false;
                }
            }
            l = zzcfx2.zziwy.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzckm zzckm2 = this.zzawg().zzag(string, string5);
            if (zzckm2 == null || !(zzckm2.mValue instanceof Long)) {
                String string6 = string;
                int n = this.zzjcb.zzb(string6, zzcfz.zziym) - 1;
                string6 = string;
                zzcfl zzcfl2 = this.zzawg();
                zzbq.zzgh((String)string6);
                zzcfl2.zzut();
                zzcfl2.zzwu();
                try {
                    zzcfl2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzcfl2.zzawm().zzayr().zze("Error pruning currencies. appId", zzcgj.zzje(string6), (Object)sQLiteException);
                }
                zzckm2 = new zzckm(string, zzcfx2.zzivk, string5, this.zzasd.currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzckm2.mValue;
                zzckm2 = new zzckm(string, zzcfx2.zzivk, string5, this.zzasd.currentTimeMillis(), l2 + l);
            }
            if (!this.zzawg().zza(zzckm2)) {
                this.zzawm().zzayr().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcgj.zzje(string), this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                this.zzawi().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzd(zzcfi zzcfi2) {
        zzcff zzcff2 = this.zzjq(zzcfi2.packageName);
        if (zzcff2 != null) {
            this.zzb(zzcfi2, zzcff2);
        }
    }

    @WorkerThread
    final void zzb(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.zzgh((String)zzcfi2.packageName);
        zzbq.checkNotNull((Object)zzcfi2.zzivk);
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivl));
        zzbq.zzgh((String)zzcfi2.zzivl.name);
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            return;
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        new zzcfi(zzcfi2).zzivn = false;
        this.zzawg().beginTransaction();
        try {
            boolean bl = false;
            zzcfi zzcfi4 = this.zzawg().zzah(zzcfi3.packageName, zzcfi3.zzivl.name);
            if (zzcfi4 != null && !zzcfi4.zzivk.equals(zzcfi3.zzivk)) {
                this.zzawm().zzayt().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzawh().zzjd(zzcfi3.zzivl.name), zzcfi3.zzivk, zzcfi4.zzivk);
            }
            if (zzcfi4 != null && zzcfi4.zzivn) {
                zzcfi3.zzivk = zzcfi4.zzivk;
                zzcfi3.zzivm = zzcfi4.zzivm;
                zzcfi3.zzivq = zzcfi4.zzivq;
                zzcfi3.zzivo = zzcfi4.zzivo;
                zzcfi3.zzivr = zzcfi4.zzivr;
                zzcfi3.zzivn = zzcfi4.zzivn;
                zzcfi3.zzivl = new zzckk(zzcfi3.zzivl.name, zzcfi4.zzivl.zzjgn, zzcfi3.zzivl.getValue(), zzcfi4.zzivl.zzivk);
            } else if (TextUtils.isEmpty((CharSequence)zzcfi3.zzivo)) {
                zzcfi3.zzivl = new zzckk(zzcfi3.zzivl.name, zzcfi3.zzivm, zzcfi3.zzivl.getValue(), zzcfi3.zzivl.zzivk);
                zzcfi3.zzivn = true;
                bl = true;
            }
            if (zzcfi3.zzivn) {
                zzckk zzckk2 = zzcfi3.zzivl;
                zzckm zzckm2 = new zzckm(zzcfi3.packageName, zzcfi3.zzivk, zzckk2.name, zzckk2.zzjgn, zzckk2.getValue());
                if (this.zzawg().zza(zzckm2)) {
                    this.zzawm().zzayw().zzd("User property updated immediately", zzcfi3.packageName, this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                } else {
                    this.zzawm().zzayr().zzd("(2)Too many active user properties, ignoring", zzcgj.zzje(zzcfi3.packageName), this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                }
                if (bl && zzcfi3.zzivr != null) {
                    zzcfx zzcfx2 = new zzcfx(zzcfi3.zzivr, zzcfi3.zzivm);
                    this.zzc(zzcfx2, zzcff2);
                }
            }
            if (this.zzawg().zza(zzcfi3)) {
                this.zzawm().zzayw().zzd("Conditional property added", zzcfi3.packageName, this.zzawh().zzjd(zzcfi3.zzivl.name), zzcfi3.zzivl.getValue());
            } else {
                this.zzawm().zzayr().zzd("Too many conditional properties, ignoring", zzcgj.zzje(zzcfi3.packageName), this.zzawh().zzjd(zzcfi3.zzivl.name), zzcfi3.zzivl.getValue());
            }
            this.zzawg().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcfi zzcfi2) {
        zzcff zzcff2 = this.zzjq(zzcfi2.packageName);
        if (zzcff2 != null) {
            this.zzc(zzcfi2, zzcff2);
        }
    }

    @WorkerThread
    final void zzc(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.zzgh((String)zzcfi2.packageName);
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivl));
        zzbq.zzgh((String)zzcfi2.zzivl.name);
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            return;
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawg().beginTransaction();
        try {
            this.zzg(zzcff2);
            zzcfi zzcfi3 = this.zzawg().zzah(zzcfi2.packageName, zzcfi2.zzivl.name);
            if (zzcfi3 != null) {
                this.zzawm().zzayw().zze("Removing conditional user property", zzcfi2.packageName, this.zzawh().zzjd(zzcfi2.zzivl.name));
                this.zzawg().zzai(zzcfi2.packageName, zzcfi2.zzivl.name);
                if (zzcfi3.zzivn) {
                    this.zzawg().zzaf(zzcfi2.packageName, zzcfi2.zzivl.name);
                }
                if (zzcfi2.zzivt != null) {
                    Bundle bundle = null;
                    if (zzcfi2.zzivt.zziwy != null) {
                        bundle = zzcfi2.zzivt.zziwy.zzayl();
                    }
                    zzcfx zzcfx2 = this.zzawi().zza(zzcfi2.zzivt.name, bundle, zzcfi3.zzivk, zzcfi2.zzivt.zziwz, true, false);
                    this.zzc(zzcfx2, zzcff2);
                }
            } else {
                this.zzawm().zzayt().zze("Conditional user property doesn't exist", zzcgj.zzje(zzcfi2.packageName), this.zzawh().zzjd(zzcfi2.zzivl.name));
            }
            this.zzawg().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcfx zzcfx2, @Size(min=1L) String string) {
        Object object;
        this.zzwu();
        ((zzcih)this.zzawl()).zzut();
        zzchj.zzavw();
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        zzbq.zzgh((String)string);
        zzcla zzcla2 = new zzcla();
        this.zzawg().beginTransaction();
        try {
            zzcft zzcft2;
            long l;
            Object object2;
            zzcfe zzcfe2 = this.zzawg().zziv(string);
            if (zzcfe2 == null) {
                this.zzawm().zzayw().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcfe2.zzawy()) {
                this.zzawm().zzayw().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzcfx2.name) || "ecommerce_purchase".equals(zzcfx2.name)) && !this.zza(string, zzcfx2)) {
                this.zzawm().zzayt().zzj("Failed to handle purchase event at single event bundle creation. appId", zzcgj.zzje(string));
            }
            object = new zzclb();
            zzcla2.zzjir = new zzclb[]{object};
            object.zzjit = 1;
            object.zzjjb = "android";
            object.zzch = zzcfe2.getAppId();
            object.zziuy = zzcfe2.zzawv();
            object.zzicq = zzcfe2.zzuy();
            long l2 = zzcfe2.zzawu();
            object.zzjjo = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzjjf = zzcfe2.zzaww();
            object.zziux = zzcfe2.getGmpAppId();
            object.zzjjk = zzcfe2.zzawx();
            if (this.isEnabled() && zzcfk.zzaxs() && this.zzjcb.zzit(object.zzch)) {
                this.zzawb();
                object.zzjjt = null;
            }
            Pair<String, Boolean> pair = this.zzawn().zzjg(zzcfe2.getAppId());
            if (zzcfe2.zzaxm() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzjjh = (String)pair.first;
                object.zzjji = (Boolean)pair.second;
            }
            this.zzawc().zzwu();
            object.zzjjc = Build.MODEL;
            this.zzawc().zzwu();
            object.zzcv = Build.VERSION.RELEASE;
            object.zzjje = (int)this.zzawc().zzayi();
            object.zzjjd = this.zzawc().zzayj();
            object.zzjjj = zzcfe2.getAppInstanceId();
            object.zzivf = zzcfe2.zzawr();
            List<zzckm> list = this.zzawg().zziu(zzcfe2.getAppId());
            object.zzjiv = new zzcld[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcld();
                object.zzjiv[i] = object2;
                ((zzcld)((Object)object2)).name = list.get((int)i).mName;
                ((zzcld)((Object)object2)).zzjjx = list.get((int)i).zzjgr;
                this.zzawi().zza((zzcld)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcfx2.zziwy.zzayl();
            if ("_iap".equals(zzcfx2.name)) {
                bundle.putLong("_c", 1L);
                this.zzawm().zzayw().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcfx2.zzivk);
            if (this.zzawi().zzkd(object.zzch)) {
                this.zzawi().zza(bundle, "_dbg", 1L);
                this.zzawi().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzawg().zzae(string, zzcfx2.name)) == null) {
                l = 0L;
                zzcft2 = new zzcft(string, zzcfx2.name, 1L, 0L, zzcfx2.zziwz, 0L, null, null, null);
                this.zzawg().zza(zzcft2);
            } else {
                l = ((zzcft)object2).zziwr;
                zzcft2 = ((zzcft)object2).zzba(zzcfx2.zziwz).zzayk();
                this.zzawg().zza(zzcft2);
            }
            zzcfs zzcfs2 = new zzcfs(this, zzcfx2.zzivk, string, zzcfx2.name, zzcfx2.zziwz, l, bundle);
            zzcky zzcky2 = new zzcky();
            object.zzjiu = new zzcky[]{zzcky2};
            zzcky2.zzjin = zzcfs2.zzffr;
            zzcky2.name = zzcfs2.mName;
            zzcky2.zzjio = zzcfs2.zziwn;
            zzcky2.zzjim = new zzckz[zzcfs2.zziwo.size()];
            int n = 0;
            for (String string2 : zzcfs2.zziwo) {
                zzckz zzckz2 = new zzckz();
                zzcky2.zzjim[n++] = zzckz2;
                zzckz2.name = string2;
                Object object3 = zzcfs2.zziwo.get(string2);
                this.zzawi().zza(zzckz2, object3);
            }
            object.zzjjn = this.zza(zzcfe2.getAppId(), object.zzjiv, object.zzjiu);
            object.zzjix = zzcky2.zzjin;
            object.zzjiy = zzcky2.zzjin;
            long l3 = zzcfe2.zzawt();
            object.zzjja = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcfe2.zzaws();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzjiz = l4 != 0L ? Long.valueOf(l4) : null;
            zzcfe2.zzaxc();
            object.zzjjl = (int)zzcfe2.zzawz();
            object.zzjjg = 11720L;
            object.zzjiw = this.zzasd.currentTimeMillis();
            object.zzjjm = Boolean.TRUE;
            zzcfe2.zzak(object.zzjix);
            zzcfe2.zzal(object.zzjiy);
            this.zzawg().zza(zzcfe2);
            this.zzawg().setTransactionSuccessful();
        }
        finally {
            this.zzawg().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcla2.zzhl()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzfhc zzfhc2 = zzfhc.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcla2.zza(zzfhc2);
            zzfhc2.zzcus();
            return this.zzawi().zzp((byte[])object);
        }
        catch (IOException iOException) {
            this.zzawm().zzayr().zze("Data loss. Failed to bundle and serialize. appId", zzcgj.zzje(string), iOException);
            return null;
        }
    }

    public final String zzjr(String string) {
        Future<String> future = this.zzawl().zzc(new zzchl(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzawm().zzayr().zze("Failed to get app instance id. appId", zzcgj.zzje(string), exception);
            return null;
        }
    }

    private static boolean zza(zzcky zzcky2, String string, Object object) {
        if (TextUtils.isEmpty((CharSequence)string) || object == null) {
            return false;
        }
        zzckz[] zzckzArray = zzcky2.zzjim;
        int n = zzcky2.zzjim.length;
        for (int i = 0; i < n; ++i) {
            zzckz zzckz2 = zzckzArray[i];
            if (!string.equals(zzckz2.name)) continue;
            return object instanceof Long && object.equals(zzckz2.zzjiq) || object instanceof String && object.equals(zzckz2.zzfzi) || object instanceof Double && object.equals(zzckz2.zzjgq);
        }
        return false;
    }

    static void zzavw() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzckk zzckk2, zzcff zzcff2) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            return;
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        int n = this.zzawi().zzjx(zzckk2.name);
        if (n != 0) {
            this.zzawi();
            String string = zzckn.zza(zzckk2.name, 24, true);
            int n2 = zzckk2.name != null ? zzckk2.name.length() : 0;
            this.zzawi().zza(zzcff2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzawi().zzl(zzckk2.name, zzckk2.getValue());
        if (n != 0) {
            this.zzawi();
            String string = zzckn.zza(zzckk2.name, 24, true);
            Object object = zzckk2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzawi().zza(zzcff2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzawi().zzm(zzckk2.name, zzckk2.getValue());
        if (object == null) {
            return;
        }
        zzckm zzckm2 = new zzckm(zzcff2.packageName, zzckk2.zzivk, zzckk2.name, zzckk2.zzjgn, object);
        this.zzawm().zzayw().zze("Setting user property", this.zzawh().zzjd(zzckm2.mName), object);
        this.zzawg().beginTransaction();
        try {
            this.zzg(zzcff2);
            boolean bl = this.zzawg().zza(zzckm2);
            this.zzawg().setTransactionSuccessful();
            if (bl) {
                this.zzawm().zzayw().zze("User property set", this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
            } else {
                this.zzawm().zzayr().zze("Too many unique user properties are set. Ignoring user property", this.zzawh().zzjd(zzckm2.mName), zzckm2.mValue);
                this.zzawi().zza(zzcff2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzckk zzckk2, zzcff zzcff2) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            return;
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawm().zzayw().zzj("Removing user property", this.zzawh().zzjd(zzckk2.name));
        this.zzawg().beginTransaction();
        try {
            this.zzg(zzcff2);
            this.zzawg().zzaf(zzcff2.packageName, zzckk2.name);
            this.zzawg().setTransactionSuccessful();
            this.zzawm().zzayw().zzj("User property removed", this.zzawh().zzjd(zzckk2.name));
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazv() {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        this.zzjdk = true;
        try {
            String string;
            Boolean bl = this.zzawd().zzbag();
            if (bl == null) {
                this.zzawm().zzayt().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzawm().zzayr().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzjdh > 0L) {
                this.zzazx();
                return;
            }
            Object object = this;
            ((zzcih)((zzchj)object).zzawl()).zzut();
            if (((zzchj)object).zzjdc != null) {
                this.zzawm().zzayx().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzazp().zzzh()) {
                this.zzawm().zzayx().log("Network not connected, ignoring upload request");
                this.zzazx();
                return;
            }
            long l = this.zzasd.currentTimeMillis();
            long l2 = l - zzcfk.zzaxq();
            this.zzh(null, l2);
            long l3 = this.zzawn().zzizw.get();
            if (l3 != 0L) {
                this.zzawm().zzayw().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzawg().zzaxt()))) {
                if (this.zzjdg == -1L) {
                    this.zzjdg = this.zzawg().zzaya();
                }
                Object object2 = string;
                int n = this.zzjcb.zzb((String)object2, zzcfz.zzixo);
                object2 = string;
                object = this.zzjcb;
                int n2 = Math.max(0, ((zzcfk)object).zzb((String)object2, zzcfz.zzixp));
                List<Pair<zzclb, Long>> list = this.zzawg().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzclb zzclb2 = (zzclb)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzclb2.zzjjh)) continue;
                        string2 = zzclb2.zzjjh;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzclb)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzclb)((Object)object3)).zzjjh) || ((zzclb)((Object)object3)).zzjjh.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcla();
                    new zzcla().zzjir = new zzclb[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcfk.zzaxs() && this.zzjcb.zzit(string);
                    for (int i = 0; i < ((zzcla)((Object)object4)).zzjir.length; ++i) {
                        ((zzcla)((Object)object4)).zzjir[i] = (zzclb)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcla)((Object)object4)).zzjir[i].zzjjg = 11720L;
                        ((zzcla)((Object)object4)).zzjir[i].zzjiw = l;
                        ((zzcla)((Object)object4)).zzjir[i].zzjjm = false;
                        if (bl2) continue;
                        ((zzcla)((Object)object4)).zzjir[i].zzjjt = null;
                    }
                    String string3 = null;
                    if (this.zzawm().zzae(2)) {
                        string3 = this.zzawh().zza((zzcla)((Object)object4));
                    }
                    byte[] byArray = this.zzawi().zzb((zzcla)((Object)object4));
                    String string4 = zzcfz.zzixy.get();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbq.checkArgument((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzchj)object).zzjdc != null) {
                            ((zzchj)object).zzawm().zzayr().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzchj)object).zzjdc = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzawn().zzizx.set(l);
                        String string5 = "?";
                        if (((zzcla)((Object)object4)).zzjir.length > 0) {
                            string5 = ((zzcla)((Object)object4)).zzjir[0].zzch;
                        }
                        this.zzawm().zzayx().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzjdj = true;
                        zzchm zzchm2 = new zzchm(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzazp();
                        ((zzcih)object).zzut();
                        ((zzcii)object).zzwu();
                        zzbq.checkNotNull((Object)uRL2);
                        zzbq.checkNotNull((Object)byArray2);
                        zzbq.checkNotNull((Object)zzchm2);
                        ((zzcih)object).zzawl().zzh(new zzcgr((zzcgn)object, (String)object2, uRL2, byArray2, null, zzchm2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzawm().zzayr().zze("Failed to parse upload URL. Not uploading. appId", zzcgj.zzje(string), string4);
                    }
                }
            } else {
                zzcfe zzcfe2;
                this.zzjdg = -1L;
                String string6 = this.zzawg().zzaz(l - zzcfk.zzaxq());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcfe2 = this.zzawg().zziv(string6)) != null) {
                    this.zzb(zzcfe2);
                }
            }
            return;
        }
        finally {
            this.zzjdk = false;
            this.zzbab();
        }
    }

    @WorkerThread
    private final void zzb(zzcfe zzcfe2) {
        ((zzcih)this.zzawl()).zzut();
        if (TextUtils.isEmpty((CharSequence)zzcfe2.getGmpAppId())) {
            this.zzb(zzcfe2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcfe2.getAppInstanceId();
        String string = zzcfe2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcfz.zzixm.get()).encodedAuthority(zzcfz.zzixn.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11720");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzawm().zzayx().zzj("Fetching remote configuration", zzcfe2.getAppId());
            zzckv zzckv2 = this.zzawj().zzjm(zzcfe2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzawj().zzjn(zzcfe2.getAppId());
            if (zzckv2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzjdi = true;
            zzchn zzchn2 = new zzchn(this);
            builder = arrayMap;
            object = uRL;
            string = zzcfe2.getAppId();
            zzcgn zzcgn2 = this.zzazp();
            ((zzcih)zzcgn2).zzut();
            zzcgn2.zzwu();
            zzbq.checkNotNull((Object)object);
            zzbq.checkNotNull((Object)zzchn2);
            ((zzcih)zzcgn2).zzawl().zzh(new zzcgr(zzcgn2, string, (URL)object, null, (Map)builder, zzchn2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzawm().zzayr().zze("Failed to parse config URL. Not fetching. appId", zzcgj.zzje(zzcfe2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzh(String string, long l) {
        this.zzawg().beginTransaction();
        try {
            block85: {
                zzckz[] zzckzArray;
                Object object;
                int zzcky3;
                int n2;
                int n3;
                Object object2;
                String string2;
                zza zza2;
                block84: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzjdg;
                    long l3 = l;
                    string2 = null;
                    object2 = this.zzawg();
                    zzbq.checkNotNull((Object)zza3);
                    ((zzcih)object2).zzut();
                    ((zzcii)object2).zzwu();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcfl)object2).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcih)object2).zzawm().zzayr().zzj("Raw event metadata record is missing. appId", zzcgj.zzje(string2));
                            break block84;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzfhb.zzn((byte[])byArray, (int)0, (int)byArray.length);
                        zzclb zzclb2 = new zzclb();
                        try {
                            zzclb2.zza((zzfhb)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcih)object2).zzawm().zzayr().zze("Data loss. Failed to merge raw event metadata. appId", zzcgj.zzje(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block84;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcih)object2).zzawm().zzayt().zzj("Get multiple raw event metadata records, expected one. appId", zzcgj.zzje(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzclb2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcih)object2).zzawm().zzayt().zzj("Raw event data disappeared while in transaction. appId", zzcgj.zzje(string2));
                            break block84;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzfhb.zzn((byte[])byArray, (int)0, (int)byArray.length);
                            zzcky zzcky2 = new zzcky();
                            try {
                                zzcky2.zza((zzfhb)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcih)object2).zzawm().zzayr().zze("Data loss. Failed to merge raw event. appId", zzcgj.zzje(string2), iOException);
                                continue;
                            }
                            zzcky2.name = cursor.getString(1);
                            zzcky2.zzjin = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcky2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzaof == null || ((zza)object2).zzaof.isEmpty()) break block85;
                boolean bl = false;
                zzclb zzclb3 = zza2.zzjdn;
                zza2.zzjdn.zzjiu = new zzcky[zza2.zzaof.size()];
                int n4 = 0;
                for (n3 = 0; n3 < zza2.zzaof.size(); ++n3) {
                    block87: {
                        zzckz[] n8;
                        int n;
                        boolean bl2;
                        block86: {
                            bl2 = bl;
                            if (this.zzawj().zzan(zza2.zzjdn.zzch, zza2.zzaof.get((int)n3).name)) {
                                this.zzawm().zzayt().zze("Dropping blacklisted raw event. appId", zzcgj.zzje(zza2.zzjdn.zzch), this.zzawh().zzjb(zza2.zzaof.get((int)n3).name));
                                if (this.zzawi().zzkf(zza2.zzjdn.zzch) || this.zzawi().zzkg(zza2.zzjdn.zzch) || "_err".equals(zza2.zzaof.get((int)n3).name)) continue;
                                this.zzawi().zza(zza2.zzjdn.zzch, 11, "_ev", zza2.zzaof.get((int)n3).name, 0);
                                continue;
                            }
                            n2 = this.zzawj().zzao(zza2.zzjdn.zzch, zza2.zzaof.get((int)n3).name);
                            if (n2 != 0) break block86;
                            this.zzawi();
                            if (!zzckn.zzkh(zza2.zzaof.get((int)n3).name)) break block87;
                        }
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (zza2.zzaof.get((int)n3).zzjim == null) {
                            zza2.zzaof.get((int)n3).zzjim = new zzckz[0];
                        }
                        zzckz[] n7 = zza2.zzaof.get((int)n3).zzjim;
                        zzcky3 = zza2.zzaof.get((int)n3).zzjim.length;
                        for (n = 0; n < zzcky3; ++n) {
                            n8 = n7[n];
                            if ("_c".equals(n8.name)) {
                                n8.zzjiq = 1L;
                                bl3 = true;
                                continue;
                            }
                            if (!"_r".equals(n8.name)) continue;
                            n8.zzjiq = 1L;
                            bl4 = true;
                        }
                        if (!bl3 && n2 != 0) {
                            this.zzawm().zzayx().zzj("Marking event as conversion", this.zzawh().zzjb(zza2.zzaof.get((int)n3).name));
                            zzckz[] zzckzArray2 = Arrays.copyOf(zza2.zzaof.get((int)n3).zzjim, zza2.zzaof.get((int)n3).zzjim.length + 1);
                            zzckz zzckz2 = new zzckz();
                            new zzckz().name = "_c";
                            zzckz2.zzjiq = 1L;
                            zzckzArray2[zzckzArray2.length - 1] = zzckz2;
                            zza2.zzaof.get((int)n3).zzjim = zzckzArray2;
                        }
                        if (!bl4) {
                            this.zzawm().zzayx().zzj("Marking event as real-time", this.zzawh().zzjb(zza2.zzaof.get((int)n3).name));
                            zzckz[] zzckzArray3 = Arrays.copyOf(zza2.zzaof.get((int)n3).zzjim, zza2.zzaof.get((int)n3).zzjim.length + 1);
                            zzckz zzckz3 = new zzckz();
                            new zzckz().name = "_r";
                            zzckz3.zzjiq = 1L;
                            zzckzArray3[zzckzArray3.length - 1] = zzckz3;
                            zza2.zzaof.get((int)n3).zzjim = zzckzArray3;
                        }
                        bl = true;
                        if (this.zzawg().zza((long)this.zzazu(), (String)zza2.zzjdn.zzch, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zziwg > (long)this.zzjcb.zzir(zza2.zzjdn.zzch)) {
                            zzcky zzcky2 = zza2.zzaof.get(n3);
                            for (n = 0; n < zzcky2.zzjim.length; ++n) {
                                if (!"_r".equals(zzcky2.zzjim[n].name)) continue;
                                n8 = new zzckz[zzcky2.zzjim.length - 1];
                                if (n > 0) {
                                    System.arraycopy(zzcky2.zzjim, 0, n8, 0, n);
                                }
                                if (n < n8.length) {
                                    System.arraycopy(zzcky2.zzjim, n + 1, n8, n, n8.length - n);
                                }
                                zzcky2.zzjim = n8;
                                break;
                            }
                            bl = bl2;
                        }
                        if (zzckn.zzjt(zza2.zzaof.get((int)n3).name) && n2 != 0 && this.zzawg().zza((long)this.zzazu(), (String)zza2.zzjdn.zzch, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zziwe > (long)this.zzjcb.zzb(string2 = zza2.zzjdn.zzch, zzcfz.zzixv)) {
                            this.zzawm().zzayt().zzj("Too many conversions. Not logging as conversion. appId", zzcgj.zzje(zza2.zzjdn.zzch));
                            zzcky zzcky4 = zza2.zzaof.get(n3);
                            boolean bl5 = false;
                            object = null;
                            zzckzArray = zzcky4.zzjim;
                            int n5 = zzcky4.zzjim.length;
                            for (int i = 0; i < n5; ++i) {
                                zzckz zzckz4 = zzckzArray[i];
                                if ("_c".equals(zzckz4.name)) {
                                    object = zzckz4;
                                    continue;
                                }
                                if (!"_err".equals(zzckz4.name)) continue;
                                bl5 = true;
                            }
                            if (bl5 && object != null) {
                                zzcky4.zzjim = (zzckz[])com.google.android.gms.common.util.zza.zza((Object[])zzcky4.zzjim, (Object[])new zzckz[]{object});
                            } else if (object != null) {
                                ((zzckz)((Object)object)).name = "_err";
                                ((zzckz)((Object)object)).zzjiq = 10L;
                            } else {
                                this.zzawm().zzayr().zzj("Did not find conversion parameter. appId", zzcgj.zzje(zza2.zzjdn.zzch));
                            }
                        }
                    }
                    zzclb3.zzjiu[n4++] = zza2.zzaof.get(n3);
                }
                if (n4 < zza2.zzaof.size()) {
                    zzclb3.zzjiu = Arrays.copyOf(zzclb3.zzjiu, n4);
                }
                zzclb3.zzjjn = this.zza(zza2.zzjdn.zzch, zza2.zzjdn.zzjiv, zzclb3.zzjiu);
                if (zzcfz.zzixh.get().booleanValue()) {
                    string2 = zza2.zzjdn.zzch;
                    object2 = this.zzjcb;
                    if ("1".equals(((zzcih)object2).zzawj().zzam(string2, "measurement.event_sampling_enabled"))) {
                        HashMap<String, zzcft> hashMap = new HashMap<String, zzcft>();
                        zzcky[] zzckyArray = new zzcky[zzclb3.zzjiu.length];
                        n2 = 0;
                        SecureRandom secureRandom = this.zzawi().zzban();
                        zzcky[] zzckyArray2 = zzclb3.zzjiu;
                        int n = zzclb3.zzjiu.length;
                        for (zzcky3 = 0; zzcky3 < n; ++zzcky3) {
                            zzcky zzcky5 = zzckyArray2[zzcky3];
                            if (zzcky5.name.equals("_ep")) {
                                this.zzawi();
                                String string3 = (String)zzckn.zza(zzcky5, "_en");
                                object = (zzcft)hashMap.get(string3);
                                if (object == null) {
                                    object = this.zzawg().zzae(zza2.zzjdn.zzch, string3);
                                    hashMap.put(string3, (zzcft)object);
                                }
                                if (object.zziwt != null) continue;
                                if (object.zziwu > 1L) {
                                    this.zzawi();
                                    zzcky5.zzjim = zzckn.zza(zzcky5.zzjim, "_sr", object.zziwu);
                                }
                                if (object.zziwv != null && object.zziwv.booleanValue()) {
                                    this.zzawi();
                                    zzcky5.zzjim = zzckn.zza(zzcky5.zzjim, "_efs", 1L);
                                }
                                zzckyArray[n2++] = zzcky5;
                                continue;
                            }
                            int n6 = 1;
                            if (!zzchj.zza(zzcky5, "_dbg", 1L)) {
                                n6 = this.zzawj().zzap(zza2.zzjdn.zzch, zzcky5.name);
                            }
                            if (n6 <= 0) {
                                this.zzawm().zzayt().zze("Sample rate must be positive. event, rate", zzcky5.name, n6);
                                zzckyArray[n2++] = zzcky5;
                                continue;
                            }
                            object = (zzcft)hashMap.get(zzcky5.name);
                            if (object == null && (object = this.zzawg().zzae(zza2.zzjdn.zzch, zzcky5.name)) == null) {
                                this.zzawm().zzayt().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzjdn.zzch, zzcky5.name);
                                object = new zzcft(zza2.zzjdn.zzch, zzcky5.name, 1L, 1L, zzcky5.zzjin, 0L, null, null, null);
                            }
                            this.zzawi();
                            zzckzArray = (zzckz[])zzckn.zza(zzcky5, "_eid");
                            Boolean bl6 = zzckzArray != null;
                            if (n6 == 1) {
                                zzckyArray[n2++] = zzcky5;
                                if (!bl6.booleanValue() || object.zziwt == null && object.zziwu == null && object.zziwv == null) continue;
                                object = object.zza(null, null, null);
                                hashMap.put(zzcky5.name, (zzcft)object);
                                continue;
                            }
                            if (secureRandom.nextInt(n6) == 0) {
                                this.zzawi();
                                zzcky5.zzjim = zzckn.zza(zzcky5.zzjim, "_sr", n6);
                                zzckyArray[n2++] = zzcky5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), null);
                                }
                                hashMap.put(zzcky5.name, object.zzbb(zzcky5.zzjin));
                                continue;
                            }
                            long l2 = object.zziws;
                            if (Math.abs(zzcky5.zzjin - l2) >= 86400000L) {
                                this.zzawi();
                                zzcky5.zzjim = zzckn.zza(zzcky5.zzjim, "_efs", 1L);
                                this.zzawi();
                                zzcky5.zzjim = zzckn.zza(zzcky5.zzjim, "_sr", n6);
                                zzckyArray[n2++] = zzcky5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), true);
                                }
                                hashMap.put(zzcky5.name, object.zzbb(zzcky5.zzjin));
                                continue;
                            }
                            if (!bl6.booleanValue()) continue;
                            hashMap.put(zzcky5.name, object.zza((Long)zzckzArray, null, null));
                        }
                        if (n2 < zzclb3.zzjiu.length) {
                            zzclb3.zzjiu = Arrays.copyOf(zzckyArray, n2);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzawg().zza((zzcft)entry.getValue());
                        }
                    }
                }
                zzclb3.zzjix = Long.MAX_VALUE;
                zzclb3.zzjiy = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzclb3.zzjiu.length; ++n3) {
                    zzcky zzcky6 = zzclb3.zzjiu[n3];
                    if (zzcky6.zzjin < zzclb3.zzjix) {
                        zzclb3.zzjix = zzcky6.zzjin;
                    }
                    if (zzcky6.zzjin <= zzclb3.zzjiy) continue;
                    zzclb3.zzjiy = zzcky6.zzjin;
                }
                String string7 = zza2.zzjdn.zzch;
                zzcfe zzcfe2 = this.zzawg().zziv(string7);
                if (zzcfe2 == null) {
                    this.zzawm().zzayr().zzj("Bundling raw events w/o app info. appId", zzcgj.zzje(zza2.zzjdn.zzch));
                } else if (zzclb3.zzjiu.length > 0) {
                    long l6 = zzcfe2.zzawt();
                    zzclb3.zzjja = l6 != 0L ? Long.valueOf(l6) : null;
                    long l7 = zzcfe2.zzaws();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    zzclb3.zzjiz = l7 != 0L ? Long.valueOf(l7) : null;
                    zzcfe2.zzaxc();
                    zzclb3.zzjjl = (int)zzcfe2.zzawz();
                    zzcfe2.zzak(zzclb3.zzjix);
                    zzcfe2.zzal(zzclb3.zzjiy);
                    zzclb3.zzivb = zzcfe2.zzaxk();
                    this.zzawg().zza(zzcfe2);
                }
                if (zzclb3.zzjiu.length > 0) {
                    zzckv zzckv2 = this.zzawj().zzjm(zza2.zzjdn.zzch);
                    if (zzckv2 == null || zzckv2.zzjib == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzjdn.zziux)) {
                            zzclb3.zzjjs = -1L;
                        } else {
                            this.zzawm().zzayt().zzj("Did not find measurement config or missing version info. appId", zzcgj.zzje(zza2.zzjdn.zzch));
                        }
                    } else {
                        zzclb3.zzjjs = zzckv2.zzjib;
                    }
                    this.zzawg().zza(zzclb3, bl);
                }
                this.zzawg().zzag(zza2.zzjdo);
                string2 = string7;
                object2 = this.zzawg();
                SQLiteDatabase sQLiteDatabase = ((zzcfl)object2).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcih)object2).zzawm().zzayr().zze("Failed to remove unused event metadata. appId", zzcgj.zzje(string2), (Object)sQLiteException);
                }
                this.zzawg().setTransactionSuccessful();
                return true;
            }
            this.zzawg().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    private final zzckx[] zza(String string, zzcld[] zzcldArray, zzcky[] zzckyArray) {
        zzbq.zzgh((String)string);
        return this.zzavz().zza(string, zzckyArray, zzcldArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        zzbq.zzgh((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzawm().zzayx().zzj("onConfigFetched. Response size", byArray.length);
            this.zzawg().beginTransaction();
            try {
                boolean bl;
                zzcfe zzcfe2 = this.zzawg().zziv(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcfe2 == null) {
                    this.zzawm().zzayt().zzj("App does not exist in onConfigFetched. appId", zzcgj.zzje(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzawj().zzjm(string) == null && !this.zzawj().zzb(string, null, null) : !this.zzawj().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcfe2.zzaq(this.zzasd.currentTimeMillis());
                    this.zzawg().zza(zzcfe2);
                    if (n == 404) {
                        this.zzawm().zzayu().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzawm().zzayx().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzazp().zzzh() && this.zzazw()) {
                        this.zzazv();
                    } else {
                        this.zzazx();
                    }
                } else {
                    zzcfe2.zzar(this.zzasd.currentTimeMillis());
                    this.zzawg().zza(zzcfe2);
                    this.zzawm().zzayx().zze("Fetching config failed. code, error", n, throwable);
                    this.zzawj().zzjo(string);
                    this.zzawn().zzizx.set(this.zzasd.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzawn().zzizy.set(this.zzasd.currentTimeMillis());
                    }
                    this.zzazx();
                }
                this.zzawg().setTransactionSuccessful();
            }
            finally {
                this.zzawg().endTransaction();
            }
            return;
        }
        finally {
            this.zzjdi = false;
            this.zzbab();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzjdc;
            this.zzjdc = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzawn().zzizw.set(this.zzasd.currentTimeMillis());
                    this.zzawn().zzizx.set(0L);
                    this.zzazx();
                    this.zzawm().zzayx().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzawg().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcfl zzcfl2 = this.zzawg();
                            zzcfl2.zzut();
                            zzcfl2.zzwu();
                            SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcfl2.zzawm().zzayr().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzawg().setTransactionSuccessful();
                    }
                    finally {
                        this.zzawg().endTransaction();
                    }
                    if (this.zzazp().zzzh() && this.zzazw()) {
                        this.zzazv();
                    } else {
                        this.zzjdg = -1L;
                        this.zzazx();
                    }
                    this.zzjdh = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzawm().zzayr().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzjdh = this.zzasd.elapsedRealtime();
                    this.zzawm().zzayx().zzj("Disable upload, time", this.zzjdh);
                }
            } else {
                this.zzawm().zzayx().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzawn().zzizx.set(this.zzasd.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzawn().zzizy.set(this.zzasd.currentTimeMillis());
                }
                this.zzazx();
            }
            return;
        }
        finally {
            this.zzjdj = false;
            this.zzbab();
        }
    }

    private final boolean zzazw() {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        return this.zzawg().zzaxy() || !TextUtils.isEmpty((CharSequence)this.zzawg().zzaxt());
    }

    @WorkerThread
    private final void zzazx() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcih)this.zzawl()).zzut();
            this.zzwu();
            if (!this.zzbaa()) {
                return;
            }
            if (this.zzjdh > 0L) {
                l3 = this.zzasd.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzjdh);
                if (l2 > 0L) {
                    this.zzawm().zzayx().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzazq().unregister();
                    this.zzazr().cancel();
                    return;
                }
                this.zzjdh = 0L;
            }
            if (!this.zzazj() || !this.zzazw()) {
                this.zzawm().zzayx().log("Nothing to upload or uploading impossible");
                this.zzazq().unregister();
                this.zzazr().cancel();
                return;
            }
            zzchj zzchj2 = this;
            long l4 = zzchj2.zzasd.currentTimeMillis();
            long l5 = Math.max(0L, zzcfz.zziyi.get());
            boolean bl = zzchj2.zzawg().zzaxz() || zzchj2.zzawg().zzaxu();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzchj2.zzjcb.zzaxr())) && !".none.".equals(string) ? Math.max(0L, zzcfz.zziyd.get()) : Math.max(0L, zzcfz.zziyc.get())) : Math.max(0L, zzcfz.zziyb.get());
            long l7 = zzchj2.zzawn().zzizw.get();
            long l8 = zzchj2.zzawn().zzizx.get();
            long l9 = zzchj2.zzawg().zzaxw();
            long l10 = zzchj2.zzawg().zzaxx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzchj2.zzawi().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzcfz.zziyk.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzcfz.zziyj.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzawm().zzayx().log("Next upload time is 0");
            this.zzazq().unregister();
            this.zzazr().cancel();
            return;
        }
        if (!this.zzazp().zzzh()) {
            this.zzawm().zzayx().log("No network");
            this.zzazq().zzze();
            this.zzazr().cancel();
            return;
        }
        l2 = this.zzawn().zzizy.get();
        long l16 = Math.max(0L, zzcfz.zzixz.get());
        if (!this.zzawi().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzazq().unregister();
        long l17 = l3 - this.zzasd.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzcfz.zziye.get());
            this.zzawn().zzizw.set(this.zzasd.currentTimeMillis());
        }
        this.zzawm().zzayx().zzj("Upload scheduled in approximately ms", l17);
        this.zzazr().zzr(l17);
    }

    public final void zzbn(boolean bl) {
        this.zzazx();
    }

    final void zzb(zzcii zzcii2) {
        ++this.zzjde;
    }

    final void zzazy() {
        ++this.zzjdf;
    }

    @WorkerThread
    public final void zzf(zzcff zzcff2) {
        int n;
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgh((String)zzcff2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            return;
        }
        zzcfe zzcfe2 = this.zzawg().zziv(zzcff2.packageName);
        if (zzcfe2 != null && TextUtils.isEmpty((CharSequence)zzcfe2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcff2.zziux)) {
            zzcfe2.zzaq(0L);
            this.zzawg().zza(zzcfe2);
            this.zzawj().zzjp(zzcff2.packageName);
        }
        if (!zzcff2.zzivc) {
            this.zzg(zzcff2);
            return;
        }
        long l = zzcff2.zzivh;
        if (l == 0L) {
            l = this.zzasd.currentTimeMillis();
        }
        if ((n = zzcff2.zzivi) != 0 && n != 1) {
            this.zzawm().zzayt().zze("Incorrect app type, assuming installed app. appId, appType", zzcgj.zzje(zzcff2.packageName), n);
            n = 0;
        }
        this.zzawg().beginTransaction();
        try {
            zzcfx zzcfx2;
            Object object;
            long l2 = l;
            zzcff zzcff3 = zzcff2;
            zzchj zzchj2 = this;
            zzcfe zzcfe3 = zzchj2.zzawg().zziv(zzcff3.packageName);
            if (zzcfe3 != null && zzcfe3.getGmpAppId() != null && !zzcfe3.getGmpAppId().equals(zzcff3.zziux)) {
                zzchj2.zzawm().zzayt().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcgj.zzje(zzcfe3.getAppId()));
                String string = zzcfe3.getAppId();
                zzcfl zzcfl2 = zzchj2.zzawg();
                zzcfl2.zzwu();
                zzcfl2.zzut();
                zzbq.zzgh((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcfl2.zzawm().zzayx().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcfl2.zzawm().zzayr().zze("Error deleting application data. appId, error", zzcgj.zzje(string), (Object)sQLiteException);
                }
                zzcfe3 = null;
            }
            if (zzcfe3 != null && zzcfe3.zzuy() != null && !zzcfe3.zzuy().equals(zzcff3.zzicq)) {
                object = new Bundle();
                object.putString("_pv", zzcfe3.zzuy());
                zzcfx2 = new zzcfx("_au", new zzcfu((Bundle)object), "auto", l2);
                zzchj2.zzb(zzcfx2, zzcff3);
            }
            this.zzg(zzcff2);
            zzcft zzcft2 = null;
            if (n == 0) {
                zzcft2 = this.zzawg().zzae(zzcff2.packageName, "_f");
            } else if (n == 1) {
                zzcft2 = this.zzawg().zzae(zzcff2.packageName, "_v");
            }
            if (zzcft2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbej zzbej2;
                    zzckk zzckk2 = new zzckk("_fot", l, l3, "auto");
                    this.zzb(zzckk2, zzcff2);
                    l2 = l;
                    zzcff3 = zzcff2;
                    zzchj2 = this;
                    ((zzcih)zzchj2.zzawl()).zzut();
                    zzchj2.zzwu();
                    zzcfe3 = new Bundle();
                    zzcfe3.putLong("_c", 1L);
                    zzcfe3.putLong("_r", 1L);
                    zzcfe3.putLong("_uwa", 0L);
                    zzcfe3.putLong("_pfo", 0L);
                    zzcfe3.putLong("_sys", 0L);
                    zzcfe3.putLong("_sysu", 0L);
                    if (zzchj2.mContext.getPackageManager() == null) {
                        zzchj2.zzawm().zzayr().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcgj.zzje(zzcff3.packageName));
                    } else {
                        zzcfx2 = null;
                        try {
                            zzcfx2 = zzbgc.zzcy((Context)zzchj2.mContext).getPackageInfo(zzcff3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchj2.zzawm().zzayr().zze("Package info is null, first open report might be inaccurate. appId", zzcgj.zzje(zzcff3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcfx2 != null && ((PackageInfo)zzcfx2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcfx2).firstInstallTime != ((PackageInfo)zzcfx2).lastUpdateTime) {
                                zzcfe3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbej2 = new zzckk("_fi", l2, bl ? 1L : 0L, "auto");
                            zzchj2.zzb((zzckk)zzbej2, zzcff3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbgc.zzcy((Context)zzchj2.mContext).getApplicationInfo(zzcff3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchj2.zzawm().zzayr().zze("Application info is null, first open report might be inaccurate. appId", zzcgj.zzje(zzcff3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcfe3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcfe3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcff3.packageName;
                    zzcfl zzcfl3 = zzchj2.zzawg();
                    zzbq.zzgh((String)string);
                    zzcfl3.zzut();
                    zzcfl3.zzwu();
                    long l4 = zzcfl3.zzal(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcfe3.putLong("_pfo", l4);
                    }
                    zzbej2 = new zzcfx("_f", new zzcfu((Bundle)zzcfe3), "auto", l2);
                    zzchj2.zzb((zzcfx)zzbej2, zzcff3);
                } else if (n == 1) {
                    zzckk zzckk3 = new zzckk("_fvt", l, l3, "auto");
                    this.zzb(zzckk3, zzcff2);
                    l2 = l;
                    zzcff3 = zzcff2;
                    zzchj2 = this;
                    ((zzcih)zzchj2.zzawl()).zzut();
                    zzchj2.zzwu();
                    zzcfe3 = new Bundle();
                    zzcfe3.putLong("_c", 1L);
                    zzcfe3.putLong("_r", 1L);
                    object = new zzcfx("_v", new zzcfu((Bundle)zzcfe3), "auto", l2);
                    zzchj2.zzb((zzcfx)((Object)object), zzcff3);
                }
                l2 = l;
                zzcff3 = zzcff2;
                zzchj2 = this;
                zzcfe3 = new Bundle();
                zzcfe3.putLong("_et", 1L);
                object = new zzcfx("_e", new zzcfu((Bundle)zzcfe3), "auto", l2);
                zzchj2.zzb((zzcfx)((Object)object), zzcff3);
            } else if (zzcff2.zzivd) {
                l2 = l;
                zzcff3 = zzcff2;
                zzchj2 = this;
                zzcfe3 = new Bundle();
                object = new zzcfx("_cd", new zzcfu((Bundle)zzcfe3), "auto", l2);
                zzchj2.zzb((zzcfx)((Object)object), zzcff3);
            }
            this.zzawg().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawg().endTransaction();
        }
    }

    @WorkerThread
    private final void zzg(zzcff zzcff2) {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgh((String)zzcff2.packageName);
        zzcfe zzcfe2 = this.zzawg().zziv(zzcff2.packageName);
        String string = this.zzawn().zzjh(zzcff2.packageName);
        boolean bl = false;
        if (zzcfe2 == null) {
            zzcfe2 = new zzcfe(this, zzcff2.packageName);
            zzcfe2.zzil(this.zzawb().zzayn());
            zzcfe2.zzin(string);
            bl = true;
        } else if (!string.equals(zzcfe2.zzawq())) {
            zzcfe2.zzin(string);
            zzcfe2.zzil(this.zzawb().zzayn());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zziux) && !zzcff2.zziux.equals(zzcfe2.getGmpAppId())) {
            zzcfe2.zzim(zzcff2.zziux);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzivf) && !zzcff2.zzivf.equals(zzcfe2.zzawr())) {
            zzcfe2.zzio(zzcff2.zzivf);
            bl = true;
        }
        if (zzcff2.zziuz != 0L && zzcff2.zziuz != zzcfe2.zzaww()) {
            zzcfe2.zzan(zzcff2.zziuz);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzicq) && !zzcff2.zzicq.equals(zzcfe2.zzuy())) {
            zzcfe2.setAppVersion(zzcff2.zzicq);
            bl = true;
        }
        if (zzcff2.zzive != zzcfe2.zzawu()) {
            zzcfe2.zzam(zzcff2.zzive);
            bl = true;
        }
        if (zzcff2.zziuy != null && !zzcff2.zziuy.equals(zzcfe2.zzawv())) {
            zzcfe2.zzip(zzcff2.zziuy);
            bl = true;
        }
        if (zzcff2.zziva != zzcfe2.zzawx()) {
            zzcfe2.zzao(zzcff2.zziva);
            bl = true;
        }
        if (zzcff2.zzivc != zzcfe2.zzawy()) {
            zzcfe2.setMeasurementEnabled(zzcff2.zzivc);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzivb) && !zzcff2.zzivb.equals(zzcfe2.zzaxj())) {
            zzcfe2.zziq(zzcff2.zzivb);
            bl = true;
        }
        if (zzcff2.zzivg != zzcfe2.zzaxl()) {
            zzcfe2.zzay(zzcff2.zzivg);
            bl = true;
        }
        if (zzcff2.zzivj != zzcfe2.zzaxm()) {
            zzcfe2.zzbk(zzcff2.zzivj);
            bl = true;
        }
        if (bl) {
            this.zzawg().zza(zzcfe2);
        }
    }

    @WorkerThread
    final void zzazz() {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        if (!this.zzjcx) {
            this.zzawm().zzayv().log("This instance being marked as an uploader");
            zzchj zzchj2 = this;
            ((zzcih)zzchj2.zzawl()).zzut();
            zzchj2.zzwu();
            if (zzchj2.zzbaa() && zzchj2.zzazs()) {
                int n;
                int n2 = zzchj2.zza(zzchj2.zzjdb);
                int n3 = n = zzchj2.zzawb().zzayo();
                int n4 = n2;
                zzchj zzchj3 = zzchj2;
                ((zzcih)zzchj3.zzawl()).zzut();
                if (n4 > n3) {
                    zzchj3.zzawm().zzayr().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzchj3.zza(n3, zzchj3.zzjdb)) {
                        zzchj3.zzawm().zzayx().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzchj3.zzawm().zzayr().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzjcx = true;
            this.zzazx();
        }
    }

    @WorkerThread
    private final boolean zzbaa() {
        ((zzcih)this.zzawl()).zzut();
        this.zzwu();
        return this.zzjcx;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcih)this.zzawl()).zzut();
        if (this.zzjdd == null) {
            this.zzjdd = new ArrayList<Runnable>();
        }
        this.zzjdd.add(runnable);
    }

    @WorkerThread
    private final void zzbab() {
        ((zzcih)this.zzawl()).zzut();
        if (this.zzjdi || this.zzjdj || this.zzjdk) {
            this.zzawm().zzayx().zzd("Not stopping services. fetch, network, upload", this.zzjdi, this.zzjdj, this.zzjdk);
            return;
        }
        this.zzawm().zzayx().log("Stopping uploading service(s)");
        if (this.zzjdd == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzjdd.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzjdd.clear();
    }

    static /* synthetic */ void zza(zzchj zzchj2) {
        zzchj2.zzazk();
    }

    final class zza
    implements zzcfn {
        zzclb zzjdn;
        List<Long> zzjdo;
        List<zzcky> zzaof;
        private long zzjdp;
        private /* synthetic */ zzchj zzjdm;

        private zza(zzchj zzchj2) {
            this.zzjdm = zzchj2;
        }

        @Override
        public final void zzb(zzclb zzclb2) {
            zzbq.checkNotNull((Object)((Object)zzclb2));
            this.zzjdn = zzclb2;
        }

        @Override
        public final boolean zza(long l, zzcky zzcky2) {
            zzbq.checkNotNull((Object)((Object)zzcky2));
            if (this.zzaof == null) {
                this.zzaof = new ArrayList<zzcky>();
            }
            if (this.zzjdo == null) {
                this.zzjdo = new ArrayList<Long>();
            }
            if (this.zzaof.size() > 0 && zza.zza(this.zzaof.get(0)) != zza.zza(zzcky2)) {
                return false;
            }
            long l2 = this.zzjdp + (long)zzcky2.zzhl();
            if (l2 >= (long)Math.max(0, zzcfz.zzixq.get())) {
                return false;
            }
            this.zzjdp = l2;
            this.zzaof.add(zzcky2);
            this.zzjdo.add(l);
            return this.zzaof.size() < Math.max(1, zzcfz.zzixr.get());
        }

        private static long zza(zzcky zzcky2) {
            return zzcky2.zzjin / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzchj zzchj2, zzchk zzchk2) {
            this(zzchj2);
        }
    }
}

