/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchp;
import com.google.android.gms.internal.zzchq;
import com.google.android.gms.internal.zzchr;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzcht;
import com.google.android.gms.internal.zzchu;
import com.google.android.gms.internal.zzchv;
import com.google.android.gms.internal.zzchw;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcib;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcig;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcho
extends zzcgc {
    private final zzchj zzitk;
    private Boolean zzjdq;
    @Nullable
    private String zzjdr;

    public zzcho(zzchj zzchj2) {
        this(zzchj2, null);
    }

    private zzcho(zzchj zzchj2, @Nullable String string) {
        zzbq.checkNotNull((Object)zzchj2);
        this.zzitk = zzchj2;
        this.zzjdr = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        this.zzitk.zzawl().zzg(new zzchp(this, zzcff2));
    }

    @Override
    @BinderThread
    public final void zza(zzcfx zzcfx2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        this.zzb(zzcff2, false);
        this.zzitk.zzawl().zzg(new zzchz(this, zzcfx2, zzcff2));
    }

    @Override
    @BinderThread
    public final void zza(zzcfx zzcfx2, String string, String string2) {
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        zzbq.zzgh((String)string);
        this.zzf(string, true);
        this.zzitk.zzawl().zzg(new zzcia(this, zzcfx2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcfx zzcfx2, String string) {
        zzbq.zzgh((String)string);
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        this.zzf(string, true);
        this.zzitk.zzawm().zzayw().zzj("Log and bundle. event", this.zzitk.zzawh().zzjb(zzcfx2.name));
        long l = this.zzitk.zzwh().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzitk.zzawl().zzd(new zzcib(this, zzcfx2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzitk.zzawm().zzayr().zzj("Log and bundle returned null. appId", zzcgj.zzje(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzitk.zzwh().nanoTime() / 1000000L;
            this.zzitk.zzawm().zzayw().zzd("Log and bundle processed. event, size, time_ms", this.zzitk.zzawh().zzjb(zzcfx2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zzd("Failed to log and bundle. appId, event, error", zzcgj.zzje(string), this.zzitk.zzawh().zzjb(zzcfx2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzckk zzckk2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzckk2));
        this.zzb(zzcff2, false);
        if (zzckk2.getValue() == null) {
            this.zzitk.zzawl().zzg(new zzcic(this, zzckk2, zzcff2));
            return;
        }
        this.zzitk.zzawl().zzg(new zzcid(this, zzckk2, zzcff2));
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(zzcff zzcff2, boolean bl) {
        this.zzb(zzcff2, false);
        Future<List<zzckm>> future = this.zzitk.zzawl().zzc(new zzcie(this, zzcff2));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkc(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zze("Failed to get user attributes. appId", zzcgj.zzje(zzcff2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        zzcif zzcif2 = new zzcif(this, zzcff2);
        if (this.zzitk.zzawl().zzazg()) {
            zzcif2.run();
            return;
        }
        this.zzitk.zzawl().zzg(zzcif2);
    }

    @BinderThread
    private final void zzb(zzcff zzcff2, boolean bl) {
        zzbq.checkNotNull((Object)((Object)zzcff2));
        this.zzf(zzcff2.packageName, false);
        this.zzitk.zzawi().zzka(zzcff2.zziux);
    }

    @BinderThread
    private final void zzf(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzitk.zzawm().zzayr().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcho zzcho2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcho2 = this;
                    if (!bl2) break block9;
                    if (zzcho2.zzjdq == null) {
                        zzcho2.zzjdq = "com.google.android.gms".equals(zzcho2.zzjdr) || zzx.zzf((Context)zzcho2.zzitk.getContext(), (int)Binder.getCallingUid()) || zzp.zzcg((Context)zzcho2.zzitk.getContext()).zzbq(Binder.getCallingUid());
                    }
                    if (zzcho2.zzjdq.booleanValue()) break block10;
                }
                if (zzcho2.zzjdr == null && zzo.zzb((Context)zzcho2.zzitk.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcho2.zzjdr = string2;
                }
                if (!string2.equals(zzcho2.zzjdr)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzitk.zzawm().zzayr().zzj("Measurement Service called with invalid calling package. appId", zzcgj.zzje(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzitk.zzawl().zzg(new zzcig(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcff zzcff2) {
        this.zzb(zzcff2, false);
        return this.zzitk.zzjr(zzcff2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivl));
        this.zzb(zzcff2, false);
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        new zzcfi(zzcfi2).packageName = zzcff2.packageName;
        if (zzcfi2.zzivl.getValue() == null) {
            this.zzitk.zzawl().zzg(new zzchq(this, zzcfi3, zzcff2));
            return;
        }
        this.zzitk.zzawl().zzg(new zzchr(this, zzcfi3, zzcff2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcfi zzcfi2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivl));
        this.zzf(zzcfi2.packageName, true);
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        if (zzcfi2.zzivl.getValue() == null) {
            this.zzitk.zzawl().zzg(new zzchs(this, zzcfi3));
            return;
        }
        this.zzitk.zzawl().zzg(new zzcht(this, zzcfi3));
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(String string, String string2, boolean bl, zzcff zzcff2) {
        this.zzb(zzcff2, false);
        Future<List<zzckm>> future = this.zzitk.zzawl().zzc(new zzchu(this, zzcff2, string, string2));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkc(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zze("Failed to get user attributes. appId", zzcgj.zzje(zzcff2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzckk> zza(String string, String string2, String string3, boolean bl) {
        this.zzf(string, true);
        Future<List<zzckm>> future = this.zzitk.zzawl().zzc(new zzchv(this, string, string2, string3));
        try {
            List<zzckm> list = future.get();
            ArrayList<zzckk> arrayList = new ArrayList<zzckk>(list.size());
            for (zzckm zzckm2 : list) {
                if (!bl && zzckn.zzkc(zzckm2.mName)) continue;
                arrayList.add(new zzckk(zzckm2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zze("Failed to get user attributes. appId", zzcgj.zzje(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfi> zza(String string, String string2, zzcff zzcff2) {
        this.zzb(zzcff2, false);
        Future<List<zzcfi>> future = this.zzitk.zzawl().zzc(new zzchw(this, zzcff2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfi> zzj(String string, String string2, String string3) {
        this.zzf(string, true);
        Future<List<zzcfi>> future = this.zzitk.zzawl().zzc(new zzchx(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzitk.zzawm().zzayr().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzcff zzcff2) {
        this.zzf(zzcff2.packageName, false);
        this.zzitk.zzawl().zzg(new zzchy(this, zzcff2));
    }

    static /* synthetic */ zzchj zza(zzcho zzcho2) {
        return zzcho2.zzitk;
    }
}

