/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzciq;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcik
extends zzcii {
    protected zzciy zzjec;
    private AppMeasurement.EventInterceptor zzjed;
    private final Set<AppMeasurement.OnEventListener> zzjee = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzjef;
    private final AtomicReference<String> zzjeg = new AtomicReference();

    protected zzcik(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxn() {
        return false;
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzwu();
        ((zzcih)this).zzawl().zzg(new zzcil(this, bl));
    }

    @WorkerThread
    private final void zzbo(boolean bl) {
        ((zzcih)this).zzut();
        this.zzwu();
        ((zzcih)this).zzawm().zzayw().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcih)this).zzawn().setMeasurementEnabled(bl);
        ((zzcih)this).zzawd().zzbae();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcih)this).zzawl().zzg(new zzciq(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcih)this).zzawl().zzg(new zzcir(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzjed == null || zzckn.zzkc(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        boolean bl = this.zzjed == null || zzckn.zzkc(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcih)this).zzwh().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcih)this).zzawl().zzg(new zzcis(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcjc zzcjc2;
        Bundle bundle2;
        Object object;
        zzbq.zzgh((String)string);
        zzbq.zzgh((String)string2);
        zzbq.checkNotNull((Object)bundle);
        ((zzcih)this).zzut();
        this.zzwu();
        if (!this.zzitk.isEnabled()) {
            ((zzcih)this).zzawm().zzayw().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzjef) {
            this.zzjef = true;
            zzcik zzcik2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcik zzcik3 = zzcik2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcih)zzcik3).getContext());
                }
                catch (Exception exception) {
                    ((zzcih)zzcik3).zzawm().zzayt().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcih)zzcik2).zzawm().zzayv().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzckn.zzkc(string2);
        if (bl && this.zzjed != null && !bl5 && !bl4) {
            ((zzcih)this).zzawm().zzayw().zze("Passing event to registered event handler (FE)", ((zzcih)this).zzawh().zzjb(string2), ((zzcih)this).zzawh().zzx(bundle));
            this.zzjed.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzitk.zzazj()) {
            return;
        }
        int n = ((zzcih)this).zzawi().zzjv(string2);
        if (n != 0) {
            ((zzcih)this).zzawi();
            String string4 = zzckn.zza(string2, 40, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzitk.zzawi().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcih)this).zzawi().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcih)this).zzawi().zzban().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcih)this).zzawi();
            bundle2 = zzckn.zzae(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcih)this).zzawi().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        if ((zzcjc2 = ((zzcih)this).zzawe().zzbac()) != null && !bundle3.containsKey("_sc")) {
            zzcjc2.zzjfg = true;
        }
        object2 = zzcjc2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzciz.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcih)this).zzawi().zzy(bundle5) : bundle5;
            ((zzcih)this).zzawm().zzayw().zze("Logging event (FE)", ((zzcih)this).zzawh().zzjb(string2), ((zzcih)this).zzawh().zzx(bundle2));
            zzcfx zzcfx2 = new zzcfx((String)object, new zzcfu(bundle2), string, l);
            ((zzcih)this).zzawd().zzc(zzcfx2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzjee) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        if (((zzcih)this).zzawe().zzbac() != null && "_ae".equals(string2)) {
            ((zzcih)this).zzawk().zzbr(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbq.zzgh((String)string);
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        int n = ((zzcih)this).zzawi().zzjx(string2);
        if (n != 0) {
            ((zzcih)this).zzawi();
            String string3 = zzckn.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzitk.zzawi().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcih)this).zzawi().zzl(string2, object);
            if (n != 0) {
                ((zzcih)this).zzawi();
                String string4 = zzckn.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzitk.zzawi().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcih)this).zzawi().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcih)this).zzawl().zzg(new zzcit(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbq.zzgh((String)string);
        zzbq.zzgh((String)string2);
        ((zzcih)this).zzut();
        this.zzwu();
        if (!this.zzitk.isEnabled()) {
            ((zzcih)this).zzawm().zzayw().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzitk.zzazj()) {
            return;
        }
        ((zzcih)this).zzawm().zzayw().zze("Setting user property (FE)", ((zzcih)this).zzawh().zzjb(string2), object);
        zzckk zzckk2 = new zzckk(string2, l, object, string);
        ((zzcih)this).zzawd().zzb(zzckk2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzckk> zzbp(boolean bl) {
        this.zzwu();
        ((zzcih)this).zzawm().zzayw().log("Fetching user attributes (FE)");
        if (((zzcih)this).zzawl().zzazg()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcih)this).zzawl();
        if (zzche.zzas()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitk.zzawl().zzg(new zzciu(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawm().zzayt().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawm().zzayt().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcih)this).zzawn().zzazb();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcih)this).zzawl().zzazh(), (Callable)new zzciv(this));
        }
        catch (Exception exception) {
            ((zzcih)this).zzawm().zzayt().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzazb() {
        return this.zzjeg.get();
    }

    final void zzjj(@Nullable String string) {
        this.zzjeg.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbc(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcih)this).zzawl().zzg(new zzciw(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawm().zzayt().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        ((zzcih)this).zzawl().zzg(new zzcix(this));
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcih)this).zzut();
        this.zzwu();
        if (eventInterceptor != null && eventInterceptor != this.zzjed) {
            zzbq.zza((this.zzjed == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzjed = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzwu();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjee.add(onEventListener)) {
            ((zzcih)this).zzawm().zzayt().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzwu();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjee.remove(onEventListener)) {
            ((zzcih)this).zzawm().zzayt().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcih)this).zzawm().zzayt().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgh((String)conditionalUserProperty.mAppId);
        ((zzcih)this).zzavw();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgh((String)conditionalUserProperty.mName);
        zzbq.zzgh((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcih)this).zzawi().zzjx(string) != 0) {
            ((zzcih)this).zzawm().zzayr().zzj("Invalid conditional user property name", ((zzcih)this).zzawh().zzjd(string));
            return;
        }
        if (((zzcih)this).zzawi().zzl(string, object) != 0) {
            ((zzcih)this).zzawm().zzayr().zze("Invalid conditional user property value", ((zzcih)this).zzawh().zzjd(string), object);
            return;
        }
        Object object2 = ((zzcih)this).zzawi().zzm(string, object);
        if (object2 == null) {
            ((zzcih)this).zzawm().zzayr().zze("Unable to normalize conditional user property value", ((zzcih)this).zzawh().zzjd(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzcih)this).zzawm().zzayr().zze("Invalid conditional user property timeout", ((zzcih)this).zzawh().zzjd(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzcih)this).zzawm().zzayr().zze("Invalid conditional user property time to live", ((zzcih)this).zzawh().zzjd(string), l3);
            return;
        }
        ((zzcih)this).zzawl().zzg(new zzcim(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbq.zzgh((String)string);
        ((zzcih)this).zzavw();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        zzbq.zzgh((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcih)this).zzawl().zzg(new zzcin(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcfx zzcfx2;
        zzcfx zzcfx3;
        zzcfx zzcfx4;
        ((zzcih)this).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgh((String)conditionalUserProperty.mName);
        zzbq.zzgh((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzitk.isEnabled()) {
            ((zzcih)this).zzawm().zzayw().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzckk zzckk2 = new zzckk(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcfx4 = ((zzcih)this).zzawi().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcfx3 = ((zzcih)this).zzawi().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcfx2 = ((zzcih)this).zzawi().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfi zzcfi2 = new zzcfi(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzckk2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcfx3, conditionalUserProperty.mTriggerTimeout, zzcfx4, conditionalUserProperty.mTimeToLive, zzcfx2);
        ((zzcih)this).zzawd().zzf(zzcfi2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcfx zzcfx2;
        ((zzcih)this).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgh((String)conditionalUserProperty.mName);
        if (!this.zzitk.isEnabled()) {
            ((zzcih)this).zzawm().zzayw().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzckk zzckk2 = new zzckk(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcfx2 = ((zzcih)this).zzawi().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfi zzcfi2 = new zzcfi(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzckk2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcfx2);
        ((zzcih)this).zzawd().zzf(zzcfi2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbq.zzgh((String)string);
        ((zzcih)this).zzavw();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcih)this).zzawl().zzazg()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcih)this).zzawl();
        if (zzche.zzas()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitk.zzawl().zzg(new zzcio(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawm().zzayt().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawm().zzayt().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcfi zzcfi2 = (zzcfi)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcfi2.zzivm;
                conditionalUserProperty.mName = zzcfi2.zzivl.name;
                conditionalUserProperty.mValue = zzcfi2.zzivl.getValue();
                conditionalUserProperty.mActive = zzcfi2.zzivn;
                conditionalUserProperty.mTriggerEventName = zzcfi2.zzivo;
                if (zzcfi2.zzivp != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcfi2.zzivp.name;
                    if (zzcfi2.zzivp.zziwy != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcfi2.zzivp.zziwy.zzayl();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcfi2.zzivq;
                if (zzcfi2.zzivr != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcfi2.zzivr.name;
                    if (zzcfi2.zzivr.zziwy != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcfi2.zzivr.zziwy.zzayl();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcfi2.zzivl.zzjgn;
                conditionalUserProperty.mTimeToLive = zzcfi2.zzivs;
                if (zzcfi2.zzivt != null) {
                    conditionalUserProperty.mExpiredEventName = zzcfi2.zzivt.name;
                    if (zzcfi2.zzivt.zziwy != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcfi2.zzivt.zziwy.zzayl();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbq.zzgh((String)string);
        ((zzcih)this).zzavw();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcih)this).zzawl().zzazg()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcih)this).zzawl();
        if (zzche.zzas()) {
            ((zzcih)this).zzawm().zzayr().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitk.zzawl().zzg(new zzcip(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawm().zzayt().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawm().zzayt().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzckk zzckk2 = (zzckk)((Object)iterator.next());
                arrayMap.put(zzckk2.name, zzckk2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcik zzcik2, boolean bl) {
        zzcik2.zzbo(bl);
    }

    static /* synthetic */ void zza(zzcik zzcik2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcik2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcik zzcik2, String string, String string2, Object object, long l) {
        zzcik2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcik zzcik2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcik2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcik zzcik2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcik2.zzc(conditionalUserProperty);
    }
}

