/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzciz
extends zzcii {
    protected zzcjc zzjes;
    private volatile AppMeasurement.zzb zzjet;
    private AppMeasurement.zzb zzjeu;
    private long zzjev;
    private final Map<Activity, zzcjc> zzjew = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzjex = new CopyOnWriteArrayList();
    private boolean zzjey;
    private AppMeasurement.zzb zzjez;
    private String zzjfa;

    public zzciz(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxn() {
        return false;
    }

    @WorkerThread
    public final zzcjc zzbac() {
        this.zzwu();
        ((zzcih)this).zzut();
        return this.zzjes;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcih)this).zzawm().zzayt().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcih)this).zzawl();
        if (!zzche.zzas()) {
            ((zzcih)this).zzawm().zzayt().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzjey) {
            ((zzcih)this).zzawm().zzayt().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzjet == null) {
            ((zzcih)this).zzawm().zzayt().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzjew.get(activity) == null) {
            ((zzcih)this).zzawm().zzayt().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzciz.zzjs(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzjet.zzitq.equals(string2);
        boolean bl2 = zzckn.zzas(this.zzjet.zzitp, string);
        if (bl && bl2) {
            ((zzcih)this).zzawm().zzayu().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzcih)this).zzawm().zzayt().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzcih)this).zzawm().zzayt().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcih)this).zzawm().zzayx().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcjc zzcjc2 = new zzcjc(string, string2, ((zzcih)this).zzawi().zzbam());
        this.zzjew.put(activity, zzcjc2);
        this.zza(activity, zzcjc2, true);
    }

    public final AppMeasurement.zzb zzbad() {
        AppMeasurement.zzb zzb2 = this.zzjet;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzcih)this).zzawm().zzayt().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzjex.remove(zza2);
        this.zzjex.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        this.zzjex.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcjc zzcjc2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzjet != null) {
            zzb2 = this.zzjet;
        } else if (this.zzjeu != null && Math.abs(((zzcih)this).zzwh().elapsedRealtime() - this.zzjev) < 1000L) {
            zzb2 = this.zzjeu;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzjey = true;
        try {
            object2 = this.zzjex.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcjc2);
                }
                catch (Exception exception) {
                    ((zzcih)this).zzawm().zzayr().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcih)this).zzawm().zzayr().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzjey = false;
        }
        Object object3 = object2 = this.zzjet == null ? this.zzjeu : this.zzjet;
        if (bl2) {
            if (zzcjc2.zzitq == null) {
                zzcjc2.zzitq = zzciz.zzjs(activity.getClass().getCanonicalName());
            }
            object = new zzcjc(zzcjc2);
            this.zzjeu = this.zzjet;
            this.zzjev = ((zzcih)this).zzwh().elapsedRealtime();
            this.zzjet = object;
            ((zzcih)this).zzawl().zzg(new zzcja(this, bl, (AppMeasurement.zzb)object2, (zzcjc)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcjc zzcjc2) {
        ((zzcih)this).zzavy().zzai(((zzcih)this).zzwh().elapsedRealtime());
        if (((zzcih)this).zzawk().zzbr(zzcjc2.zzjfg)) {
            zzcjc2.zzjfg = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzitp != null) {
                bundle.putString("_sn", zzb2.zzitp);
            }
            bundle.putString("_sc", zzb2.zzitq);
            bundle.putLong("_si", zzb2.zzitr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcih)this).zzut();
        zzciz zzciz2 = this;
        synchronized (zzciz2) {
            if (this.zzjfa == null || this.zzjfa.equals(string) || zzb2 != null) {
                this.zzjfa = string;
                this.zzjez = zzb2;
            }
            return;
        }
    }

    private static String zzjs(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcjc zzq(@NonNull Activity activity) {
        zzbq.checkNotNull((Object)activity);
        zzcjc zzcjc2 = this.zzjew.get(activity);
        if (zzcjc2 == null) {
            String string = zzciz.zzjs(activity.getClass().getCanonicalName());
            zzcjc2 = new zzcjc(null, string, ((zzcih)this).zzawi().zzbam());
            this.zzjew.put(activity, zzcjc2);
        }
        return zzcjc2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcjc zzcjc2 = this.zzq(activity);
        this.zza(activity, zzcjc2, false);
        zzcfa zzcfa2 = ((zzcih)this).zzavy();
        long l = ((zzcih)zzcfa2).zzwh().elapsedRealtime();
        ((zzcih)zzcfa2).zzawl().zzg(new zzcfd(zzcfa2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcjc zzcjc2 = this.zzq(activity);
        this.zzjeu = this.zzjet;
        this.zzjev = ((zzcih)this).zzwh().elapsedRealtime();
        this.zzjet = null;
        ((zzcih)this).zzawl().zzg(new zzcjb(this, zzcjc2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcjc zzcjc2 = this.zzjew.get(activity);
        if (zzcjc2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcjc2.zzitr);
        bundle2.putString("name", zzcjc2.zzitp);
        bundle2.putString("referrer_name", zzcjc2.zzitq);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzjew.remove(activity);
    }

    static /* synthetic */ void zza(zzciz zzciz2, zzcjc zzcjc2) {
        zzciz2.zza(zzcjc2);
    }
}

