/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcij;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzcih
extends zzcjl {
    private ExecutorService zzieo;
    private zzcil zzjef;
    private zzcil zzjeg;
    private final PriorityBlockingQueue<zzcik<?>> zzjeh;
    private final BlockingQueue<zzcik<?>> zzjei;
    private final Thread.UncaughtExceptionHandler zzjej;
    private final Thread.UncaughtExceptionHandler zzjek;
    private final Object zzjel = new Object();
    private final Semaphore zzjem = new Semaphore(2);
    private volatile boolean zzjen;
    private static final AtomicLong zzjeo = new AtomicLong(Long.MIN_VALUE);

    zzcih(zzcim zzcim2) {
        super(zzcim2);
        this.zzjeh = new PriorityBlockingQueue();
        this.zzjei = new LinkedBlockingQueue();
        this.zzjej = new zzcij(this, "Thread death: Uncaught exception on worker thread");
        this.zzjek = new zzcij(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    @Override
    public final void zzve() {
        if (Thread.currentThread() != this.zzjef) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzawj() {
        if (Thread.currentThread() != this.zzjeg) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzau() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzazs() {
        return Thread.currentThread() == this.zzjef;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzxf();
        zzbq.checkNotNull(callable);
        zzcik zzcik2 = new zzcik(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjef) {
            if (!this.zzjeh.isEmpty()) {
                ((zzcjk)this).zzawy().zzazf().log("Callable skipped the worker queue.");
            }
            zzcik2.run();
        } else {
            this.zza(zzcik2);
        }
        return zzcik2;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzxf();
        zzbq.checkNotNull(callable);
        zzcik zzcik2 = new zzcik(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjef) {
            zzcik2.run();
        } else {
            this.zza(zzcik2);
        }
        return zzcik2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzxf();
        zzbq.checkNotNull((Object)runnable);
        this.zza(new zzcik(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzcik<?> zzcik2) {
        Object object = this.zzjel;
        synchronized (object) {
            this.zzjeh.add(zzcik2);
            if (this.zzjef == null) {
                this.zzjef = new zzcil(this, "Measurement Worker", this.zzjeh);
                this.zzjef.setUncaughtExceptionHandler(this.zzjej);
                this.zzjef.start();
            } else {
                this.zzjef.zzrk();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzxf();
        zzbq.checkNotNull((Object)runnable);
        zzcik zzcik2 = new zzcik(this, runnable, false, "Task exception on network thread");
        zzcih zzcih2 = this;
        Object object = zzcih2.zzjel;
        synchronized (object) {
            zzcih2.zzjei.add(zzcik2);
            if (zzcih2.zzjeg == null) {
                zzcih2.zzjeg = new zzcil(zzcih2, "Measurement Network", zzcih2.zzjei);
                zzcih2.zzjeg.setUncaughtExceptionHandler(zzcih2.zzjek);
                zzcih2.zzjeg.start();
            } else {
                zzcih2.zzjeg.zzrk();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzazt() {
        Object object = this.zzjel;
        synchronized (object) {
            if (this.zzieo == null) {
                this.zzieo = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzieo;
        }
    }

    static /* synthetic */ Semaphore zza(zzcih zzcih2) {
        return zzcih2.zzjem;
    }

    static /* synthetic */ boolean zzb(zzcih zzcih2) {
        return zzcih2.zzjen;
    }

    static /* synthetic */ Object zzc(zzcih zzcih2) {
        return zzcih2.zzjel;
    }

    static /* synthetic */ zzcil zzd(zzcih zzcih2) {
        return zzcih2.zzjef;
    }

    static /* synthetic */ zzcil zza(zzcih zzcih2, zzcil zzcil2) {
        zzcih2.zzjef = null;
        return null;
    }

    static /* synthetic */ zzcil zze(zzcih zzcih2) {
        return zzcih2.zzjeg;
    }

    static /* synthetic */ zzcil zzb(zzcih zzcih2, zzcil zzcil2) {
        zzcih2.zzjeg = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzazu() {
        return zzjeo;
    }
}

