/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import java.lang.reflect.InvocationTargetException;

public final class zzeh
extends zzhi {
    private Boolean zzagi;
    @NonNull
    private zzej zzagj = zzei.zzagk;
    private Boolean zzxy;

    zzeh(zzgn zzgn2) {
        super(zzgn2);
    }

    final void zza(@NonNull zzej zzej2) {
        this.zzagj = zzej2;
    }

    static String zzhn() {
        return zzez.zzaie.get();
    }

    @WorkerThread
    public final int zzas(@Size(min=1L) String string) {
        return this.zzb(string, zzez.zzais);
    }

    public final long zzgw() {
        zzee zzee2 = ((zzhi)this).zzgl();
        return 12780L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzds() {
        if (this.zzxy == null) {
            zzeh zzeh2 = this;
            synchronized (zzeh2) {
                if (this.zzxy == null) {
                    ApplicationInfo applicationInfo = ((zzhi)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzxy = string2 != null && string2.equals(string);
                    }
                    if (this.zzxy == null) {
                        this.zzxy = Boolean.TRUE;
                        ((zzhi)this).zzgi().zziv().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzxy;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzez.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagj.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzez.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagj.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzez.zza<Double> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagj.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzez.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagj.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzat(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzhi)this).getContext().getPackageManager() == null) {
                ((zzhi)this).zzgi().zziv().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzhi)this).getContext()).getApplicationInfo(((zzhi)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzhi)this).zzgi().zziv().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzhi)this).zzgi().zziv().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhi)this).zzgi().zziv().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzho() {
        zzee zzee2 = ((zzhi)this).zzgl();
        Boolean bl = this.zzat("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzhp() {
        zzee zzee2 = ((zzhi)this).zzgl();
        return this.zzat("firebase_analytics_collection_enabled");
    }

    public static long zzhq() {
        return zzez.zzajh.get();
    }

    public static long zzhr() {
        return zzez.zzaih.get();
    }

    public final String zzhs() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzhi)this).zzgi().zziv().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzhi)this).zzgi().zziv().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzhi)this).zzgi().zziv().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzhi)this).zzgi().zziv().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzht() {
        return zzez.zzaid.get();
    }

    public final boolean zzau(String string) {
        return "1".equals(this.zzagj.zze(string, "gaia_collection_enabled"));
    }

    public final boolean zzav(String string) {
        return "1".equals(this.zzagj.zze(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzaw(String string) {
        return this.zzd(string, zzez.zzajq);
    }

    @WorkerThread
    final boolean zzax(String string) {
        return this.zzd(string, zzez.zzajs);
    }

    @WorkerThread
    final boolean zzay(String string) {
        return this.zzd(string, zzez.zzajt);
    }

    @WorkerThread
    final boolean zzaz(String string) {
        return this.zzd(string, zzez.zzajl);
    }

    @WorkerThread
    final String zzba(String string) {
        zzez.zza<String> zza2 = zzez.zzajm;
        String string2 = string;
        zzeh zzeh2 = this;
        if (string2 == null) {
            return zza2.get();
        }
        return zza2.get(zzeh2.zzagj.zze(string2, zza2.getKey()));
    }

    final boolean zzbb(String string) {
        return this.zzd(string, zzez.zzaju);
    }

    @WorkerThread
    final boolean zzbc(String string) {
        return this.zzd(string, zzez.zzajv);
    }

    @WorkerThread
    final boolean zzbd(String string) {
        return this.zzd(string, zzez.zzajy);
    }

    @WorkerThread
    final boolean zzhu() {
        if (this.zzagi == null) {
            this.zzagi = this.zzat("app_measurement_lite");
            if (this.zzagi == null) {
                this.zzagi = false;
            }
        }
        return this.zzagi;
    }
}

