/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzfd
extends zzdz {
    private String zzth;
    private String zztg;
    private int zzakd;
    private String zzafh;
    private String zztf;
    private long zzake;
    private long zzafl;
    private int zzagb;
    private String zzafa;

    zzfd(zzgn zzgn2) {
        super(zzgn2);
    }

    @Override
    protected final boolean zzgn() {
        return true;
    }

    @Override
    protected final void zzgo() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzhi)this).getContext().getPackageName();
        PackageManager packageManager = ((zzhi)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzhi)this).zzgi().zziv().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzfi.zzbp(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzhi)this).zzgi().zziv().zzg("Error retrieving app installer package name. appId", zzfi.zzbp(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzhi)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhi)this).zzgi().zziv().zze("Error retrieving package info. appId, appName", zzfi.zzbp(string4), string3);
            }
        }
        this.zzth = string4;
        this.zzafh = string;
        this.zztg = string2;
        this.zzakd = n;
        this.zztf = string3;
        this.zzake = 0L;
        zzee zzee2 = ((zzhi)this).zzgl();
        packageInfo = GoogleServices.initialize((Context)((zzhi)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzfd zzfd2 = this;
            if (packageInfo2 == null) {
                ((zzhi)zzfd2).zzgi().zziv().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzhi)zzfd2).zzgi().zziv().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzhi)this).zzgk().zzhp();
            if (((zzhi)this).zzgk().zzho()) {
                ((zzhi)this).zzgi().zzja().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzhi)this).zzgi().zzja().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzhi)this).zzgi().zzja().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzhi)this).zzgi().zzjc().log("Collection enabled");
            }
        }
        this.zzafa = "";
        this.zzafl = 0L;
        zzee2 = ((zzhi)this).zzgl();
        if (this.zzacv.zzkd() != null) {
            this.zzafa = this.zzacv.zzkd();
        } else {
            try {
                object = GoogleServices.getGoogleAppId();
                Object object2 = this.zzafa = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl2) {
                    ((zzhi)this).zzgi().zzjc().zze("App package, google app id", this.zzth, this.zzafa);
                }
            }
            catch (IllegalStateException illegalStateException) {
                ((zzhi)this).zzgi().zziv().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzfi.zzbp(string4), illegalStateException);
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzagb = InstantApps.isInstantApp((Context)((zzhi)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzagb = 0;
    }

    @WorkerThread
    final zzeb zzbl(String string) {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        String string2 = this.zzah();
        String string3 = this.getGmpAppId();
        zzhi zzhi2 = this;
        ((zzdz)zzhi2).zzch();
        String string4 = ((zzfd)zzhi2).zztg;
        long l = this.zzis();
        zzhi2 = this;
        ((zzdz)zzhi2).zzch();
        String string5 = ((zzfd)zzhi2).zzafh;
        long l2 = ((zzhi)this).zzgk().zzgw();
        zzhi2 = this;
        ((zzdz)zzhi2).zzch();
        zzhi2.zzab();
        if (((zzfd)zzhi2).zzake == 0L) {
            ((zzfd)zzhi2).zzake = ((zzfd)zzhi2).zzacv.zzgg().zzd(zzhi2.getContext(), zzhi2.getContext().getPackageName());
        }
        long l3 = ((zzfd)zzhi2).zzake;
        boolean bl = this.zzacv.isEnabled();
        boolean bl2 = !((zzhi)this).zzgj().zzamm;
        String string6 = this.zzgr();
        zzhi2 = this;
        ((zzdz)zzhi2).zzch();
        long l4 = ((zzfd)zzhi2).zzafl;
        long l5 = this.zzacv.zzke();
        int n = this.zzit();
        zzhi2 = ((zzhi)this).zzgk();
        zzhi2.zzfv();
        Boolean bl3 = ((zzeh)zzhi2).zzat("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzhi2 = ((zzhi)this).zzgk();
        zzhi2.zzfv();
        bl3 = ((zzeh)zzhi2).zzat("google_analytics_ssaid_collection_enabled");
        return new zzeb(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl4, bl3 == null || bl3 != false, ((zzhi)this).zzgj().zzjo());
    }

    @WorkerThread
    final String zzir() {
        byte[] byArray = new byte[16];
        ((zzhi)this).zzgg().zzlo().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzgr() {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        if (((zzhi)this).zzgk().zzbb(this.zzth) && !this.zzacv.isEnabled()) {
            return null;
        }
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhi)this).zzgi().zziy().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzah() {
        this.zzch();
        return this.zzth;
    }

    final String getGmpAppId() {
        this.zzch();
        return this.zzafa;
    }

    final int zzis() {
        this.zzch();
        return this.zzakd;
    }

    final int zzit() {
        this.zzch();
        return this.zzagb;
    }
}

