/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.support.annotation.GuardedBy;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.measurement.AppMeasurement;

public final class zzfi
extends zzhj {
    private char zzakl = '\u0000';
    private long zzafi = -1L;
    @GuardedBy(value="this")
    private String zzakm;
    private final zzfk zzakn = new zzfk(this, 6, false, false);
    private final zzfk zzako = new zzfk(this, 6, true, false);
    private final zzfk zzakp = new zzfk(this, 6, false, true);
    private final zzfk zzakq = new zzfk(this, 5, false, false);
    private final zzfk zzakr = new zzfk(this, 5, true, false);
    private final zzfk zzaks = new zzfk(this, 5, false, true);
    private final zzfk zzakt = new zzfk(this, 4, false, false);
    private final zzfk zzaku = new zzfk(this, 3, false, false);
    private final zzfk zzakv = new zzfk(this, 2, false, false);

    zzfi(zzgn zzgn2) {
        super(zzgn2);
    }

    public final zzfk zziv() {
        return this.zzakn;
    }

    public final zzfk zziw() {
        return this.zzako;
    }

    public final zzfk zzix() {
        return this.zzakp;
    }

    public final zzfk zziy() {
        return this.zzakq;
    }

    public final zzfk zziz() {
        return this.zzaks;
    }

    public final zzfk zzja() {
        return this.zzakt;
    }

    public final zzfk zzjb() {
        return this.zzaku;
    }

    public final zzfk zzjc() {
        return this.zzakv;
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    protected static Object zzbp(String string) {
        if (string == null) {
            return null;
        }
        return new zzfl(string);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && this.isLoggable(n)) {
            String string2 = zzfi.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfi zzfi2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzgi zzgi2 = zzfi2.zzacv.zzka();
            if (zzgi2 == null) {
                zzfi2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgi2.isInitialized()) {
                zzfi2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzgi2.zzc(new zzfj(zzfi2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final boolean isLoggable(int n) {
        return Log.isLoggable((String)this.zzjd(), (int)n);
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzjd(), (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzjd() {
        zzfi zzfi2 = this;
        synchronized (zzfi2) {
            if (this.zzakm == null) {
                this.zzakm = zzeh.zzhn();
            }
            return this.zzakm;
        }
    }

    static String zza(boolean bl, String string, Object object, Object object2, Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfi.zza(bl, object);
        String string3 = zzfi.zza(bl, object2);
        String string4 = zzfi.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length() - 1));
            long l2 = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            return new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string).length()).append(string).append(l).append("...").append(string).append(l2).toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfi.zzbq(AppMeasurement.class.getCanonicalName());
            String string3 = zzfi.zzbq(zzgn.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string4;
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !(string4 = zzfi.zzbq(string5)).equals(string) && !string4.equals(string3)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzfl) {
            return zzfl.zza((zzfl)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    private static String zzbq(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public final String zzje() {
        Pair<String, Long> pair = ((zzhi)this).zzgj().zzals.zzfi();
        if (pair == null || pair == zzft.zzalr) {
            return null;
        }
        String string = String.valueOf(pair.second);
        String string2 = (String)pair.first;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    static /* synthetic */ char zza(zzfi zzfi2) {
        return zzfi2.zzakl;
    }

    static /* synthetic */ char zza(zzfi zzfi2, char c) {
        zzfi2.zzakl = c;
        return zzfi2.zzakl;
    }

    static /* synthetic */ long zzb(zzfi zzfi2) {
        return zzfi2.zzafi;
    }

    static /* synthetic */ long zza(zzfi zzfi2, long l) {
        zzfi2.zzafi = l;
        return zzfi2.zzafi;
    }
}

