/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzkd;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzft
extends zzhj {
    @VisibleForTesting
    static final Pair<String, Long> zzalr = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabe;
    public zzfx zzals;
    public final zzfw zzalt = new zzfw(this, "last_upload", 0L);
    public final zzfw zzalu = new zzfw(this, "last_upload_attempt", 0L);
    public final zzfw zzalv = new zzfw(this, "backoff", 0L);
    public final zzfw zzalw = new zzfw(this, "last_delete_stale", 0L);
    public final zzfw zzalx;
    public final zzfw zzaly;
    public final zzfw zzalz;
    public final zzfy zzama;
    private String zzamb;
    private boolean zzamc;
    private long zzamd;
    private String zzame;
    private long zzamf;
    private final Object zzamg;
    public final zzfw zzamh = new zzfw(this, "time_before_start", 10000L);
    public final zzfw zzami = new zzfw(this, "session_timeout", 1800000L);
    public final zzfv zzamj = new zzfv(this, "start_new_session", true);
    public final zzfw zzamk = new zzfw(this, "last_pause_time", 0L);
    public final zzfw zzaml = new zzfw(this, "time_active", 0L);
    public boolean zzamm;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzbr(String string) {
        this.zzab();
        long l = this.zzbt().elapsedRealtime();
        if (this.zzamb != null && l < this.zzamd) {
            return new Pair((Object)this.zzamb, (Object)this.zzamc);
        }
        String string2 = string;
        this.zzamd = l + this.zzgk().zza(string2, zzez.zzaif);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzamb = info.getId();
                this.zzamc = info.isLimitAdTrackingEnabled();
            }
            if (this.zzamb == null) {
                this.zzamb = "";
            }
        }
        catch (Exception exception) {
            this.zzgi().zzjb().zzg("Unable to get advertising id", exception);
            this.zzamb = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzamb, (Object)this.zzamc);
    }

    @WorkerThread
    final String zzbs(String string) {
        this.zzab();
        String string2 = (String)this.zzbr((String)string).first;
        MessageDigest messageDigest = zzkd.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzft(zzgn zzgn2) {
        super(zzgn2);
        this.zzalx = new zzfw(this, "midnight_offset", 0L);
        this.zzaly = new zzfw(this, "first_open_time", 0L);
        this.zzalz = new zzfw(this, "app_install_time", 0L);
        this.zzama = new zzfy(this, "app_instance_id", null);
        this.zzamg = new Object();
    }

    @Override
    protected final boolean zzgn() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzgo() {
        this.zzabe = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzamm = this.zzabe.getBoolean("has_been_opened", false);
        if (!this.zzamm) {
            SharedPreferences.Editor editor = this.zzabe.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzals = new zzfx(this, "health_monitor", Math.max(0L, zzez.zzaig.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzji() {
        this.zzab();
        this.zzch();
        return this.zzabe;
    }

    @WorkerThread
    final void zzbt(String string) {
        this.zzab();
        SharedPreferences.Editor editor = this.zzji().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjj() {
        this.zzab();
        return this.zzji().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzbu(String string) {
        Object object = this.zzamg;
        synchronized (object) {
            this.zzame = string;
            this.zzamf = this.zzbt().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzjk() {
        Object object = this.zzamg;
        synchronized (object) {
            if (Math.abs(this.zzbt().elapsedRealtime() - this.zzamf) < 1000L) {
                return this.zzame;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzjl() {
        this.zzab();
        if (!this.zzji().contains("use_service")) {
            return null;
        }
        return this.zzji().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzab();
        this.zzgi().zzjc().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzji().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjm() {
        this.zzab();
        this.zzgi().zzjc().log("Clearing collection preferences.");
        boolean bl = this.zzji().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzg(true);
        }
        SharedPreferences.Editor editor = this.zzji().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzab();
        this.zzgi().zzjc().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzji().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzg(boolean bl) {
        this.zzab();
        return this.zzji().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzjn() {
        this.zzab();
        String string = this.zzji().getString("previous_os_version", null);
        this.zzge().zzch();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzji().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzh(boolean bl) {
        this.zzab();
        this.zzgi().zzjc().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzji().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzjo() {
        this.zzab();
        return this.zzji().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzjp() {
        return this.zzabe.contains("deferred_analytics_collection");
    }

    static /* synthetic */ SharedPreferences zza(zzft zzft2) {
        return zzft2.zzji();
    }
}

