/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgn;

public final class zzgd {
    private final zzgg zzamz;

    public zzgd(zzgg zzgg2) {
        Preconditions.checkNotNull((Object)zzgg2);
        this.zzamz = zzgg2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzgn zzgn2 = zzgn.zza(context, null, null);
        zzfi zzfi2 = zzgn2.zzgi();
        if (intent == null) {
            zzfi2.zziy().log("Receiver called with null intent");
            return;
        }
        zzee zzee2 = zzgn2.zzgl();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzfi2.zzjc().zzg("Device receiver got", string);
        } else {
            zzfi2.zzjc().zzg("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzfi2.zzjc().log("Starting wakeful intent.");
            this.zzamz.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzgn2.zzgh().zzc(new zzge(this, zzgn2, zzfi2));
            }
            catch (Exception exception) {
                zzfi2.zziy().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzamz.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzfi2.zzjc().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzfi2.zzja().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzgn2.zzgg().zza(uri);
            if (bundle == null) {
                zzfi2.zzjc().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzfi2.zziy().log("Install referrer is missing timestamp");
                }
                zzgn2.zzgh().zzc(new zzgf(this, zzgn2, l, bundle, context, zzfi2, pendingResult));
            }
        }
    }
}

