/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzhm;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzjj;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzwx;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.concurrent.atomic.AtomicReference;

public class zzgn
implements zzhk {
    private static volatile zzgn zzaoc;
    private final Context zzqx;
    private final String zzaod;
    private final zzee zzahs;
    private final zzeh zzaoe;
    private final zzft zzaof;
    private final zzfi zzaog;
    private final zzgi zzaoh;
    private final zzjj zzaoi;
    private final AppMeasurement zzaoj;
    private final FirebaseAnalytics zzaok;
    private final zzkd zzaol;
    private final zzfg zzaom;
    private final Clock clock;
    private final zzih zzaon;
    private final zzhm zzaoo;
    private final zzdu zzaop;
    private zzfe zzaoq;
    private zzik zzaor;
    private zzer zzaos;
    private zzfd zzaot;
    private zzfz zzaou;
    private boolean zzvn = false;
    private Boolean zzaov;
    private long zzaow;
    private int zzaox;
    private int zzaoy;
    private final long zzaga;

    private zzgn(zzhl zzhl2) {
        Preconditions.checkNotNull((Object)zzhl2);
        Object object = zzhl2.zzqx;
        this.zzahs = new zzee((Context)object);
        zzez.zza(this.zzahs);
        this.zzqx = zzhl2.zzqx;
        this.zzaod = zzhl2.zzaod;
        zzwx.init(this.zzqx);
        this.clock = DefaultClock.getInstance();
        this.zzaga = this.clock.currentTimeMillis();
        object = this;
        this.zzaoe = new zzeh((zzgn)object);
        object = this;
        zzft zzft2 = new zzft((zzgn)object);
        zzft2.zzm();
        this.zzaof = zzft2;
        object = this;
        zzfi zzfi2 = new zzfi((zzgn)object);
        zzfi2.zzm();
        this.zzaog = zzfi2;
        object = this;
        zzkd zzkd2 = new zzkd((zzgn)object);
        zzkd2.zzm();
        this.zzaol = zzkd2;
        object = this;
        zzfg zzfg2 = new zzfg((zzgn)object);
        zzfg2.zzm();
        this.zzaom = zzfg2;
        object = this;
        this.zzaop = new zzdu((zzgn)object);
        object = this;
        zzih zzih2 = new zzih((zzgn)object);
        zzih2.zzm();
        this.zzaon = zzih2;
        object = this;
        zzhm zzhm2 = new zzhm((zzgn)object);
        zzhm2.zzm();
        this.zzaoo = zzhm2;
        object = this;
        this.zzaoj = new AppMeasurement((zzgn)object);
        object = this;
        this.zzaok = new FirebaseAnalytics((zzgn)object);
        object = this;
        zzjj zzjj2 = new zzjj((zzgn)object);
        zzjj2.zzm();
        this.zzaoi = zzjj2;
        object = this;
        zzgi zzgi2 = new zzgi((zzgn)object);
        zzgi2.zzm();
        this.zzaoh = zzgi2;
        object = this;
        zzee zzee2 = ((zzgn)object).zzahs;
        if (((zzgn)object).zzqx.getApplicationContext() instanceof Application) {
            zzhm zzhm3 = ((zzgn)object).zzfy();
            if (((zzhi)zzhm3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhi)zzhm3).getContext().getApplicationContext();
                if (zzhm3.zzapl == null) {
                    zzhm3.zzapl = new zzif(zzhm3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm3.zzapl);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm3.zzapl);
                ((zzhi)zzhm3).zzgi().zzjc().log("Registered activity lifecycle callback");
            }
        } else {
            ((zzgn)object).zzgi().zziy().log("Application context is not an Application");
        }
        this.zzaoh.zzc(new zzgo(this, zzhl2));
    }

    @WorkerThread
    private final void zza(zzhl zzhl2) {
        String string;
        zzfk zzfk2;
        ((zzhi)this.zzgh()).zzab();
        zzeh.zzhn();
        zzgn zzgn2 = this;
        zzer zzer2 = new zzer(zzgn2);
        zzer2.zzm();
        this.zzaos = zzer2;
        zzgn2 = this;
        zzfd zzfd2 = new zzfd(zzgn2);
        zzfd2.zzm();
        this.zzaot = zzfd2;
        zzgn2 = this;
        zzfe zzfe2 = new zzfe(zzgn2);
        zzfe2.zzm();
        this.zzaoq = zzfe2;
        zzgn2 = this;
        zzik zzik2 = new zzik(zzgn2);
        zzik2.zzm();
        this.zzaor = zzik2;
        this.zzaol.zzgm();
        this.zzaof.zzgm();
        zzgn2 = this;
        this.zzaou = new zzfz(zzgn2);
        this.zzaot.zzgm();
        this.zzgi().zzja().zzg("App measurement is starting up, version", this.zzaoe.zzgw());
        zzee zzee2 = this.zzahs;
        this.zzgi().zzja().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzee2 = this.zzahs;
        String string2 = zzfd2.zzah();
        if (this.zzgg().zzcn(string2)) {
            zzfk2 = this.zzgi().zzja();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzfk2 = this.zzgi().zzja();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzfk2.log(string);
        this.zzgi().zzjb().log("Debug-level message logging enabled");
        if (this.zzaox != this.zzaoy) {
            this.zzgi().zziv().zze("Not all components initialized", this.zzaox, this.zzaoy);
        }
        this.zzvn = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzhi)this.zzgh()).zzab();
        if (this.zzgj().zzalt.get() == 0L) {
            this.zzgj().zzalt.set(this.clock.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgj().zzaly.get()) == 0L) {
            this.zzgi().zzjc().zzg("Persisting first open", this.zzaga);
            this.zzgj().zzaly.set(this.zzaga);
        }
        if (!this.zzkg()) {
            if (this.isEnabled()) {
                if (!this.zzgg().zzx("android.permission.INTERNET")) {
                    this.zzgi().zziv().log("App is missing INTERNET permission");
                }
                if (!this.zzgg().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgi().zziv().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzee zzee2 = this.zzahs;
                if (!Wrappers.packageManager((Context)this.zzqx).isCallerInstantApp() && !this.zzaoe.zzhu()) {
                    if (!zzgd.zza(this.zzqx)) {
                        this.zzgi().zziv().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkd.zza(this.zzqx, false)) {
                        this.zzgi().zziv().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgi().zziv().log("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzee zzee3 = this.zzahs;
            if (!TextUtils.isEmpty((CharSequence)this.zzfz().getGmpAppId())) {
                String string = this.zzgj().zzjj();
                if (string == null) {
                    this.zzgj().zzbt(this.zzfz().getGmpAppId());
                } else if (!string.equals(this.zzfz().getGmpAppId())) {
                    this.zzgi().zzja().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzgj().zzjm();
                    this.zzaor.disconnect();
                    this.zzaor.zzdf();
                    this.zzgj().zzbt(this.zzfz().getGmpAppId());
                    this.zzgj().zzaly.set(this.zzaga);
                    this.zzgj().zzama.zzbv(null);
                }
            }
            this.zzfy().zzbu(this.zzgj().zzama.zzjq());
            zzee3 = this.zzahs;
            if (!TextUtils.isEmpty((CharSequence)this.zzfz().getGmpAppId())) {
                boolean bl = this.isEnabled();
                if (!this.zzgj().zzjp() && !this.zzaoe.zzho()) {
                    this.zzgj().zzh(!bl);
                }
                if (!this.zzaoe.zzbc(this.zzfz().zzah()) || bl) {
                    this.zzfy().zzkm();
                }
                this.zzga().zza(new AtomicReference<String>());
            }
        }
    }

    @Override
    public final zzee zzgl() {
        return this.zzahs;
    }

    public final zzeh zzgk() {
        return this.zzaoe;
    }

    public final zzft zzgj() {
        zzgn.zza((zzhi)this.zzaof);
        return this.zzaof;
    }

    @Override
    public final zzfi zzgi() {
        zzgn.zza(this.zzaog);
        return this.zzaog;
    }

    public final zzfi zzjy() {
        if (this.zzaog != null && this.zzaog.isInitialized()) {
            return this.zzaog;
        }
        return null;
    }

    @Override
    public final zzgi zzgh() {
        zzgn.zza(this.zzaoh);
        return this.zzaoh;
    }

    public final zzjj zzgd() {
        zzgn.zza(this.zzaoi);
        return this.zzaoi;
    }

    public final zzfz zzjz() {
        return this.zzaou;
    }

    final zzgi zzka() {
        return this.zzaoh;
    }

    public final zzhm zzfy() {
        zzgn.zza(this.zzaoo);
        return this.zzaoo;
    }

    public final AppMeasurement zzkb() {
        return this.zzaoj;
    }

    public final FirebaseAnalytics zzkc() {
        return this.zzaok;
    }

    public final zzkd zzgg() {
        zzgn.zza((zzhi)this.zzaol);
        return this.zzaol;
    }

    public final zzfg zzgf() {
        zzgn.zza((zzhi)this.zzaom);
        return this.zzaom;
    }

    public final zzfe zzgc() {
        zzgn.zza(this.zzaoq);
        return this.zzaoq;
    }

    @Override
    public final Context getContext() {
        return this.zzqx;
    }

    public final String zzkd() {
        return this.zzaod;
    }

    @Override
    public final Clock zzbt() {
        return this.clock;
    }

    public final zzih zzgb() {
        zzgn.zza(this.zzaon);
        return this.zzaon;
    }

    public final zzik zzga() {
        zzgn.zza(this.zzaor);
        return this.zzaor;
    }

    public final zzer zzge() {
        zzgn.zza(this.zzaos);
        return this.zzaos;
    }

    public final zzfd zzfz() {
        zzgn.zza(this.zzaot);
        return this.zzaot;
    }

    public final zzdu zzfx() {
        if (this.zzaop == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzaop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzgn zza(Context context, String string, String string2) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzaoc != null) return zzaoc;
        Class<zzgn> clazz = zzgn.class;
        synchronized (zzgn.class) {
            if (zzaoc != null) return zzaoc;
            zzhl zzhl2 = new zzhl(context, null);
            zzaoc = new zzgn(zzhl2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzaoc;
        }
    }

    private final void zzch() {
        if (!this.zzvn) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzhj zzhj2) {
        if (zzhj2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhj2.isInitialized()) {
            String string = String.valueOf(zzhj2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzdz zzdz2) {
        if (zzdz2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzdz2.isInitialized()) {
            String string = String.valueOf(zzdz2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhi zzhi2) {
        if (zzhi2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzhi)this.zzgh()).zzab();
        this.zzch();
        if (this.zzaoe.zzho()) {
            return false;
        }
        Boolean bl = this.zzaoe.zzhp();
        boolean bl2 = bl != null ? bl : !GoogleServices.isMeasurementExplicitlyDisabled();
        return this.zzgj().zzg(bl2);
    }

    final long zzke() {
        Long l = this.zzgj().zzaly.get();
        if (l == 0L) {
            return this.zzaga;
        }
        return Math.min(this.zzaga, l);
    }

    final void zzfv() {
        zzee zzee2 = this.zzahs;
    }

    final void zzfu() {
        zzee zzee2 = this.zzahs;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzhj zzhj2) {
        ++this.zzaox;
    }

    final void zzb(zzdz zzdz2) {
        ++this.zzaox;
    }

    final void zzkf() {
        ++this.zzaoy;
    }

    @WorkerThread
    protected final boolean zzkg() {
        this.zzch();
        ((zzhi)this.zzgh()).zzab();
        if (this.zzaov == null || this.zzaow == 0L || this.zzaov != null && !this.zzaov.booleanValue() && Math.abs(this.clock.elapsedRealtime() - this.zzaow) > 1000L) {
            this.zzaow = this.clock.elapsedRealtime();
            zzee zzee2 = this.zzahs;
            this.zzaov = this.zzgg().zzx("android.permission.INTERNET") && this.zzgg().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzqx).isCallerInstantApp() || this.zzaoe.zzhu() || zzgd.zza(this.zzqx) && zzkd.zza(this.zzqx, false));
            if (this.zzaov.booleanValue()) {
                this.zzaov = this.zzgg().zzck(this.zzfz().getGmpAppId());
            }
        }
        return this.zzaov;
    }

    static /* synthetic */ void zza(zzgn zzgn2, zzhl zzhl2) {
        zzgn2.zza(zzhl2);
    }
}

