/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhn;
import com.google.android.gms.internal.measurement.zzho;
import com.google.android.gms.internal.measurement.zzhp;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhr;
import com.google.android.gms.internal.measurement.zzhs;
import com.google.android.gms.internal.measurement.zzht;
import com.google.android.gms.internal.measurement.zzhu;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzia;
import com.google.android.gms.internal.measurement.zzib;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhm
extends zzdz {
    @VisibleForTesting
    protected zzif zzapl;
    private AppMeasurement.EventInterceptor zzapm;
    private final Set<AppMeasurement.OnEventListener> zzapn = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzapo;
    private final AtomicReference<String> zzapp = new AtomicReference();
    @VisibleForTesting
    protected boolean zzapq = true;

    protected zzhm(zzgn zzgn2) {
        super(zzgn2);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    public final Boolean zzkh() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzhi)this).zzgh().zza(atomicReference, 15000L, "boolean test flag value", new zzhn(this, atomicReference));
    }

    public final String zzki() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzhi)this).zzgh().zza(atomicReference, 15000L, "String test flag value", new zzhx(this, atomicReference));
    }

    public final Long zzkj() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzhi)this).zzgh().zza(atomicReference, 15000L, "long test flag value", new zzhy(this, atomicReference));
    }

    public final Integer zzkk() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzhi)this).zzgh().zza(atomicReference, 15000L, "int test flag value", new zzhz(this, atomicReference));
    }

    public final Double zzkl() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzhi)this).zzgh().zza(atomicReference, 15000L, "double test flag value", new zzia(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzch();
        ((zzhi)this).zzfv();
        ((zzhi)this).zzgh().zzc(new zzib(this, bl));
    }

    @WorkerThread
    private final void zzi(boolean bl) {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        ((zzhi)this).zzgi().zzjb().zzg("Setting app measurement enabled (FE)", bl);
        ((zzhi)this).zzgj().setMeasurementEnabled(bl);
        if (((zzhi)this).zzgk().zzbc(((zzdy)this).zzfz().zzah())) {
            if (this.zzacv.isEnabled() && this.zzapq) {
                ((zzhi)this).zzgi().zzjb().log("Recording app launch after enabling measurement for the first time (FE)");
                this.zzkm();
                return;
            }
            ((zzdy)this).zzga().zzkp();
            return;
        }
        ((zzdy)this).zzga().zzkp();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzgh().zzc(new zzic(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzgh().zzc(new zzid(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        ((zzhi)this).zzfv();
        boolean bl2 = this.zzapm == null || zzkd.zzcm(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        ((zzhi)this).zzfv();
        boolean bl = this.zzapm == null || zzkd.zzcm(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzab();
        boolean bl = this.zzapm == null || zzkd.zzcm(string2);
        this.zza(string, string2, ((zzhi)this).zzbt().currentTimeMillis(), bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzig zzig2;
        zzig zzig3;
        Object object4;
        Object object5;
        zzhi zzhi2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzhi)this).zzab();
        this.zzch();
        if (!this.zzacv.isEnabled()) {
            ((zzhi)this).zzgi().zzjb().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzapo) {
            this.zzapo = true;
            zzhi2 = this;
            try {
                object5 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object5;
                object4 = zzhi2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzhi)object4).getContext());
                }
                catch (Exception exception) {
                    ((zzhi)object4).zzgi().zziy().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzhi2.zzgi().zzja().log("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3) {
            object4 = ((zzhi)this).zzgl();
            if (!"_iap".equals(string2)) {
                int n;
                object5 = string2;
                zzhi2 = this.zzacv.zzgg();
                if ((!((zzkd)zzhi2).zzq("event", (String)object5) ? 2 : (!((zzkd)zzhi2).zza("event", AppMeasurement.Event.zzacw, (String)object5) ? 13 : (n = !((zzkd)zzhi2).zza("event", 40, (String)object5) ? 2 : 0))) != 0) {
                    ((zzhi)this).zzgi().zzix().zzg("Invalid public event name. Event will not be logged (FE)", ((zzhi)this).zzgf().zzbm(string2));
                    this.zzacv.zzgg();
                    String string4 = zzkd.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzacv.zzgg().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object4 = ((zzhi)this).zzgl();
        zzig zzig4 = ((zzdy)this).zzgb().zzkn();
        if (zzig4 != null && !bundle.containsKey("_sc")) {
            zzig4.zzaqc = true;
        }
        zzig zzig5 = zzig4;
        zzih.zza(zzig5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzkd.zzcm(string2);
        if (bl && this.zzapm != null && !bl5 && !bl4) {
            ((zzhi)this).zzgi().zzjb().zze("Passing event to registered event handler (FE)", ((zzhi)this).zzgf().zzbm(string2), ((zzhi)this).zzgf().zzb(bundle));
            this.zzapm.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzacv.zzkg()) {
            return;
        }
        int n = ((zzhi)this).zzgg().zzch(string2);
        if (n != 0) {
            ((zzhi)this).zzgi().zzix().zzg("Invalid event name. Event will not be logged (FE)", ((zzhi)this).zzgf().zzbm(string2));
            ((zzhi)this).zzgg();
            String string5 = zzkd.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzacv.zzgg().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzhi)this).zzgg().zza(string3, string2, bundle, list, bl3, true);
        zzhi2 = bundle3;
        if (bundle3 == null || !zzhi2.containsKey("_sc") || !zzhi2.containsKey("_si")) {
            zzig3 = null;
        } else {
            object5 = zzhi2.getString("_sn");
            String string6 = zzhi2.getString("_sc");
            Long l2 = zzhi2.getLong("_si");
            zzig3 = zzig2 = new zzig((String)object5, string6, l2);
        }
        if (zzig3 == null) {
            zzig2 = zzig5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzhi)this).zzgg().zzlo().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzhi)this).zzgg();
            object = zzkd.zze(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object6 = object[j];
                zzih.zza(zzig2, object6, true);
                bundle2 = ((zzhi)this).zzgg().zza(string3, "_ep", object6, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzhi)this).zzgg().zzd(bundle4) : bundle4;
            ((zzhi)this).zzgi().zzjb().zze("Logging event (FE)", ((zzhi)this).zzgf().zzbm(string2), ((zzhi)this).zzgf().zzb((Bundle)object2));
            object = new zzex((String)object3, new zzeu((Bundle)object2), string, l);
            ((zzdy)this).zzga().zzb((zzex)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzapn) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzhi)this).zzgl();
        if (((zzdy)this).zzgb().zzkn() != null && "_ae".equals(string2)) {
            ((zzdy)this).zzgd().zzl(true);
        }
    }

    public final void logEventNoInterceptor(String string, String string2, Bundle bundle, long l) {
        ((zzhi)this).zzfv();
        this.zzb(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zzb(string, string2, ((zzhi)this).zzbt().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzhi)this).zzgh().zzc(new zzie(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    public final void setUserProperty(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        long l = ((zzhi)this).zzbt().currentTimeMillis();
        int n = ((zzhi)this).zzgg().zzcj(string2);
        if (n != 0) {
            ((zzhi)this).zzgg();
            String string3 = zzkd.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzacv.zzgg().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzhi)this).zzgg().zzi(string2, object);
            if (n != 0) {
                ((zzhi)this).zzgg();
                String string4 = zzkd.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzacv.zzgg().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzhi)this).zzgg().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzhi)this).zzgh().zzc(new zzho(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        if (!this.zzacv.isEnabled()) {
            ((zzhi)this).zzgi().zzjb().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzacv.zzkg()) {
            return;
        }
        ((zzhi)this).zzgi().zzjb().zze("Setting user property (FE)", ((zzhi)this).zzgf().zzbm(string2), object);
        zzka zzka2 = new zzka(string2, l, object, string);
        ((zzdy)this).zzga().zzb(zzka2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzka> zzj(boolean bl) {
        ((zzhi)this).zzfv();
        this.zzch();
        ((zzhi)this).zzgi().zzjb().log("Fetching user attributes (FE)");
        if (((zzhi)this).zzgh().zzju()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzee.isMainThread()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacv.zzgh().zzc(new zzhp(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhi)this).zzgi().zziy().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhi)this).zzgi().zziy().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzhi)this).zzgj().zzjk();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzhi)this).zzgh().zzjv(), (Callable)new zzhq(this));
        }
        catch (Exception exception) {
            ((zzhi)this).zzgi().zziy().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzjk() {
        ((zzhi)this).zzfv();
        return this.zzapp.get();
    }

    final void zzbu(@Nullable String string) {
        this.zzapp.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzaj(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhi)this).zzgh().zzc(new zzhr(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzhi)this).zzgi().zziy().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        long l = ((zzhi)this).zzbt().currentTimeMillis();
        ((zzhi)this).zzgh().zzc(new zzhs(this, l));
    }

    @WorkerThread
    public final void zzkm() {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        if (!this.zzacv.zzkg()) {
            return;
        }
        ((zzdy)this).zzga().zzkm();
        this.zzapq = false;
        String string = ((zzhi)this).zzgj().zzjn();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzhi)this).zzge().zzch();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        if (eventInterceptor != null && eventInterceptor != this.zzapm) {
            Preconditions.checkState((this.zzapm == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzapm = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzhi)this).zzfv();
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzapn.add(onEventListener)) {
            ((zzhi)this).zzgi().zziy().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzhi)this).zzfv();
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzapn.remove(onEventListener)) {
            ((zzhi)this).zzgi().zziy().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ((zzhi)this).zzfv();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzhi)this).zzgi().zziy().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzhi)this).zzfu();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzhi)this).zzbt().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzhi)this).zzgg().zzcj(string) != 0) {
            ((zzhi)this).zzgi().zziv().zzg("Invalid conditional user property name", ((zzhi)this).zzgf().zzbo(string));
            return;
        }
        if (((zzhi)this).zzgg().zzi(string, object) != 0) {
            ((zzhi)this).zzgi().zziv().zze("Invalid conditional user property value", ((zzhi)this).zzgf().zzbo(string), object);
            return;
        }
        Object object2 = ((zzhi)this).zzgg().zzj(string, object);
        if (object2 == null) {
            ((zzhi)this).zzgi().zziv().zze("Unable to normalize conditional user property value", ((zzhi)this).zzgf().zzbo(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzhi)this).zzgi().zziv().zze("Invalid conditional user property timeout", ((zzhi)this).zzgf().zzbo(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzhi)this).zzgi().zziv().zze("Invalid conditional user property time to live", ((zzhi)this).zzgf().zzbo(string), l3);
            return;
        }
        ((zzhi)this).zzgh().zzc(new zzht(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzhi)this).zzfv();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhi)this).zzfu();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzhi)this).zzbt().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzhi)this).zzgh().zzc(new zzhu(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzex zzex2;
        zzex zzex3;
        zzex zzex4;
        ((zzhi)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzacv.isEnabled()) {
            ((zzhi)this).zzgi().zzjb().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzka zzka2 = new zzka(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzex4 = ((zzhi)this).zzgg().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzex3 = ((zzhi)this).zzgg().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzex2 = ((zzhi)this).zzgg().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzef zzef2 = new zzef(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzka2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzex3, conditionalUserProperty.mTriggerTimeout, zzex4, conditionalUserProperty.mTimeToLive, zzex2);
        ((zzdy)this).zzga().zzd(zzef2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzex zzex2;
        ((zzhi)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzacv.isEnabled()) {
            ((zzhi)this).zzgi().zzjb().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzka zzka2 = new zzka(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzex2 = ((zzhi)this).zzgg().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzef zzef2 = new zzef(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzka2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzex2);
        ((zzdy)this).zzga().zzd(zzef2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzhi)this).zzfv();
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhi)this).zzfu();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzhi)this).zzgh().zzju()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzee.isMainThread()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacv.zzgh().zzc(new zzhv(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhi)this).zzgi().zziy().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhi)this).zzgi().zziy().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzef zzef2 = (zzef)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = zzef2.packageName;
                conditionalUserProperty.mOrigin = zzef2.origin;
                conditionalUserProperty.mCreationTimestamp = zzef2.creationTimestamp;
                conditionalUserProperty.mName = zzef2.zzage.name;
                conditionalUserProperty.mValue = zzef2.zzage.getValue();
                conditionalUserProperty.mActive = zzef2.active;
                conditionalUserProperty.mTriggerEventName = zzef2.triggerEventName;
                if (zzef2.zzagf != null) {
                    conditionalUserProperty.mTimedOutEventName = zzef2.zzagf.name;
                    if (zzef2.zzagf.zzahg != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzef2.zzagf.zzahg.zzin();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzef2.triggerTimeout;
                if (zzef2.zzagg != null) {
                    conditionalUserProperty.mTriggeredEventName = zzef2.zzagg.name;
                    if (zzef2.zzagg.zzahg != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzef2.zzagg.zzahg.zzin();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzef2.zzage.zzast;
                conditionalUserProperty.mTimeToLive = zzef2.timeToLive;
                if (zzef2.zzagh != null) {
                    conditionalUserProperty.mExpiredEventName = zzef2.zzagh.name;
                    if (zzef2.zzagh.zzahg != null) {
                        conditionalUserProperty.mExpiredEventParams = zzef2.zzagh.zzahg.zzin();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzhi)this).zzfv();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhi)this).zzfu();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzhi)this).zzgh().zzju()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzee.isMainThread()) {
            ((zzhi)this).zzgi().zziv().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacv.zzgh().zzc(new zzhw(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhi)this).zzgi().zziy().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhi)this).zzgi().zziy().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzka zzka2 = (zzka)((Object)iterator.next());
                arrayMap.put(zzka2.name, zzka2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzhm zzhm2, boolean bl) {
        zzhm2.zzi(bl);
    }

    static /* synthetic */ void zza(zzhm zzhm2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzhm2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzhm zzhm2, String string, String string2, Object object, long l) {
        zzhm2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzhm zzhm2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhm2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzhm zzhm2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhm2.zzc(conditionalUserProperty);
    }
}

