/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.support.annotation.GuardedBy;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzwv;
import com.google.android.gms.internal.measurement.zzww;
import com.google.android.gms.internal.measurement.zzwx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzwu {
    private static final ConcurrentHashMap<Uri, zzwu> zzbox = new ConcurrentHashMap();
    private final ContentResolver zzboy;
    private final Uri uri;
    private final ContentObserver zzboz;
    private final Object zzbpa = new Object();
    private volatile Map<String, String> zzbpb;
    private final Object zzbpc = new Object();
    @GuardedBy(value="listenersLock")
    private final List<zzww> zzbpd = new ArrayList<zzww>();
    private static final String[] zzbpe = new String[]{"key", "value"};

    private zzwu(ContentResolver contentResolver, Uri uri) {
        this.zzboy = contentResolver;
        this.uri = uri;
        this.zzboz = new zzwv(this, null);
    }

    public static zzwu zza(ContentResolver contentResolver, Uri uri) {
        zzwu zzwu2 = zzbox.get(uri);
        if (zzwu2 == null) {
            zzwu2 = new zzwu(contentResolver, uri);
            zzwu zzwu3 = zzbox.putIfAbsent(uri, zzwu2);
            if (zzwu3 == null) {
                zzwu2.zzboy.registerContentObserver(zzwu2.uri, false, zzwu2.zzboz);
            } else {
                zzwu2 = zzwu3;
            }
        }
        return zzwu2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zzsh() {
        Map<String, String> map = zzwx.zzd("gms:phenotype:phenotype_flag:debug_disable_caching", false) ? this.zzsj() : this.zzbpb;
        if (map == null) {
            Object object = this.zzbpa;
            synchronized (object) {
                map = this.zzbpb;
                if (map == null) {
                    map = this.zzsj();
                    this.zzbpb = map;
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzsi() {
        Object object = this.zzbpa;
        synchronized (object) {
            this.zzbpb = null;
            return;
        }
    }

    private final Map<String, String> zzsj() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Cursor cursor = this.zzboy.query(this.uri, zzbpe, null, null, null);
            if (cursor != null) {
                try {
                    while (cursor.moveToNext()) {
                        hashMap.put(cursor.getString(0), cursor.getString(1));
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return hashMap;
        }
        catch (SQLiteException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzsk() {
        Object object = this.zzbpc;
        synchronized (object) {
            Iterator<zzww> iterator = this.zzbpd.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzsl();
            }
            return;
        }
    }

    static /* synthetic */ void zza(zzwu zzwu2) {
        zzwu2.zzsk();
    }
}

