/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.List;
import java.util.Map;

@Deprecated
@Keep
public class AppMeasurement {
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private final zzgn zzacv;

    @Deprecated
    @Keep
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return zzgn.zza(context, null, null).zzkb();
    }

    public final void logEvent(@NonNull @Size(min=1L, max=40L) String string, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacv.zzfy().zza("app", string, bundle, true);
    }

    public final void setUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        int n = this.zzacv.zzgg().zzci(string);
        if (n != 0) {
            this.zzacv.zzgg();
            String string3 = zzkd.zza(string, 24, true);
            int n2 = string != null ? string.length() : 0;
            this.zzacv.zzgg().zza(n, "_ev", string3, n2);
            return;
        }
        this.setUserPropertyInternal("app", string, string2);
    }

    @Deprecated
    public void setMeasurementEnabled(boolean bl) {
        this.zzacv.zzfy().setMeasurementEnabled(bl);
    }

    public final void setMinimumSessionDuration(long l) {
        this.zzacv.zzfy().setMinimumSessionDuration(l);
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zzacv.zzfy().setSessionTimeoutDuration(l);
    }

    public AppMeasurement(zzgn zzgn2) {
        Preconditions.checkNotNull((Object)zzgn2);
        this.zzacv = zzgn2;
    }

    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacv.zzfy().logEvent(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacv.zzfy().logEventNoInterceptor(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        this.zzacv.zzfy().setUserProperty(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        List<zzka> list = this.zzacv.zzfy().zzj(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzka zzka2 : list) {
            arrayMap.put(zzka2.name, zzka2.getValue());
        }
        return arrayMap;
    }

    @WorkerThread
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzacv.zzfy().setEventInterceptor(eventInterceptor);
    }

    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzacv.zzfy().registerOnMeasurementEventListener(onEventListener);
    }

    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzacv.zzfy().unregisterOnMeasurementEventListener(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        zzig zzig2 = this.zzacv.zzgb().zzko();
        if (zzig2 != null) {
            return zzig2.zzuk;
        }
        return null;
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        zzig zzig2 = this.zzacv.zzgb().zzko();
        if (zzig2 != null) {
            return zzig2.zzaqa;
        }
        return null;
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        return this.zzacv.zzfy().zzjk();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzacv.zzkd() != null) {
            return this.zzacv.zzkd();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzacv.zzgi().zziv().zzg("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    @Keep
    public long generateEventId() {
        return this.zzacv.zzgg().zzln();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzacv.zzfx().beginAdUnitExposure(string);
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzacv.zzfx().endAdUnitExposure(string);
    }

    @Keep
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzacv.zzfy().setConditionalUserProperty(conditionalUserProperty);
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzacv.zzfy().setConditionalUserPropertyAs(conditionalUserProperty);
    }

    @Keep
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzacv.zzfy().clearConditionalUserProperty(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzacv.zzfy().clearConditionalUserPropertyAs(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzacv.zzfy().getUserProperties(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        return this.zzacv.zzfy().getUserPropertiesAs(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzacv.zzfy().getConditionalUserProperties(string, string2);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        return this.zzacv.zzfy().getConditionalUserPropertiesAs(string, string2, string3);
    }

    @WorkerThread
    @Keep
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        this.zzacv.zzfy();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        return this.zzacv.zzfy().zzkh();
    }

    @KeepForSdk
    public String getString() {
        return this.zzacv.zzfy().zzki();
    }

    @KeepForSdk
    public Long getLong() {
        return this.zzacv.zzfy().zzkj();
    }

    @KeepForSdk
    public Integer getInteger() {
        return this.zzacv.zzfy().zzkk();
    }

    @KeepForSdk
    public Double getDouble() {
        return this.zzacv.zzfy().zzkl();
    }

    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @KeepForSdk
        public String mAppId;
        @Keep
        @KeepForSdk
        public String mOrigin;
        @Keep
        @KeepForSdk
        public String mName;
        @Keep
        @KeepForSdk
        public Object mValue;
        @Keep
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @KeepForSdk
        public boolean mActive;
        @Keep
        @KeepForSdk
        public long mTriggeredTimestamp;

        public ConditionalUserProperty() {
        }

        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzkd.zzf(conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }
    }

    @KeepForSdk
    public static interface OnEventListener {
        @WorkerThread
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static interface EventInterceptor {
        @WorkerThread
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class UserProperty
    extends FirebaseAnalytics.UserProperty {
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";
        public static final String[] zzada = new String[]{"firebase_last_notification", "first_open_time", "first_visit_time", "last_deep_link_referrer", "user_id", "first_open_after_install", "lifetime_user_engagement"};
        public static final String[] zzadb = new String[]{"_ln", "_fot", "_fvt", "_ldl", "_id", "_fi", "_lte"};

        private UserProperty() {
        }

        public static String zzal(String string) {
            return zzkd.zza(string, zzada, zzadb);
        }
    }

    @KeepForSdk
    public static final class Param
    extends FirebaseAnalytics.Param {
        @KeepForSdk
        public static final String FATAL = "fatal";
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @KeepForSdk
        public static final String TYPE = "type";
        public static final String[] zzacy = new String[]{"firebase_conversion", "engagement_time_msec", "exposure_time", "ad_event_id", "ad_unit_id", "firebase_error", "firebase_error_value", "firebase_error_length", "firebase_event_origin", "firebase_screen", "firebase_screen_class", "firebase_screen_id", "firebase_previous_screen", "firebase_previous_class", "firebase_previous_id", "message_device_time", "message_id", "message_name", "message_time", "previous_app_version", "previous_os_version", "topic", "update_with_analytics", "previous_first_open_count", "system_app", "system_app_update", "previous_install_count", "ga_event_id", "ga_extra_params_ct", "ga_group_name", "ga_list_length", "ga_index", "ga_event_name", "campaign_info_source", "deferred_analytics_collection"};
        public static final String[] zzacz = new String[]{"_c", "_et", "_xt", "_aeid", "_ai", "_err", "_ev", "_el", "_o", "_sn", "_sc", "_si", "_pn", "_pc", "_pi", "_ndt", "_nmid", "_nmn", "_nmt", "_pv", "_po", "_nt", "_uwa", "_pfo", "_sys", "_sysu", "_pin", "_eid", "_epc", "_gn", "_ll", "_i", "_en", "_cis", "_dac"};

        private Param() {
        }

        public static String zzal(String string) {
            return zzkd.zza(string, zzacy, zzacz);
        }
    }

    @KeepForSdk
    public static final class Event
    extends FirebaseAnalytics.Event {
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @KeepForSdk
        public static final String AD_REWARD = "_ar";
        public static final String[] zzacw = new String[]{"app_clear_data", "app_exception", "app_remove", "app_upgrade", "app_install", "app_update", "firebase_campaign", "error", "first_open", "first_visit", "in_app_purchase", "notification_dismiss", "notification_foreground", "notification_open", "notification_receive", "os_update", "session_start", "user_engagement", "ad_exposure", "adunit_exposure", "ad_query", "ad_activeview", "ad_impression", "ad_click", "ad_reward", "screen_view", "ga_extra_parameter"};
        public static final String[] zzacx = new String[]{"_cd", "_ae", "_ui", "_ug", "_in", "_au", "_cmp", "_err", "_f", "_v", "_iap", "_nd", "_nf", "_no", "_nr", "_ou", "_s", "_e", "_xa", "_xu", "_aq", "_aa", "_ai", "_ac", "_ar", "_vs", "_ep"};

        private Event() {
        }

        public static String zzak(String string) {
            return zzkd.zza(string, zzacx, zzacw);
        }

        public static String zzal(String string) {
            return zzkd.zza(string, zzacw, zzacx);
        }
    }
}

