/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Build;
import android.support.v4.content.PermissionChecker;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzsg;
import com.google.android.gms.internal.measurement.zzsi;
import com.google.android.gms.internal.measurement.zzsm;
import com.google.android.gms.internal.measurement.zzsn;
import com.google.android.gms.internal.measurement.zzso;
import com.google.android.gms.internal.measurement.zzsp;
import com.google.android.gms.internal.measurement.zzsq;
import com.google.android.gms.internal.measurement.zzsr;
import com.google.android.gms.internal.measurement.zzss;
import com.google.android.gms.internal.measurement.zzst;
import com.google.android.gms.internal.measurement.zzsu;
import com.google.android.gms.internal.measurement.zzsv;
import javax.annotation.Nullable;

public abstract class zzsl<T> {
    private static final Object zzbqy = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context zzri = null;
    private static boolean zzbqz = false;
    private static volatile Boolean zzbra = null;
    private final zzsv zzbrb;
    final String zzbrc;
    private final String zzbrd;
    private final T zzbre;
    private T zzbrf = null;
    private volatile zzsi zzbrg = null;
    private volatile SharedPreferences zzbrh = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Object object = zzbqy;
        synchronized (object) {
            Context context2;
            if (Build.VERSION.SDK_INT >= 24 && context.isDeviceProtectedStorage()) {
                context2 = context;
            } else {
                context2 = context.getApplicationContext();
                if (context2 == null) {
                    context2 = context;
                }
            }
            if (zzri != context2) {
                zzbra = null;
            }
            zzri = context2;
        }
        zzbqz = false;
    }

    private zzsl(zzsv zzsv2, String string, T t) {
        zzsv zzsv3 = zzsv2;
        if (zzsv.zza(zzsv2) == null) {
            throw new IllegalArgumentException("Must pass a valid SharedPreferences file name or ContentProvider URI");
        }
        zzsv3 = zzsv2;
        this.zzbrb = zzsv2;
        String string2 = String.valueOf(zzsv.zzb(zzsv2));
        String string3 = String.valueOf(string);
        this.zzbrd = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        String string4 = String.valueOf(zzsv.zzc(zzsv2));
        String string5 = String.valueOf(string);
        this.zzbrc = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        this.zzbre = t;
    }

    public final T getDefaultValue() {
        return this.zzbre;
    }

    public final T get() {
        if (zzri == null) {
            throw new IllegalStateException("Must call PhenotypeFlag.init() first");
        }
        zzsv zzsv2 = this.zzbrb;
        T t = this.zzte();
        if (t != null) {
            return t;
        }
        t = this.zztf();
        if (t != null) {
            return t;
        }
        return this.zzbre;
    }

    @Nullable
    @TargetApi(value=24)
    private final T zzte() {
        zzsv zzsv2 = this.zzbrb;
        if (!zzsl.zzd("gms:phenotype:phenotype_flag:debug_bypass_phenotype", false)) {
            if (zzsv.zza(this.zzbrb) != null) {
                String string;
                zzsi zzsi2 = this.zztg();
                if (zzsi2 != null && (string = (String)zzsl.zza(new zzsm(this, zzsi2))) != null) {
                    return this.zzfj(string);
                }
            } else {
                zzsv2 = this.zzbrb;
            }
        } else {
            String string = String.valueOf(this.zzbrc);
            Log.w((String)"PhenotypeFlag", (String)(string.length() != 0 ? "Bypass reading Phenotype values for flag: ".concat(string) : new String("Bypass reading Phenotype values for flag: ")));
        }
        return null;
    }

    @Nullable
    private final T zztf() {
        zzsv zzsv2 = this.zzbrb;
        if (zzsl.zzth()) {
            try {
                String string = (String)zzsl.zza(new zzsn(this));
                if (string != null) {
                    return this.zzfj(string);
                }
            }
            catch (SecurityException securityException) {
                String string = String.valueOf(this.zzbrc);
                Log.e((String)"PhenotypeFlag", (String)(string.length() != 0 ? "Unable to read GServices for flag: ".concat(string) : new String("Unable to read GServices for flag: ")), (Throwable)securityException);
            }
        }
        return null;
    }

    protected abstract T zzfj(String var1);

    private static <V> V zza(zzsu<V> zzsu2) {
        V v;
        try {
            v = zzsu2.zztj();
        }
        catch (SecurityException securityException) {
            long l = Binder.clearCallingIdentity();
            try {
                v = zzsu2.zztj();
            }
            finally {
                Binder.restoreCallingIdentity((long)l);
            }
        }
        return v;
    }

    private final zzsi zztg() {
        if (this.zzbrg == null) {
            try {
                this.zzbrg = zzsi.zza(zzri.getContentResolver(), zzsv.zza(this.zzbrb));
            }
            catch (SecurityException securityException) {}
        }
        return this.zzbrg;
    }

    static boolean zzd(String string, boolean bl) {
        try {
            if (zzsl.zzth()) {
                return (Boolean)zzsl.zza(new zzso(string, false));
            }
            return false;
        }
        catch (SecurityException securityException) {
            Log.e((String)"PhenotypeFlag", (String)"Unable to read GServices, returning default value.", (Throwable)securityException);
            return false;
        }
    }

    private static boolean zzth() {
        if (zzbra == null) {
            if (zzri != null) {
                zzbra = PermissionChecker.checkSelfPermission((Context)zzri, (String)"com.google.android.providers.gsf.permission.READ_GSERVICES") == 0;
            } else {
                return false;
            }
        }
        return zzbra;
    }

    private static zzsl<Long> zza(zzsv zzsv2, String string, long l) {
        return new zzsp(zzsv2, string, l);
    }

    private static zzsl<Integer> zza(zzsv zzsv2, String string, int n) {
        return new zzsq(zzsv2, string, n);
    }

    private static zzsl<Boolean> zza(zzsv zzsv2, String string, boolean bl) {
        return new zzsr(zzsv2, string, bl);
    }

    private static zzsl<Double> zza(zzsv zzsv2, String string, double d) {
        return new zzss(zzsv2, string, d);
    }

    private static zzsl<String> zza(zzsv zzsv2, String string, String string2) {
        return new zzst(zzsv2, string, string2);
    }

    static final /* synthetic */ Boolean zze(String string, boolean bl) {
        return zzsg.zza(zzri.getContentResolver(), string, bl);
    }

    final /* synthetic */ String zzti() {
        return zzsg.zza(zzri.getContentResolver(), this.zzbrd, null);
    }

    static /* synthetic */ zzsl zzb(zzsv zzsv2, String string, long l) {
        return zzsl.zza(zzsv2, string, l);
    }

    static /* synthetic */ zzsl zzb(zzsv zzsv2, String string, boolean bl) {
        return zzsl.zza(zzsv2, string, bl);
    }

    static /* synthetic */ zzsl zzb(zzsv zzsv2, String string, int n) {
        return zzsl.zza(zzsv2, string, n);
    }

    static /* synthetic */ zzsl zzb(zzsv zzsv2, String string, double d) {
        return zzsl.zza(zzsv2, string, d);
    }

    static /* synthetic */ zzsl zzb(zzsv zzsv2, String string, String string2) {
        return zzsl.zza(zzsv2, string, string2);
    }

    /* synthetic */ zzsl(zzsv zzsv2, String string, Object object, zzsp zzsp2) {
        this(zzsv2, string, object);
    }
}

