/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzdo;
import com.google.android.gms.measurement.internal.zze;
import java.util.Map;

public final class zza
extends zze {
    private final Map<String, Long> zzafq;
    private final Map<String, Integer> zzafr = new ArrayMap();
    private long zzafs;

    public zza(zzbt zzbt2) {
        super(zzbt2);
        this.zzafq = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzco)this).zzgo().zzjd().zzbx("Ad unit id must be a non-empty string");
            return;
        }
        ((zzco)this).zzgn().zzc(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzco)this).zzgb();
        ((zzco)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzafr.isEmpty()) {
            this.zzafs = l;
        }
        if ((n = this.zzafr.get(string)) != null) {
            this.zzafr.put(string, n + 1);
            return;
        }
        if (this.zzafr.size() >= 100) {
            ((zzco)this).zzgo().zzjg().zzbx("Too many ads visible");
            return;
        }
        this.zzafr.put(string, 1);
        this.zzafq.put(string, l);
    }

    public final void endAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzco)this).zzgo().zzjd().zzbx("Ad unit id must be a non-empty string");
            return;
        }
        ((zzco)this).zzgn().zzc(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzco)this).zzgb();
        ((zzco)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzafr.get(string);
        if (n != null) {
            zzdn zzdn2 = ((zze)this).zzgh().zzla();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzafr.remove(string);
                Long l2 = this.zzafq.get(string);
                if (l2 == null) {
                    ((zzco)this).zzgo().zzjd().zzbx("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzafq.remove(string);
                    this.zza(string, l3, zzdn2);
                }
                if (this.zzafr.isEmpty()) {
                    if (this.zzafs == 0L) {
                        ((zzco)this).zzgo().zzjd().zzbx("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzafs, zzdn2);
                    this.zzafs = 0L;
                }
                return;
            }
            this.zzafr.put(string, n2);
            return;
        }
        ((zzco)this).zzgo().zzjd().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzdn zzdn2) {
        if (zzdn2 == null) {
            ((zzco)this).zzgo().zzjl().zzbx("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzco)this).zzgo().zzjl().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzdo.zza(zzdn2, bundle, true);
        ((zze)this).zzge().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzdn zzdn2) {
        if (zzdn2 == null) {
            ((zzco)this).zzgo().zzjl().zzbx("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzco)this).zzgo().zzjl().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzdo.zza(zzdn2, bundle, true);
        ((zze)this).zzge().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzq(long l) {
        zzdn zzdn2 = ((zze)this).zzgh().zzla();
        for (String string : this.zzafq.keySet()) {
            long l2 = this.zzafq.get(string);
            this.zza(string, l - l2, zzdn2);
        }
        if (!this.zzafq.isEmpty()) {
            this.zza(l - this.zzafs, zzdn2);
        }
        this.zzr(l);
    }

    @WorkerThread
    private final void zzr(long l) {
        for (String string : this.zzafq.keySet()) {
            this.zzafq.put(string, l);
        }
        if (!this.zzafq.isEmpty()) {
            this.zzafs = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zza(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzb(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzr(l);
    }
}

